/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.global;

import java.awt.event.ActionEvent;
import java.io.OutputStream;
import org.pentaho.reporting.designer.core.actions.AbstractDesignerContextAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentBundle;

public final class NewReportAction
extends AbstractDesignerContextAction {
    private static final String TRANSLATIONS_PROPERTIES = "translations.properties";

    public NewReportAction() {
        this.putValue("Name", ActionMessages.getString("NewReportAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("NewReportAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("NewReportAction.Mnemonic"));
        this.putValue("SmallIcon", IconLoader.getInstance().getNewIcon());
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("NewReportAction.Accelerator"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            MasterReport report = NewReportAction.prepareMasterReport();
            this.getReportDesignerContext().addMasterReport(report);
            this.getReportDesignerContext().getView().setWelcomeVisible(false);
        }
        catch (ReportDataFactoryException e1) {
            UncaughtExceptionsModel.getInstance().addException(e1);
        }
    }

    public static MasterReport prepareMasterReport() {
        MasterReport report = new MasterReport();
        report.setAutoSort(Boolean.TRUE);
        report.setDataFactory((DataFactory)new CompoundDataFactory());
        report.setQuery(null);
        report.getRelationalGroup(0).getHeader().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        report.getRelationalGroup(0).getFooter().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        report.getDetailsFooter().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        report.getDetailsHeader().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        report.getNoDataBand().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        report.getWatermark().setAttribute("http://reporting.pentaho.org/namespaces/report-designer/2.0", "hideInLayoutGUI", (Object)Boolean.TRUE);
        try {
            MemoryDocumentBundle bundle = (MemoryDocumentBundle)report.getBundle();
            if (!bundle.isEntryExists(TRANSLATIONS_PROPERTIES)) {
                String defaultMessage = ActionMessages.getString("Translations.DefaultContent", new Object[0]);
                OutputStream outputStream = bundle.createEntry(TRANSLATIONS_PROPERTIES, "text/plain");
                outputStream.write(defaultMessage.getBytes("ISO-8859-1"));
                outputStream.close();
                bundle.getWriteableDocumentMetaData().setEntryAttribute(TRANSLATIONS_PROPERTIES, "sticky", "true");
            }
        }
        catch (Exception ex) {
            DebugLog.log((Object)"Failed to created default translation entry", (Throwable)ex);
        }
        return report;
    }
}

