/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.actions.elements.format;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.pentaho.reporting.designer.core.actions.AbstractElementSelectionAction;
import org.pentaho.reporting.designer.core.actions.ActionMessages;
import org.pentaho.reporting.designer.core.model.selection.DocumentContextSelectionModel;
import org.pentaho.reporting.designer.core.util.undo.CompoundUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.StyleEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.event.ReportModelEvent;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;

public final class ApplyFontColorAction
extends AbstractElementSelectionAction {
    private JComboBox comboBox;

    public ApplyFontColorAction(JComboBox comboBox) {
        if (comboBox == null) {
            throw new NullPointerException();
        }
        this.comboBox = comboBox;
        this.putValue("Name", ActionMessages.getString("ApplyFontColorAction.Text", new Object[0]));
        this.putValue("ShortDescription", ActionMessages.getString("ApplyFontColorAction.Description", new Object[0]));
        this.putValue("MnemonicKey", ActionMessages.getOptionalMnemonic("ApplyFontColorAction.Mnemonic"));
        this.putValue("AcceleratorKey", ActionMessages.getOptionalKeyStroke("ApplyFontColorAction.Accelerator"));
    }

    @Override
    protected void selectedElementPropertiesChanged(ReportModelEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = this.comboBox.getSelectedItem();
        if (o != null && !(o instanceof Color)) {
            return;
        }
        Color color = (Color)o;
        DocumentContextSelectionModel model = this.getSelectionModel();
        if (model == null) {
            return;
        }
        List<Element> visualElements = model.getSelectedElementsOfType(Element.class);
        ArrayList<StyleEditUndoEntry> undos = new ArrayList<StyleEditUndoEntry>();
        for (Element visualElement : visualElements) {
            ElementStyleSheet styleSheet = visualElement.getStyle();
            undos.add(StyleEditUndoEntry.createConditional((ReportElement)visualElement, ElementStyleKeys.PAINT, color));
            styleSheet.setStyleProperty(ElementStyleKeys.PAINT, (Object)color);
            visualElement.notifyNodePropertiesChanged();
        }
        this.getActiveContext().getUndo().addChange(ActionMessages.getString("ApplyFontColorAction.UndoName", new Object[0]), new CompoundUndoEntry(undos.toArray(new UndoEntry[undos.size()])));
    }
}

