/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.jdbc.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.LibSwingUtil;
import org.pentaho.reporting.ui.datasources.jdbc.JdbcDataSourceModule;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.ui.DataSourceDialogModel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.XulDatabaseDialog;
import org.pentaho.ui.xul.XulException;

public abstract class ConnectionPanel
extends JPanel {
    private DataSourceDialogModel dialogModel;
    private DesignTimeContext designTimeContext;
    private ResourceBundleSupport bundleSupport;
    private boolean securityConfigurationAvailable = true;

    public ConnectionPanel(DataSourceDialogModel aDialogModel, DesignTimeContext designTimeContext) {
        this.dialogModel = aDialogModel;
        this.designTimeContext = designTimeContext;
        this.bundleSupport = new ResourceBundleSupport(Locale.getDefault(), "org.pentaho.reporting.ui.datasources.jdbc.messages", ObjectUtilities.getClassLoader(JdbcDataSourceModule.class));
    }

    protected void initPanel() {
        this.setLayout(new BorderLayout());
        JList<Object> dataSourceList = new JList<Object>(this.dialogModel.getConnections());
        dataSourceList.setCellRenderer(new DataSourceDefinitionListCellRenderer());
        dataSourceList.setSelectionMode(0);
        dataSourceList.addListSelectionListener(new DataSourceDefinitionListSelectionListener(dataSourceList));
        dataSourceList.setVisibleRowCount(10);
        SelectionConnectionUpdateHandler theSelectedConnectionAction = new SelectionConnectionUpdateHandler(dataSourceList);
        this.dialogModel.addPropertyChangeListener(theSelectedConnectionAction);
        EditDataSourceAction editDataSourceAction = new EditDataSourceAction(dataSourceList);
        this.dialogModel.addPropertyChangeListener(editDataSourceAction);
        RemoveDataSourceAction removeDataSourceAction = new RemoveDataSourceAction(dataSourceList);
        this.dialogModel.addPropertyChangeListener(removeDataSourceAction);
        JPanel connectionButtonPanel = new JPanel();
        connectionButtonPanel.setLayout(new FlowLayout(2));
        if (this.isSecurityConfigurationAvailable()) {
            connectionButtonPanel.add(new JButton(this.createEditSecurityAction()));
            connectionButtonPanel.add(Box.createHorizontalStrut(40));
        }
        connectionButtonPanel.add((Component)new BorderlessButton((Action)editDataSourceAction));
        connectionButtonPanel.add((Component)new BorderlessButton((Action)new AddDataSourceAction(dataSourceList)));
        connectionButtonPanel.add((Component)new BorderlessButton((Action)removeDataSourceAction));
        JPanel connectionButtonPanelWrapper = new JPanel(new BorderLayout());
        connectionButtonPanelWrapper.add((Component)new JLabel(this.bundleSupport.getString("ConnectionPanel.Connections")), "Center");
        connectionButtonPanelWrapper.add((Component)connectionButtonPanel, "East");
        this.add("North", connectionButtonPanelWrapper);
        this.add("Center", new JScrollPane(dataSourceList));
    }

    protected abstract Action createEditSecurityAction();

    public boolean isSecurityConfigurationAvailable() {
        return this.securityConfigurationAvailable;
    }

    public void setSecurityConfigurationAvailable(boolean securityConfigurationAvailable) {
        this.securityConfigurationAvailable = securityConfigurationAvailable;
    }

    public DataSourceDialogModel getDialogModel() {
        return this.dialogModel;
    }

    public DesignTimeContext getDesignTimeContext() {
        return this.designTimeContext;
    }

    protected ResourceBundleSupport getBundleSupport() {
        return this.bundleSupport;
    }

    private class AddDataSourceAction
    extends AbstractAction {
        private JList dataSourceList;

        private AddDataSourceAction(JList dataSourceList) {
            this.dataSourceList = dataSourceList;
            URL location = ConnectionPanel.class.getResource("/org/pentaho/reporting/ui/datasources/jdbc/resources/Add.png");
            if (location != null) {
                this.putValue("SmallIcon", new ImageIcon(location));
            } else {
                this.putValue("Name", ConnectionPanel.this.bundleSupport.getString("ConnectionPanel.Add.Name"));
            }
            this.putValue("ShortDescription", ConnectionPanel.this.bundleSupport.getString("ConnectionPanel.Add.Description"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DesignTimeContext designTimeContext = ConnectionPanel.this.getDesignTimeContext();
            try {
                Window parentWindow = LibSwingUtil.getWindowAncestor((Component)ConnectionPanel.this);
                XulDatabaseDialog connectionDialog = new XulDatabaseDialog(parentWindow, designTimeContext);
                JdbcConnectionDefinition connectionDefinition = connectionDialog.open(null);
                if (connectionDefinition != null && !StringUtils.isEmpty((String)connectionDefinition.getName()) && !ConnectionPanel.this.getDialogModel().getConnectionDefinitionManager().updateSourceList(connectionDefinition)) {
                    ConnectionPanel.this.getDialogModel().addConnection(connectionDefinition);
                    this.dataSourceList.setSelectedValue(connectionDefinition, true);
                }
            }
            catch (XulException e1) {
                designTimeContext.error((Exception)((Object)e1));
            }
        }
    }

    private class RemoveDataSourceAction
    extends AbstractAction
    implements PropertyChangeListener {
        private JList dataSourceList;

        private RemoveDataSourceAction(JList dataSourceList) {
            this.dataSourceList = dataSourceList;
            this.setEnabled(ConnectionPanel.this.getDialogModel().isConnectionSelected());
            URL resource = ConnectionPanel.class.getResource("/org/pentaho/reporting/ui/datasources/jdbc/resources/Remove.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", ConnectionPanel.this.bundleSupport.getString("ConnectionPanel.Remove.Name"));
            }
            this.putValue("ShortDescription", ConnectionPanel.this.bundleSupport.getString("ConnectionPanel.Remove.Description"));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setEnabled(ConnectionPanel.this.getDialogModel().isConnectionSelected());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JdbcConnectionDefinition source = (JdbcConnectionDefinition)this.dataSourceList.getSelectedValue();
            if (source != null) {
                ConnectionPanel.this.getDialogModel().getConnectionDefinitionManager().removeSource(source.getName());
                ConnectionPanel.this.getDialogModel().removeConnection(source);
            }
        }
    }

    private class EditDataSourceAction
    extends AbstractAction
    implements PropertyChangeListener {
        private JList dataSourceList;

        private EditDataSourceAction(JList dataSourceList) {
            this.dataSourceList = dataSourceList;
            URL location = ConnectionPanel.class.getResource("/org/pentaho/reporting/ui/datasources/jdbc/resources/Edit.png");
            if (location != null) {
                this.putValue("SmallIcon", new ImageIcon(location));
            } else {
                this.putValue("Name", ConnectionPanel.this.bundleSupport.getString("ConnectionPanel.Edit.Name"));
            }
            this.putValue("ShortDescription", ConnectionPanel.this.bundleSupport.getString("ConnectionPanel.Edit.Description"));
            this.setEnabled(ConnectionPanel.this.getDialogModel().isConnectionSelected());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setEnabled(ConnectionPanel.this.getDialogModel().isConnectionSelected());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JdbcConnectionDefinition existingConnection = (JdbcConnectionDefinition)this.dataSourceList.getSelectedValue();
            DesignTimeContext designTimeContext = ConnectionPanel.this.getDesignTimeContext();
            try {
                Window parentWindow = LibSwingUtil.getWindowAncestor((Component)ConnectionPanel.this);
                XulDatabaseDialog connectionDialog = new XulDatabaseDialog(parentWindow, designTimeContext);
                JdbcConnectionDefinition connectionDefinition = connectionDialog.open(existingConnection);
                if (connectionDefinition != null) {
                    if (!existingConnection.getName().equals(connectionDefinition.getName())) {
                        ConnectionPanel.this.getDialogModel().getConnectionDefinitionManager().removeSource(existingConnection.getName());
                    }
                    DataSourceDialogModel dialogModel = ConnectionPanel.this.getDialogModel();
                    ConnectionPanel.this.getDialogModel().getConnectionDefinitionManager().updateSourceList(connectionDefinition);
                    dialogModel.editConnection(existingConnection, connectionDefinition);
                    this.dataSourceList.setSelectedValue(connectionDefinition, true);
                }
            }
            catch (XulException e1) {
                designTimeContext.error((Exception)((Object)e1));
            }
        }
    }

    private static class SelectionConnectionUpdateHandler
    implements PropertyChangeListener {
        private JList dataSourceList;

        private SelectionConnectionUpdateHandler(JList dataSourceList) {
            this.dataSourceList = dataSourceList;
        }

        @Override
        public void propertyChange(PropertyChangeEvent aEvent) {
            DataSourceDialogModel theDialogModel = (DataSourceDialogModel)aEvent.getSource();
            DefaultComboBoxModel theConnections = theDialogModel.getConnections();
            Object theConnection = theConnections.getSelectedItem();
            if (theConnection != null) {
                this.dataSourceList.setSelectedValue(theConnection, true);
            } else {
                this.dataSourceList.clearSelection();
            }
        }
    }

    private static class DataSourceDefinitionListCellRenderer
    extends DefaultListCellRenderer {
        private DataSourceDefinitionListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel listCellRendererComponent = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null) {
                String jndiName = ((JdbcConnectionDefinition)value).getName();
                if (!"".equals(jndiName)) {
                    listCellRendererComponent.setText(jndiName);
                } else {
                    listCellRendererComponent.setText(" ");
                }
            }
            return listCellRendererComponent;
        }
    }

    private class DataSourceDefinitionListSelectionListener
    implements ListSelectionListener {
        private JList dataSourceList;

        private DataSourceDefinitionListSelectionListener(JList dataSourceList) {
            this.dataSourceList = dataSourceList;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ConnectionPanel.this.getDialogModel().getConnections().setSelectedItem(this.dataSourceList.getSelectedValue());
        }
    }
}

