/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.table;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import org.pentaho.reporting.ui.datasources.table.EditableHeaderTableColumn;
import org.pentaho.reporting.ui.datasources.table.EditableHeaderUI;
import org.pentaho.reporting.ui.datasources.table.TableEditorModel;
import org.pentaho.reporting.ui.datasources.table.TypedHeaderInformation;

public class EditableHeader
extends JTableHeader
implements CellEditorListener {
    private int editingColumn;
    private TableCellEditor cellEditor;
    private Component editorComp;
    private TableEditorModel tableModel;

    public EditableHeader(TableColumnModel columnModel, TableEditorModel aTableModel) {
        super(columnModel);
        this.setReorderingAllowed(false);
        this.cellEditor = null;
        this.tableModel = aTableModel;
    }

    @Override
    public void updateUI() {
        this.setUI(new EditableHeaderUI());
        this.resizeAndRepaint();
        this.invalidate();
    }

    public boolean editCellAt(int index, EventObject e) {
        if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
            return false;
        }
        if (!this.isCellEditable(index)) {
            return false;
        }
        TableCellEditor editor = this.getCellEditor(index);
        if (editor != null && editor.isCellEditable(e)) {
            this.editorComp = this.prepareEditor(editor, index);
            this.editorComp.setBounds(this.getHeaderRect(index));
            this.add(this.editorComp);
            this.editorComp.validate();
            this.setCellEditor(editor);
            this.setEditingColumn(index);
            editor.addCellEditorListener(this);
            return true;
        }
        return false;
    }

    public boolean isCellEditable(int index) {
        if (this.getReorderingAllowed()) {
            return false;
        }
        int columnIndex = this.columnModel.getColumn(index).getModelIndex();
        if (columnIndex == 0) {
            return false;
        }
        EditableHeaderTableColumn col = (EditableHeaderTableColumn)this.columnModel.getColumn(columnIndex);
        return col.isHeaderEditable();
    }

    public TableCellEditor getCellEditor(int index) {
        int columnIndex = this.columnModel.getColumn(index).getModelIndex();
        if (columnIndex == 0) {
            return null;
        }
        EditableHeaderTableColumn col = (EditableHeaderTableColumn)this.columnModel.getColumn(columnIndex);
        return col.getHeaderEditor();
    }

    public void setCellEditor(TableCellEditor newEditor) {
        TableCellEditor oldEditor = this.cellEditor;
        this.cellEditor = newEditor;
        if (oldEditor != null) {
            oldEditor.removeCellEditorListener(this);
        }
        if (newEditor != null) {
            newEditor.addCellEditorListener(this);
        }
    }

    public Component prepareEditor(TableCellEditor editor, int index) {
        Object value = this.columnModel.getColumn(index).getHeaderValue();
        boolean isSelected = true;
        JTable table = this.getTable();
        return editor.getTableCellEditorComponent(table, value, true, -1, index);
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public Component getEditorComponent() {
        return this.editorComp;
    }

    public void setEditingColumn(int aColumn) {
        this.editingColumn = aColumn;
    }

    public int getEditingColumn() {
        return this.editingColumn;
    }

    public void removeEditor() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.removeCellEditorListener(this);
            this.requestFocus();
            this.remove(this.editorComp);
            int index = this.getEditingColumn();
            Rectangle cellRect = this.getHeaderRect(index);
            this.setCellEditor(null);
            this.setEditingColumn(-1);
            this.editorComp = null;
            this.repaint(cellRect);
        }
    }

    public boolean isEditing() {
        return this.cellEditor != null;
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            Object value = editor.getCellEditorValue();
            int index = this.getEditingColumn();
            this.columnModel.getColumn(index).setHeaderValue(value);
            this.removeEditor();
            if (this.tableModel != null && value instanceof TypedHeaderInformation) {
                TypedHeaderInformation hi = (TypedHeaderInformation)value;
                this.tableModel.setColumnName(index, hi.getName());
                this.tableModel.setColumnClass(index, hi.getType());
            }
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        this.removeEditor();
    }
}

