/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class DeleteTableHandler
extends TableEventHandler {
    private static final Log LOG = LogFactory.getLog(DeleteTableHandler.class);

    public DeleteTableHandler(TableName tableName, Server server, MasterServices masterServices) {
        super(EventType.C_M_DELETE_TABLE, tableName, server, masterServices);
    }

    @Override
    protected void prepareWithTableLock() throws IOException {
        this.getTableDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleTableOperation(List<HRegionInfo> regions) throws IOException, KeeperException {
        MasterCoprocessorHost cpHost = ((HMaster)this.server).getCoprocessorHost();
        if (cpHost != null) {
            cpHost.preDeleteTableHandler(this.tableName);
        }
        AssignmentManager am = this.masterServices.getAssignmentManager();
        RegionStates states = am.getRegionStates();
        long waitTime = this.server.getConfiguration().getLong("hbase.master.wait.on.region", 300000L);
        for (HRegionInfo region : regions) {
            long done = System.currentTimeMillis() + waitTime;
            while (System.currentTimeMillis() < done) {
                if (states.isRegionInState(region, RegionState.State.FAILED_OPEN)) {
                    am.regionOffline(region);
                }
                if (!states.isRegionInTransition(region)) break;
                Threads.sleep((long)this.waitingTimeForEvents);
                LOG.debug((Object)("Waiting on region to clear regions in transition; " + am.getRegionStates().getRegionTransitionState(region)));
            }
            if (!states.isRegionInTransition(region)) continue;
            throw new IOException("Waited hbase.master.wait.on.region (" + waitTime + "ms) for region to leave region " + region.getRegionNameAsString() + " in transitions");
        }
        LOG.debug((Object)"Deleting regions from META");
        MetaEditor.deleteRegions(this.server.getCatalogTracker(), regions);
        MasterFileSystem mfs = this.masterServices.getMasterFileSystem();
        Path tempTableDir = mfs.moveTableToTemp(this.tableName);
        try {
            Path regionDir;
            FileSystem fs = mfs.getFileSystem();
            for (HRegionInfo hri : regions) {
                LOG.debug((Object)("Archiving region " + hri.getRegionNameAsString() + " from FS"));
                HFileArchiver.archiveRegion(fs, mfs.getRootDir(), tempTableDir, new Path(tempTableDir, hri.getEncodedName()));
            }
            HColumnDescriptor[] hcds = this.getTableDescriptor().getColumnFamilies();
            boolean hasMob = false;
            for (HColumnDescriptor hcd : hcds) {
                if (!hcd.isMobEnabled()) continue;
                hasMob = true;
                break;
            }
            Path mobTableDir = null;
            if (hasMob && fs.exists(regionDir = new Path(mobTableDir = FSUtils.getTableDir(new Path(mfs.getRootDir(), "mobdir"), this.tableName), MobUtils.getMobRegionInfo(this.tableName).getEncodedName()))) {
                HFileArchiver.archiveRegion(fs, mfs.getRootDir(), mobTableDir, regionDir);
            }
            if (!fs.delete(tempTableDir, true)) {
                LOG.error((Object)("Couldn't delete " + tempTableDir));
            }
            if (hasMob && mobTableDir != null && fs.exists(mobTableDir) && !fs.delete(mobTableDir, true)) {
                LOG.error((Object)("Couldn't delete " + mobTableDir));
            }
            LOG.debug((Object)("Table '" + this.tableName + "' archived!"));
        }
        finally {
            LOG.debug((Object)("Removing '" + this.tableName + "' descriptor."));
            this.masterServices.getTableDescriptors().remove(this.tableName);
            LOG.debug((Object)("Removing '" + this.tableName + "' from region states."));
            states.tableDeleted(this.tableName);
            LOG.debug((Object)("Marking '" + this.tableName + "' as deleted."));
            am.getZKTable().setDeletedTable(this.tableName);
        }
        if (cpHost != null) {
            cpHost.postDeleteTableHandler(this.tableName);
        }
    }

    @Override
    protected void releaseTableLock() {
        super.releaseTableLock();
        try {
            this.masterServices.getTableLockManager().tableDeleted(this.tableName);
        }
        catch (IOException ex) {
            LOG.warn((Object)"Received exception from TableLockManager.tableDeleted:", (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableName;
    }
}

