/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import com.google.common.annotations.VisibleForTesting;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.apache.commons.vfs.FileObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeAdapter;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.AddUndoPositionInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.JndiUtil;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.LastUsedFile;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.ObjectUsageCount;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.di.core.changed.PDIObserver;
import org.pentaho.di.core.clipboard.ImageDataTransfer;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleAuthException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleMissingPluginsException;
import org.pentaho.di.core.exception.KettleRowException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.gui.GUIFactory;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.gui.SpoonInterface;
import org.pentaho.di.core.gui.ThreadDialogs;
import org.pentaho.di.core.gui.UndoInterface;
import org.pentaho.di.core.lifecycle.LifeEventHandler;
import org.pentaho.di.core.lifecycle.LifeEventInfo;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleSupport;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.FileLoggingEventListener;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.KettleLoggingEventListener;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.namedcluster.NamedClusterManager;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PartitionerPluginType;
import org.pentaho.di.core.plugins.PluginFolder;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.PluginTypeListener;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.reflection.StringSearchResult;
import org.pentaho.di.core.row.RowBuffer;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.undo.TransAction;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.imp.ImportRules;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobExecutionConfiguration;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.job.JobEntryJob;
import org.pentaho.di.job.entries.trans.JobEntryTrans;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.laf.BasePropertyHandler;
import org.pentaho.di.metastore.MetaStoreConst;
import org.pentaho.di.pan.CommandLineOption;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.pkg.JarfileGenerator;
import org.pentaho.di.repository.KettleRepositoryLostException;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryCapabilities;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.repository.RepositorySecurityProvider;
import org.pentaho.di.resource.ResourceExportInterface;
import org.pentaho.di.resource.ResourceUtil;
import org.pentaho.di.resource.TopLevelResource;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.HasSlaveServersInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowDistributionInterface;
import org.pentaho.di.trans.step.RowDistributionPluginType;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesMeta;
import org.pentaho.di.ui.cluster.dialog.ClusterSchemaDialog;
import org.pentaho.di.ui.cluster.dialog.SlaveServerDialog;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.core.PrintSpool;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.auth.AuthProviderDialog;
import org.pentaho.di.ui.core.database.wizard.CreateDatabaseWizard;
import org.pentaho.di.ui.core.dialog.CheckResultDialog;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.EnterOptionsDialog;
import org.pentaho.di.ui.core.dialog.EnterSearchDialog;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.EnterStringsDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.KettlePropertiesFileDialog;
import org.pentaho.di.ui.core.dialog.PopupOverwritePrompter;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.dialog.ShowBrowserDialog;
import org.pentaho.di.ui.core.dialog.ShowMessageDialog;
import org.pentaho.di.ui.core.dialog.Splash;
import org.pentaho.di.ui.core.dialog.SubjectDataBrowserDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.OsHelper;
import org.pentaho.di.ui.core.widget.TreeMemory;
import org.pentaho.di.ui.imp.ImportRulesDialog;
import org.pentaho.di.ui.job.dialog.JobDialogPluginType;
import org.pentaho.di.ui.job.dialog.JobLoadProgressDialog;
import org.pentaho.di.ui.partition.dialog.PartitionSchemaDialog;
import org.pentaho.di.ui.repository.ILoginCallback;
import org.pentaho.di.ui.repository.RepositoriesDialog;
import org.pentaho.di.ui.repository.RepositorySecurityUI;
import org.pentaho.di.ui.repository.dialog.RepositoryDialogInterface;
import org.pentaho.di.ui.repository.dialog.RepositoryExportProgressDialog;
import org.pentaho.di.ui.repository.dialog.RepositoryImportProgressDialog;
import org.pentaho.di.ui.repository.dialog.RepositoryRevisionBrowserDialogInterface;
import org.pentaho.di.ui.repository.dialog.SelectDirectoryDialog;
import org.pentaho.di.ui.repository.dialog.SelectObjectDialog;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorer;
import org.pentaho.di.ui.repository.repositoryexplorer.RepositoryExplorerCallback;
import org.pentaho.di.ui.repository.repositoryexplorer.UISupportRegistery;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryContent;
import org.pentaho.di.ui.repository.repositoryexplorer.uisupport.BaseRepositoryExplorerUISupport;
import org.pentaho.di.ui.repository.repositoryexplorer.uisupport.ManageUserUISupport;
import org.pentaho.di.ui.spoon.FileListener;
import org.pentaho.di.ui.spoon.ISpoonMenuController;
import org.pentaho.di.ui.spoon.JobFileListener;
import org.pentaho.di.ui.spoon.MainSpoonPerspective;
import org.pentaho.di.ui.spoon.PartitionSchemasProvider;
import org.pentaho.di.ui.spoon.Sleak;
import org.pentaho.di.ui.spoon.SpoonLifecycleListener;
import org.pentaho.di.ui.spoon.SpoonPerspective;
import org.pentaho.di.ui.spoon.SpoonPerspectiveManager;
import org.pentaho.di.ui.spoon.SpoonPerspectiveOpenSaveInterface;
import org.pentaho.di.ui.spoon.SpoonPluginManager;
import org.pentaho.di.ui.spoon.SpoonPluginType;
import org.pentaho.di.ui.spoon.TabItemInterface;
import org.pentaho.di.ui.spoon.TabMapEntry;
import org.pentaho.di.ui.spoon.TransFileListener;
import org.pentaho.di.ui.spoon.TreeSelection;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegates;
import org.pentaho.di.ui.spoon.dialog.AnalyseImpactProgressDialog;
import org.pentaho.di.ui.spoon.dialog.CheckTransProgressDialog;
import org.pentaho.di.ui.spoon.dialog.LogSettingsDialog;
import org.pentaho.di.ui.spoon.dialog.MetaStoreExplorerDialog;
import org.pentaho.di.ui.spoon.dialog.SaveProgressDialog;
import org.pentaho.di.ui.spoon.dialog.TipsDialog;
import org.pentaho.di.ui.spoon.job.JobGraph;
import org.pentaho.di.ui.spoon.partition.PartitionMethodSelector;
import org.pentaho.di.ui.spoon.partition.PartitionSettings;
import org.pentaho.di.ui.spoon.partition.processor.MethodProcessor;
import org.pentaho.di.ui.spoon.partition.processor.MethodProcessorFactory;
import org.pentaho.di.ui.spoon.trans.TransGraph;
import org.pentaho.di.ui.spoon.wizards.CopyTableWizardPage1;
import org.pentaho.di.ui.spoon.wizards.CopyTableWizardPage2;
import org.pentaho.di.ui.trans.dialog.TransDialogPluginType;
import org.pentaho.di.ui.trans.dialog.TransHopDialog;
import org.pentaho.di.ui.trans.dialog.TransLoadProgressDialog;
import org.pentaho.di.ui.util.HelpUtils;
import org.pentaho.di.ui.util.ThreadGuiResources;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.di.version.BuildVersion;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.stores.delegate.DelegatingMetaStore;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulEventSource;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.WaitBoxRunnable;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.components.XulMenuseparator;
import org.pentaho.ui.xul.components.XulToolbarbutton;
import org.pentaho.ui.xul.components.XulWaitBox;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulMenupopup;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.jface.tags.ApplicationWindowLocal;
import org.pentaho.ui.xul.jface.tags.JfaceMenuitem;
import org.pentaho.ui.xul.jface.tags.JfaceMenupopup;
import org.pentaho.ui.xul.swt.tags.SwtDeck;
import org.pentaho.vfs.ui.VfsFileChooserDialog;
import org.pentaho.xul.swt.tab.TabItem;
import org.pentaho.xul.swt.tab.TabListener;
import org.pentaho.xul.swt.tab.TabSet;
import org.w3c.dom.Node;

public class Spoon
extends ApplicationWindow
implements AddUndoPositionInterface,
TabListener,
SpoonInterface,
OverwritePrompter,
PDIObserver,
LifeEventHandler,
XulEventSource,
XulEventHandler,
PartitionSchemasProvider {
    private static Class<?> PKG = Spoon.class;
    public static final LoggingObjectInterface loggingObject = new SimpleLoggingObject("Spoon", LoggingObjectType.SPOON, null);
    public static final String STRING_TRANSFORMATIONS = BaseMessages.getString(PKG, (String)"Spoon.STRING_TRANSFORMATIONS", (String[])new String[0]);
    public static final String STRING_JOBS = BaseMessages.getString(PKG, (String)"Spoon.STRING_JOBS", (String[])new String[0]);
    public static final String STRING_BUILDING_BLOCKS = BaseMessages.getString(PKG, (String)"Spoon.STRING_BUILDING_BLOCKS", (String[])new String[0]);
    public static final String STRING_ELEMENTS = BaseMessages.getString(PKG, (String)"Spoon.STRING_ELEMENTS", (String[])new String[0]);
    public static final String STRING_CONNECTIONS = BaseMessages.getString(PKG, (String)"Spoon.STRING_CONNECTIONS", (String[])new String[0]);
    public static final String STRING_STEPS = BaseMessages.getString(PKG, (String)"Spoon.STRING_STEPS", (String[])new String[0]);
    public static final String STRING_JOB_ENTRIES = BaseMessages.getString(PKG, (String)"Spoon.STRING_JOB_ENTRIES", (String[])new String[0]);
    public static final String STRING_HOPS = BaseMessages.getString(PKG, (String)"Spoon.STRING_HOPS", (String[])new String[0]);
    public static final String STRING_PARTITIONS = BaseMessages.getString(PKG, (String)"Spoon.STRING_PARTITIONS", (String[])new String[0]);
    public static final String STRING_SLAVES = BaseMessages.getString(PKG, (String)"Spoon.STRING_SLAVES", (String[])new String[0]);
    public static final String STRING_CLUSTERS = BaseMessages.getString(PKG, (String)"Spoon.STRING_CLUSTERS", (String[])new String[0]);
    public static final String STRING_TRANS_BASE = BaseMessages.getString(PKG, (String)"Spoon.STRING_BASE", (String[])new String[0]);
    public static final String STRING_HISTORY = BaseMessages.getString(PKG, (String)"Spoon.STRING_HISTORY", (String[])new String[0]);
    public static final String STRING_TRANS_NO_NAME = BaseMessages.getString(PKG, (String)"Spoon.STRING_TRANS_NO_NAME", (String[])new String[0]);
    public static final String STRING_JOB_NO_NAME = BaseMessages.getString(PKG, (String)"Spoon.STRING_JOB_NO_NAME", (String[])new String[0]);
    public static final String STRING_TRANSFORMATION = BaseMessages.getString(PKG, (String)"Spoon.STRING_TRANSFORMATION", (String[])new String[0]);
    public static final String STRING_JOB = BaseMessages.getString(PKG, (String)"Spoon.STRING_JOB", (String[])new String[0]);
    public static final String STRING_NAMED_CLUSTERS = BaseMessages.getString(PKG, (String)"Spoon.STRING_NAMED_CLUSTERS", (String[])new String[0]);
    private static final String SYNC_TRANS = "sync_trans_name_to_file_name";
    public static final String APP_NAME = BaseMessages.getString(PKG, (String)"Spoon.Application.Name", (String[])new String[0]);
    private static final String STRING_SPOON_MAIN_TREE = BaseMessages.getString(PKG, (String)"Spoon.MainTree.Label", (String[])new String[0]);
    private static final String STRING_SPOON_CORE_OBJECTS_TREE = BaseMessages.getString(PKG, (String)"Spoon.CoreObjectsTree.Label", (String[])new String[0]);
    public static final String XML_TAG_TRANSFORMATION_STEPS = "transformation-steps";
    public static final String XML_TAG_JOB_JOB_ENTRIES = "job-jobentries";
    private static final String XML_TAG_STEPS = "steps";
    public static final int MESSAGE_DIALOG_WITH_TOGGLE_YES_BUTTON_ID = 256;
    public static final int MESSAGE_DIALOG_WITH_TOGGLE_NO_BUTTON_ID = 257;
    public static final int MESSAGE_DIALOG_WITH_TOGGLE_CUSTOM_DISTRIBUTION_BUTTON_ID = 258;
    private static Spoon staticSpoon;
    private static LogChannelInterface log;
    private Display display;
    private Shell shell;
    private static Splash splash;
    private static FileLoggingEventListener fileLoggingEventListener;
    private boolean destroy;
    private SashForm sashform;
    public TabSet tabfolder;
    public SpoonDelegates delegates = new SpoonDelegates(this);
    public RowMetaAndData variables = new RowMetaAndData((RowMetaInterface)new RowMeta(), new Object[0]);
    private String[] arguments;
    private boolean stopped;
    private Cursor cursor_hourglass;
    private Cursor cursor_hand;
    public PropsUI props;
    public Repository rep;
    public RepositoryCapabilities capabilities;
    private RepositoryDirectoryInterface defaultSaveLocation = null;
    private Repository defaultSaveLocationRepository = null;
    private CTabItem view;
    private CTabItem design;
    private Label selectionLabel;
    public Text selectionFilter;
    private Menu fileMenus;
    private static final String APP_TITLE;
    private static final String STRING_WELCOME_TAB_NAME;
    private static final String STRING_DOCUMENT_TAB_NAME;
    private static final String FILE_WELCOME_PAGE;
    private static final String FILE_DOCUMENT_MAP;
    private static final String FILE_DOCUMENT_INSTAVIEW;
    private static final String UNDO_MENU_ITEM = "edit-undo";
    private static final String REDO_MENU_ITEM = "edit-redo";
    private static final String UNDO_UNAVAILABLE;
    private static final String REDO_UNAVAILABLE;
    private Composite tabComp;
    private Tree selectionTree;
    private Tree coreObjectsTree;
    private TransExecutionConfiguration transExecutionConfiguration;
    private TransExecutionConfiguration transPreviewExecutionConfiguration;
    private TransExecutionConfiguration transDebugExecutionConfiguration;
    private JobExecutionConfiguration jobExecutionConfiguration;
    private int coreObjectsState = 1;
    protected Map<String, FileListener> fileExtensionMap = new HashMap<String, FileListener>();
    private List<Object[]> menuListeners = new ArrayList<Object[]>();
    private LifecycleSupport lifecycleSupport = new LifecycleSupport();
    private Composite mainComposite;
    private boolean viewSelected;
    private boolean designSelected;
    private Composite variableComposite;
    private Map<String, String> coreStepToolTipMap;
    private Map<String, String> coreJobToolTipMap;
    private DefaultToolTip toolTip;
    public Map<String, SharedObjects> sharedObjectsFileMap;
    public String lastDirOpened;
    private List<FileListener> fileListeners = new ArrayList<FileListener>();
    private XulDomContainer mainSpoonContainer;
    private List<ISpoonMenuController> menuControllers = new ArrayList<ISpoonMenuController>();
    private XulToolbar mainToolbar;
    private SwtDeck deck;
    public static final String XUL_FILE_MAIN = "ui/spoon.xul";
    private Map<String, XulComponent> menuMap = new HashMap<String, XulComponent>();
    private RepositoriesDialog loginDialog;
    private VfsFileChooserDialog vfsFileChooserDialog;
    protected String startupPerspective = null;
    private CommandLineOption[] commandLineOptions;
    public DelegatingMetaStore metaStore;
    private boolean previousShowTrans;
    private boolean previousShowJob;
    public boolean showTrans;
    public boolean showJob;
    private Object selectionObjectParent = null;
    private Object selectionObject = null;
    private String lastFileOpened = null;
    protected PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public static void main(String[] a) throws KettleException {
        block6: {
            ExecutorService executor = Executors.newCachedThreadPool();
            Future<KettleException> pluginRegistryFuture = executor.submit(new Callable<KettleException>(){

                @Override
                public KettleException call() throws Exception {
                    Spoon.registerUIPluginObjectTypes();
                    try {
                        KettleEnvironment.init();
                    }
                    catch (KettleException e) {
                        return e;
                    }
                    KettleClientEnvironment.getInstance().setClient(KettleClientEnvironment.ClientType.SPOON);
                    return null;
                }
            });
            try {
                Display display;
                OsHelper.setAppName();
                if (System.getProperties().containsKey("SLEAK")) {
                    DeviceData data = new DeviceData();
                    data.tracking = true;
                    display = new Display(data);
                    Sleak sleak = new Sleak();
                    Shell sleakShell = new Shell(display);
                    sleakShell.setText("S-Leak");
                    Point size = sleakShell.getSize();
                    sleakShell.setSize(size.x / 2, size.y / 2);
                    sleak.create((Composite)sleakShell);
                    sleakShell.open();
                } else {
                    display = new Display();
                }
                OsHelper.initOsHandlers(display);
                UIManager.setLookAndFeel(new MetalLookAndFeel());
                splash = new Splash(display);
                ArrayList<String> args = new ArrayList<String>(Arrays.asList(a));
                CommandLineOption[] commandLineOptions = Spoon.getCommandLineArgs(args);
                KettleException registryException = pluginRegistryFuture.get();
                if (registryException != null) {
                    throw registryException;
                }
                PropsUI.init(display, 1);
                KettleLogStore.init((int)PropsUI.getInstance().getMaxNrLinesInLog(), (int)PropsUI.getInstance().getMaxLogLineTimeoutMinutes());
                Spoon.initLogging(commandLineOptions);
                staticSpoon = new Spoon();
                Spoon.staticSpoon.commandLineOptions = commandLineOptions;
                StringBuffer perspectiveIdBuff = Spoon.getCommandLineOption(commandLineOptions, "perspective").getArgument();
                String pId = perspectiveIdBuff.toString();
                if (!Const.isEmpty((String)pId)) {
                    Spoon.staticSpoon.startupPerspective = pId;
                }
                SpoonFactory.setSpoonInstance((SpoonInterface)staticSpoon);
                staticSpoon.setDestroy(true);
                GUIFactory.setThreadDialogs((ThreadDialogs)new ThreadGuiResources());
                staticSpoon.setArguments(args.toArray(new String[args.size()]));
                staticSpoon.start();
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (staticSpoon == null) break block6;
                log.logError("Fatal error : " + Const.NVL((String)t.toString(), (String)Const.NVL((String)t.getMessage(), (String)"Unknown error")));
                log.logError(Const.getStackTracker((Throwable)t));
            }
        }
        System.exit(0);
    }

    private static void initLogging(CommandLineOption[] options) throws KettleException {
        StringBuffer optionLogFile = Spoon.getCommandLineOption(options, "logfile").getArgument();
        StringBuffer optionLogLevel = Spoon.getCommandLineOption(options, "level").getArgument();
        Locale.setDefault(Const.DEFAULT_LOCALE);
        if (!Const.isEmpty((StringBuffer)optionLogFile)) {
            fileLoggingEventListener = new FileLoggingEventListener(optionLogFile.toString(), true);
            if (log.isBasic()) {
                String filename = fileLoggingEventListener.getFilename();
                log.logBasic(BaseMessages.getString(PKG, (String)"Spoon.Log.LoggingToFile", (String[])new String[0]) + filename);
            }
            KettleLogStore.getAppender().addLoggingEventListener((KettleLoggingEventListener)fileLoggingEventListener);
        } else {
            fileLoggingEventListener = null;
        }
        if (!Const.isEmpty((StringBuffer)optionLogLevel)) {
            log.setLogLevel(LogLevel.getLogLevelForCode((String)optionLogLevel.toString()));
            if (log.isBasic()) {
                log.logBasic(BaseMessages.getString(PKG, (String)"Spoon.Log.LoggingAtLevel", (String[])new String[0]) + log.getLogLevel().getDescription());
            }
        }
    }

    public Spoon() {
        this(null);
    }

    public Spoon(Repository rep) {
        super(null);
        this.addMenuBar();
        log = new LogChannel((Object)APP_NAME);
        SpoonFactory.setSpoonInstance((SpoonInterface)this);
        this.metaStore = new DelegatingMetaStore();
        try {
            IMetaStore localMetaStore = MetaStoreConst.openLocalPentahoMetaStore();
            this.metaStore.addMetaStore(localMetaStore);
            this.metaStore.setActiveMetaStoreName(localMetaStore.getName());
            if (rep != null) {
                this.metaStore.addMetaStore(0, rep.getMetaStore());
                this.metaStore.setActiveMetaStoreName(rep.getMetaStore().getName());
            }
        }
        catch (MetaStoreException e) {
            new ErrorDialog(this.shell, "Error opening Pentaho Metastore", "Unable to open local Pentaho Metastore", (Exception)((Object)e));
        }
        this.setRepository(rep);
        this.props = PropsUI.getInstance();
        this.sharedObjectsFileMap = new Hashtable<String, SharedObjects>();
        Thread uiThread = Thread.currentThread();
        this.display = Display.findDisplay((Thread)uiThread);
        staticSpoon = this;
        try {
            JndiUtil.initJNDI();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Unable to init simple JNDI", "Unable to init simple JNDI", e);
        }
    }

    private static void registerUIPluginObjectTypes() {
        RepositoryPluginType.getInstance().addObjectType(RepositoryRevisionBrowserDialogInterface.class, "version-browser-classname");
        RepositoryPluginType.getInstance().addObjectType(RepositoryDialogInterface.class, "dialog-classname");
        PluginRegistry.addPluginType((PluginTypeInterface)SpoonPluginType.getInstance());
        SpoonPluginType.getInstance().getPluginFolders().add(new PluginFolder("plugins/repositories", false, true));
        LifecyclePluginType.getInstance().getPluginFolders().add(new PluginFolder("plugins/spoon", false, true));
        LifecyclePluginType.getInstance().getPluginFolders().add(new PluginFolder("plugins/repositories", false, true));
        PluginRegistry.addPluginType((PluginTypeInterface)JobDialogPluginType.getInstance());
        PluginRegistry.addPluginType((PluginTypeInterface)TransDialogPluginType.getInstance());
    }

    public void init(TransMeta ti) {
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.shell.setLayout((Layout)layout);
        this.addFileListener(new TransFileListener());
        this.addFileListener(new JobFileListener());
        if (ti != null) {
            this.delegates.trans.addTransformation(ti);
        }
        this.loadSettings();
        this.transExecutionConfiguration = new TransExecutionConfiguration();
        this.transExecutionConfiguration.setGatheringMetrics(true);
        this.transPreviewExecutionConfiguration = new TransExecutionConfiguration();
        this.transPreviewExecutionConfiguration.setGatheringMetrics(true);
        this.transDebugExecutionConfiguration = new TransExecutionConfiguration();
        this.transDebugExecutionConfiguration.setGatheringMetrics(true);
        this.jobExecutionConfiguration = new JobExecutionConfiguration();
        this.variables = new RowMetaAndData((RowMetaInterface)new RowMeta(), new Object[0]);
        Image[] images = new Image[]{GUIResource.getInstance().getImageSpoonHigh(), GUIResource.getInstance().getImageSpoon()};
        this.shell.setImages(images);
        this.cursor_hourglass = new Cursor((Device)this.display, 1);
        this.cursor_hand = new Cursor((Device)this.display, 21);
        Composite sashComposite = null;
        MainSpoonPerspective mainPerspective = null;
        try {
            Composite tempSashComposite;
            KettleXulLoader xulLoader = new KettleXulLoader();
            xulLoader.setOuterContext(this.shell);
            xulLoader.setSettingsManager(XulSpoonSettingsManager.getInstance());
            ApplicationWindowLocal.setApplicationWindow((ApplicationWindow)this);
            this.mainSpoonContainer = xulLoader.loadXul(XUL_FILE_MAIN, new XulSpoonResourceBundle());
            DefaultBindingFactory bf = new DefaultBindingFactory();
            bf.setDocument(this.mainSpoonContainer.getDocumentRoot());
            this.mainSpoonContainer.addEventHandler((XulEventHandler)this);
            this.mainSpoonContainer.getDocumentRoot().getElementById("spoon-menubar");
            this.mainToolbar = (XulToolbar)this.mainSpoonContainer.getDocumentRoot().getElementById("main-toolbar");
            this.mainSpoonContainer.getDocumentRoot().getElementById("trans-job-canvas");
            this.deck = (SwtDeck)this.mainSpoonContainer.getDocumentRoot().getElementById("canvas-deck");
            sashComposite = tempSashComposite = new Composite((Composite)this.shell, 0);
            mainPerspective = new MainSpoonPerspective(tempSashComposite, this.tabfolder);
            if (this.startupPerspective == null) {
                this.startupPerspective = mainPerspective.getId();
            }
            SpoonPerspectiveManager.getInstance().setStartupPerspective(this.startupPerspective);
            SpoonPerspectiveManager.getInstance().addPerspective(mainPerspective);
            SpoonPluginManager.getInstance().applyPluginsForContainer("spoon", this.mainSpoonContainer);
            SpoonPerspectiveManager.getInstance().setDeck((XulDeck)this.deck);
            SpoonPerspectiveManager.getInstance().setXulDoc(this.mainSpoonContainer);
            SpoonPerspectiveManager.getInstance().initialize();
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error initializing transformation", (Throwable)e);
        }
        WindowProperty windowProperty = this.props.getScreen(APP_TITLE);
        if (windowProperty != null) {
            windowProperty.setShell(this.shell);
        } else {
            this.shell.pack();
            this.shell.setMaximized(true);
        }
        layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        sashComposite.setLayoutData((Object)data);
        sashComposite.setLayout((Layout)layout);
        this.sashform = new SashForm(sashComposite, 256);
        FormData fdSash = new FormData();
        fdSash.left = new FormAttachment(0, 0);
        fdSash.top = new FormAttachment(0, 0);
        fdSash.bottom = new FormAttachment(100, 0);
        fdSash.right = new FormAttachment(100, 0);
        this.sashform.setLayoutData((Object)fdSash);
        this.createPopupMenus();
        this.addTree();
        this.addTabs();
        mainPerspective.setTabset(this.tabfolder);
        ((Composite)this.deck.getManagedObject()).layout(true, true);
        SpoonPluginManager.getInstance().notifyLifecycleListeners(SpoonLifecycleListener.SpoonLifeCycleEvent.STARTUP);
        if (this.props.showWelcomePageOnStartup()) {
            this.showWelcomePage();
        }
        int operations = 17;
        DropTarget target = new DropTarget((Control)this.shell, operations);
        final FileTransfer fileTransfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{fileTransfer};
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void drop(DropTargetEvent event) {
                if (fileTransfer.isSupportedType(event.currentDataType)) {
                    String[] files;
                    for (String file : files = (String[])event.data) {
                        Spoon.this.openFile(file, false);
                    }
                }
            }
        });
        PluginRegistry.getInstance().addPluginListener(StepPluginType.class, new PluginTypeListener(){

            public void pluginAdded(Object serviceObject) {
                Spoon.this.previousShowTrans = false;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Spoon.this.refreshCoreObjects();
                    }
                });
            }

            public void pluginRemoved(Object serviceObject) {
                Spoon.this.previousShowTrans = false;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Spoon.this.refreshCoreObjects();
                    }
                });
            }

            public void pluginChanged(Object serviceObject) {
            }
        });
    }

    public XulDomContainer getMainSpoonContainer() {
        return this.mainSpoonContainer;
    }

    public void loadPerspective(String id) {
        List<SpoonPerspective> perspectives = SpoonPerspectiveManager.getInstance().getPerspectives();
        for (int pos = 0; pos < perspectives.size(); ++pos) {
            SpoonPerspective perspective = perspectives.get(pos);
            if (!perspective.getId().equals(id)) continue;
            this.loadPerspective(pos);
            return;
        }
    }

    public void loadPerspective(int pos) {
        try {
            SpoonPerspectiveManager.getInstance().activatePerspective(SpoonPerspectiveManager.getInstance().getPerspectives().get(pos).getClass());
        }
        catch (KettleException e) {
            log.logError("Error loading perspective", (Throwable)e);
        }
    }

    public static Spoon getInstance() {
        return staticSpoon;
    }

    public VfsFileChooserDialog getVfsFileChooserDialog(FileObject rootFile, FileObject initialFile) {
        if (this.vfsFileChooserDialog == null) {
            this.vfsFileChooserDialog = new VfsFileChooserDialog(this.shell, KettleVFS.getInstance().getFileSystemManager(), rootFile, initialFile);
        }
        this.vfsFileChooserDialog.setRootFile(rootFile);
        this.vfsFileChooserDialog.setInitialFile(initialFile);
        return this.vfsFileChooserDialog;
    }

    public boolean closeFile() {
        boolean closed = true;
        EngineMetaInterface meta = this.getActiveMeta();
        if (meta != null) {
            closed = this.tabCloseSelected();
        }
        return closed;
    }

    public boolean closeAllFiles() {
        int numTabs = this.delegates.tabs.getTabs().size();
        for (int i = numTabs - 1; i >= 0; --i) {
            this.tabfolder.setSelected(i);
            if (this.closeFile()) continue;
            return false;
        }
        return true;
    }

    public boolean closeAllJobsAndTransformations() {
        List<TransMeta> transList = this.delegates.trans.getTransformationList();
        List<JobMeta> jobList = this.delegates.jobs.getJobList();
        if (transList.size() == 0 && jobList.size() == 0) {
            return true;
        }
        boolean createPerms = !RepositorySecurityUI.verifyOperations(this.shell, this.rep, false, RepositoryOperation.MODIFY_TRANSFORMATION, RepositoryOperation.MODIFY_JOB);
        boolean executePerms = !RepositorySecurityUI.verifyOperations(this.shell, this.rep, false, RepositoryOperation.EXECUTE_TRANSFORMATION, RepositoryOperation.EXECUTE_JOB);
        boolean readPerms = !RepositorySecurityUI.verifyOperations(this.shell, this.rep, false, RepositoryOperation.READ_TRANSFORMATION, RepositoryOperation.READ_JOB);
        String warningTitle = BaseMessages.getString(PKG, (String)"Spoon.Dialog.WarnToCloseAllForce.Disconnect.Title", (String[])new String[0]);
        String warningText = BaseMessages.getString(PKG, (String)"Spoon.Dialog.WarnToCloseAllForce.Disconnect.Message", (String[])new String[0]);
        int buttons = 32;
        if (readPerms && createPerms && executePerms) {
            warningTitle = BaseMessages.getString(PKG, (String)"Spoon.Dialog.WarnToCloseAllOption.Disconnect.Title", (String[])new String[0]);
            warningText = BaseMessages.getString(PKG, (String)"Spoon.Dialog.WarnToCloseAllOption.Disconnect.Message", (String[])new String[0]);
            buttons = 192;
        }
        MessageBox mb = new MessageBox(Spoon.getInstance().getShell(), buttons | 8);
        mb.setMessage(warningText);
        mb.setText(warningTitle);
        int isCloseAllFiles = mb.open();
        if (isCloseAllFiles == 64 || isCloseAllFiles == 32) {
            return Spoon.getInstance().closeAllFiles();
        }
        return isCloseAllFiles == 128 && executePerms;
    }

    public void closeSpoonBrowser() {
        TabMapEntry browserTab = this.delegates.tabs.findTabMapEntry(STRING_WELCOME_TAB_NAME, TabMapEntry.ObjectType.BROWSER);
        if (browserTab != null) {
            this.delegates.tabs.removeTab(browserTab);
        }
    }

    public void searchMetaData() {
        boolean add;
        List stringList;
        String filter;
        TransMeta[] transMetas = this.getLoadedTransformations();
        JobMeta[] jobMetas = this.getLoadedJobs();
        if (!(transMetas != null && transMetas.length != 0 || jobMetas != null && jobMetas.length != 0)) {
            return;
        }
        EnterSearchDialog esd = new EnterSearchDialog(this.shell);
        if (!esd.open()) {
            return;
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (TransMeta transMeta : transMetas) {
            filter = esd.getFilterString();
            if (filter != null) {
                filter = filter.toUpperCase();
            }
            stringList = transMeta.getStringList(esd.isSearchingSteps(), esd.isSearchingDatabases(), esd.isSearchingNotes());
            for (StringSearchResult result : stringList) {
                add = Const.isEmpty((String)filter);
                if (filter != null && result.getString().toUpperCase().contains(filter)) {
                    add = true;
                }
                if (filter != null && result.getFieldName().toUpperCase().contains(filter)) {
                    add = true;
                }
                if (filter != null && result.getParentObject().toString().toUpperCase().contains(filter)) {
                    add = true;
                }
                if (filter != null && result.getGrandParentObject().toString().toUpperCase().contains(filter)) {
                    add = true;
                }
                if (!add) continue;
                rows.add(result.toRow());
            }
        }
        for (TransMeta transMeta : jobMetas) {
            filter = esd.getFilterString();
            if (filter != null) {
                filter = filter.toUpperCase();
            }
            stringList = transMeta.getStringList(esd.isSearchingSteps(), esd.isSearchingDatabases(), esd.isSearchingNotes());
            for (StringSearchResult result : stringList) {
                add = Const.isEmpty((String)filter);
                if (filter != null && result.getString().toUpperCase().contains(filter)) {
                    add = true;
                }
                if (filter != null && result.getFieldName().toUpperCase().contains(filter)) {
                    add = true;
                }
                if (filter != null && result.getParentObject().toString().toUpperCase().contains(filter)) {
                    add = true;
                }
                if (filter != null && result.getGrandParentObject().toString().toUpperCase().contains(filter)) {
                    add = true;
                }
                if (!add) continue;
                rows.add(result.toRow());
            }
        }
        if (rows.size() != 0) {
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, Variables.getADefaultVariableSpace(), 0, BaseMessages.getString(PKG, (String)"Spoon.StringSearchResult.Subtitle", (String[])new String[0]), StringSearchResult.getResultRowMeta(), rows);
            String title = BaseMessages.getString(PKG, (String)"Spoon.StringSearchResult.Title", (String[])new String[0]);
            String message = BaseMessages.getString(PKG, (String)"Spoon.StringSearchResult.Message", (String[])new String[0]);
            prd.setTitleMessage(title, message);
            prd.open();
        } else {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.NothingFound.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.NothingFound.Title", (String[])new String[0]));
            mb.open();
        }
    }

    public void showArguments() {
        RowMetaAndData allArgs = new RowMetaAndData();
        for (int ii = 0; ii < this.arguments.length; ++ii) {
            allArgs.addValue((ValueMetaInterface)new ValueMeta("Argument " + (1 + ii), 2), (Object)this.arguments[ii]);
        }
        EnterStringsDialog esd = new EnterStringsDialog(this.shell, 0, allArgs);
        esd.setTitle(BaseMessages.getString(PKG, (String)"Spoon.Dialog.ShowArguments.Title", (String[])new String[0]));
        esd.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.ShowArguments.Message", (String[])new String[0]));
        esd.setReadOnly(true);
        esd.setShellImage(GUIResource.getInstance().getImageLogoSmall());
        esd.open();
    }

    private void fillVariables(RowMetaAndData vars) {
        String varValue;
        List list;
        String[] keys;
        TransMeta[] transMetas = this.getLoadedTransformations();
        JobMeta[] jobMetas = this.getLoadedJobs();
        if (!(transMetas != null && transMetas.length != 0 || jobMetas != null && jobMetas.length != 0)) {
            return;
        }
        Properties sp = new Properties();
        sp.putAll((Map<?, ?>)System.getProperties());
        VariableSpace space = Variables.getADefaultVariableSpace();
        for (String string : keys = space.listVariables()) {
            sp.put(string, space.getVariable(string));
        }
        for (String string : transMetas) {
            list = string.getUsedVariables();
            for (String varName : list) {
                varValue = sp.getProperty(varName, "");
                if (vars.getRowMeta().indexOfValue(varName) >= 0 || varName.startsWith("Internal")) continue;
                vars.addValue((ValueMetaInterface)new ValueMeta(varName, 2), (Object)varValue);
            }
        }
        for (String string : jobMetas) {
            list = string.getUsedVariables();
            for (String varName : list) {
                varValue = sp.getProperty(varName, "");
                if (vars.getRowMeta().indexOfValue(varName) >= 0 || varName.startsWith("Internal")) continue;
                vars.addValue((ValueMetaInterface)new ValueMeta(varName, 2), (Object)varValue);
            }
        }
    }

    public void setVariables() {
        this.fillVariables(this.variables);
        EnterStringsDialog esd = new EnterStringsDialog(this.shell, 0, this.variables);
        esd.setTitle(BaseMessages.getString(PKG, (String)"Spoon.Dialog.SetVariables.Title", (String[])new String[0]));
        esd.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.SetVariables.Message", (String[])new String[0]));
        esd.setReadOnly(false);
        esd.setShellImage(GUIResource.getInstance().getImageVariable());
        if (esd.open() != null) {
            this.applyVariables();
        }
    }

    public void applyVariables() {
        for (int i = 0; i < this.variables.size(); ++i) {
            try {
                String name = this.variables.getValueMeta(i).getName();
                String value = this.variables.getString(i, "");
                this.applyVariableToAllLoadedObjects(name, value);
                continue;
            }
            catch (KettleValueException e) {
                log.logDebug("Unexpected exception occurred : " + e.getMessage());
            }
        }
    }

    public void applyVariableToAllLoadedObjects(String name, String value) {
        for (TransMeta transMeta : this.getLoadedTransformations()) {
            transMeta.setVariable(name, Const.NVL((String)value, (String)""));
        }
        for (TransMeta transMeta : this.getLoadedJobs()) {
            transMeta.setVariable(name, Const.NVL((String)value, (String)""));
        }
        this.transExecutionConfiguration.getVariables().put(name, value);
        this.jobExecutionConfiguration.getVariables().put(name, value);
        this.transDebugExecutionConfiguration.getVariables().put(name, value);
    }

    public void showVariables() {
        this.fillVariables(this.variables);
        EnterStringsDialog esd = new EnterStringsDialog(this.shell, 0, this.variables);
        esd.setTitle(BaseMessages.getString(PKG, (String)"Spoon.Dialog.ShowVariables.Title", (String[])new String[0]));
        esd.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.ShowVariables.Message", (String[])new String[0]));
        esd.setReadOnly(true);
        esd.setShellImage(GUIResource.getInstance().getImageVariable());
        esd.open();
    }

    public void openSpoon() {
        this.shell = this.getShell();
        this.shell.setText(APP_TITLE);
        this.mainComposite.setRedraw(true);
        this.mainComposite.setVisible(false);
        this.mainComposite.setVisible(true);
        this.mainComposite.redraw();
        this.refreshTree();
        this.setShellText();
    }

    public boolean readAndDispatch() {
        return this.display.readAndDispatch();
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.stopped = stopped;
    }

    public void setDestroy(boolean destroy) {
        this.destroy = destroy;
    }

    public boolean doDestroy() {
        return this.destroy;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public synchronized void dispose() {
        this.setStopped(true);
        this.cursor_hand.dispose();
        this.cursor_hourglass.dispose();
        if (this.destroy && this.display != null && !this.display.isDisposed()) {
            try {
                this.display.dispose();
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }

    public boolean isDisposed() {
        return this.display.isDisposed();
    }

    public void sleep() {
        this.display.sleep();
    }

    public void undoAction() {
        this.undoAction(this.getActiveUndoInterface());
    }

    public void redoAction() {
        this.redoAction(this.getActiveUndoInterface());
    }

    public void copySteps() {
        JobMeta jobMeta;
        TransMeta transMeta = this.getActiveTransformation();
        if (transMeta != null) {
            this.copySelected(transMeta, transMeta.getSelectedSteps(), transMeta.getSelectedNotes());
        }
        if ((jobMeta = this.getActiveJob()) != null) {
            this.copyJobentries();
        }
    }

    public void copyJobentries() {
        JobMeta jobMeta = this.getActiveJob();
        if (jobMeta != null) {
            if (RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.MODIFY_JOB, RepositoryOperation.EXECUTE_JOB)) {
                return;
            }
            this.delegates.jobs.copyJobEntries(jobMeta, jobMeta.getSelectedEntries());
        }
    }

    public void copy() {
        boolean jobActive;
        TransMeta transMeta = this.getActiveTransformation();
        JobMeta jobMeta = this.getActiveJob();
        boolean transActive = transMeta != null;
        boolean bl = jobActive = jobMeta != null;
        if (transActive) {
            if (transMeta.getSelectedSteps().size() > 0) {
                this.copySteps();
            } else {
                this.copyTransformation();
            }
        } else if (jobActive) {
            if (jobMeta.getSelectedEntries().size() > 0) {
                this.copyJobentries();
            } else {
                this.copyJob();
            }
        }
    }

    public void copyFile() {
        boolean jobActive;
        TransMeta transMeta = this.getActiveTransformation();
        JobMeta jobMeta = this.getActiveJob();
        boolean transActive = transMeta != null;
        boolean bl = jobActive = jobMeta != null;
        if (transActive) {
            this.copyTransformation();
        } else if (jobActive) {
            this.copyJob();
        }
    }

    public void cut() {
        block4: {
            List jobEntryCopies;
            boolean jobActive;
            JobMeta jobMeta;
            block3: {
                TransMeta transMeta = this.getActiveTransformation();
                jobMeta = this.getActiveJob();
                boolean transActive = transMeta != null;
                boolean bl = jobActive = jobMeta != null;
                if (!transActive) break block3;
                List stepMetas = transMeta.getSelectedSteps();
                if (stepMetas == null || stepMetas.size() <= 0) break block4;
                this.copySteps();
                for (StepMeta stepMeta : stepMetas) {
                    this.delStep(transMeta, stepMeta);
                }
                break block4;
            }
            if (jobActive && (jobEntryCopies = jobMeta.getSelectedEntries()) != null && jobEntryCopies.size() > 0) {
                this.copyJobentries();
                for (JobEntryCopy jobEntryCopy : jobEntryCopies) {
                    this.deleteJobEntryCopies(jobMeta, jobEntryCopy);
                }
            }
        }
    }

    public void removeMenuItem(String itemid, boolean removeTrailingSeparators) {
        XulMenuitem item = (XulMenuitem)this.mainSpoonContainer.getDocumentRoot().getElementById(itemid);
        if (item != null) {
            XulComponent lastMenuItem;
            List children;
            XulComponent menu = item.getParent();
            item.getParent().removeChild((Element)item);
            if (removeTrailingSeparators && (children = menu.getChildNodes()).size() > 0 && (lastMenuItem = (XulComponent)children.get(children.size() - 1)) instanceof XulMenuseparator) {
                menu.removeChild((Element)lastMenuItem);
                try {
                    Menu swtm = (Menu)menu.getManagedObject();
                    swtm.getItems()[swtm.getItemCount() - 1].dispose();
                }
                catch (Throwable t) {
                    LogChannel.GENERAL.logError("Error removing XUL menu item", t);
                }
            }
        } else {
            log.logError("Could not find menu item with id " + itemid + " to remove from Spoon menu");
        }
    }

    public void createPopupMenus() {
        try {
            this.menuMap.put("trans-class", this.mainSpoonContainer.getDocumentRoot().getElementById("trans-class"));
            this.menuMap.put("trans-class-new", this.mainSpoonContainer.getDocumentRoot().getElementById("trans-class-new"));
            this.menuMap.put("job-class", this.mainSpoonContainer.getDocumentRoot().getElementById("job-class"));
            this.menuMap.put("trans-hop-class", this.mainSpoonContainer.getDocumentRoot().getElementById("trans-hop-class"));
            this.menuMap.put("database-class", this.mainSpoonContainer.getDocumentRoot().getElementById("database-class"));
            this.menuMap.put("partition-schema-class", this.mainSpoonContainer.getDocumentRoot().getElementById("partition-schema-class"));
            this.menuMap.put("cluster-schema-class", this.mainSpoonContainer.getDocumentRoot().getElementById("cluster-schema-class"));
            this.menuMap.put("slave-cluster-class", this.mainSpoonContainer.getDocumentRoot().getElementById("slave-cluster-class"));
            this.menuMap.put("named-cluster-class", this.mainSpoonContainer.getDocumentRoot().getElementById("named-cluster-class"));
            this.menuMap.put("trans-inst", this.mainSpoonContainer.getDocumentRoot().getElementById("trans-inst"));
            this.menuMap.put("job-inst", this.mainSpoonContainer.getDocumentRoot().getElementById("job-inst"));
            this.menuMap.put("step-plugin", this.mainSpoonContainer.getDocumentRoot().getElementById("step-plugin"));
            this.menuMap.put("database-inst", this.mainSpoonContainer.getDocumentRoot().getElementById("database-inst"));
            this.menuMap.put("named-conf-inst", this.mainSpoonContainer.getDocumentRoot().getElementById("named-conf-inst"));
            this.menuMap.put("step-inst", this.mainSpoonContainer.getDocumentRoot().getElementById("step-inst"));
            this.menuMap.put("job-entry-copy-inst", this.mainSpoonContainer.getDocumentRoot().getElementById("job-entry-copy-inst"));
            this.menuMap.put("trans-hop-inst", this.mainSpoonContainer.getDocumentRoot().getElementById("trans-hop-inst"));
            this.menuMap.put("partition-schema-inst", this.mainSpoonContainer.getDocumentRoot().getElementById("partition-schema-inst"));
            this.menuMap.put("cluster-schema-inst", this.mainSpoonContainer.getDocumentRoot().getElementById("cluster-schema-inst"));
            this.menuMap.put("slave-server-inst", this.mainSpoonContainer.getDocumentRoot().getElementById("slave-server-inst"));
            this.menuMap.put("named-cluster-inst", this.mainSpoonContainer.getDocumentRoot().getElementById("named-cluster-inst"));
        }
        catch (Throwable t) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Message", (String[])new String[]{XUL_FILE_MAIN}), new Exception(t));
        }
        this.addMenuLast();
    }

    public void executeTransformation() {
        this.executeTransformation(this.getActiveTransformation(), true, false, false, false, false, this.transExecutionConfiguration.getReplayDate(), false, this.transExecutionConfiguration.getLogLevel());
    }

    public void previewTransformation() {
        this.executeTransformation(this.getActiveTransformation(), true, false, false, true, false, this.transDebugExecutionConfiguration.getReplayDate(), true, this.transDebugExecutionConfiguration.getLogLevel());
    }

    public void debugTransformation() {
        this.executeTransformation(this.getActiveTransformation(), true, false, false, false, true, this.transPreviewExecutionConfiguration.getReplayDate(), true, this.transPreviewExecutionConfiguration.getLogLevel());
    }

    public void checkTrans() {
        this.checkTrans(this.getActiveTransformation());
    }

    public void analyseImpact() {
        this.analyseImpact(this.getActiveTransformation());
    }

    public void showLastImpactAnalyses() {
        this.showLastImpactAnalyses(this.getActiveTransformation());
    }

    public void showLastTransPreview() {
        TransGraph transGraph = this.getActiveTransGraph();
        if (transGraph != null) {
            transGraph.showLastPreviewResults();
        }
    }

    public void showExecutionResults() {
        TransGraph transGraph = this.getActiveTransGraph();
        if (transGraph != null) {
            transGraph.showExecutionResults();
            this.enableMenus();
        } else {
            JobGraph jobGraph = this.getActiveJobGraph();
            if (jobGraph != null) {
                jobGraph.showExecutionResults();
                this.enableMenus();
            }
        }
    }

    public boolean isExecutionResultsPaneVisible() {
        TransGraph transGraph = this.getActiveTransGraph();
        return transGraph != null && transGraph.isExecutionResultsPaneVisible();
    }

    public void copyTransformation() {
        this.copyTransformation(this.getActiveTransformation());
    }

    public void copyTransformationImage() {
        this.copyTransformationImage(this.getActiveTransformation());
    }

    public boolean editTransformationProperties() {
        return TransGraph.editProperties(this.getActiveTransformation(), this, this.rep, true);
    }

    public boolean editProperties() {
        if (this.getActiveTransformation() != null) {
            return this.editTransformationProperties();
        }
        if (this.getActiveJob() != null) {
            return this.editJobProperties("job-settings");
        }
        return true;
    }

    public void executeJob() {
        this.executeJob(this.getActiveJob(), true, false, null, false, null, 0);
    }

    public void copyJob() {
        this.copyJob(this.getActiveJob());
    }

    public void showTips() {
        new TipsDialog(this.shell).open();
    }

    public void showWelcomePage() {
        try {
            LocationListener listener = new LocationListener(){

                public void changing(LocationEvent event) {
                    if (event.location.endsWith(".pdf")) {
                        Program.launch((String)event.location);
                        event.doit = false;
                    } else if (event.location.contains("samples/transformations") || event.location.contains("samples/jobs") || event.location.contains("samples/mapping")) {
                        try {
                            FileObject fileObject = KettleVFS.getFileObject((String)event.location);
                            if (fileObject.exists()) {
                                if (event.location.endsWith(".ktr") || event.location.endsWith(".kjb")) {
                                    Spoon.this.openFile(event.location, false);
                                } else {
                                    Spoon.this.lastDirOpened = KettleVFS.getFilename((FileObject)fileObject);
                                    Spoon.this.openFile(true);
                                }
                                event.doit = false;
                            }
                        }
                        catch (Exception e) {
                            log.logError("Error handling samples location: " + event.location, (Throwable)e);
                        }
                    }
                }

                public void changed(LocationEvent event) {
                }
            };
            String webstartRoot = System.getProperty("spoon.webstartroot");
            if (webstartRoot != null) {
                URL url = new URL(webstartRoot + '/' + FILE_WELCOME_PAGE);
                this.addSpoonBrowser(STRING_WELCOME_TAB_NAME, url.toString(), listener);
            } else {
                File file = new File(FILE_WELCOME_PAGE);
                if (file.exists()) {
                    this.addSpoonBrowser(STRING_WELCOME_TAB_NAME, file.toURI().toURL().toString(), listener);
                }
            }
        }
        catch (MalformedURLException e1) {
            log.logError(Const.getStackTracker((Throwable)e1));
        }
    }

    public static final String getInstaviewURL() {
        String strURL = null;
        try {
            String webstartRoot = System.getProperty("spoon.webstartroot");
            if (webstartRoot != null) {
                URL url = new URL(webstartRoot + '/' + FILE_DOCUMENT_INSTAVIEW);
                strURL = url.toString();
            } else {
                File file = new File(FILE_DOCUMENT_INSTAVIEW);
                if (file.exists()) {
                    strURL = file.toURI().toURL().toString();
                }
            }
        }
        catch (MalformedURLException e1) {
            log.logError(Const.getStackTracker((Throwable)e1));
        }
        return strURL;
    }

    public void showDocumentMap() {
        try {
            LocationListener listener = new LocationListener(){

                public void changing(LocationEvent event) {
                    if (event.location.endsWith(".pdf")) {
                        Program.launch((String)event.location);
                        event.doit = false;
                    }
                }

                public void changed(LocationEvent event) {
                    System.out.println("Changed to: " + event.location);
                }
            };
            String webstartRoot = System.getProperty("spoon.webstartroot");
            if (webstartRoot != null) {
                URL url = new URL(webstartRoot + '/' + FILE_DOCUMENT_MAP);
                this.addSpoonBrowser(STRING_DOCUMENT_TAB_NAME, url.toString(), listener);
            } else {
                File file = new File(FILE_DOCUMENT_MAP);
                if (file.exists()) {
                    this.addSpoonBrowser(STRING_DOCUMENT_TAB_NAME, file.toURI().toURL().toString(), listener);
                }
            }
        }
        catch (MalformedURLException e1) {
            log.logError(Const.getStackTracker((Throwable)e1));
        }
    }

    public void addMenuLast() {
        Document doc = this.mainSpoonContainer.getDocumentRoot();
        JfaceMenupopup recentFilesPopup = (JfaceMenupopup)doc.getElementById("file-open-recent-popup");
        recentFilesPopup.removeChildren();
        List<LastUsedFile> lastUsedFiles = this.props.getLastUsedFiles();
        for (int i = 0; i < lastUsedFiles.size(); ++i) {
            int lastSep;
            LastUsedFile lastUsedFile = lastUsedFiles.get(i);
            char chr = (char)(49 + i);
            String accessKey = "ctrl-" + chr;
            String accessText = "CTRL-" + chr;
            String text = lastUsedFile.toString();
            String id = "last-file-" + i;
            if (i > 8) {
                accessKey = null;
                accessText = null;
            }
            final String lastFileId = Integer.toString(i);
            Action action = new Action("open-last-file-" + (i + 1), 4){

                public void run() {
                    Spoon.this.lastFileSelect(lastFileId);
                }
            };
            int targetLength = 40;
            if (text.length() > targetLength && (lastSep = text.replace('\\', '/').lastIndexOf(47)) != -1) {
                String fileName = "..." + text.substring(lastSep);
                if (fileName.length() < targetLength) {
                    int leadSize = targetLength - fileName.length();
                    text = text.substring(0, leadSize) + fileName;
                } else {
                    text = fileName;
                }
            }
            JfaceMenuitem miFileLast = new JfaceMenuitem(null, (XulComponent)recentFilesPopup, this.mainSpoonContainer, text, 0, action);
            miFileLast.setLabel(text);
            miFileLast.setId(id);
            if (accessText != null && accessKey != null) {
                miFileLast.setAcceltext(accessText);
                miFileLast.setAccesskey(accessKey);
            }
            if (lastUsedFile.isTransformation()) {
                miFileLast.setImage(GUIResource.getInstance().getImageTransGraph());
            } else if (lastUsedFile.isJob()) {
                miFileLast.setImage(GUIResource.getInstance().getImageJobGraph());
            }
            miFileLast.setCommand("spoon.lastFileSelect('" + i + "')");
        }
    }

    public void lastFileSelect(String id) {
        int idx = Integer.parseInt(id);
        List<LastUsedFile> lastUsedFiles = this.props.getLastUsedFiles();
        final LastUsedFile lastUsedFile = lastUsedFiles.get(idx);
        if (lastUsedFile.isSourceRepository() && (this.rep == null || !this.rep.getName().equalsIgnoreCase(lastUsedFile.getRepositoryName()))) {
            this.loginDialog = new RepositoriesDialog(this.shell, lastUsedFile.getRepositoryName(), new ILoginCallback(){

                @Override
                public void onSuccess(Repository repository) {
                    if (Spoon.this.rep != null) {
                        Spoon.this.rep.disconnect();
                        SpoonPluginManager.getInstance().notifyLifecycleListeners(SpoonLifecycleListener.SpoonLifeCycleEvent.REPOSITORY_DISCONNECTED);
                    }
                    Spoon.this.setRepository(repository);
                    try {
                        Spoon.this.loadLastUsedFile(lastUsedFile, Spoon.this.rep == null ? null : Spoon.this.rep.getName());
                        Spoon.this.addMenuLast();
                    }
                    catch (KettleException ke) {
                        new ErrorDialog(Spoon.this.loginDialog.getShell(), BaseMessages.getString((Class)PKG, (String)"Spoon.Dialog.LoadTransformationError.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"Spoon.Dialog.LoadTransformationError.Message", (String[])new String[0]), (Exception)((Object)ke));
                    }
                }

                @Override
                public void onError(Throwable t) {
                    Spoon.this.onLoginError(t);
                }

                @Override
                public void onCancel() {
                }
            });
            this.loginDialog.show();
        } else if (!lastUsedFile.isSourceRepository()) {
            this.openFile(lastUsedFile.getFilename(), false);
        } else {
            try {
                this.loadLastUsedFile(lastUsedFile, this.rep == null ? null : this.rep.getName());
                this.addMenuLast();
            }
            catch (KettleException ke) {
                new ErrorDialog(this.loginDialog.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.LoadTransformationError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.LoadTransformationError.Message", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }

    private void addTree() {
        this.mainComposite = new Composite((Composite)this.sashform, 2048);
        this.mainComposite.setLayout((Layout)new FormLayout());
        Label sep0 = new Label(this.mainComposite, 258);
        sep0.setBackground(GUIResource.getInstance().getColorWhite());
        FormData fdSep0 = new FormData();
        fdSep0.left = new FormAttachment(0, 0);
        fdSep0.right = new FormAttachment(100, 0);
        fdSep0.top = new FormAttachment(0, 0);
        sep0.setLayoutData((Object)fdSep0);
        Composite tabWrapper = new Composite(this.mainComposite, 0);
        tabWrapper.setLayout((Layout)new FormLayout());
        tabWrapper.setBackground(GUIResource.getInstance().getColorWhite());
        FormData fdTabWrapper = new FormData();
        fdTabWrapper.left = new FormAttachment(0, 0);
        fdTabWrapper.top = new FormAttachment((Control)sep0, 0);
        fdTabWrapper.right = new FormAttachment(100, 0);
        tabWrapper.setLayoutData((Object)fdTabWrapper);
        CTabFolder tabFolder = new CTabFolder(tabWrapper, 0x800100);
        tabFolder.setSimple(false);
        tabFolder.setBackground(GUIResource.getInstance().getColorWhite());
        tabFolder.setBorderVisible(false);
        tabFolder.setSelectionBackground(new Color[]{this.display.getSystemColor(18), this.display.getSystemColor(19)}, new int[]{55}, true);
        FormData fdTab = new FormData();
        fdTab.left = new FormAttachment(0, 0);
        fdTab.top = new FormAttachment((Control)sep0, 0);
        fdTab.right = new FormAttachment(100, 0);
        fdTab.height = 0;
        tabFolder.setLayoutData((Object)fdTab);
        this.view = new CTabItem(tabFolder, 0);
        this.view.setControl((Control)new Composite((Composite)tabFolder, 0));
        this.view.setText(STRING_SPOON_MAIN_TREE);
        this.view.setImage(GUIResource.getInstance().getImageExploreSolutionSmall());
        this.design = new CTabItem(tabFolder, 0);
        this.design.setText(STRING_SPOON_CORE_OBJECTS_TREE);
        this.design.setControl((Control)new Composite((Composite)tabFolder, 0));
        this.design.setImage(GUIResource.getInstance().getImageEditSmall());
        Label sep3 = new Label(this.mainComposite, 258);
        sep3.setBackground(GUIResource.getInstance().getColorWhite());
        FormData fdSep3 = new FormData();
        fdSep3.left = new FormAttachment(0, 0);
        fdSep3.right = new FormAttachment(100, 0);
        fdSep3.top = new FormAttachment((Control)tabWrapper, 0);
        sep3.setLayoutData((Object)fdSep3);
        this.selectionLabel = new Label(this.mainComposite, 256);
        FormData fdsLabel = new FormData();
        fdsLabel.left = new FormAttachment(0, 0);
        fdsLabel.top = new FormAttachment((Control)sep3, 5);
        this.selectionLabel.setLayoutData((Object)fdsLabel);
        ToolBar treeTb = new ToolBar(this.mainComposite, 0x800900);
        ToolItem expandAll = new ToolItem(treeTb, 8);
        expandAll.setImage(GUIResource.getInstance().getImageExpandAll());
        ToolItem collapseAll = new ToolItem(treeTb, 8);
        collapseAll.setImage(GUIResource.getInstance().getImageCollapseAll());
        FormData fdTreeToolbar = new FormData();
        fdTreeToolbar.top = new FormAttachment((Control)sep3, 0);
        fdTreeToolbar.right = new FormAttachment(95, 5);
        treeTb.setLayoutData((Object)fdTreeToolbar);
        this.selectionFilter = new Text(this.mainComposite, 19332);
        this.selectionFilter.setToolTipText(BaseMessages.getString(PKG, (String)"Spoon.SelectionFilter.Tooltip", (String[])new String[0]));
        FormData fdSelectionFilter = new FormData();
        fdSelectionFilter.top = new FormAttachment((Control)treeTb, -(GUIResource.getInstance().getImageExpandAll().getBounds().height + 5));
        fdSelectionFilter.right = new FormAttachment(95, -55);
        fdSelectionFilter.left = new FormAttachment((Control)this.selectionLabel, 10);
        this.selectionFilter.setLayoutData((Object)fdSelectionFilter);
        this.selectionFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (Spoon.this.coreObjectsTree != null && !Spoon.this.coreObjectsTree.isDisposed()) {
                    Spoon.this.previousShowTrans = false;
                    Spoon.this.previousShowJob = false;
                    Spoon.this.refreshCoreObjects();
                    if (!Const.isEmpty((String)Spoon.this.selectionFilter.getText())) {
                        Spoon.this.tidyBranches(Spoon.this.coreObjectsTree.getItems(), true);
                    } else {
                        Spoon.this.tidyBranches(Spoon.this.coreObjectsTree.getItems(), false);
                    }
                }
                if (Spoon.this.selectionTree != null && !Spoon.this.selectionTree.isDisposed()) {
                    Spoon.this.refreshTree();
                    if (!Const.isEmpty((String)Spoon.this.selectionFilter.getText())) {
                        Spoon.this.tidyBranches(Spoon.this.selectionTree.getItems(), true);
                    } else {
                        Spoon.this.tidyBranches(Spoon.this.selectionTree.getItems(), false);
                    }
                    Spoon.this.selectionFilter.setFocus();
                }
            }
        });
        expandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (Spoon.this.designSelected) {
                    Spoon.this.tidyBranches(Spoon.this.coreObjectsTree.getItems(), true);
                }
                if (Spoon.this.viewSelected) {
                    Spoon.this.tidyBranches(Spoon.this.selectionTree.getItems(), true);
                }
            }
        });
        collapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (Spoon.this.designSelected) {
                    Spoon.this.tidyBranches(Spoon.this.coreObjectsTree.getItems(), false);
                }
                if (Spoon.this.viewSelected) {
                    Spoon.this.tidyBranches(Spoon.this.selectionTree.getItems(), false);
                }
            }
        });
        tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (arg0.item == Spoon.this.view) {
                    Spoon.this.setViewMode();
                } else {
                    Spoon.this.setDesignMode();
                }
            }
        });
        Label sep4 = new Label(this.mainComposite, 258);
        sep4.setBackground(GUIResource.getInstance().getColorWhite());
        FormData fdSep4 = new FormData();
        fdSep4.left = new FormAttachment(0, 0);
        fdSep4.right = new FormAttachment(100, 0);
        fdSep4.top = new FormAttachment((Control)treeTb, 5);
        sep4.setLayoutData((Object)fdSep4);
        this.variableComposite = new Composite(this.mainComposite, 0);
        this.variableComposite.setBackground(GUIResource.getInstance().getColorBackground());
        this.variableComposite.setLayout((Layout)new FillLayout());
        FormData fdVariableComposite = new FormData();
        fdVariableComposite.left = new FormAttachment(0, 0);
        fdVariableComposite.right = new FormAttachment(100, 0);
        fdVariableComposite.top = new FormAttachment((Control)sep4, 0);
        fdVariableComposite.bottom = new FormAttachment(100, 0);
        this.variableComposite.setLayoutData((Object)fdVariableComposite);
        this.disposeVariableComposite(true, false, false, false);
        this.coreStepToolTipMap = new Hashtable<String, String>();
        this.coreJobToolTipMap = new Hashtable<String, String>();
        this.addDefaultKeyListeners((Control)tabFolder);
        this.addDefaultKeyListeners((Control)this.mainComposite);
    }

    public void addDefaultKeyListeners(Control control) {
        control.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 119 && (e.stateMask & 0x40000) != 0 || e.keyCode == 0x100000D && (e.stateMask & 0x40000) != 0) {
                    Spoon.this.closeFile();
                }
                if (e.keyCode == 0x100000E && (e.stateMask & 0x40000) != 0) {
                    new MetaStoreExplorerDialog(Spoon.this.shell, (IMetaStore)Spoon.this.metaStore).open();
                }
            }
        });
    }

    public boolean setViewMode() {
        if (this.viewSelected) {
            return true;
        }
        this.selectionFilter.setText("");
        this.disposeVariableComposite(true, false, false, false);
        this.refreshTree();
        return false;
    }

    public boolean setDesignMode() {
        if (this.designSelected) {
            return true;
        }
        this.selectionFilter.setText("");
        this.disposeVariableComposite(false, false, true, false);
        this.refreshCoreObjects();
        return false;
    }

    private void tidyBranches(TreeItem[] items, boolean expand) {
        for (TreeItem item : items) {
            item.setExpanded(expand);
            this.tidyBranches(item.getItems(), expand);
        }
    }

    public void disposeVariableComposite(boolean tree, boolean shared, boolean core, boolean history) {
        this.viewSelected = tree;
        this.view.getParent().setSelection(this.viewSelected ? this.view : this.design);
        this.designSelected = core;
        for (Control control : this.variableComposite.getChildren()) {
            if (control instanceof Tree) {
                control.setMenu(null);
            }
            control.dispose();
        }
        this.previousShowTrans = false;
        this.previousShowJob = false;
        this.selectionLabel.setText(tree ? BaseMessages.getString(PKG, (String)"Spoon.Explorer", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"Spoon.Steps", (String[])new String[0]));
    }

    public void addCoreObjectsTree() {
        this.coreObjectsTree = new Tree(this.variableComposite, 516);
        this.props.setLook((Control)this.coreObjectsTree);
        this.coreObjectsTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeItem[] selection;
                if (Spoon.this.props.getAutoCollapseCoreObjectsTree() && (selection = Spoon.this.coreObjectsTree.getSelection()).length == 1) {
                    TreeItem top = selection[0];
                    while (top.getParentItem() != null) {
                        top = top.getParentItem();
                    }
                    if (top == selection[0]) {
                        boolean expanded = top.getExpanded();
                        for (TreeItem item : Spoon.this.coreObjectsTree.getItems()) {
                            item.setExpanded(false);
                        }
                        top.setExpanded(!expanded);
                    }
                }
            }
        });
        this.coreObjectsTree.addTreeListener((TreeListener)new TreeAdapter(){

            public void treeExpanded(TreeEvent treeEvent) {
                if (Spoon.this.props.getAutoCollapseCoreObjectsTree()) {
                    TreeItem treeItem = (TreeItem)treeEvent.item;
                    Spoon.this.coreObjectsTree.setSelection(treeItem);
                    for (TreeItem item : Spoon.this.coreObjectsTree.getItems()) {
                        if (item != treeItem) {
                            item.setExpanded(false);
                            continue;
                        }
                        treeItem.setExpanded(true);
                    }
                }
            }
        });
        this.coreObjectsTree.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent move) {
                if (!Spoon.this.getProperties().showToolTips()) {
                    return;
                }
                Spoon.this.toolTip.hide();
                TreeItem item = Spoon.this.searchMouseOverTreeItem(Spoon.this.coreObjectsTree.getItems(), move.x, move.y);
                if (item != null) {
                    Image image;
                    PluginInterface plugin;
                    String name = item.getText();
                    String tip = (String)Spoon.this.coreStepToolTipMap.get(name);
                    if (tip != null && (plugin = PluginRegistry.getInstance().findPluginWithName(StepPluginType.class, name)) != null) {
                        image = GUIResource.getInstance().getImagesSteps().get(plugin.getIds()[0]);
                        if (image == null) {
                            Spoon.this.toolTip.hide();
                        }
                        Spoon.this.toolTip.setImage(image);
                        Spoon.this.toolTip.setText(name + Const.CR + Const.CR + tip);
                        Spoon.this.toolTip.show(new Point(move.x + 10, move.y + 10));
                    }
                    if ((tip = (String)Spoon.this.coreJobToolTipMap.get(name)) != null && (plugin = PluginRegistry.getInstance().findPluginWithName(JobEntryPluginType.class, name)) != null) {
                        image = GUIResource.getInstance().getImagesJobentries().get(plugin.getIds()[0]);
                        Spoon.this.toolTip.setImage(image);
                        Spoon.this.toolTip.setText(name + Const.CR + Const.CR + tip);
                        Spoon.this.toolTip.show(new Point(move.x + 10, move.y + 10));
                    }
                }
            }
        });
        this.addDragSourceToTree(this.coreObjectsTree);
        this.addDefaultKeyListeners((Control)this.coreObjectsTree);
        this.coreObjectsTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                boolean shift = (event.stateMask & 0x20000) != 0;
                Spoon.this.doubleClickedInTree(Spoon.this.coreObjectsTree, shift);
            }
        });
        this.toolTip = new DefaultToolTip((Control)this.variableComposite, 1, true);
        this.toolTip.setRespectMonitorBounds(true);
        this.toolTip.setRespectDisplayBounds(true);
        this.toolTip.setPopupDelay(350);
        this.toolTip.setHideDelay(5000);
        this.toolTip.setShift(new Point(5, 5));
    }

    protected TreeItem searchMouseOverTreeItem(TreeItem[] treeItems, int x, int y) {
        for (TreeItem treeItem : treeItems) {
            if (treeItem.getBounds().contains(x, y)) {
                return treeItem;
            }
            if (treeItem.getItemCount() <= 0 || (treeItem = this.searchMouseOverTreeItem(treeItem.getItems(), x, y)) == null) continue;
            return treeItem;
        }
        return null;
    }

    public void refreshCoreObjects() {
        TreeItem stepItem;
        String pluginDescription;
        String pluginName;
        PluginRegistry registry;
        TreeItem[] expandItems;
        if (this.shell.isDisposed()) {
            return;
        }
        if (!this.designSelected) {
            return;
        }
        if (this.coreObjectsTree == null || this.coreObjectsTree.isDisposed()) {
            this.addCoreObjectsTree();
        }
        this.showTrans = this.getActiveTransformation() != null;
        boolean bl = this.showJob = this.getActiveJob() != null;
        if (this.showTrans == this.previousShowTrans && this.showJob == this.previousShowJob) {
            return;
        }
        for (TreeItem item : expandItems = this.coreObjectsTree.getItems()) {
            item.dispose();
        }
        if (this.showTrans) {
            Image stepImage;
            TreeItem item;
            this.selectionLabel.setText(BaseMessages.getString(PKG, (String)"Spoon.Steps", (String[])new String[0]));
            registry = PluginRegistry.getInstance();
            List baseSteps = registry.getPlugins(StepPluginType.class);
            List baseCategories = registry.getCategories(StepPluginType.class);
            for (String baseCategory : baseCategories) {
                TreeItem item2 = new TreeItem(this.coreObjectsTree, 0);
                item2.setText(baseCategory);
                item2.setImage(GUIResource.getInstance().getImageArrow());
                for (PluginInterface baseStep : baseSteps) {
                    if (!baseStep.getCategory().equalsIgnoreCase(baseCategory)) continue;
                    stepImage = GUIResource.getInstance().getImagesStepsSmall().get(baseStep.getIds()[0]);
                    pluginName = baseStep.getName();
                    pluginDescription = baseStep.getDescription();
                    if (!this.filterMatch(pluginName) && !this.filterMatch(pluginDescription)) continue;
                    stepItem = this.createTreeItem(item2, pluginName, stepImage);
                    stepItem.addListener(13, new Listener(){

                        public void handleEvent(Event event) {
                            System.out.println("Tree item Listener fired");
                        }
                    });
                    this.coreStepToolTipMap.put(pluginName, pluginDescription);
                }
            }
            item = new TreeItem(this.coreObjectsTree, 0);
            item.setText(BaseMessages.getString(PKG, (String)"Spoon.History", (String[])new String[0]));
            item.setImage(GUIResource.getInstance().getImageArrow());
            List pluginHistory = this.props.getPluginHistory();
            for (int i = 0; i < pluginHistory.size() && i < 10; ++i) {
                ObjectUsageCount usage = (ObjectUsageCount)pluginHistory.get(i);
                PluginInterface stepPlugin = PluginRegistry.getInstance().findPluginWithId(StepPluginType.class, usage.getObjectName());
                if (stepPlugin == null) continue;
                stepImage = GUIResource.getInstance().getImagesSteps().get(stepPlugin.getIds()[0]);
                pluginName = Const.NVL((String)stepPlugin.getName(), (String)"");
                pluginDescription = Const.NVL((String)stepPlugin.getDescription(), (String)"");
                if (!this.filterMatch(pluginName) && !this.filterMatch(pluginDescription)) continue;
                stepItem = this.createTreeItem(item, pluginName, stepImage);
                stepItem.addListener(13, new Listener(){

                    public void handleEvent(Event event) {
                        System.out.println("Tree item Listener fired");
                    }
                });
                this.coreStepToolTipMap.put(stepPlugin.getDescription(), pluginDescription + " (" + usage.getNrUses() + ")");
            }
        }
        if (this.showJob) {
            this.selectionLabel.setText(BaseMessages.getString(PKG, (String)"Spoon.Entries", (String[])new String[0]));
            registry = PluginRegistry.getInstance();
            List baseJobEntries = registry.getPlugins(JobEntryPluginType.class);
            List baseCategories = registry.getCategories(JobEntryPluginType.class);
            TreeItem generalItem = null;
            for (String baseCategory : baseCategories) {
                TreeItem item = new TreeItem(this.coreObjectsTree, 0);
                item.setText(baseCategory);
                item.setImage(GUIResource.getInstance().getImageArrow());
                if (baseCategory.equalsIgnoreCase(JobEntryPluginType.GENERAL_CATEGORY)) {
                    generalItem = item;
                }
                for (int j = 0; j < baseJobEntries.size(); ++j) {
                    if (((PluginInterface)baseJobEntries.get(j)).getIds()[0].equals("SPECIAL") || !((PluginInterface)baseJobEntries.get(j)).getCategory().equalsIgnoreCase(baseCategory)) continue;
                    Image jobEntryImage = GUIResource.getInstance().getImagesJobentriesSmall().get(((PluginInterface)baseJobEntries.get(j)).getIds()[0]);
                    pluginName = Const.NVL((String)((PluginInterface)baseJobEntries.get(j)).getName(), (String)"");
                    pluginDescription = Const.NVL((String)((PluginInterface)baseJobEntries.get(j)).getDescription(), (String)"");
                    if (!this.filterMatch(pluginName) && !this.filterMatch(pluginDescription)) continue;
                    stepItem = this.createTreeItem(item, pluginName, jobEntryImage);
                    stepItem.addListener(13, new Listener(){

                        public void handleEvent(Event arg0) {
                            System.out.println("Tree item Listener fired");
                        }
                    });
                    this.coreJobToolTipMap.put(pluginName, pluginDescription);
                }
            }
            JobEntryCopy startEntry = JobMeta.createStartEntry();
            JobEntryCopy dummyEntry = JobMeta.createDummyEntry();
            String[] specialText = new String[]{startEntry.getName(), dummyEntry.getName()};
            String[] specialTooltip = new String[]{startEntry.getDescription(), dummyEntry.getDescription()};
            Image[] specialImage = new Image[]{GUIResource.getInstance().getImageStartSmall(), GUIResource.getInstance().getImageDummySmall()};
            for (int i = 0; i < specialText.length; ++i) {
                TreeItem specialItem = new TreeItem(generalItem, 0, i);
                specialItem.setImage(specialImage[i]);
                specialItem.setText(specialText[i]);
                specialItem.addListener(13, new Listener(){

                    public void handleEvent(Event arg0) {
                        System.out.println("Tree item Listener fired");
                    }
                });
                this.coreJobToolTipMap.put(specialText[i], specialTooltip[i]);
            }
        }
        this.variableComposite.layout(true, true);
        this.previousShowTrans = this.showTrans;
        this.previousShowJob = this.showJob;
    }

    protected void shareObject(SharedObjectInterface sharedObject) {
        sharedObject.setShared(true);
        EngineMetaInterface meta = this.getActiveMeta();
        try {
            if (meta != null) {
                SharedObjects sharedObjects = null;
                if (meta instanceof TransMeta) {
                    sharedObjects = ((TransMeta)meta).getSharedObjects();
                }
                if (meta instanceof JobMeta) {
                    sharedObjects = ((JobMeta)meta).getSharedObjects();
                }
                if (sharedObjects != null) {
                    sharedObjects.storeObject(sharedObject);
                    sharedObjects.saveToFile();
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorWritingSharedObjects.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorWritingSharedObjects.Message", (String[])new String[0]), e);
        }
        this.refreshTree();
    }

    protected void unShareObject(SharedObjectInterface sharedObject) {
        MessageBox mb = new MessageBox(this.shell, 200);
        mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.StopSharing.Message", (String[])new String[0]));
        mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.StopSharing.Title", (String[])new String[0]));
        int answer = mb.open();
        if (answer == 64) {
            sharedObject.setShared(false);
            EngineMetaInterface meta = this.getActiveMeta();
            try {
                if (meta != null) {
                    SharedObjects sharedObjects = null;
                    if (meta instanceof TransMeta) {
                        sharedObjects = ((TransMeta)meta).getSharedObjects();
                    }
                    if (meta instanceof JobMeta) {
                        sharedObjects = ((JobMeta)meta).getSharedObjects();
                    }
                    if (sharedObjects != null) {
                        sharedObjects.removeObject(sharedObject);
                        sharedObjects.saveToFile();
                    }
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorWritingSharedObjects.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorWritingSharedObjects.Message", (String[])new String[0]), e);
            }
            this.refreshTree();
        }
    }

    public TreeSelection[] getTreeObjects(Tree tree) {
        return this.delegates.tree.getTreeObjects(tree, this.selectionTree, this.coreObjectsTree);
    }

    private void addDragSourceToTree(Tree tree) {
        this.delegates.tree.addDragSourceToTree(tree, this.selectionTree, this.coreObjectsTree);
    }

    public void hideToolTips() {
        if (this.toolTip != null) {
            this.toolTip.hide();
        }
    }

    public void showSelection() {
        TabMapEntry entry;
        TabMapEntry entry2;
        TreeSelection[] objects = this.getTreeObjects(this.selectionTree);
        if (objects.length != 1) {
            return;
        }
        TreeSelection object = objects[0];
        Object selection = object.getSelection();
        Object parent = object.getParent();
        TransMeta transMeta = null;
        if (selection instanceof TransMeta) {
            transMeta = (TransMeta)selection;
        }
        if (parent instanceof TransMeta) {
            transMeta = (TransMeta)parent;
        }
        if (transMeta != null && (entry2 = this.delegates.tabs.findTabMapEntry(transMeta)) != null) {
            int desired;
            int current = this.tabfolder.getSelectedIndex();
            if (current != (desired = this.tabfolder.indexOf(entry2.getTabItem()))) {
                this.tabfolder.setSelected(desired);
            }
            transMeta.setInternalKettleVariables();
            if (this.getCoreObjectsState() != 3) {
                this.refreshCoreObjects();
            }
        }
        JobMeta jobMeta = null;
        if (selection instanceof JobMeta) {
            jobMeta = (JobMeta)selection;
        }
        if (parent instanceof JobMeta) {
            jobMeta = (JobMeta)parent;
        }
        if (jobMeta != null && (entry = this.delegates.tabs.findTabMapEntry(transMeta)) != null) {
            int desired;
            int current = this.tabfolder.getSelectedIndex();
            if (current != (desired = this.tabfolder.indexOf(entry.getTabItem()))) {
                this.tabfolder.setSelected(desired);
            }
            jobMeta.setInternalKettleVariables();
            if (this.getCoreObjectsState() != 2) {
                this.refreshCoreObjects();
            }
        }
    }

    public void newHop() {
        this.newHop((TransMeta)this.selectionObjectParent);
    }

    public void sortHops() {
        ((TransMeta)this.selectionObjectParent).sortHops();
        this.refreshTree();
    }

    public void newDatabasePartitioningSchema() {
        TransMeta transMeta = this.getActiveTransformation();
        if (transMeta != null) {
            this.newPartitioningSchema(transMeta);
        }
    }

    public void newClusteringSchema() {
        TransMeta transMeta = this.getActiveTransformation();
        if (transMeta != null) {
            this.newClusteringSchema(transMeta);
        }
    }

    public void newSlaveServer() {
        this.newSlaveServer((HasSlaveServersInterface)this.selectionObjectParent);
    }

    public void editTransformationPropertiesPopup() {
        TransGraph.editProperties((TransMeta)this.selectionObject, this, this.rep, true);
    }

    public void addTransLog() {
        TransGraph activeTransGraph = this.getActiveTransGraph();
        if (activeTransGraph != null) {
            activeTransGraph.transLogDelegate.addTransLog();
            activeTransGraph.transGridDelegate.addTransGrid();
        }
    }

    public void addTransHistory() {
        TransGraph activeTransGraph = this.getActiveTransGraph();
        if (activeTransGraph != null) {
            activeTransGraph.transHistoryDelegate.addTransHistory();
        }
    }

    public boolean editJobProperties(String id) {
        if ("job-settings".equals(id)) {
            return JobGraph.editProperties(this.getActiveJob(), this, this.rep, true);
        }
        if ("job-inst-settings".equals(id)) {
            return JobGraph.editProperties((JobMeta)this.selectionObject, this, this.rep, true);
        }
        return false;
    }

    public void editJobPropertiesPopup() {
        JobGraph.editProperties((JobMeta)this.selectionObject, this, this.rep, true);
    }

    public void addJobLog() {
        JobGraph activeJobGraph = this.getActiveJobGraph();
        if (activeJobGraph != null) {
            activeJobGraph.jobLogDelegate.addJobLog();
            activeJobGraph.jobGridDelegate.addJobGrid();
        }
    }

    public void addJobHistory() {
        this.addJobHistory((JobMeta)this.selectionObject, true);
    }

    public void newStep() {
        this.newStep(this.getActiveTransformation());
    }

    public void editConnection() {
        if (RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.MODIFY_DATABASE)) {
            return;
        }
        DatabaseMeta databaseMeta = (DatabaseMeta)this.selectionObject;
        this.delegates.db.editConnection(databaseMeta);
    }

    public void dupeConnection() {
        DatabaseMeta databaseMeta = (DatabaseMeta)this.selectionObject;
        HasDatabasesInterface hasDatabasesInterface = (HasDatabasesInterface)this.selectionObjectParent;
        this.delegates.db.dupeConnection(hasDatabasesInterface, databaseMeta);
    }

    public void clipConnection() {
        DatabaseMeta databaseMeta = (DatabaseMeta)this.selectionObject;
        this.delegates.db.clipConnection(databaseMeta);
    }

    public void delConnection() {
        if (RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.DELETE_DATABASE)) {
            return;
        }
        DatabaseMeta databaseMeta = (DatabaseMeta)this.selectionObject;
        MessageBox mb = new MessageBox(this.shell, 196);
        mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.ExploreDB.DeleteConnectionAsk.Message", (String[])new String[]{databaseMeta.getName()}));
        mb.setText(BaseMessages.getString(PKG, (String)"Spoon.ExploreDB.DeleteConnectionAsk.Title", (String[])new String[0]));
        int response = mb.open();
        if (response != 64) {
            return;
        }
        HasDatabasesInterface hasDatabasesInterface = (HasDatabasesInterface)this.selectionObjectParent;
        this.delegates.db.delConnection(hasDatabasesInterface, databaseMeta);
    }

    public void sqlConnection() {
        DatabaseMeta databaseMeta = (DatabaseMeta)this.selectionObject;
        this.delegates.db.sqlConnection(databaseMeta);
    }

    public void clearDBCache(String id) {
        if ("database-class-clear-cache".equals(id)) {
            this.delegates.db.clearDBCache(null);
        }
        if ("database-inst-clear-cache".equals(id)) {
            DatabaseMeta databaseMeta = (DatabaseMeta)this.selectionObject;
            this.delegates.db.clearDBCache(databaseMeta);
        }
    }

    public void exploreDatabase() {
        if (RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.EXPLORE_DATABASE)) {
            return;
        }
        ArrayList<DatabaseMeta> databases = new ArrayList<DatabaseMeta>();
        HasDatabasesInterface databasesInterface = this.getActiveHasDatabasesInterface();
        if (databasesInterface != null) {
            databases.addAll(databasesInterface.getDatabases());
        }
        if (this.rep != null) {
            try {
                List list = this.rep.readDatabases();
                for (DatabaseMeta databaseMeta : list) {
                    int index = databases.indexOf(databaseMeta);
                    if (index < 0) {
                        databases.add(databaseMeta);
                        continue;
                    }
                    databases.set(index, databaseMeta);
                }
            }
            catch (KettleException e) {
                log.logError("Unexpected repository error", new Object[]{e.getMessage()});
            }
        }
        if (databases.size() == 0) {
            return;
        }
        String[] databaseNames = new String[databases.size()];
        for (int i = 0; i < databases.size(); ++i) {
            databaseNames[i] = ((DatabaseMeta)databases.get(i)).getName();
        }
        EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, databaseNames, BaseMessages.getString(PKG, (String)"Spoon.ExploreDB.SelectDB.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ExploreDB.SelectDB.Message", (String[])new String[0]));
        String name = dialog.open();
        if (name != null) {
            this.selectionObject = DatabaseMeta.findDatabase(databases, (String)name);
            this.exploreDB();
        }
    }

    public void exploreDB() {
        DatabaseMeta databaseMeta = (DatabaseMeta)this.selectionObject;
        this.delegates.db.exploreDB(databaseMeta, true);
    }

    public void editStep() {
        TransMeta transMeta = (TransMeta)this.selectionObjectParent;
        StepMeta stepMeta = (StepMeta)this.selectionObject;
        this.delegates.steps.editStep(transMeta, stepMeta);
    }

    public void dupeStep() {
        TransMeta transMeta = (TransMeta)this.selectionObjectParent;
        StepMeta stepMeta = (StepMeta)this.selectionObject;
        this.delegates.steps.dupeStep(transMeta, stepMeta);
    }

    public void delStep() {
        TransMeta transMeta = (TransMeta)this.selectionObjectParent;
        StepMeta stepMeta = (StepMeta)this.selectionObject;
        this.delegates.steps.delStep(transMeta, stepMeta);
    }

    public void helpStep() {
        StepMeta stepMeta = (StepMeta)this.selectionObject;
        PluginInterface stepPlugin = PluginRegistry.getInstance().findPluginWithId(StepPluginType.class, stepMeta.getStepID());
        HelpUtils.openHelpDialog(this.shell, stepPlugin);
    }

    public void shareObject(String id) {
        if ("database-inst-share".equals(id)) {
            DatabaseMeta databaseMeta = (DatabaseMeta)this.selectionObject;
            if (databaseMeta.isShared()) {
                this.unShareObject((SharedObjectInterface)databaseMeta);
            } else {
                this.shareObject((SharedObjectInterface)databaseMeta);
            }
        }
        if ("step-inst-share".equals(id)) {
            StepMeta stepMeta = (StepMeta)this.selectionObject;
            this.shareObject((SharedObjectInterface)stepMeta);
        }
        if ("partition-schema-inst-share".equals(id)) {
            PartitionSchema partitionSchema = (PartitionSchema)this.selectionObject;
            this.shareObject((SharedObjectInterface)partitionSchema);
        }
        if ("cluster-schema-inst-share".equals(id)) {
            ClusterSchema clusterSchema = (ClusterSchema)this.selectionObject;
            this.shareObject((SharedObjectInterface)clusterSchema);
        }
        if ("slave-server-inst-share".equals(id)) {
            SlaveServer slaveServer = (SlaveServer)this.selectionObject;
            this.shareObject((SharedObjectInterface)slaveServer);
        }
    }

    public void editJobEntry() {
        JobMeta jobMeta = (JobMeta)this.selectionObjectParent;
        JobEntryCopy jobEntry = (JobEntryCopy)this.selectionObject;
        this.editJobEntry(jobMeta, jobEntry);
    }

    public void dupeJobEntry() {
        JobMeta jobMeta = (JobMeta)this.selectionObjectParent;
        JobEntryCopy jobEntry = (JobEntryCopy)this.selectionObject;
        this.delegates.jobs.dupeJobEntry(jobMeta, jobEntry);
    }

    public void deleteJobEntryCopies() {
        JobMeta jobMeta = (JobMeta)this.selectionObjectParent;
        JobEntryCopy jobEntry = (JobEntryCopy)this.selectionObject;
        this.deleteJobEntryCopies(jobMeta, jobEntry);
    }

    public void helpJobEntry() {
        JobEntryCopy jobEntry = (JobEntryCopy)this.selectionObject;
        String jobName = jobEntry.getName();
        PluginInterface jobEntryPlugin = PluginRegistry.getInstance().findPluginWithName(JobEntryPluginType.class, jobName);
        HelpUtils.openHelpDialog(this.shell, jobEntryPlugin);
    }

    public void editHop() {
        TransMeta transMeta = (TransMeta)this.selectionObjectParent;
        TransHopMeta transHopMeta = (TransHopMeta)this.selectionObject;
        this.editHop(transMeta, transHopMeta);
    }

    public void delHop() {
        TransMeta transMeta = (TransMeta)this.selectionObjectParent;
        TransHopMeta transHopMeta = (TransHopMeta)this.selectionObject;
        this.delHop(transMeta, transHopMeta);
    }

    public void editPartitionSchema() {
        TransMeta transMeta = (TransMeta)this.selectionObjectParent;
        PartitionSchema partitionSchema = (PartitionSchema)this.selectionObject;
        this.editPartitionSchema(transMeta, partitionSchema);
    }

    public void delPartitionSchema() {
        TransMeta transMeta = (TransMeta)this.selectionObjectParent;
        PartitionSchema partitionSchema = (PartitionSchema)this.selectionObject;
        this.delPartitionSchema(transMeta, partitionSchema);
    }

    public void editClusterSchema() {
        TransMeta transMeta = (TransMeta)this.selectionObjectParent;
        ClusterSchema clusterSchema = (ClusterSchema)this.selectionObject;
        this.editClusterSchema(transMeta, clusterSchema);
    }

    public void delClusterSchema() {
        TransMeta transMeta = (TransMeta)this.selectionObjectParent;
        ClusterSchema clusterSchema = (ClusterSchema)this.selectionObject;
        this.delClusterSchema(transMeta, clusterSchema);
    }

    public void monitorClusterSchema() throws KettleException {
        ClusterSchema clusterSchema = (ClusterSchema)this.selectionObject;
        this.monitorClusterSchema(clusterSchema);
    }

    public void editSlaveServer() {
        SlaveServer slaveServer = (SlaveServer)this.selectionObject;
        this.editSlaveServer(slaveServer);
    }

    public void delSlaveServer() {
        HasSlaveServersInterface hasSlaveServersInterface = (HasSlaveServersInterface)this.selectionObjectParent;
        SlaveServer slaveServer = (SlaveServer)this.selectionObject;
        this.delSlaveServer(hasSlaveServersInterface, slaveServer);
    }

    public void addSpoonSlave() {
        SlaveServer slaveServer = (SlaveServer)this.selectionObject;
        this.addSpoonSlave(slaveServer);
    }

    private synchronized void setMenu(Tree tree) {
        TreeSelection[] objects = this.getTreeObjects(tree);
        if (objects.length != 1) {
            return;
        }
        TreeSelection object = objects[0];
        Object selection = this.selectionObject = object.getSelection();
        this.selectionObjectParent = object.getParent();
        Object spoonMenu = null;
        if (selection instanceof Class) {
            spoonMenu = selection.equals(TransMeta.class) ? (XulMenupopup)this.menuMap.get("trans-class") : (selection.equals(JobMeta.class) ? (XulMenupopup)this.menuMap.get("job-class") : (selection.equals(TransHopMeta.class) ? (XulMenupopup)this.menuMap.get("trans-hop-class") : (selection.equals(DatabaseMeta.class) ? (XulMenupopup)this.menuMap.get("database-class") : (selection.equals(PartitionSchema.class) ? (XulMenupopup)this.menuMap.get("partition-schema-class") : (selection.equals(ClusterSchema.class) ? (XulMenupopup)this.menuMap.get("cluster-schema-class") : (selection.equals(SlaveServer.class) ? (XulMenupopup)this.menuMap.get("slave-cluster-class") : (selection.equals(NamedCluster.class) ? (XulMenupopup)this.menuMap.get("named-cluster-class") : null)))))));
        } else if (selection instanceof TransMeta) {
            spoonMenu = (XulMenupopup)this.menuMap.get("trans-inst");
        } else if (selection instanceof JobMeta) {
            spoonMenu = (XulMenupopup)this.menuMap.get("job-inst");
        } else if (selection instanceof PluginInterface) {
            spoonMenu = (XulMenupopup)this.menuMap.get("step-plugin");
        } else if (selection instanceof DatabaseMeta) {
            DatabaseMeta databaseMeta;
            spoonMenu = (XulMenupopup)this.menuMap.get("database-inst");
            XulMenuitem item = (XulMenuitem)this.mainSpoonContainer.getDocumentRoot().getElementById("database-inst-explore");
            if (item != null) {
                databaseMeta = (DatabaseMeta)selection;
                item.setDisabled(!databaseMeta.isExplorable());
            }
            if ((item = (XulMenuitem)this.mainSpoonContainer.getDocumentRoot().getElementById("database-inst-clear-cache")) != null) {
                databaseMeta = (DatabaseMeta)this.selectionObject;
                item.setLabel(BaseMessages.getString(PKG, (String)"Spoon.Menu.Popup.CONNECTIONS.ClearDBCache", (String[])new String[0]) + databaseMeta.getName());
            }
            if ((item = (XulMenuitem)this.mainSpoonContainer.getDocumentRoot().getElementById("database-inst-share")) != null) {
                databaseMeta = (DatabaseMeta)selection;
                if (databaseMeta.isShared()) {
                    item.setLabel(BaseMessages.getString(PKG, (String)"Spoon.Menu.Popup.CONNECTIONS.UnShare", (String[])new String[0]));
                } else {
                    item.setLabel(BaseMessages.getString(PKG, (String)"Spoon.Menu.Popup.CONNECTIONS.Share", (String[])new String[0]));
                }
            }
        } else if (selection instanceof NamedCluster) {
            spoonMenu = (XulMenupopup)this.menuMap.get("named-cluster-inst");
        } else if (selection instanceof StepMeta) {
            spoonMenu = (XulMenupopup)this.menuMap.get("step-inst");
        } else if (selection instanceof JobEntryCopy) {
            spoonMenu = (XulMenupopup)this.menuMap.get("job-entry-copy-inst");
        } else if (selection instanceof TransHopMeta) {
            spoonMenu = (XulMenupopup)this.menuMap.get("trans-hop-inst");
        } else if (selection instanceof PartitionSchema) {
            spoonMenu = (XulMenupopup)this.menuMap.get("partition-schema-inst");
        } else if (selection instanceof ClusterSchema) {
            spoonMenu = (XulMenupopup)this.menuMap.get("cluster-schema-inst");
        } else if (selection instanceof SlaveServer) {
            spoonMenu = (XulMenupopup)this.menuMap.get("slave-server-inst");
        }
        if (spoonMenu != null) {
            ConstUI.displayMenu(spoonMenu, (Control)tree);
        } else {
            tree.setMenu(null);
        }
    }

    private void doubleClickedInTree(Tree tree) {
        this.doubleClickedInTree(tree, false);
    }

    private void doubleClickedInTree(Tree tree, boolean shift) {
        TreeSelection[] objects = this.getTreeObjects(tree);
        if (objects.length != 1) {
            return;
        }
        TreeSelection object = objects[0];
        Object selection = object.getSelection();
        Object parent = object.getParent();
        if (selection instanceof Class) {
            if (selection.equals(TransMeta.class)) {
                this.newTransFile();
            }
            if (selection.equals(JobMeta.class)) {
                this.newJobFile();
            }
            if (selection.equals(TransHopMeta.class)) {
                this.newHop((TransMeta)parent);
            }
            if (selection.equals(DatabaseMeta.class)) {
                this.delegates.db.newConnection();
            }
            if (selection.equals(PartitionSchema.class)) {
                this.newPartitioningSchema((TransMeta)parent);
            }
            if (selection.equals(ClusterSchema.class)) {
                this.newClusteringSchema((TransMeta)parent);
            }
            if (selection.equals(SlaveServer.class)) {
                this.newSlaveServer((HasSlaveServersInterface)parent);
            }
        } else {
            if (selection instanceof TransMeta) {
                TransGraph.editProperties((TransMeta)selection, this, this.rep, true);
            }
            if (selection instanceof JobMeta) {
                JobGraph.editProperties((JobMeta)selection, this, this.rep, true);
            }
            if (selection instanceof PluginInterface) {
                JobGraph jobGraph;
                TransGraph transGraph;
                PluginInterface plugin = (PluginInterface)selection;
                if (plugin.getPluginType().equals(StepPluginType.class) && (transGraph = this.getActiveTransGraph()) != null) {
                    transGraph.addStepToChain(plugin, shift);
                }
                if (plugin.getPluginType().equals(JobEntryPluginType.class) && (jobGraph = this.getActiveJobGraph()) != null) {
                    jobGraph.addJobEntryToChain(object.getItemText(), shift);
                }
            }
            if (selection instanceof DatabaseMeta) {
                this.delegates.db.editConnection((DatabaseMeta)selection);
            }
            if (selection instanceof StepMeta) {
                this.delegates.steps.editStep((TransMeta)parent, (StepMeta)selection);
            }
            if (selection instanceof JobEntryCopy) {
                this.editJobEntry((JobMeta)parent, (JobEntryCopy)selection);
            }
            if (selection instanceof TransHopMeta) {
                this.editHop((TransMeta)parent, (TransHopMeta)selection);
            }
            if (selection instanceof PartitionSchema) {
                this.editPartitionSchema((TransMeta)parent, (PartitionSchema)selection);
            }
            if (selection instanceof ClusterSchema) {
                this.editClusterSchema((TransMeta)parent, (ClusterSchema)selection);
            }
            if (selection instanceof SlaveServer) {
                this.editSlaveServer((SlaveServer)selection);
            }
        }
    }

    protected void monitorClusterSchema(ClusterSchema clusterSchema) throws KettleException {
        for (int i = 0; i < clusterSchema.getSlaveServers().size(); ++i) {
            SlaveServer slaveServer = (SlaveServer)clusterSchema.getSlaveServers().get(i);
            this.addSpoonSlave(slaveServer);
        }
    }

    protected void editSlaveServer(SlaveServer slaveServer) {
        SlaveServerDialog dialog = new SlaveServerDialog(this.shell, slaveServer);
        if (dialog.open()) {
            this.refreshTree();
            this.refreshGraph();
        }
    }

    private void addTabs() {
        Control[] comps;
        if (this.tabComp != null) {
            this.tabComp.dispose();
        }
        this.tabComp = new Composite((Composite)this.sashform, 2048);
        this.props.setLook((Control)this.tabComp);
        this.tabComp.setLayout((Layout)new FillLayout());
        this.tabfolder = new TabSet(this.tabComp);
        this.tabfolder.setChangedFont(GUIResource.getInstance().getFontBold());
        this.props.setLook((Control)this.tabfolder.getSwtTabset(), 5);
        final CTabFolder cTabFolder = this.tabfolder.getSwtTabset();
        cTabFolder.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                Point real = new Point(event.x, event.y);
                Point point = Spoon.this.display.map(null, (Control)cTabFolder, real);
                final CTabItem item = cTabFolder.getItem(point);
                if (item != null) {
                    Menu menu = new Menu((Control)cTabFolder);
                    MenuItem closeItem = new MenuItem(menu, 0);
                    closeItem.setText(BaseMessages.getString((Class)PKG, (String)"Spoon.Tab.Close", (String[])new String[0]));
                    closeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            int index = Spoon.this.tabfolder.getSwtTabset().indexOf(item);
                            if (index >= 0) {
                                TabMapEntry entry = Spoon.this.delegates.tabs.getTabs().get(index);
                                Spoon.this.tabClose(entry.getTabItem());
                            }
                        }
                    });
                    MenuItem closeAllItems = new MenuItem(menu, 0);
                    closeAllItems.setText(BaseMessages.getString((Class)PKG, (String)"Spoon.Tab.CloseAll", (String[])new String[0]));
                    closeAllItems.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            for (TabMapEntry entry : Spoon.this.delegates.tabs.getTabs()) {
                                Spoon.this.tabClose(entry.getTabItem());
                            }
                        }
                    });
                    MenuItem closeOtherItems = new MenuItem(menu, 0);
                    closeOtherItems.setText(BaseMessages.getString((Class)PKG, (String)"Spoon.Tab.CloseOthers", (String[])new String[0]));
                    closeOtherItems.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            int index = Spoon.this.tabfolder.getSwtTabset().indexOf(item);
                            if (index >= 0) {
                                TabMapEntry entry = Spoon.this.delegates.tabs.getTabs().get(index);
                                for (TabMapEntry closeEntry : Spoon.this.delegates.tabs.getTabs()) {
                                    if (closeEntry.equals(entry)) continue;
                                    Spoon.this.tabClose(closeEntry.getTabItem());
                                }
                            }
                        }
                    });
                    menu.setLocation(real);
                    menu.setVisible(true);
                }
            }
        });
        int[] weights = this.props.getSashWeights();
        this.sashform.setWeights(weights);
        this.sashform.setVisible(true);
        for (Control comp : comps = this.sashform.getChildren()) {
            if (!(comp instanceof Sash)) continue;
            int limit = 10;
            final int SASH_LIMIT = Const.isOSX() ? 150 : limit;
            final Sash sash = (Sash)comp;
            sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Rectangle rect = sash.getParent().getClientArea();
                    event.x = Math.min(Math.max(event.x, SASH_LIMIT), rect.width - SASH_LIMIT);
                    if (event.detail != 1) {
                        sash.setBounds(event.x, event.y, event.width, event.height);
                        Spoon.this.sashform.layout();
                    }
                }
            });
        }
        this.tabfolder.addListener(this);
    }

    @Override
    public void tabDeselected(TabItem item) {
    }

    public boolean tabCloseSelected() {
        String activePerspectiveId = SpoonPerspectiveManager.getInstance().getActivePerspective().getId();
        boolean etlPerspective = activePerspectiveId.equals("001-spoon-jobs");
        if (etlPerspective) {
            return this.tabClose(this.tabfolder.getSelected());
        }
        try {
            SpoonPerspective activePerspective = SpoonPerspectiveManager.getInstance().getActivePerspective();
            Class<?> cls = activePerspective.getClass();
            Method m = cls.getMethod("onFileClose", new Class[0]);
            return (Boolean)m.invoke((Object)activePerspective, new Object[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean tabClose(TabItem item) {
        try {
            return this.delegates.tabs.tabClose(item);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Unexpected error closing tab!", e);
            return false;
        }
    }

    public TabSet getTabSet() {
        return this.tabfolder;
    }

    @Override
    public void tabSelected(TabItem item) {
        this.delegates.tabs.tabSelected(item);
        this.enableMenus();
    }

    public String getRepositoryName() {
        if (this.rep == null) {
            return null;
        }
        return this.rep.getName();
    }

    /*
     * WARNING - void declaration
     */
    public void pasteXML(TransMeta transMeta, String clipcontent, org.pentaho.di.core.gui.Point loc) {
        if (RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.MODIFY_TRANSFORMATION, RepositoryOperation.EXECUTE_TRANSFORMATION)) {
            return;
        }
        try {
            void var21_39;
            org.w3c.dom.Document doc = XMLHandler.loadXMLString((String)clipcontent);
            Node transNode = XMLHandler.getSubNode((Node)doc, (String)XML_TAG_TRANSFORMATION_STEPS);
            transMeta.unselectAll();
            Node stepsNode = XMLHandler.getSubNode((Node)transNode, (String)XML_TAG_STEPS);
            int nr = XMLHandler.countNodes((Node)stepsNode, (String)"step");
            if (this.getLog().isDebug()) {
                this.getLog().logDebug(BaseMessages.getString(PKG, (String)"Spoon.Log.FoundSteps", (String[])new String[]{"" + nr}) + loc);
            }
            Object[] steps = new StepMeta[nr];
            ArrayList<String> stepOldNames = new ArrayList<String>(nr);
            org.pentaho.di.core.gui.Point min = new org.pentaho.di.core.gui.Point(99999999, 99999999);
            for (int i = 0; i < nr; ++i) {
                Node stepNode = XMLHandler.getSubNodeByNr((Node)stepsNode, (String)"step", (int)i);
                steps[i] = new StepMeta(stepNode, transMeta.getDatabases(), (IMetaStore)this.metaStore);
                if (loc == null) continue;
                org.pentaho.di.core.gui.Point p = steps[i].getLocation();
                if (min.x > p.x) {
                    min.x = p.x;
                }
                if (min.y <= p.y) continue;
                min.y = p.y;
            }
            Node hopsNode = XMLHandler.getSubNode((Node)transNode, (String)"order");
            nr = XMLHandler.countNodes((Node)hopsNode, (String)"hop");
            if (this.getLog().isDebug()) {
                this.getLog().logDebug(BaseMessages.getString(PKG, (String)"Spoon.Log.FoundHops", (String[])new String[]{"" + nr}));
            }
            Object[] hops = new TransHopMeta[nr];
            ArrayList alSteps = new ArrayList();
            Collections.addAll(alSteps, steps);
            for (int i = 0; i < nr; ++i) {
                Node hopNode = XMLHandler.getSubNodeByNr((Node)hopsNode, (String)"hop", (int)i);
                hops[i] = new TransHopMeta(hopNode, alSteps);
            }
            org.pentaho.di.core.gui.Point offset = new org.pentaho.di.core.gui.Point(loc.x - min.x, loc.y - min.y);
            int[] position = new int[steps.length];
            for (int i = 0; i < steps.length; ++i) {
                org.pentaho.di.core.gui.Point p = steps[i].getLocation();
                String name = steps[i].getName();
                steps[i].setLocation(p.x + offset.x, p.y + offset.y);
                steps[i].setDraw(true);
                stepOldNames.add(name);
                steps[i].setName(transMeta.getAlternativeStepname(name));
                transMeta.addStep(steps[i]);
                position[i] = transMeta.indexOfStep(steps[i]);
                steps[i].setSelected(true);
            }
            for (TransHopMeta transHopMeta : hops) {
                transMeta.addTransHop(transHopMeta);
            }
            Node notesNode = XMLHandler.getSubNode((Node)transNode, (String)"notepads");
            nr = XMLHandler.countNodes((Node)notesNode, (String)"notepad");
            if (this.getLog().isDebug()) {
                this.getLog().logDebug(BaseMessages.getString(PKG, (String)"Spoon.Log.FoundNotepads", (String[])new String[]{"" + nr}));
            }
            Object[] notes = new NotePadMeta[nr];
            for (int i = 0; i < notes.length; ++i) {
                Node node = XMLHandler.getSubNodeByNr((Node)notesNode, (String)"notepad", (int)i);
                notes[i] = new NotePadMeta(node);
                org.pentaho.di.core.gui.Point p = notes[i].getLocation();
                notes[i].setLocation(p.x + offset.x, p.y + offset.y);
                transMeta.addNote(notes[i]);
                notes[i].setSelected(true);
            }
            for (StepMeta stepMeta : steps) {
                StepMetaInterface smi = stepMeta.getStepMetaInterface();
                smi.searchInfoAndTargetSteps(transMeta.getSteps());
            }
            Node errorHandlingNode = XMLHandler.getSubNode((Node)transNode, (String)"step_error_handling");
            int n = XMLHandler.countNodes((Node)errorHandlingNode, (String)"error");
            for (int i = 0; i < n; ++i) {
                Node node = XMLHandler.getSubNodeByNr((Node)errorHandlingNode, (String)"error", (int)i);
                StepErrorMeta stepErrorMeta = new StepErrorMeta(transMeta.getParentVariableSpace(), node, transMeta.getSteps());
                int srcStepPos = stepOldNames.indexOf(stepErrorMeta.getSourceStep().getName());
                int tgtStepPos = stepOldNames.indexOf(stepErrorMeta.getTargetStep().getName());
                StepMeta sourceStep = transMeta.findStep(steps[srcStepPos].getName());
                if (sourceStep != null) {
                    sourceStep.setStepErrorMeta(stepErrorMeta);
                }
                StepMeta targetStep = transMeta.findStep(steps[tgtStepPos].getName());
                stepErrorMeta.setSourceStep(sourceStep);
                stepErrorMeta.setTargetStep(targetStep);
            }
            this.addUndoNew((UndoInterface)transMeta, steps, position, false);
            int[] hopPos = new int[hops.length];
            boolean bl = false;
            while (var21_39 < hops.length) {
                hopPos[var21_39] = transMeta.indexOfTransHop(hops[var21_39]);
                ++var21_39;
            }
            this.addUndoNew((UndoInterface)transMeta, hops, hopPos, true);
            int[] nArray = new int[notes.length];
            for (int i = 0; i < notes.length; ++i) {
                nArray[i] = transMeta.indexOfNote(notes[i]);
            }
            this.addUndoNew((UndoInterface)transMeta, notes, nArray, true);
            if (transMeta.haveStepsChanged()) {
                this.refreshTree();
                this.refreshGraph();
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.UnablePasteSteps.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.UnablePasteSteps.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void copySelected(TransMeta transMeta, List<StepMeta> steps, List<NotePadMeta> notes) {
        if (steps == null || steps.size() == 0) {
            return;
        }
        if (RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.MODIFY_TRANSFORMATION, RepositoryOperation.EXECUTE_TRANSFORMATION)) {
            return;
        }
        StringBuilder xml = new StringBuilder(5000).append(XMLHandler.getXMLHeader());
        try {
            xml.append(XMLHandler.openTag((String)XML_TAG_TRANSFORMATION_STEPS)).append(Const.CR);
            xml.append(XMLHandler.openTag((String)XML_TAG_STEPS)).append(Const.CR);
            for (StepMeta step : steps) {
                xml.append(step.getXML());
            }
            xml.append(XMLHandler.closeTag((String)XML_TAG_STEPS)).append(Const.CR);
            xml.append(XMLHandler.openTag((String)"order")).append(Const.CR);
            for (StepMeta step1 : steps) {
                for (StepMeta step2 : steps) {
                    TransHopMeta hop;
                    if (step1 == step2 || (hop = transMeta.findTransHop(step1, step2, true)) == null) continue;
                    xml.append(hop.getXML()).append(Const.CR);
                }
            }
            xml.append(XMLHandler.closeTag((String)"order")).append(Const.CR);
            xml.append(XMLHandler.openTag((String)"notepads")).append(Const.CR);
            if (notes != null) {
                for (NotePadMeta note : notes) {
                    xml.append(note.getXML());
                }
            }
            xml.append(XMLHandler.closeTag((String)"notepads")).append(Const.CR);
            xml.append(XMLHandler.openTag((String)"step_error_handling")).append(Const.CR);
            for (StepMeta step : steps) {
                if (step.getStepErrorMeta() == null) continue;
                xml.append(step.getStepErrorMeta().getXML()).append(Const.CR);
            }
            xml.append(XMLHandler.closeTag((String)"step_error_handling")).append(Const.CR);
            xml.append(XMLHandler.closeTag((String)XML_TAG_TRANSFORMATION_STEPS)).append(Const.CR);
            this.toClipboard(xml.toString());
        }
        catch (Exception ex) {
            new ErrorDialog(this.getShell(), "Error", "Error encoding to XML", ex);
        }
    }

    public void editHop(TransMeta transMeta, TransHopMeta transHopMeta) {
        String name = transHopMeta.toString();
        TransHopMeta before = (TransHopMeta)transHopMeta.clone();
        TransHopDialog hd = new TransHopDialog(this.shell, 0, transHopMeta, transMeta);
        if (hd.open() != null) {
            TransHopMeta after = (TransHopMeta)transHopMeta.clone();
            this.addUndoChange((UndoInterface)transMeta, new TransHopMeta[]{before}, new TransHopMeta[]{after}, new int[]{transMeta.indexOfTransHop(transHopMeta)});
            String newName = transHopMeta.toString();
            if (!name.equalsIgnoreCase(newName)) {
                this.refreshTree();
                this.refreshGraph();
            }
        }
        this.setShellText();
    }

    public void delHop(TransMeta transMeta, TransHopMeta transHopMeta) {
        StepErrorMeta stepErrorMeta;
        int index = transMeta.indexOfTransHop(transHopMeta);
        this.addUndoDelete((UndoInterface)transMeta, new Object[]{(TransHopMeta)transHopMeta.clone()}, new int[]{index});
        transMeta.removeTransHop(index);
        if (transHopMeta.getFromStep().isDoingErrorHandling() && (stepErrorMeta = transHopMeta.getFromStep().getStepErrorMeta()).getTargetStep() != null && stepErrorMeta.getTargetStep().equals((Object)transHopMeta.getToStep())) {
            StepMeta stepMeta = transHopMeta.getFromStep();
            StepMeta before = (StepMeta)stepMeta.clone();
            stepErrorMeta.setEnabled(false);
            index = transMeta.indexOfStep(stepMeta);
            this.addUndoChange((UndoInterface)transMeta, new Object[]{before}, new Object[]{stepMeta}, new int[]{index});
        }
        this.refreshTree();
        this.refreshGraph();
    }

    public void newHop(TransMeta transMeta, StepMeta fr, StepMeta to) {
        TransHopMeta hi = new TransHopMeta(fr, to);
        TransHopDialog hd = new TransHopDialog(this.shell, 0, hi, transMeta);
        if (hd.open() != null) {
            this.newHop(transMeta, hi);
        }
    }

    public void newHop(TransMeta transMeta, TransHopMeta transHopMeta) {
        if (this.checkIfHopAlreadyExists(transMeta, transHopMeta)) {
            transMeta.addTransHop(transHopMeta);
            int idx = transMeta.indexOfTransHop(transHopMeta);
            if (!this.performNewTransHopChecks(transMeta, transHopMeta)) {
                transMeta.removeTransHop(idx);
            } else {
                this.addUndoNew((UndoInterface)transMeta, new TransHopMeta[]{transHopMeta}, new int[]{transMeta.indexOfTransHop(transHopMeta)});
            }
            transHopMeta.getFromStep().drawStep();
            transHopMeta.getToStep().drawStep();
            this.refreshTree();
            this.refreshGraph();
        }
    }

    public boolean checkIfHopAlreadyExists(TransMeta transMeta, TransHopMeta newHop) {
        boolean ok = true;
        if (transMeta.findTransHop(newHop.getFromStep(), newHop.getToStep()) != null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.HopExists.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.HopExists.Title", (String[])new String[0]));
            mb.open();
            ok = false;
        }
        return ok;
    }

    public boolean performNewTransHopChecks(TransMeta transMeta, TransHopMeta newHop) {
        boolean ok = true;
        if (transMeta.hasLoop(newHop.getFromStep()) || transMeta.hasLoop(newHop.getToStep())) {
            MessageBox mb = new MessageBox(this.shell, 72);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TransGraph.Dialog.HopCausesLoop.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"TransGraph.Dialog.HopCausesLoop.Title", (String[])new String[0]));
            mb.open();
            ok = false;
        }
        if (ok) {
            try {
                if (!newHop.getToStep().getStepMetaInterface().excludeFromRowLayoutVerification()) {
                    transMeta.checkRowMixingStatically(newHop.getToStep(), null);
                }
            }
            catch (KettleRowException re) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TransGraph.Dialog.HopCausesRowMixing.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransGraph.Dialog.HopCausesRowMixing.Message", (String[])new String[0]), (Exception)((Object)re));
            }
            this.verifyCopyDistribute(transMeta, newHop.getFromStep());
        }
        return ok;
    }

    public void verifyCopyDistribute(TransMeta transMeta, StepMeta fr) {
        List nextSteps = transMeta.findNextSteps(fr);
        int nrNextSteps = nextSteps.size();
        if (nrNextSteps == 2) {
            boolean distributes = fr.getStepMetaInterface().excludeFromCopyDistributeVerification();
            boolean customDistribution = false;
            if (this.props.showCopyOrDistributeWarning() && !fr.getStepMetaInterface().excludeFromCopyDistributeVerification()) {
                MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"System.Warning", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"Spoon.Dialog.CopyOrDistribute.Message", (String[])new String[]{fr.getName(), Integer.toString(nrNextSteps)}), 4, this.getRowDistributionLabels(), 0, BaseMessages.getString(PKG, (String)"Spoon.Message.Warning.NotShowWarning", (String[])new String[0]), !this.props.showCopyOrDistributeWarning());
                MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
                int idx = md.open();
                this.props.setShowCopyOrDistributeWarning(!md.getToggleState());
                this.props.saveProps();
                distributes = idx == 256;
                boolean bl = customDistribution = idx == 258;
            }
            if (distributes) {
                fr.setDistributes(true);
                fr.setRowDistribution(null);
            } else if (customDistribution) {
                RowDistributionInterface rowDistribution = this.getActiveTransGraph().askUserForCustomDistributionMethod();
                fr.setDistributes(true);
                fr.setRowDistribution(rowDistribution);
            } else {
                fr.setDistributes(false);
                fr.setDistributes(false);
            }
            this.refreshTree();
            this.refreshGraph();
        }
    }

    private String[] getRowDistributionLabels() {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(BaseMessages.getString(PKG, (String)"Spoon.Dialog.CopyOrDistribute.Distribute", (String[])new String[0]));
        labels.add(BaseMessages.getString(PKG, (String)"Spoon.Dialog.CopyOrDistribute.Copy", (String[])new String[0]));
        if (PluginRegistry.getInstance().getPlugins(RowDistributionPluginType.class).size() > 0) {
            labels.add(BaseMessages.getString(PKG, (String)"Spoon.Dialog.CopyOrDistribute.CustomRowDistribution", (String[])new String[0]));
        }
        return labels.toArray(new String[labels.size()]);
    }

    public void newHop(TransMeta transMeta) {
        this.newHop(transMeta, null, null);
    }

    public void openRepository() {
        if (Spoon.getInstance().isTabsChanged()) {
            MessageBox mb = new MessageBox(Spoon.getInstance().getShell(), 32);
            mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.WarnToSaveAllPriorToConnect.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.WarnToCloseAllForce.Disconnect.Title", (String[])new String[0]));
            mb.open();
            return;
        }
        this.loginDialog = new RepositoriesDialog(this.shell, null, new ILoginCallback(){

            @Override
            public void onSuccess(Repository repository) {
                if (Spoon.this.rep != null) {
                    Spoon.this.rep.disconnect();
                    SpoonPluginManager.getInstance().notifyLifecycleListeners(SpoonLifecycleListener.SpoonLifeCycleEvent.REPOSITORY_DISCONNECTED);
                }
                Spoon.this.setRepository(repository);
                Spoon.this.loadSessionInformation(repository, true);
                Spoon.this.refreshTree();
                Spoon.this.setShellText();
                SpoonPluginManager.getInstance().notifyLifecycleListeners(SpoonLifecycleListener.SpoonLifeCycleEvent.REPOSITORY_CONNECTED);
            }

            @Override
            public void onError(Throwable t) {
                Spoon.this.closeRepository();
                Spoon.this.onLoginError(t);
            }

            @Override
            public void onCancel() {
            }
        });
        this.loginDialog.show();
    }

    private void loadSessionInformation(Repository repository, boolean saveOldDatabases) {
        TransMeta[] transMetas;
        JobMeta[] jobMetas;
        for (JobMeta jobMeta : jobMetas = this.getLoadedJobs()) {
            for (int i = 0; i < jobMeta.nrDatabases(); ++i) {
                jobMeta.getDatabase(i).setObjectId(null);
            }
            jobMeta.setObjectId(null);
            List oldDatabases = jobMeta.getDatabases();
            jobMeta.setDatabases(new ArrayList());
            jobMeta.setSlaveServers(new ArrayList());
            try {
                SharedObjects sharedObjects = repository != null ? repository.readJobMetaSharedObjects(jobMeta) : jobMeta.readSharedObjects();
                this.sharedObjectsFileMap.put(sharedObjects.getFilename(), sharedObjects);
            }
            catch (KettleException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorReadingSharedObjects.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorReadingSharedObjects.Message", (String[])new String[]{this.makeTabName((EngineMetaInterface)jobMeta, true)}), (Exception)((Object)e));
            }
            for (DatabaseMeta oldDatabase : oldDatabases) {
                DatabaseMeta newDatabase = DatabaseMeta.findDatabase((List)jobMeta.getDatabases(), (String)oldDatabase.getName());
                if (newDatabase != null) {
                    oldDatabase.setDatabaseInterface(newDatabase.getDatabaseInterface());
                    continue;
                }
                if (!saveOldDatabases) continue;
                jobMeta.addDatabase(oldDatabase);
            }
            if (repository == null) continue;
            try {
                RepositoryDirectoryInterface rdi = repository.findDirectory(jobMeta.getRepositoryDirectory().getPath());
                if (rdi != null) {
                    jobMeta.setRepositoryDirectory(rdi);
                    continue;
                }
                jobMeta.setRepositoryDirectory(repository.loadRepositoryDirectoryTree());
            }
            catch (KettleException ke) {
                this.rep = null;
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorConnectingRepository.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorConnectingRepository.Message", (String[])new String[]{Const.CR}), (Exception)((Object)ke));
            }
        }
        for (TransMeta transMeta : transMetas = this.getLoadedTransformations()) {
            for (int i = 0; i < transMeta.nrDatabases(); ++i) {
                transMeta.getDatabase(i).setObjectId(null);
            }
            transMeta.setObjectId(null);
            List oldDatabases = transMeta.getDatabases();
            transMeta.setDatabases(new ArrayList());
            transMeta.setPartitionSchemas(new ArrayList());
            transMeta.setSlaveServers(new ArrayList());
            transMeta.setClusterSchemas(new ArrayList());
            try {
                SharedObjects sharedObjects = repository != null ? repository.readTransSharedObjects(transMeta) : transMeta.readSharedObjects();
                this.sharedObjectsFileMap.put(sharedObjects.getFilename(), sharedObjects);
            }
            catch (KettleException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorReadingSharedObjects.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorReadingSharedObjects.Message", (String[])new String[]{this.makeTabName((EngineMetaInterface)transMeta, true)}), (Exception)((Object)e));
            }
            for (DatabaseMeta oldDatabase : oldDatabases) {
                DatabaseMeta newDatabase = DatabaseMeta.findDatabase((List)transMeta.getDatabases(), (String)oldDatabase.getName());
                if (newDatabase != null) {
                    oldDatabase.setDatabaseInterface(newDatabase.getDatabaseInterface());
                    continue;
                }
                if (!saveOldDatabases) continue;
                transMeta.addDatabase(oldDatabase);
            }
            if (repository == null) continue;
            try {
                RepositoryDirectoryInterface rdi = repository.findDirectory(transMeta.getRepositoryDirectory().getPath());
                if (rdi != null) {
                    transMeta.setRepositoryDirectory(rdi);
                    continue;
                }
                transMeta.setRepositoryDirectory(repository.loadRepositoryDirectoryTree());
            }
            catch (KettleException ke) {
                this.rep = null;
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorConnectingRepository.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorConnectingRepository.Message", (String[])new String[]{Const.CR}), (Exception)((Object)ke));
            }
        }
    }

    public void clearSharedObjectCache() throws KettleException {
        if (this.rep != null) {
            JobMeta jobMeta;
            this.rep.clearSharedObjectCache();
            TransMeta transMeta = this.getActiveTransformation();
            if (transMeta != null) {
                this.rep.readTransSharedObjects(transMeta);
            }
            if ((jobMeta = this.getActiveJob()) != null) {
                this.rep.readJobMetaSharedObjects(jobMeta);
            }
        }
    }

    public void exploreRepository() {
        if (this.rep != null) {
            final RepositoryExplorerCallback cb = new RepositoryExplorerCallback(){

                @Override
                public boolean open(UIRepositoryContent element, String revision) throws Exception {
                    String objName = element.getName();
                    if (objName != null) {
                        RepositoryObjectType objectType = element.getRepositoryElementType();
                        RepositoryDirectory repDir = element.getRepositoryDirectory();
                        if (element.getObjectId() != null) {
                            Spoon.this.loadObjectFromRepository(element.getObjectId(), objectType, revision);
                        } else {
                            Spoon.this.loadObjectFromRepository(objName, objectType, (RepositoryDirectoryInterface)repDir, revision);
                        }
                    }
                    return false;
                }

                @Override
                public boolean error(String message) throws Exception {
                    Spoon.this.closeRepository();
                    return true;
                }
            };
            try {
                final XulWaitBox box = (XulWaitBox)this.mainSpoonContainer.getDocumentRoot().createElement("waitbox");
                box.setIndeterminate(true);
                box.setCanCancel(false);
                box.setTitle(BaseMessages.getString(RepositoryDialogInterface.class, (String)"RepositoryExplorerDialog.Connection.Wait.Title", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(RepositoryDialogInterface.class, (String)"RepositoryExplorerDialog.Explorer.Wait.Message", (String[])new String[0]));
                box.setDialogParent((Object)this.shell);
                box.setRunnable(new WaitBoxRunnable(box){

                    public void run() {
                        Spoon.this.shell.getDisplay().syncExec(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                try {
                                    RepositoryExplorer explorer;
                                    try {
                                        explorer = new RepositoryExplorer(Spoon.this.shell, Spoon.this.rep, cb, Variables.getADefaultVariableSpace());
                                    }
                                    catch (KettleRepositoryLostException krle) {
                                        Spoon.this.shell.getDisplay().asyncExec(new Runnable(){

                                            @Override
                                            public void run() {
                                                new ErrorDialog(Spoon.this.getShell(), BaseMessages.getString((Class)PKG, (String)"Spoon.Error", (String[])new String[0]), krle.getPrefaceMessage(), (Exception)krle);
                                            }
                                        });
                                        Spoon.this.closeRepository();
                                        return;
                                    }
                                    finally {
                                        box.stop();
                                    }
                                    if (!explorer.isInitialized()) {
                                        return;
                                    }
                                    explorer.show();
                                    explorer.dispose();
                                }
                                catch (Throwable e) {
                                    Spoon.this.shell.getDisplay().asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            new ErrorDialog(Spoon.this.shell, BaseMessages.getString((Class)PKG, (String)"Spoon.Error", (String[])new String[0]), e.getMessage(), e);
                                        }
                                    });
                                }
                            }
                        });
                    }

                    public void cancel() {
                    }
                });
                box.start();
            }
            catch (Throwable e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Error", (String[])new String[0]), e.getMessage(), e);
            }
        }
    }

    private void loadObjectFromRepository(ObjectId objectId, RepositoryObjectType objectType, String revision) throws Exception {
        if (objectType.equals((Object)RepositoryObjectType.TRANSFORMATION)) {
            try {
                TransLoadProgressDialog progressDialog = new TransLoadProgressDialog(this.shell, this.rep, objectId, revision);
                TransMeta transMeta = progressDialog.open();
                transMeta.clearChanged();
                if (transMeta != null) {
                    if (log.isDetailed()) {
                        log.logDetailed(BaseMessages.getString(PKG, (String)"Spoon.Log.LoadToTransformation", (String[])new String[]{transMeta.getName(), transMeta.getRepositoryDirectory().getName()}));
                    }
                    this.props.addLastFile("Trans", transMeta.getName(), transMeta.getRepositoryDirectory().getPath(), true, this.rep.getName());
                    this.addMenuLast();
                    this.addTransGraph(transMeta);
                }
                this.refreshTree();
                this.refreshGraph();
            }
            catch (Exception e) {
                if (KettleRepositoryLostException.lookupStackStrace((Throwable)e) == null) {
                    new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), BaseMessages.getString(Spoon.class, (String)"Spoon.Dialog.ErrorOpeningById.Message", (Object[])new Object[]{objectId}), e.getMessage(), e);
                }
                throw e;
            }
        } else if (objectType.equals((Object)RepositoryObjectType.JOB)) {
            try {
                JobLoadProgressDialog progressDialog = new JobLoadProgressDialog(this.shell, this.rep, objectId, revision);
                JobMeta jobMeta = progressDialog.open();
                jobMeta.clearChanged();
                if (jobMeta != null) {
                    this.props.addLastFile("Job", jobMeta.getName(), jobMeta.getRepositoryDirectory().getPath(), true, this.rep.getName());
                    this.saveSettings();
                    this.addMenuLast();
                    this.addJobGraph(jobMeta);
                }
                this.refreshTree();
                this.refreshGraph();
            }
            catch (Exception e) {
                if (KettleRepositoryLostException.lookupStackStrace((Throwable)e) == null) {
                    new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), BaseMessages.getString(Spoon.class, (String)"Spoon.Dialog.ErrorOpeningById.Message", (Object[])new Object[]{objectId}), e.getMessage(), e);
                }
                throw e;
            }
        }
    }

    public void loadObjectFromRepository(String objName, RepositoryObjectType objectType, RepositoryDirectoryInterface repDir, String versionLabel) throws Exception {
        if (objectType.equals((Object)RepositoryObjectType.TRANSFORMATION)) {
            try {
                TransLoadProgressDialog progressDialog = new TransLoadProgressDialog(this.shell, this.rep, objName, repDir, versionLabel);
                TransMeta transMeta = progressDialog.open();
                transMeta.clearChanged();
                if (transMeta != null) {
                    if (log.isDetailed()) {
                        log.logDetailed(BaseMessages.getString(PKG, (String)"Spoon.Log.LoadToTransformation", (String[])new String[]{objName, repDir.getName()}));
                    }
                    this.props.addLastFile("Trans", objName, repDir.getPath(), true, this.rep.getName());
                    this.addMenuLast();
                    this.addTransGraph(transMeta);
                }
                this.refreshTree();
                this.refreshGraph();
            }
            catch (Exception e) {
                if (KettleRepositoryLostException.lookupStackStrace((Throwable)e) == null) {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorOpening.Message", (String[])new String[0]) + objName + Const.CR + e.getMessage());
                    mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorOpening.Title", (String[])new String[0]));
                    mb.open();
                }
                throw e;
            }
        } else if (objectType.equals((Object)RepositoryObjectType.JOB)) {
            try {
                JobLoadProgressDialog progressDialog = new JobLoadProgressDialog(this.shell, this.rep, objName, repDir, versionLabel);
                JobMeta jobMeta = progressDialog.open();
                jobMeta.clearChanged();
                if (jobMeta != null) {
                    this.props.addLastFile("Job", objName, repDir.getPath(), true, this.rep.getName());
                    this.saveSettings();
                    this.addMenuLast();
                    this.addJobGraph(jobMeta);
                }
                this.refreshTree();
                this.refreshGraph();
            }
            catch (Exception e) {
                if (KettleRepositoryLostException.lookupStackStrace((Throwable)e) == null) {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorOpening.Message", (String[])new String[0]) + objName + Const.CR + e.getMessage());
                    mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorOpening.Title", (String[])new String[0]));
                    mb.open();
                }
                throw e;
            }
        }
    }

    public void closeRepository() {
        boolean shouldDisconnect;
        if (this.rep != null && (shouldDisconnect = Spoon.getInstance().closeAllJobsAndTransformations())) {
            this.loadSessionInformation(null, false);
            this.rep.disconnect();
            if (this.metaStore.getMetaStoreList().size() > 1) {
                try {
                    this.metaStore.getMetaStoreList().remove(0);
                    this.metaStore.setActiveMetaStoreName(((IMetaStore)this.metaStore.getMetaStoreList().get(0)).getName());
                }
                catch (MetaStoreException e) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.ErrorRemovingMetaStore.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorRemovingMetaStore.Message", (String[])new String[0]), (Exception)((Object)e));
                }
            }
            this.setRepository(null);
            this.setShellText();
            SpoonPluginManager.getInstance().notifyLifecycleListeners(SpoonLifecycleListener.SpoonLifeCycleEvent.REPOSITORY_DISCONNECTED);
            this.enableMenus();
        }
    }

    public void openFile() {
        this.openFile(false);
    }

    public void importFile() {
        this.openFile(true);
    }

    public void openFile(boolean importfile) {
        try {
            SpoonPerspective activePerspective = SpoonPerspectiveManager.getInstance().getActivePerspective();
            if (!importfile && activePerspective instanceof SpoonPerspectiveOpenSaveInterface) {
                ((SpoonPerspectiveOpenSaveInterface)((Object)activePerspective)).open();
                return;
            }
            String activePerspectiveId = activePerspective.getId();
            boolean etlPerspective = activePerspectiveId.equals("001-spoon-jobs");
            if (this.rep == null || importfile || !etlPerspective) {
                FileDialog dialog = new FileDialog(this.shell, 4096);
                LinkedHashSet<String> extensions = new LinkedHashSet<String>();
                LinkedHashSet<String> extensionNames = new LinkedHashSet<String>();
                StringBuilder allExtensions = new StringBuilder();
                for (FileListener l : this.fileListeners) {
                    for (String ext : l.getSupportedExtensions()) {
                        extensions.add("*." + ext);
                        allExtensions.append("*.").append(ext).append(";");
                    }
                    Collections.addAll(extensionNames, l.getFileTypeDisplayNames(Locale.getDefault()));
                }
                extensions.add("*");
                extensionNames.add(BaseMessages.getString(PKG, (String)"Spoon.Dialog.OpenFile.AllFiles", (String[])new String[0]));
                String[] exts = new String[extensions.size() + 1];
                exts[0] = allExtensions.toString();
                System.arraycopy(extensions.toArray(new String[extensions.size()]), 0, exts, 1, extensions.size());
                String[] extNames = new String[extensionNames.size() + 1];
                extNames[0] = BaseMessages.getString(PKG, (String)"Spoon.Dialog.OpenFile.AllTypes", (String[])new String[0]);
                System.arraycopy(extensionNames.toArray(new String[extensionNames.size()]), 0, extNames, 1, extensionNames.size());
                dialog.setFilterExtensions(exts);
                this.setFilterPath(dialog);
                String filename = dialog.open();
                if (filename != null) {
                    if (importfile && activePerspective instanceof SpoonPerspectiveOpenSaveInterface) {
                        ((SpoonPerspectiveOpenSaveInterface)((Object)activePerspective)).importFile(filename);
                        return;
                    }
                    this.lastDirOpened = dialog.getFilterPath();
                    this.openFile(filename, importfile);
                }
            } else {
                SelectObjectDialog sod = new SelectObjectDialog(this.shell, this.rep);
                if (sod.open() != null) {
                    RepositoryObjectType type = sod.getObjectType();
                    String name = sod.getObjectName();
                    RepositoryDirectoryInterface repDir = sod.getDirectory();
                    if (RepositoryObjectType.TRANSFORMATION.equals((Object)type)) {
                        TransLoadProgressDialog tlpd = new TransLoadProgressDialog(this.shell, this.rep, name, repDir, null);
                        TransMeta transMeta = tlpd.open();
                        this.sharedObjectsFileMap.put(transMeta.getSharedObjects().getFilename(), transMeta.getSharedObjects());
                        this.setTransMetaVariables(transMeta);
                        if (transMeta != null) {
                            if (log.isDetailed()) {
                                log.logDetailed(BaseMessages.getString(PKG, (String)"Spoon.Log.LoadToTransformation", (String[])new String[]{name, repDir.getName()}));
                            }
                            this.props.addLastFile("Trans", name, repDir.getPath(), true, this.rep.getName());
                            this.addMenuLast();
                            transMeta.clearChanged();
                            this.addTransGraph(transMeta);
                        }
                        this.refreshGraph();
                        this.refreshTree();
                    } else if (RepositoryObjectType.JOB.equals((Object)type)) {
                        JobLoadProgressDialog jlpd = new JobLoadProgressDialog(this.shell, this.rep, name, repDir, null);
                        JobMeta jobMeta = jlpd.open();
                        this.sharedObjectsFileMap.put(jobMeta.getSharedObjects().getFilename(), jobMeta.getSharedObjects());
                        this.setJobMetaVariables(jobMeta);
                        if (jobMeta != null) {
                            this.props.addLastFile("Job", name, repDir.getPath(), true, this.rep.getName());
                            this.saveSettings();
                            this.addMenuLast();
                            this.addJobGraph(jobMeta);
                        }
                        this.refreshGraph();
                        this.refreshTree();
                    }
                }
            }
        }
        catch (KettleRepositoryLostException krle) {
            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Error", (String[])new String[0]), krle.getPrefaceMessage(), (Exception)((Object)krle));
            this.closeRepository();
        }
    }

    private void setFilterPath(FileDialog dialog) {
        if (!Const.isEmpty((String)this.lastDirOpened) && new File(this.lastDirOpened).exists()) {
            dialog.setFilterPath(this.lastDirOpened);
        }
    }

    public String getLastFileOpened() {
        if (this.lastFileOpened == null) {
            this.lastFileOpened = System.getProperty("org.pentaho.di.defaultVFSPath", "");
        }
        return this.lastFileOpened;
    }

    public void setLastFileOpened(String inLastFileOpened) {
        this.lastFileOpened = inLastFileOpened;
    }

    public void displayCmdLine() {
        String cmdFile = this.getCmdLine();
        if (Const.isEmpty((String)cmdFile)) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ExportCmdLine.JobOrTransformationMissing.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"ExportCmdLine.JobOrTransformationMissing.Title", (String[])new String[0]));
            mb.open();
        } else {
            ShowBrowserDialog sbd = new ShowBrowserDialog(this.shell, BaseMessages.getString(PKG, (String)"ExportCmdLine.CommandLine.Title", (String[])new String[0]), cmdFile);
            sbd.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCmdLineFile() {
        String cmdFile = this.getCmdLine();
        if (Const.isEmpty((String)cmdFile)) {
            MessageBox mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ExportCmdLine.JobOrTransformationMissing.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"ExportCmdLine.JobOrTransformationMissing.Title", (String[])new String[0]));
            mb.open();
        } else {
            boolean export = true;
            FileDialog dialog = new FileDialog(this.shell, 8192);
            dialog.setFilterExtensions(new String[]{"*.bat", ".sh", "*.*"});
            dialog.setFilterNames(new String[]{BaseMessages.getString(PKG, (String)"ExportCmdLine.BatFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExportCmdLineShFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExportCmdLine.AllFiles", (String[])new String[0])});
            String filename = dialog.open();
            if (filename != null) {
                MessageBox mb;
                int id = 64;
                try {
                    FileObject f = KettleVFS.getFileObject((String)filename);
                    if (f.exists()) {
                        mb = new MessageBox(this.shell, 200);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"ExportCmdLineShFiles.FileExistsReplace", (String[])new String[]{filename}));
                        mb.setText(BaseMessages.getString(PKG, (String)"ExportCmdLineShFiles.ConfirmOverwrite", (String[])new String[0]));
                        id = mb.open();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (id == 128) {
                    export = false;
                }
                if (export) {
                    FileWriter out = null;
                    try {
                        out = new FileWriter(filename);
                        out.write(cmdFile);
                        out.flush();
                    }
                    catch (Exception e) {
                        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ExportCmdLineShFiles.ErrorWritingFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExportCmdLineShFiles.ErrorWritingFile.Message", (String[])new String[]{filename}), e);
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                    mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"ExportCmdLineShFiles.CmdExported.Message", (String[])new String[]{filename}));
                    mb.setText(BaseMessages.getString(PKG, (String)"ExportCmdLineShFiles.CmdExported.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
    }

    private String getCmdLine() {
        TransMeta transMeta = this.getActiveTransformation();
        JobMeta jobMeta = this.getActiveJob();
        String cmdFile = "";
        if (this.rep != null && (jobMeta != null || transMeta != null)) {
            if (jobMeta != null) {
                if (jobMeta.getName() != null) {
                    cmdFile = Const.isWindows() ? "kitchen /rep:\"" + this.rep.getName() + "\"" + " /user:\"" + (this.rep.getUserInfo() != null ? this.rep.getUserInfo().getLogin() : "") + "\"" + " /pass:\"" + Encr.encryptPasswordIfNotUsingVariables((String)this.rep.getUserInfo().getPassword()) + "\"" + " /job:\"" + jobMeta.getName() + '\"' + " /dir:\"" + jobMeta.getRepositoryDirectory().getPath() + "\"" + " /level:Basic" : "sh kitchen.sh -rep='" + this.rep.getName() + "'" + " -user='" + (this.rep.getUserInfo() != null ? this.rep.getUserInfo().getLogin() : "") + "'" + " -pass='" + Encr.encryptPasswordIfNotUsingVariables((String)(this.rep.getUserInfo() != null ? this.rep.getUserInfo().getPassword() : "")) + "'" + " -job='" + jobMeta.getName() + "'" + " -dir='" + jobMeta.getRepositoryDirectory().getPath() + "'" + " -level=Basic";
                }
            } else if (transMeta.getName() != null) {
                cmdFile = Const.isWindows() ? "pan /rep:\"" + this.rep.getName() + "\"" + " /user:\"" + (this.rep.getUserInfo() != null ? this.rep.getUserInfo().getLogin() : "") + "\"" + " /pass:\"" + Encr.encryptPasswordIfNotUsingVariables((String)(this.rep.getUserInfo() != null ? this.rep.getUserInfo().getPassword() : "")) + "\"" + " /trans:\"" + transMeta.getName() + "\"" + " /dir:\"" + transMeta.getRepositoryDirectory().getPath() + "\"" + " /level:Basic" : "sh pan.sh -rep='" + this.rep.getName() + "'" + " -user='" + (this.rep.getUserInfo() != null ? this.rep.getUserInfo().getLogin() : "") + "'" + " -pass='" + Encr.encryptPasswordIfNotUsingVariables((String)(this.rep.getUserInfo() != null ? this.rep.getUserInfo().getPassword() : "")) + "'" + " -trans='" + transMeta.getName() + "'" + " -dir='" + transMeta.getRepositoryDirectory().getPath() + "'" + " -level=Basic";
            }
        } else if (this.rep == null && (jobMeta != null || transMeta != null)) {
            if (jobMeta != null) {
                if (jobMeta.getFilename() != null) {
                    cmdFile = Const.isWindows() ? "kitchen /file:\"" + jobMeta.getFilename() + "\"" + " /level:Basic" : "sh kitchen.sh -file='" + jobMeta.getFilename() + "'" + " -level=Basic";
                }
            } else if (transMeta.getFilename() != null) {
                cmdFile = Const.isWindows() ? "pan /file:\"" + transMeta.getFilename() + "\"" + " /level:Basic" : "sh pan.sh -file:'" + transMeta.getFilename() + "'" + " -level=Basic";
            }
        }
        return cmdFile;
    }

    public void openFileVFSFile() {
        FileObject rootFile;
        FileObject initialFile;
        try {
            initialFile = KettleVFS.getFileObject((String)this.getLastFileOpened());
            rootFile = initialFile.getFileSystem().getRoot();
        }
        catch (Exception e) {
            String message = Const.getStackTracker((Throwable)e);
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Error", (String[])new String[0]), message, e);
            return;
        }
        FileObject selectedFile = this.getVfsFileChooserDialog(rootFile, initialFile).open(this.shell, null, Const.STRING_TRANS_AND_JOB_FILTER_EXT, Const.getTransformationAndJobFilterNames(), 0);
        if (selectedFile != null) {
            this.setLastFileOpened(selectedFile.getName().getFriendlyURI());
            this.openFile(selectedFile.getName().getFriendlyURI(), false);
        }
    }

    public void addFileListener(FileListener listener) {
        this.fileListeners.add(listener);
        for (String s : listener.getSupportedExtensions()) {
            if (this.fileExtensionMap.containsKey(s)) continue;
            this.fileExtensionMap.put(s, listener);
        }
    }

    public void openFile(String filename, boolean importfile) {
        block13: {
            try {
                org.w3c.dom.Element root;
                FileListener listener;
                boolean loaded;
                block12: {
                    loaded = false;
                    listener = null;
                    root = null;
                    int idx = filename.lastIndexOf(46);
                    if (idx != -1) {
                        for (FileListener li : this.fileListeners) {
                            if (!li.accepts(filename)) continue;
                            listener = li;
                            break;
                        }
                    }
                    try {
                        org.w3c.dom.Document document = XMLHandler.loadXMLFile((String)filename);
                        root = document.getDocumentElement();
                    }
                    catch (KettleXMLException e) {
                        if (!log.isDetailed()) break block12;
                        log.logDetailed(BaseMessages.getString(PKG, (String)"Spoon.File.Xml.Parse.Error", (String[])new String[0]));
                    }
                }
                if (listener == null && root != null) {
                    for (FileListener li : this.fileListeners) {
                        if (!li.acceptsXml(root.getNodeName())) continue;
                        listener = li;
                        break;
                    }
                }
                if (!Const.isEmpty((String)filename)) {
                    if (listener != null) {
                        loaded = listener.open(root, filename, importfile);
                    }
                    if (!loaded) {
                        this.hideSplash();
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.UnknownFileType.Message", (String[])new String[]{filename}));
                        mb.setText(BaseMessages.getString(PKG, (String)"Spoon.UnknownFileType.Title", (String[])new String[0]));
                        mb.open();
                    } else {
                        this.applyVariables();
                    }
                }
            }
            catch (KettleMissingPluginsException e) {
                if (!this.marketPluginIsAvailable()) break block13;
                this.handleMissingPluginsExceptionWithMarketplace(e);
            }
        }
    }

    private boolean marketPluginIsAvailable() {
        PluginInterface marketPlugin = this.findMarketPlugin();
        return marketPlugin != null;
    }

    private PluginInterface findMarketPlugin() {
        return PluginRegistry.getInstance().findPluginWithId(SpoonPluginType.class, "market");
    }

    public void handleMissingPluginsExceptionWithMarketplace(KettleMissingPluginsException missingPluginsException) {
        try {
            this.hideSplash();
            MessageBox box = new MessageBox(this.shell, 196);
            box.setText(BaseMessages.getString(PKG, (String)"Spoon.MissingPluginsFoundDialog.Title", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"Spoon.MissingPluginsFoundDialog.Message", (String[])new String[]{Const.CR, missingPluginsException.getPluginsMessage()}));
            int answer = box.open();
            if ((answer & 0x40) != 0) {
                String controllerClassName = "org.pentaho.di.ui.spoon.dialog.MarketplaceController";
                PluginInterface marketPlugin = this.findMarketPlugin();
                ClassLoader classLoader = PluginRegistry.getInstance().getClassLoader(marketPlugin);
                Class<?> controllerClass = classLoader.loadClass(controllerClassName);
                Method method = controllerClass.getMethod("showMarketPlaceDialog", new Class[0]);
                method.invoke(null, new Object[0]);
            }
        }
        catch (Exception ex) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.ErrorShowingMarketplaceDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorShowingMarketplaceDialog.Message", (String[])new String[0]), ex);
        }
    }

    public PropsUI getProperties() {
        return this.props;
    }

    public void newFileDropDown() {
        XulToolbarbutton button = (XulToolbarbutton)this.mainToolbar.getElementById("file-new");
        Object object = button.getManagedObject();
        if (object instanceof ToolItem) {
            ToolItem item = (ToolItem)object;
            Rectangle bounds = item.getBounds();
            Point p = item.getParent().toDisplay(new Point(bounds.x, bounds.y));
            this.fileMenus.setLocation(p.x, p.y + bounds.height);
            this.fileMenus.setVisible(true);
        }
    }

    public void newTransFile() {
        TransMeta transMeta = new TransMeta();
        transMeta.addObserver((PDIObserver)this);
        this.setTransMetaVariables(transMeta);
        transMeta.setRepository(this.rep);
        transMeta.setMetaStore((IMetaStore)this.metaStore);
        try {
            SharedObjects sharedObjects = this.rep != null ? this.rep.readTransSharedObjects(transMeta) : transMeta.readSharedObjects();
            this.sharedObjectsFileMap.put(sharedObjects.getFilename(), sharedObjects);
            transMeta.importFromMetaStore();
            transMeta.clearChanged();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingSharedObjects.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingSharedObjects.Message", (String[])new String[0]), e);
        }
        transMeta.setRepositoryDirectory(this.getDefaultSaveLocation((RepositoryElementInterface)transMeta));
        int nr = 1;
        transMeta.setName(STRING_TRANSFORMATION + " " + nr);
        while (this.findTransformation(this.delegates.tabs.makeTabName((EngineMetaInterface)transMeta, false)) != null) {
            transMeta.setName(STRING_TRANSFORMATION + " " + ++nr);
        }
        this.addTransGraph(transMeta);
        this.applyVariables();
        if (this.setDesignMode()) {
            this.refreshTree();
        }
        this.loadPerspective("001-spoon-jobs");
    }

    public void newJobFile() {
        try {
            JobMeta jobMeta = new JobMeta();
            jobMeta.addObserver((PDIObserver)this);
            this.setJobMetaVariables(jobMeta);
            jobMeta.setRepository(this.rep);
            jobMeta.setMetaStore((IMetaStore)this.metaStore);
            try {
                SharedObjects sharedObjects = this.rep != null ? this.rep.readJobMetaSharedObjects(jobMeta) : jobMeta.readSharedObjects();
                this.sharedObjectsFileMap.put(sharedObjects.getFilename(), sharedObjects);
                jobMeta.importFromMetaStore();
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorReadingSharedObjects.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorReadingSharedObjects.Message", (String[])new String[]{this.delegates.tabs.makeTabName((EngineMetaInterface)jobMeta, true)}), e);
            }
            jobMeta.setRepositoryDirectory(this.getDefaultSaveLocation((RepositoryElementInterface)jobMeta));
            int nr = 1;
            jobMeta.setName(STRING_JOB + " " + nr);
            while (this.findJob(this.delegates.tabs.makeTabName((EngineMetaInterface)jobMeta, false)) != null) {
                jobMeta.setName(STRING_JOB + " " + ++nr);
            }
            jobMeta.clearChanged();
            this.addJobGraph(jobMeta);
            this.applyVariables();
            if (this.setDesignMode()) {
                this.refreshTree();
            }
            this.loadPerspective("001-spoon-jobs");
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorCreatingNewJob.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorCreatingNewJob.Message", (String[])new String[0]), e);
        }
    }

    public void setTransMetaVariables(TransMeta transMeta) {
        for (int i = 0; i < this.variables.size(); ++i) {
            try {
                String name = this.variables.getValueMeta(i).getName();
                String value = this.variables.getString(i, "");
                transMeta.setVariable(name, Const.NVL((String)value, (String)""));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setParametersAsVariablesInUI((NamedParams)transMeta, (VariableSpace)transMeta);
    }

    public void setJobMetaVariables(JobMeta jobMeta) {
        for (int i = 0; i < this.variables.size(); ++i) {
            try {
                String name = this.variables.getValueMeta(i).getName();
                String value = this.variables.getString(i, "");
                jobMeta.setVariable(name, Const.NVL((String)value, (String)""));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setParametersAsVariablesInUI((NamedParams)jobMeta, (VariableSpace)jobMeta);
    }

    public void loadRepositoryObjects(TransMeta transMeta) {
        if (this.rep != null) {
            try {
                SharedObjects sharedObjects = this.rep.readTransSharedObjects(transMeta);
                this.sharedObjectsFileMap.put(sharedObjects.getFilename(), sharedObjects);
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Error.UnableToLoadSharedObjects.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Error.UnableToLoadSharedObjects.Message", (String[])new String[0]), e);
            }
        }
    }

    public boolean quitFile(boolean canCancel) throws KettleException {
        if (log.isDetailed()) {
            log.logDetailed(BaseMessages.getString(PKG, (String)"Spoon.Log.QuitApplication", (String[])new String[0]));
        }
        boolean exit = true;
        this.saveSettings();
        if (this.props.showExitWarning() && canCancel) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"System.Warning", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"Spoon.Message.Warning.PromptExit", (String[])new String[0]), 4, new String[]{BaseMessages.getString(PKG, (String)"Spoon.Message.Warning.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Message.Warning.No", (String[])new String[0])}, 1, BaseMessages.getString(PKG, (String)"Spoon.Message.Warning.NotShowWarning", (String[])new String[0]), !this.props.showExitWarning());
            MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            int idx = md.open();
            this.props.setExitWarningShown(!md.getToggleState());
            this.props.saveProps();
            if ((idx & 0xFF) == 1) {
                return false;
            }
        }
        List<TabMapEntry> list = this.delegates.tabs.getTabs();
        for (TabMapEntry mapEntry : list) {
            TabItemInterface itemInterface = mapEntry.getObject();
            if (itemInterface.canBeClosed()) continue;
            this.tabfolder.setSelected(mapEntry.getTabItem());
            int reply = itemInterface.showChangedWarning();
            if (reply == 64) {
                exit = itemInterface.applyChanges();
                continue;
            }
            if (reply == 256) {
                return false;
            }
            exit = true;
        }
        if (exit || !canCancel) {
            for (TabMapEntry mapEntry : list) {
                TransGraph transGraph;
                TransMeta transMeta;
                if (mapEntry.getObject().canBeClosed()) continue;
                if (mapEntry.getObject() instanceof TransGraph && (transMeta = (TransMeta)mapEntry.getObject().getManagedObject()).hasChanged()) {
                    this.delegates.tabs.removeTab(mapEntry);
                }
                if (!(mapEntry.getObject() instanceof TransGraph) || !(transGraph = (TransGraph)mapEntry.getObject()).isRunning()) continue;
                transGraph.stop();
                this.delegates.tabs.removeTab(mapEntry);
            }
        }
        try {
            this.lifecycleSupport.onExit((LifeEventHandler)this);
        }
        catch (LifecycleException e) {
            MessageBox box = new MessageBox(this.shell, 33);
            box.setMessage(e.getMessage());
            box.open();
        }
        if (exit) {
            this.close();
        }
        return exit;
    }

    public boolean saveFile() {
        try {
            EngineMetaInterface meta = this.getActiveMeta();
            if (meta != null) {
                return this.saveToFile(meta);
            }
        }
        catch (Exception e) {
            KettleRepositoryLostException krle = KettleRepositoryLostException.lookupStackStrace((Throwable)e);
            if (krle != null) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.File.Save.Fail.Title", (String[])new String[0]), krle.getPrefaceMessage(), (Exception)((Object)krle));
                this.closeRepository();
            }
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.File.Save.Fail.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.File.Save.Fail.Message", (String[])new String[0]), e);
        }
        return false;
    }

    public boolean saveToFile(EngineMetaInterface meta) throws KettleException {
        SpoonPerspective activePerspective;
        if (meta == null) {
            return false;
        }
        boolean saved = false;
        if (meta instanceof TransMeta) {
            ((TransMeta)meta).setRepository(this.rep);
            ((TransMeta)meta).setMetaStore((IMetaStore)this.metaStore);
        }
        if (meta instanceof JobMeta) {
            ((JobMeta)meta).setRepository(this.rep);
            ((JobMeta)meta).setMetaStore((IMetaStore)this.metaStore);
        }
        if (log.isDetailed()) {
            log.logDetailed(BaseMessages.getString(PKG, (String)"Spoon.Log.SaveToFileOrRepository", (String[])new String[0]));
        }
        if ((activePerspective = SpoonPerspectiveManager.getInstance().getActivePerspective()) instanceof SpoonPerspectiveOpenSaveInterface) {
            return ((SpoonPerspectiveOpenSaveInterface)((Object)activePerspective)).save(meta);
        }
        String activePerspectiveId = activePerspective.getId();
        boolean etlPerspective = activePerspectiveId.equals("001-spoon-jobs");
        if (this.rep != null && etlPerspective) {
            saved = this.saveToRepository(meta);
        } else if (meta.getFilename() != null) {
            saved = this.save(meta, meta.getFilename(), false);
        } else if (meta.canSave()) {
            saved = this.saveFileAs(meta);
        }
        meta.saveSharedObjects();
        try {
            if (this.props.useDBCache() && meta instanceof TransMeta) {
                ((TransMeta)meta).getDbCache().saveCache();
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingDatabaseCache.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingDatabaseCache.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        this.delegates.tabs.renameTabs();
        this.refreshTree();
        this.enableMenus();
        return saved;
    }

    public boolean saveToRepository(EngineMetaInterface meta) throws KettleException {
        return this.saveToRepository(meta, meta.getObjectId() == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveToRepository(EngineMetaInterface meta, boolean ask_name) throws KettleException {
        if (meta.getFileType().equals("Trans") && RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.MODIFY_TRANSFORMATION)) {
            return false;
        }
        if (meta.getFileType().equals("Job") && RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.MODIFY_JOB)) {
            return false;
        }
        if (log.isDetailed()) {
            log.logDetailed(BaseMessages.getString(PKG, (String)"Spoon.Log.SaveToRepository", (String[])new String[0]));
        }
        if (this.rep != null) {
            boolean answer = true;
            boolean ask = ask_name;
            if (meta.getRepositoryDirectory() == null || meta.getRepositoryDirectory().isRoot()) {
                meta.setRepositoryDirectory(this.rep.getDefaultSaveDirectory((RepositoryElementInterface)meta));
            }
            while (answer && (ask || Const.isEmpty((String)meta.getName()))) {
                if (!ask) {
                    MessageBox mb = new MessageBox(this.shell, 40);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.PromptTransformationName.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.PromptTransformationName.Title", (String[])new String[0]));
                    mb.open();
                }
                ask = false;
                if (meta instanceof TransMeta) {
                    answer = TransGraph.editProperties((TransMeta)meta, this, this.rep, false);
                }
                if (!(meta instanceof JobMeta)) continue;
                answer = JobGraph.editProperties((JobMeta)meta, this, this.rep, false);
            }
            if (answer && !Const.isEmpty((String)meta.getName())) {
                int response = 64;
                ObjectId existingId = null;
                if (meta instanceof TransMeta) {
                    existingId = this.rep.getTransformationID(meta.getName(), meta.getRepositoryDirectory());
                }
                if (meta instanceof JobMeta) {
                    existingId = this.rep.getJobId(meta.getName(), meta.getRepositoryDirectory());
                }
                if ((meta.getObjectId() == null && existingId != null || existingId != null && !meta.getObjectId().equals(existingId)) && (!this.rep.getRepositoryMeta().getRepositoryCapabilities().supportsRevisions() || meta.getObjectId() == null)) {
                    MessageBox mb = new MessageBox(this.shell, 196);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.PromptOverwriteTransformation.Message", (String[])new String[]{meta.getName(), Const.CR}));
                    mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.PromptOverwriteTransformation.Title", (String[])new String[0]));
                    response = mb.open();
                }
                boolean saved = false;
                if (response == 64) {
                    if (meta.getObjectId() == null) {
                        meta.setObjectId(existingId);
                    }
                    try {
                        SaveProgressDialog spd;
                        boolean versionOk;
                        RepositorySecurityProvider repositorySecurityProvider;
                        this.shell.setCursor(this.cursor_hourglass);
                        if (meta.getCreatedDate() == null) {
                            meta.setCreatedDate(new Date());
                            if (this.capabilities.supportsUsers()) {
                                meta.setCreatedUser(this.rep.getUserInfo().getLogin());
                            }
                        }
                        meta.setModifiedDate(new Date());
                        if (this.capabilities.supportsUsers()) {
                            meta.setModifiedUser(this.rep.getUserInfo().getLogin());
                        }
                        boolean versioningEnabled = true;
                        boolean versionCommentsEnabled = true;
                        RepositorySecurityProvider repositorySecurityProvider2 = repositorySecurityProvider = this.rep != null && this.rep.getSecurityProvider() != null ? this.rep.getSecurityProvider() : null;
                        if (repositorySecurityProvider != null) {
                            versioningEnabled = repositorySecurityProvider.isVersioningEnabled();
                            versionCommentsEnabled = repositorySecurityProvider.allowsVersionComments();
                        }
                        String versionComment = null;
                        if (!versioningEnabled || !versionCommentsEnabled) {
                            versionOk = true;
                            versionComment = "";
                        } else {
                            versionOk = false;
                        }
                        while (!versionOk) {
                            versionComment = RepositorySecurityUI.getVersionComment(this.shell, this.rep, meta.getName());
                            if (this.rep != null && this.rep.getSecurityProvider() != null && this.rep.getSecurityProvider().allowsVersionComments() && versionComment == null) {
                                boolean bl = false;
                                return bl;
                            }
                            if (Const.isEmpty((String)versionComment) && this.rep.getSecurityProvider().isVersionCommentMandatory()) {
                                if (RepositorySecurityUI.showVersionCommentMandatoryDialog(this.shell)) continue;
                                boolean bl = false;
                                return bl;
                            }
                            versionOk = true;
                        }
                        if (versionOk && (spd = new SaveProgressDialog(this.shell, this.rep, meta, versionComment)).open()) {
                            saved = true;
                            if (!this.props.getSaveConfirmation()) {
                                MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Message.Warning.SaveOK", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"Spoon.Message.Warning.TransformationWasStored", (String[])new String[0]), 3, new String[]{BaseMessages.getString(PKG, (String)"Spoon.Message.Warning.OK", (String[])new String[0])}, 0, BaseMessages.getString(PKG, (String)"Spoon.Message.Warning.NotShowThisMessage", (String[])new String[0]), this.props.getSaveConfirmation());
                                MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
                                md.open();
                                this.props.setSaveConfirmation(md.getToggleState());
                            }
                            this.props.addLastFile(meta.getFileType(), meta.getName(), meta.getRepositoryDirectory().getPath(), true, this.getRepositoryName());
                            this.saveSettings();
                            this.addMenuLast();
                            this.setShellText();
                        }
                    }
                    finally {
                        this.shell.setCursor(null);
                    }
                }
                return saved;
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.NoRepositoryConnection.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.NoRepositoryConnection.Title", (String[])new String[0]));
            mb.open();
        }
        return false;
    }

    public boolean saveJobRepository(JobMeta jobMeta) throws KettleException {
        return this.saveToRepository((EngineMetaInterface)jobMeta, false);
    }

    public boolean saveJobRepository(JobMeta jobMeta, boolean ask_name) throws KettleException {
        return this.saveToRepository((EngineMetaInterface)jobMeta, ask_name);
    }

    public boolean saveFileAs() throws KettleException {
        try {
            EngineMetaInterface meta = this.getActiveMeta();
            if (meta != null && meta.canSave()) {
                return this.saveFileAs(meta);
            }
        }
        catch (Exception e) {
            KettleRepositoryLostException krle = KettleRepositoryLostException.lookupStackStrace((Throwable)e);
            if (krle != null) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.File.Save.Fail.Title", (String[])new String[0]), krle.getPrefaceMessage(), (Exception)((Object)krle));
                this.closeRepository();
            }
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.File.Save.Fail.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.File.Save.Fail.Message", (String[])new String[0]), e);
        }
        return false;
    }

    public boolean saveFileAs(EngineMetaInterface meta) throws KettleException {
        boolean saved;
        if (log.isBasic()) {
            log.logBasic(BaseMessages.getString(PKG, (String)"Spoon.Log.SaveAs", (String[])new String[0]));
        }
        String activePerspectiveId = SpoonPerspectiveManager.getInstance().getActivePerspective().getId();
        boolean etlPerspective = activePerspectiveId.equals("001-spoon-jobs");
        if (this.rep != null && etlPerspective) {
            meta.setObjectId(null);
            saved = this.saveToRepository(meta, true);
        } else {
            saved = this.saveXMLFile(meta, false);
        }
        this.delegates.tabs.renameTabs();
        this.refreshTree();
        if (saved && (meta instanceof TransMeta || meta instanceof JobMeta)) {
            TabMapEntry tabEntry = this.delegates.tabs.findTabMapEntry(meta);
            TabItem tabItem = tabEntry.getTabItem();
            if (meta.getFileType().equals("Trans")) {
                tabItem.setImage(GUIResource.getInstance().getImageTransGraph());
            } else if (meta.getFileType().equals("Job")) {
                tabItem.setImage(GUIResource.getInstance().getImageJobGraph());
            }
        }
        this.enableMenus();
        return saved;
    }

    public boolean exportXMLFile() {
        return this.saveXMLFile(true);
    }

    public void exportAllXMLFile() {
        TransMeta resourceExportInterface = this.getActiveTransformation();
        if (resourceExportInterface == null) {
            resourceExportInterface = this.getActiveJob();
        }
        if (resourceExportInterface == null) {
            return;
        }
        try {
            String zipFilename = null;
            while (Const.isEmpty(zipFilename)) {
                FileDialog dialog = new FileDialog(this.shell, 8192);
                dialog.setText(BaseMessages.getString(PKG, (String)"Spoon.ExportResourceSelectZipFile", (String[])new String[0]));
                dialog.setFilterExtensions(new String[]{"*.zip;*.ZIP", "*"});
                dialog.setFilterNames(new String[]{BaseMessages.getString(PKG, (String)"System.FileType.ZIPFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                this.setFilterPath(dialog);
                if (dialog.open() != null) {
                    this.lastDirOpened = dialog.getFilterPath();
                    zipFilename = dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName();
                    FileObject zipFileObject = KettleVFS.getFileObject((String)zipFilename);
                    if (!zipFileObject.exists()) continue;
                    MessageBox box = new MessageBox(this.shell, 448);
                    box.setMessage(BaseMessages.getString(PKG, (String)"Spoon.ExportResourceZipFileExists.Message", (String[])new String[]{zipFilename}));
                    box.setText(BaseMessages.getString(PKG, (String)"Spoon.ExportResourceZipFileExists.Title", (String[])new String[0]));
                    int answer = box.open();
                    if (answer == 256) {
                        return;
                    }
                    if (answer != 128) continue;
                    zipFilename = null;
                    continue;
                }
                return;
            }
            TopLevelResource topLevelResource = ResourceUtil.serializeResourceExportInterface(zipFilename, (ResourceExportInterface)resourceExportInterface, (VariableSpace)((VariableSpace)resourceExportInterface), (Repository)this.rep, (IMetaStore)this.metaStore);
            String message = ResourceUtil.getExplanation(zipFilename, (String)topLevelResource.getResourceName(), (ResourceExportInterface)resourceExportInterface);
            EnterTextDialog enterTextDialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ResourceSerialized", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ResourceSerializedSuccesfully", (String[])new String[0]), message);
            enterTextDialog.setReadOnly();
            enterTextDialog.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorExportingFile", (String[])new String[0]), e);
        }
    }

    public void exportAllFileRepository() {
        TransMeta resourceExportInterface = this.getActiveTransformation();
        if (resourceExportInterface == null) {
            resourceExportInterface = this.getActiveJob();
        }
        if (resourceExportInterface == null) {
            return;
        }
        try {
            String zipFilename = null;
            while (Const.isEmpty(zipFilename)) {
                FileDialog dialog = new FileDialog(this.shell, 8192);
                dialog.setText(BaseMessages.getString(PKG, (String)"Spoon.ExportResourceSelectZipFile", (String[])new String[0]));
                dialog.setFilterExtensions(new String[]{"*.zip;*.ZIP", "*"});
                dialog.setFilterNames(new String[]{BaseMessages.getString(PKG, (String)"System.FileType.ZIPFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                this.setFilterPath(dialog);
                if (dialog.open() != null) {
                    this.lastDirOpened = dialog.getFilterPath();
                    zipFilename = dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName();
                    FileObject zipFileObject = KettleVFS.getFileObject((String)zipFilename);
                    if (!zipFileObject.exists()) continue;
                    MessageBox box = new MessageBox(this.shell, 448);
                    box.setMessage(BaseMessages.getString(PKG, (String)"Spoon.ExportResourceZipFileExists.Message", (String[])new String[]{zipFilename}));
                    box.setText(BaseMessages.getString(PKG, (String)"Spoon.ExportResourceZipFileExists.Title", (String[])new String[0]));
                    int answer = box.open();
                    if (answer == 256) {
                        return;
                    }
                    if (answer != 128) continue;
                    zipFilename = null;
                    continue;
                }
                return;
            }
            TopLevelResource topLevelResource = ResourceUtil.serializeResourceExportInterface(zipFilename, (ResourceExportInterface)resourceExportInterface, (VariableSpace)((VariableSpace)resourceExportInterface), (Repository)this.rep, (IMetaStore)this.metaStore);
            String message = ResourceUtil.getExplanation(zipFilename, (String)topLevelResource.getResourceName(), (ResourceExportInterface)resourceExportInterface);
            EnterTextDialog enterTextDialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ResourceSerialized", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ResourceSerializedSuccesfully", (String[])new String[0]), message);
            enterTextDialog.setReadOnly();
            enterTextDialog.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorExportingFile", (String[])new String[0]), e);
        }
    }

    public void exportRepositoryAll() {
        this.exportRepositoryDirectory(null);
    }

    public boolean exportRepositoryDirectory(RepositoryDirectory directoryToExport) {
        ImportRulesDialog importRulesDialog;
        int answer;
        FileDialog dialog = this.getExportFileDialog();
        if (dialog.open() == null) {
            return false;
        }
        String filename = dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName();
        log.logBasic(BaseMessages.getString(PKG, (String)"Spoon.Log.Exporting", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"Spoon.Log.ExportObjectsToFile", (String[])new String[]{filename})});
        MessageBox box = RepositoryExportProgressDialog.checkIsFileIsAcceptable(this.shell, log, filename);
        int n = answer = box == null ? 32 : box.open();
        if (answer != 32) {
            return false;
        }
        box = new MessageBox(this.shell, 268501444);
        box.setText(BaseMessages.getString(PKG, (String)"Spoon.QuestionApplyImportRulesToExport.Title", (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)"Spoon.QuestionApplyImportRulesToExport.Message", (String[])new String[0]));
        answer = box.open();
        if (answer == 256) {
            return false;
        }
        ImportRules importRules = new ImportRules();
        if (answer == 64 && !(importRulesDialog = new ImportRulesDialog(this.shell, importRules)).open()) {
            return false;
        }
        RepositoryExportProgressDialog repd = new RepositoryExportProgressDialog(this.shell, this.rep, (RepositoryDirectoryInterface)directoryToExport, filename, importRules);
        repd.open();
        return true;
    }

    public FileDialog getExportFileDialog() {
        FileDialog dialog = new FileDialog(this.shell, 8196);
        dialog.setText(BaseMessages.getString(PKG, (String)"Spoon.SelectAnXMLFileToExportTo.Message", (String[])new String[0]));
        return dialog;
    }

    public void importDirectoryToRepository() {
        ImportRulesDialog importRulesDialog;
        FileDialog dialog = new FileDialog(this.shell, 4098);
        dialog.setText(BaseMessages.getString(PKG, (String)"Spoon.SelectAnXMLFileToImportFrom.Message", (String[])new String[0]));
        if (dialog.open() == null) {
            return;
        }
        MessageBox box = new MessageBox(this.shell, 268501444);
        box.setText(BaseMessages.getString(PKG, (String)"Spoon.QuestionApplyImportRules.Title", (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)"Spoon.QuestionApplyImportRules.Message", (String[])new String[0]));
        int answer = box.open();
        if (answer == 256) {
            return;
        }
        ImportRules importRules = new ImportRules();
        if (answer == 64 && !(importRulesDialog = new ImportRulesDialog(this.shell, importRules)).open()) {
            return;
        }
        SelectDirectoryDialog sdd = new SelectDirectoryDialog(this.shell, 0, this.rep);
        RepositoryDirectoryInterface baseDirectory = sdd.open();
        if (baseDirectory == null) {
            return;
        }
        String versionComment = null;
        boolean versionOk = false;
        while (!versionOk) {
            versionComment = RepositorySecurityUI.getVersionComment(this.shell, this.rep, "Import of files into [" + baseDirectory.getPath() + "]");
            if (this.rep != null && this.rep.getSecurityProvider() != null && this.rep.getSecurityProvider().allowsVersionComments() && versionComment == null) {
                return;
            }
            if (Const.isEmpty((String)versionComment) && this.rep.getSecurityProvider().isVersionCommentMandatory()) {
                if (RepositorySecurityUI.showVersionCommentMandatoryDialog(this.shell)) continue;
                versionOk = true;
                continue;
            }
            versionOk = true;
        }
        String[] filenames = dialog.getFileNames();
        if (filenames.length > 0) {
            RepositoryImportProgressDialog ripd = new RepositoryImportProgressDialog(this.shell, 0, this.rep, dialog.getFilterPath(), filenames, baseDirectory, versionComment, importRules);
            ripd.open();
            this.refreshTree();
        }
    }

    public boolean saveXMLFile(boolean export) {
        TransMeta transMeta = this.getActiveTransformation();
        if (transMeta != null) {
            return this.saveXMLFile((EngineMetaInterface)transMeta, export);
        }
        JobMeta jobMeta = this.getActiveJob();
        if (jobMeta != null) {
            return this.saveXMLFile((EngineMetaInterface)jobMeta, export);
        }
        return false;
    }

    public boolean saveXMLFile(EngineMetaInterface meta, boolean export) {
        if (log.isBasic()) {
            log.logBasic("Save file as...");
        }
        boolean saved = false;
        String beforeFilename = meta.getFilename();
        String beforeName = meta.getName();
        FileDialog dialog = new FileDialog(this.shell, 8192);
        String[] extensions = meta.getFilterExtensions();
        dialog.setFilterExtensions(extensions);
        dialog.setFilterNames(meta.getFilterNames());
        this.setFilterPath(dialog);
        String filename = dialog.open();
        if (filename != null) {
            this.lastDirOpened = dialog.getFilterPath();
            boolean ending = false;
            for (int i = 0; i < extensions.length - 1; ++i) {
                String[] parts;
                for (String part : parts = extensions[i].split(";")) {
                    if (!filename.toLowerCase().endsWith(part.substring(1).toLowerCase())) continue;
                    ending = true;
                }
            }
            if (filename.endsWith(meta.getDefaultExtension())) {
                ending = true;
            }
            if (!ending) {
                if (!meta.getDefaultExtension().startsWith(".") && !filename.endsWith(".")) {
                    filename = filename + ".";
                }
                filename = filename + meta.getDefaultExtension();
            }
            int id = 64;
            try {
                FileObject f = KettleVFS.getFileObject((String)filename);
                if (f.exists()) {
                    MessageBox mb = new MessageBox(this.shell, 200);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.PromptOverwriteFile.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.PromptOverwriteFile.Title", (String[])new String[0]));
                    id = mb.open();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (id == 64) {
                if (!(export || Const.isEmpty((String)beforeFilename) || beforeFilename.equals(filename))) {
                    meta.setName(Const.createName((String)filename));
                    meta.setFilename(filename);
                    if (!this.editProperties()) {
                        meta.setFilename(beforeFilename);
                        meta.setName(beforeName);
                        return saved;
                    }
                }
                if (!(saved = this.save(meta, filename, export))) {
                    meta.setFilename(beforeFilename);
                    meta.setName(beforeName);
                }
            }
        }
        return saved;
    }

    public boolean saveXMLFileToVfs() {
        TransMeta transMeta = this.getActiveTransformation();
        if (transMeta != null) {
            return this.saveXMLFileToVfs((EngineMetaInterface)transMeta);
        }
        JobMeta jobMeta = this.getActiveJob();
        if (jobMeta != null) {
            return this.saveXMLFileToVfs((EngineMetaInterface)jobMeta);
        }
        return false;
    }

    public boolean saveXMLFileToVfs(EngineMetaInterface meta) {
        FileObject rootFile;
        FileObject initialFile;
        if (log.isBasic()) {
            log.logBasic("Save file as...");
        }
        try {
            initialFile = KettleVFS.getFileObject((String)this.getLastFileOpened());
            rootFile = KettleVFS.getFileObject((String)this.getLastFileOpened()).getFileSystem().getRoot();
        }
        catch (Exception e) {
            MessageBox messageDialog = new MessageBox(this.shell, 33);
            messageDialog.setText("Error");
            messageDialog.setMessage(e.getMessage());
            messageDialog.open();
            return false;
        }
        String filename = null;
        FileObject selectedFile = this.getVfsFileChooserDialog(rootFile, initialFile).open(this.shell, "Untitled", Const.STRING_TRANS_AND_JOB_FILTER_EXT, Const.getTransformationAndJobFilterNames(), 3);
        if (selectedFile != null) {
            filename = selectedFile.getName().getFriendlyURI();
        }
        String[] extensions = meta.getFilterExtensions();
        if (filename != null) {
            boolean ending = false;
            for (int i = 0; i < extensions.length - 1; ++i) {
                if (!filename.endsWith(extensions[i].substring(1))) continue;
                ending = true;
            }
            if (filename.endsWith(meta.getDefaultExtension())) {
                ending = true;
            }
            if (!ending) {
                filename = filename + '.' + meta.getDefaultExtension();
            }
            int id = 64;
            try {
                FileObject f = KettleVFS.getFileObject((String)filename);
                if (f.exists()) {
                    MessageBox mb = new MessageBox(this.shell, 200);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.PromptOverwriteFile.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.PromptOverwriteFile.Title", (String[])new String[0]));
                    id = mb.open();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (id == 64) {
                this.save(meta, filename, false);
            }
        }
        return false;
    }

    public boolean save(EngineMetaInterface meta, String filename, boolean export) {
        Pattern pattern;
        Matcher matcher;
        boolean isNotTransOrJob;
        boolean saved = false;
        boolean bl = isNotTransOrJob = !"Trans".equals(meta.getFileType()) && !"Job".equals(meta.getFileType());
        if (isNotTransOrJob && !(matcher = (pattern = Pattern.compile("\\p{ASCII}+")).matcher(filename)).matches()) {
            MessageBox box = new MessageBox(Spoon.staticSpoon.shell, 33);
            box.setMessage("Special characters are not allowed in the filename. Please use ASCII characters only");
            box.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingConnection.Title", (String[])new String[0]));
            box.open();
            return false;
        }
        FileListener listener = null;
        int idx = filename.lastIndexOf(46);
        if (idx != -1) {
            String extension = filename.substring(idx + 1);
            listener = this.fileExtensionMap.get(extension);
        }
        if (listener == null) {
            String xt = meta.getDefaultExtension();
            listener = this.fileExtensionMap.get(xt);
        }
        if (listener != null) {
            String sync = BasePropertyHandler.getProperty((String)SYNC_TRANS);
            if (Boolean.parseBoolean(sync)) {
                listener.syncMetaName(meta, Const.createName((String)filename));
                this.delegates.tabs.renameTabs();
            }
            saved = listener.save(meta, filename, export);
        }
        return saved;
    }

    public boolean saveMeta(EngineMetaInterface meta, String filename) {
        meta.setFilename(filename);
        if (Const.isEmpty((String)meta.getName()) || this.delegates.jobs.isDefaultJobName(meta.getName()) || this.delegates.trans.isDefaultTransformationName(meta.getName())) {
            meta.nameFromFilename();
        }
        boolean saved = false;
        try {
            String xml = XMLHandler.getXMLHeader() + meta.getXML();
            DataOutputStream dos = new DataOutputStream(KettleVFS.getOutputStream((String)filename, (boolean)false));
            dos.write(xml.getBytes("UTF-8"));
            dos.close();
            saved = true;
            this.props.addLastFile(meta.getFileType(), filename, null, false, null);
            this.saveSettings();
            this.addMenuLast();
            if (log.isDebug()) {
                log.logDebug(BaseMessages.getString(PKG, (String)"Spoon.Log.FileWritten", (String[])new String[0]) + " [" + filename + "]");
            }
            meta.setFilename(filename);
            meta.clearChanged();
            this.setShellText();
        }
        catch (Exception e) {
            if (log.isDebug()) {
                log.logDebug(BaseMessages.getString(PKG, (String)"Spoon.Log.ErrorOpeningFileForWriting", (String[])new String[0]) + e.toString());
            }
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingFile.Message", (String[])new String[0]) + Const.CR + e.toString(), e);
        }
        return saved;
    }

    public void helpAbout() {
        MessageBox mb = new MessageBox(this.shell, 0x11000022);
        String releaseText = Const.RELEASE.getMessage();
        StringBuilder messageBuilder = new StringBuilder();
        BuildVersion buildVersion = BuildVersion.getInstance();
        String buildVersionInfo = buildVersion.getVersion();
        if (Const.isEmpty((String)buildVersionInfo)) {
            buildVersionInfo = "Unknown";
        }
        String releaseInfo = "";
        String buildStatus = "";
        messageBuilder.append(BaseMessages.getString(PKG, (String)"System.ProductInfo", (String[])new String[0]));
        messageBuilder.append(releaseText);
        messageBuilder.append(" - ");
        String containingChecksumRegex = ".+\\b([a-f0-9]{40})\\b";
        if (!buildVersionInfo.matches(containingChecksumRegex)) {
            releaseInfo = buildVersionInfo;
        } else {
            for (String currentElement : buildVersionInfo.split("\\.")) {
                if (currentElement.length() != 40) {
                    releaseInfo = releaseInfo + currentElement + ".";
                    continue;
                }
                buildStatus = currentElement;
            }
            releaseInfo = new String(releaseInfo.substring(0, releaseInfo.length() - 1));
        }
        messageBuilder.append(releaseInfo);
        messageBuilder.append(Const.CR);
        messageBuilder.append(Const.CR);
        messageBuilder.append(Const.CR);
        messageBuilder.append(BaseMessages.getString(PKG, (String)"System.CompanyInfo", (String[])new String[]{"" + (new Date().getYear() + 1900)}));
        messageBuilder.append(Const.CR);
        messageBuilder.append(BaseMessages.getString(PKG, (String)"System.ProductWebsiteUrl", (String[])new String[0]));
        messageBuilder.append(Const.CR);
        messageBuilder.append(Const.CR);
        messageBuilder.append(Const.CR);
        messageBuilder.append("Build version : ");
        messageBuilder.append(releaseInfo);
        if (!buildStatus.isEmpty()) {
            messageBuilder.append(Const.CR);
            messageBuilder.append("Commit ID : ");
            messageBuilder.append(buildStatus);
        }
        messageBuilder.append(Const.CR);
        messageBuilder.append("Build date : ");
        String inputStringDate = buildVersion.getBuildDate();
        String outputStringDate = "";
        SimpleDateFormat inputFormat = null;
        SimpleDateFormat otputFormat = null;
        if (inputStringDate.matches("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}.\\d{3}$")) {
            inputFormat = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss.SSS");
        }
        if (inputStringDate.matches("^\\d{4}-\\d{1,2}-\\d{1,2}\\_\\d{1,2}-\\d{2}-\\d{2}$")) {
            inputFormat = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss");
        }
        if (inputStringDate.matches("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}.\\d{2}.\\d{2}$")) {
            inputFormat = new SimpleDateFormat("yyyy-MM-dd hh.mm.ss");
        }
        otputFormat = new SimpleDateFormat("MMMM d, yyyy hh:mm:ss");
        try {
            if (inputFormat != null) {
                Date date = inputFormat.parse(inputStringDate);
                outputStringDate = otputFormat.format(date);
            } else {
                outputStringDate = inputStringDate;
            }
        }
        catch (ParseException e) {
            outputStringDate = inputStringDate;
        }
        messageBuilder.append(outputStringDate);
        mb.setMessage(messageBuilder.toString());
        mb.setText(APP_NAME);
        mb.open();
    }

    public void showPluginInfo() {
        try {
            HashMap<String, RowMetaInterface> metaMap = new HashMap<String, RowMetaInterface>();
            HashMap<String, List<Object[]>> dataMap = new HashMap<String, List<Object[]>>();
            PluginRegistry registry = PluginRegistry.getInstance();
            List pluginTypeClasses = registry.getPluginTypes();
            for (Class pluginTypeClass : pluginTypeClasses) {
                PluginTypeInterface pluginTypeInterface = registry.getPluginType(pluginTypeClass);
                String subject = pluginTypeInterface.getName();
                RowBuffer pluginInformation = registry.getPluginInformation(pluginTypeClass);
                metaMap.put(subject, pluginInformation.getRowMeta());
                dataMap.put(subject, pluginInformation.getBuffer());
            }
            SubjectDataBrowserDialog dialog = new SubjectDataBrowserDialog(this.shell, metaMap, dataMap, "Plugin browser", "Plugin type");
            dialog.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error listing plugins", e);
        }
    }

    public void editUnselectAll() {
        JobMeta jobMeta;
        TransMeta transMeta = this.getActiveTransformation();
        if (transMeta != null) {
            transMeta.unselectAll();
            this.getActiveTransGraph().redraw();
        }
        if ((jobMeta = this.getActiveJob()) != null) {
            jobMeta.unselectAll();
            this.getActiveJobGraph().redraw();
        }
    }

    public void editSelectAll() {
        JobMeta jobMeta;
        TransMeta transMeta = this.getActiveTransformation();
        if (transMeta != null) {
            transMeta.selectAll();
            this.getActiveTransGraph().redraw();
        }
        if ((jobMeta = this.getActiveJob()) != null) {
            jobMeta.selectAll();
            this.getActiveJobGraph().redraw();
        }
    }

    public void editOptions() {
        EnterOptionsDialog eod = new EnterOptionsDialog(this.shell);
        if (eod.open() != null) {
            this.props.saveProps();
            this.loadSettings();
            this.changeLooks();
            MessageBox mb = new MessageBox(this.shell, 2);
            mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.PleaseRestartApplication.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.PleaseRestartApplication.Title", (String[])new String[0]));
            mb.open();
        }
    }

    public void editKettlePropertiesFile() {
        KettlePropertiesFileDialog dialog = new KettlePropertiesFileDialog(this.shell, 0);
        Map<String, String> newProperties = dialog.open();
        if (newProperties != null) {
            for (String name : newProperties.keySet()) {
                String value = newProperties.get(name);
                this.applyVariableToAllLoadedObjects(name, value);
                System.setProperty(name, value);
            }
        }
    }

    @VisibleForTesting
    boolean filterMatch(String string) {
        if (Const.isEmpty((String)string)) {
            return true;
        }
        String filter = this.selectionFilter.getText();
        if (Const.isEmpty((String)filter)) {
            return true;
        }
        try {
            if (string.matches(filter)) {
                return true;
            }
        }
        catch (Exception e) {
            log.logError("Not a valid pattern [" + filter + "] : " + e.getMessage());
        }
        return string.toUpperCase().contains(filter.toUpperCase());
    }

    private void createSelectionTree() {
        this.selectionTree = new Tree(this.variableComposite, 4);
        this.props.setLook((Control)this.selectionTree);
        this.selectionTree.setLayout((Layout)new FillLayout());
        this.addDefaultKeyListeners((Control)this.selectionTree);
        TreeMemory.addTreeListener(this.selectionTree, STRING_SPOON_MAIN_TREE);
        this.selectionTree.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                Spoon.this.setMenu(Spoon.this.selectionTree);
            }
        });
        this.selectionTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Spoon.this.showSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Spoon.this.doubleClickedInTree(Spoon.this.selectionTree);
            }
        });
        this.addDragSourceToTree(this.selectionTree);
    }

    public void refreshTree() {
        String name;
        Object managedObject;
        if (this.shell.isDisposed() || !this.viewSelected) {
            return;
        }
        if (this.selectionTree == null || this.selectionTree.isDisposed()) {
            this.createSelectionTree();
        }
        GUIResource guiResource = GUIResource.getInstance();
        TransMeta activeTransMeta = this.getActiveTransformation();
        JobMeta activeJobMeta = this.getActiveJob();
        boolean showAll = activeTransMeta == null && activeJobMeta == null;
        this.selectionTree.removeAll();
        if (!this.props.isOnlyActiveFileShownInTree() || showAll || activeTransMeta != null) {
            TreeItem tiTrans = new TreeItem(this.selectionTree, 0);
            tiTrans.setText(STRING_TRANSFORMATIONS);
            tiTrans.setImage(GUIResource.getInstance().getImageBol());
            if (this.props.isOnlyActiveFileShownInTree()) {
                TreeMemory.getInstance().storeExpanded(STRING_SPOON_MAIN_TREE, tiTrans, true);
            }
            for (TabMapEntry entry : this.delegates.tabs.getTabs()) {
                managedObject = entry.getObject().getManagedObject();
                if (!(managedObject instanceof TransMeta)) continue;
                TransMeta transMeta = (TransMeta)managedObject;
                if (this.props.isOnlyActiveFileShownInTree() && !showAll && (activeTransMeta == null || !activeTransMeta.equals((Object)transMeta))) continue;
                name = this.delegates.tabs.makeTabName((EngineMetaInterface)transMeta, entry.isShowingLocation());
                if (Const.isEmpty((String)name)) {
                    name = STRING_TRANS_NO_NAME;
                }
                TreeItem tiTransName = this.createTreeItem(tiTrans, name, guiResource.getImageTransGraph());
                if (this.props.isOnlyActiveFileShownInTree()) {
                    TreeMemory.getInstance().storeExpanded(STRING_SPOON_MAIN_TREE, tiTransName, true);
                }
                this.refreshDbConnectionsSubtree(tiTransName, (AbstractMeta)transMeta, guiResource);
                this.refreshStepsSubtree(tiTransName, transMeta, guiResource);
                this.refreshHopsSubtree(tiTransName, transMeta, guiResource);
                this.refreshPartitionsSubtree(tiTransName, transMeta, guiResource);
                this.refreshSlavesSubtree(tiTransName, (AbstractMeta)transMeta, guiResource);
                this.refreshClustersSubtree(tiTransName, transMeta, guiResource);
                this.refreshNamedClusterSubtree(tiTransName, (AbstractMeta)transMeta, guiResource);
            }
        }
        if (!this.props.isOnlyActiveFileShownInTree() || showAll || activeJobMeta != null) {
            TreeItem tiJobs = new TreeItem(this.selectionTree, 0);
            tiJobs.setText(STRING_JOBS);
            tiJobs.setImage(GUIResource.getInstance().getImageBol());
            if (this.props.isOnlyActiveFileShownInTree()) {
                tiJobs.setExpanded(true);
                TreeMemory.getInstance().storeExpanded(STRING_SPOON_MAIN_TREE, tiJobs, true);
            }
            for (TabMapEntry entry : this.delegates.tabs.getTabs()) {
                managedObject = entry.getObject().getManagedObject();
                if (!(managedObject instanceof JobMeta)) continue;
                JobMeta jobMeta = (JobMeta)managedObject;
                if (this.props.isOnlyActiveFileShownInTree() && !showAll && (activeJobMeta == null || !activeJobMeta.equals((Object)jobMeta))) continue;
                name = this.delegates.tabs.makeTabName((EngineMetaInterface)jobMeta, entry.isShowingLocation());
                if (Const.isEmpty((String)name)) {
                    name = STRING_JOB_NO_NAME;
                }
                if (!this.filterMatch(name)) continue;
                TreeItem tiJobName = this.createTreeItem(tiJobs, name, guiResource.getImageJobGraph());
                if (this.props.isOnlyActiveFileShownInTree()) {
                    TreeMemory.getInstance().storeExpanded(STRING_SPOON_MAIN_TREE, tiJobName, true);
                }
                this.refreshDbConnectionsSubtree(tiJobName, (AbstractMeta)jobMeta, guiResource);
                this.refreshJobEntriesSubtree(tiJobName, jobMeta, guiResource);
                this.refreshNamedClusterSubtree(tiJobName, (AbstractMeta)jobMeta, guiResource);
                this.refreshSlavesSubtree(tiJobName, (AbstractMeta)jobMeta, guiResource);
            }
        }
        TreeMemory.setExpandedFromMemory(this.selectionTree, STRING_SPOON_MAIN_TREE);
        this.selectionTree.setFocus();
        this.selectionTree.layout();
        this.variableComposite.layout(true, true);
        this.setShellText();
    }

    private String[] pickupDbConnections(AbstractMeta transMeta) throws KettleException {
        return this.rep == null ? transMeta.getDatabaseNames() : this.rep.getDatabaseNames(false);
    }

    private DatabaseMeta findDatabase(List<? extends DatabaseMeta> dbs, String dbName) {
        for (DatabaseMeta databaseMeta : dbs) {
            if (!databaseMeta.getName().equalsIgnoreCase(dbName) && !databaseMeta.getDisplayName().equalsIgnoreCase(dbName)) continue;
            return databaseMeta;
        }
        return null;
    }

    @VisibleForTesting
    TreeItem createTreeItem(TreeItem parent, String text, Image image) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(text);
        item.setImage(image);
        return item;
    }

    @VisibleForTesting
    void refreshDbConnectionsSubtree(TreeItem tiRootName, AbstractMeta meta, GUIResource guiResource) {
        List dbs;
        String[] dbNames;
        TreeItem tiDbTitle = this.createTreeItem(tiRootName, STRING_CONNECTIONS, guiResource.getImageBol());
        try {
            dbNames = this.pickupDbConnections(meta);
            if (dbNames.length == 0) {
                return;
            }
            if (this.rep == null) {
                dbs = meta.getDatabases();
            } else {
                dbs = this.rep.readDatabases();
                for (int i = 0; i < dbNames.length; ++i) {
                    String dbName = dbNames[i];
                    ((DatabaseMeta)dbs.get(i)).setName(dbName);
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorFetchingFromRepo.DbConnections", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        Arrays.sort(dbNames, String.CASE_INSENSITIVE_ORDER);
        for (String dbName : dbNames) {
            if (!this.filterMatch(dbName)) continue;
            DatabaseMeta databaseMeta = meta.findDatabase(dbName);
            if (databaseMeta == null) {
                databaseMeta = this.findDatabase(dbs, dbName);
            }
            TreeItem tiDb = this.createTreeItem(tiDbTitle, databaseMeta.getDisplayName(), guiResource.getImageConnection());
            if (!databaseMeta.isShared()) continue;
            tiDb.setFont(guiResource.getFontBold());
        }
    }

    private void refreshStepsSubtree(TreeItem tiRootName, TransMeta meta, GUIResource guiResource) {
        TreeItem tiStepTitle = this.createTreeItem(tiRootName, STRING_STEPS, guiResource.getImageBol());
        for (int i = 0; i < meta.nrSteps(); ++i) {
            StepMeta stepMeta = meta.getStep(i);
            PluginInterface stepPlugin = PluginRegistry.getInstance().findPluginWithId(StepPluginType.class, stepMeta.getStepID());
            if (!this.filterMatch(stepMeta.getName())) continue;
            Image stepIcon = guiResource.getImagesStepsSmall().get(stepPlugin.getIds()[0]);
            if (stepIcon == null) {
                stepIcon = guiResource.getImageBol();
            }
            TreeItem tiStep = this.createTreeItem(tiStepTitle, stepMeta.getName(), stepIcon);
            if (stepMeta.isShared()) {
                tiStep.setFont(guiResource.getFontBold());
            }
            if (stepMeta.isDrawn()) continue;
            tiStep.setForeground(guiResource.getColorDarkGray());
        }
    }

    @VisibleForTesting
    void refreshHopsSubtree(TreeItem tiTransName, TransMeta transMeta, GUIResource guiResource) {
        TreeItem tiHopTitle = this.createTreeItem(tiTransName, STRING_HOPS, guiResource.getImageBol());
        for (int i = 0; i < transMeta.nrTransHops(); ++i) {
            TransHopMeta hopMeta = transMeta.getTransHop(i);
            if (!this.filterMatch(hopMeta.toString())) continue;
            Image icon = hopMeta.isEnabled() ? guiResource.getImageHop() : guiResource.getImageDisabledHop();
            this.createTreeItem(tiHopTitle, hopMeta.toString(), icon);
        }
    }

    @Override
    public List<String> getPartitionSchemasNames(TransMeta transMeta) throws KettleException {
        return Arrays.asList(this.pickupPartitionSchemaNames(transMeta));
    }

    private String[] pickupPartitionSchemaNames(TransMeta transMeta) throws KettleException {
        return this.rep == null ? transMeta.getPartitionSchemasNames() : this.rep.getPartitionSchemaNames(false);
    }

    @Override
    public List<PartitionSchema> getPartitionSchemas(TransMeta transMeta) throws KettleException {
        return this.pickupPartitionSchemas(transMeta);
    }

    private List<PartitionSchema> pickupPartitionSchemas(TransMeta transMeta) throws KettleException {
        if (this.rep != null) {
            ObjectId[] ids = this.rep.getPartitionSchemaIDs(false);
            ArrayList<PartitionSchema> result = new ArrayList<PartitionSchema>(ids.length);
            for (ObjectId id : ids) {
                PartitionSchema schema = this.rep.loadPartitionSchema(id, null);
                result.add(schema);
            }
            return result;
        }
        return transMeta.getPartitionSchemas();
    }

    @VisibleForTesting
    void refreshPartitionsSubtree(TreeItem tiTransName, TransMeta transMeta, GUIResource guiResource) {
        List<PartitionSchema> partitionSchemas;
        TreeItem tiPartitionTitle = this.createTreeItem(tiTransName, STRING_PARTITIONS, guiResource.getImageBol());
        try {
            partitionSchemas = this.pickupPartitionSchemas(transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorFetchingFromRepo.PartitioningSchemas", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        for (PartitionSchema partitionSchema : partitionSchemas) {
            if (!this.filterMatch(partitionSchema.getName())) continue;
            TreeItem tiPartition = this.createTreeItem(tiPartitionTitle, partitionSchema.getName(), guiResource.getImageFolderConnections());
            if (!partitionSchema.isShared()) continue;
            tiPartition.setFont(guiResource.getFontBold());
        }
    }

    private List<SlaveServer> pickupSlaveServers(AbstractMeta transMeta) throws KettleException {
        return this.rep == null ? transMeta.getSlaveServers() : this.rep.getSlaveServers();
    }

    @VisibleForTesting
    void refreshNamedClusterSubtree(TreeItem tiRootName, AbstractMeta meta, GUIResource guiResource) {
        List namedClusters;
        TreeItem tiNcTitle = this.createTreeItem(tiRootName, STRING_NAMED_CLUSTERS, guiResource.getImageBol());
        try {
            namedClusters = NamedClusterManager.getInstance().list((IMetaStore)this.metaStore);
        }
        catch (MetaStoreException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorFetchingFromRepo.NamedCluster", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        for (NamedCluster namedCluster : namedClusters) {
            if (!this.filterMatch(namedCluster.getName())) continue;
            this.createTreeItem(tiNcTitle, namedCluster.getName(), guiResource.getImageConnection());
        }
    }

    @VisibleForTesting
    void refreshSlavesSubtree(TreeItem tiRootName, AbstractMeta meta, GUIResource guiResource) {
        List<SlaveServer> servers;
        TreeItem tiSlaveTitle = this.createTreeItem(tiRootName, STRING_SLAVES, guiResource.getImageBol());
        try {
            servers = this.pickupSlaveServers(meta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorFetchingFromRepo.SlaveServers", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] slaveNames = SlaveServer.getSlaveServerNames(servers);
        Arrays.sort(slaveNames, String.CASE_INSENSITIVE_ORDER);
        for (String slaveName : slaveNames) {
            if (!this.filterMatch(slaveName)) continue;
            SlaveServer slaveServer = SlaveServer.findSlaveServer(servers, (String)slaveName);
            TreeItem tiSlave = this.createTreeItem(tiSlaveTitle, slaveServer.getName(), guiResource.getImageSlave());
            if (!slaveServer.isShared()) continue;
            tiSlave.setFont(guiResource.getFontBold());
        }
    }

    @VisibleForTesting
    void refreshClustersSubtree(TreeItem tiTransName, TransMeta transMeta, GUIResource guiResource) {
        TreeItem tiClusterTitle = this.createTreeItem(tiTransName, STRING_CLUSTERS, guiResource.getImageBol());
        for (ClusterSchema clusterSchema : transMeta.getClusterSchemas()) {
            if (!this.filterMatch(clusterSchema.getName())) continue;
            TreeItem tiCluster = this.createTreeItem(tiClusterTitle, clusterSchema.toString(), guiResource.getImageCluster());
            if (!clusterSchema.isShared()) continue;
            tiCluster.setFont(guiResource.getFontBold());
        }
    }

    private void refreshJobEntriesSubtree(TreeItem tiJobName, JobMeta jobMeta, GUIResource guiResource) {
        TreeItem tiJobEntriesTitle = this.createTreeItem(tiJobName, STRING_JOB_ENTRIES, guiResource.getImageBol());
        for (int i = 0; i < jobMeta.nrJobEntries(); ++i) {
            Image icon;
            TreeItem tiJobEntry;
            JobEntryCopy jobEntry = jobMeta.getJobEntry(i);
            if (!this.filterMatch(jobEntry.getName()) && !this.filterMatch(jobEntry.getDescription()) || (tiJobEntry = ConstUI.findTreeItem(tiJobEntriesTitle, jobEntry.getName())) != null) continue;
            if (jobEntry.isStart()) {
                icon = GUIResource.getInstance().getImageStart();
            } else if (jobEntry.isDummy()) {
                icon = GUIResource.getInstance().getImageDummy();
            } else {
                String key = jobEntry.getEntry().getPluginId();
                icon = GUIResource.getInstance().getImagesJobentriesSmall().get(key);
            }
            this.createTreeItem(tiJobEntriesTitle, jobEntry.getName(), icon);
        }
    }

    public String getActiveTabText() {
        if (this.tabfolder.getSelected() == null) {
            return null;
        }
        return this.tabfolder.getSelected().getText();
    }

    public void refreshGraph() {
        if (this.shell.isDisposed()) {
            return;
        }
        TabItem tabItem = this.tabfolder.getSelected();
        if (tabItem == null) {
            return;
        }
        TabMapEntry tabMapEntry = this.delegates.tabs.getTab(tabItem);
        if (tabMapEntry != null) {
            if (tabMapEntry.getObject() instanceof TransGraph) {
                TransGraph transGraph = (TransGraph)tabMapEntry.getObject();
                transGraph.redraw();
            }
            if (tabMapEntry.getObject() instanceof JobGraph) {
                JobGraph jobGraph = (JobGraph)tabMapEntry.getObject();
                jobGraph.redraw();
            }
        }
        this.setShellText();
    }

    public StepMeta newStep(TransMeta transMeta) {
        return this.newStep(transMeta, true, true);
    }

    public StepMeta newStep(TransMeta transMeta, boolean openit, boolean rename) {
        if (transMeta == null) {
            return null;
        }
        TreeItem[] ti = this.selectionTree.getSelection();
        StepMeta inf = null;
        if (ti.length == 1) {
            String stepType = ti[0].getText();
            if (log.isDebug()) {
                log.logDebug(BaseMessages.getString(PKG, (String)"Spoon.Log.NewStep", (String[])new String[0]) + stepType);
            }
            inf = this.newStep(transMeta, stepType, stepType, openit, rename);
        }
        return inf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepMeta newStep(TransMeta transMeta, String name, String description, boolean openit, boolean rename) {
        StepMeta inf = null;
        if (rename && transMeta.findStep(name) != null) {
            int i = 2;
            String newName = name + " " + i;
            while (transMeta.findStep(newName) != null) {
                newName = name + " " + ++i;
            }
            name = newName;
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface stepPlugin = null;
        try {
            stepPlugin = registry.findPluginWithName(StepPluginType.class, description);
            if (stepPlugin != null) {
                StepDialogInterface dialog;
                StepMetaInterface info = (StepMetaInterface)registry.loadClass(stepPlugin);
                info.setDefault();
                if (openit && (dialog = this.getStepEntryDialog(info, transMeta, name)) != null) {
                    name = dialog.open();
                }
                inf = new StepMeta(stepPlugin.getIds()[0], name, info);
                if (name != null) {
                    String newName = name;
                    StepMeta stepMeta = transMeta.findStep(newName);
                    int nr = 2;
                    while (stepMeta != null) {
                        newName = name + " " + nr;
                        stepMeta = transMeta.findStep(newName);
                        ++nr;
                    }
                    if (nr > 2) {
                        inf.setName(newName);
                        MessageBox mb = new MessageBox(this.shell, 34);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.ChangeStepname.Message", (String[])new String[]{newName}));
                        mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.ChangeStepname.Title", (String[])new String[0]));
                        mb.open();
                    }
                } else {
                    return null;
                }
                inf.setLocation(20, 20);
                transMeta.addStep(inf);
                this.addUndoNew((UndoInterface)transMeta, new StepMeta[]{inf}, new int[]{transMeta.indexOfStep(inf)});
                this.props.increasePluginHistory(stepPlugin.getIds()[0]);
                this.refreshTree();
                this.setShellText();
            }
        }
        catch (KettleException e) {
            String filename = stepPlugin.getErrorHelpFile();
            if (stepPlugin != null && !Const.isEmpty((String)filename)) {
                FileInputStream fis = null;
                try {
                    StringBuilder content = new StringBuilder();
                    fis = new FileInputStream(new File(filename));
                    int ch = fis.read();
                    while (ch >= 0) {
                        content.append((char)ch);
                        ch = fis.read();
                    }
                    ShowBrowserDialog sbd = new ShowBrowserDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorHelpText.Title", (String[])new String[0]), content.toString());
                    sbd.open();
                }
                catch (Exception ex) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorShowingHelpText.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorShowingHelpText.Message", (String[])new String[0]), ex);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception ex) {
                            log.logError("Error closing plugin help file", (Throwable)ex);
                        }
                    }
                }
            } else {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.UnableCreateNewStep.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.UnableCreateNewStep.Message", (String[])new String[0]), (Exception)((Object)e));
            }
            return null;
        }
        catch (Throwable e) {
            if (!this.shell.isDisposed()) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorCreatingStep.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.UnableCreateNewStep.Message", (String[])new String[0]), e);
            }
            return null;
        }
        return inf;
    }

    public void setShellText() {
        String tab;
        JobMeta jobMeta;
        if (this.shell.isDisposed()) {
            return;
        }
        String filename = null;
        String name = null;
        String version = null;
        TransMeta changed = null;
        TransMeta transMeta = this.getActiveTransformation();
        if (transMeta != null) {
            changed = transMeta;
            filename = transMeta.getFilename();
            name = transMeta.getName();
            String string = version = transMeta.getObjectRevision() == null ? null : transMeta.getObjectRevision().getName();
        }
        if ((jobMeta = this.getActiveJob()) != null) {
            changed = jobMeta;
            filename = jobMeta.getFilename();
            name = jobMeta.getName();
            version = jobMeta.getObjectRevision() == null ? null : jobMeta.getObjectRevision().getName();
        }
        String text = "";
        text = this.rep != null ? text + APP_TITLE + " - [" + this.getRepositoryName() + "] " : text + APP_TITLE + " - ";
        text = Const.isEmpty((String)name) ? (!Const.isEmpty((String)filename) ? text + filename : (!Const.isEmpty((String)(tab = this.getActiveTabText())) ? text + tab : text + BaseMessages.getString(PKG, (String)"Spoon.Various.NoName", (String[])new String[0]))) : text + name;
        if (!Const.isEmpty((String)version)) {
            text = text + " v" + version;
        }
        if (changed != null && changed.hasChanged()) {
            text = text + " " + BaseMessages.getString(PKG, (String)"Spoon.Various.Changed", (String[])new String[0]);
        }
        this.shell.setText(text);
        this.markTabsChanged();
    }

    public void enableMenus() {
        Document doc;
        EngineMetaInterface meta;
        TransGraph transGraph;
        boolean disableTransMenu = this.getActiveTransformation() == null;
        boolean disableJobMenu = this.getActiveJob() == null;
        boolean disableMetaMenu = this.getActiveMeta() == null;
        boolean isRepositoryRunning = this.rep != null;
        boolean disablePreviewButton = true;
        String activePerspectiveId = null;
        SpoonPerspectiveManager manager = SpoonPerspectiveManager.getInstance();
        if (manager != null && manager.getActivePerspective() != null) {
            activePerspectiveId = manager.getActivePerspective().getId();
        }
        boolean etlPerspective = false;
        if (activePerspectiveId != null && activePerspectiveId.length() > 0) {
            etlPerspective = activePerspectiveId.equals("001-spoon-jobs");
        }
        if ((transGraph = this.getActiveTransGraph()) != null) {
            disablePreviewButton = !transGraph.isRunning() || transGraph.isHalting();
        }
        boolean disableSave = true;
        TabItemInterface currentTab = this.getActiveTabitem();
        if (currentTab != null && currentTab.canHandleSave()) {
            boolean bl = disableSave = !currentTab.hasContentChanged();
        }
        if ((meta = this.getActiveMeta()) != null) {
            boolean bl = disableSave = !meta.canSave();
        }
        if (this.mainSpoonContainer != null && (doc = this.mainSpoonContainer.getDocumentRoot()) != null) {
            if (etlPerspective) {
                doc.getElementById("file").setVisible(etlPerspective);
                doc.getElementById("edit").setVisible(etlPerspective);
                doc.getElementById("view").setVisible(etlPerspective);
                doc.getElementById("action").setVisible(etlPerspective);
                doc.getElementById("tools").setVisible(etlPerspective);
                doc.getElementById("help").setVisible(etlPerspective);
                doc.getElementById("help-tip").setVisible(etlPerspective);
                doc.getElementById("help-welcome").setVisible(etlPerspective);
                doc.getElementById("help-plugins").setVisible(true);
            }
            this.disableMenuItem(doc, "file-new-database", disableTransMenu && disableJobMenu || !isRepositoryRunning);
            this.disableMenuItem(doc, "file-save", disableTransMenu && disableJobMenu && disableMetaMenu || disableSave);
            this.disableMenuItem(doc, "toolbar-file-save", disableTransMenu && disableJobMenu && disableMetaMenu || disableSave);
            this.disableMenuItem(doc, "file-save-as", disableTransMenu && disableJobMenu && disableMetaMenu || disableSave);
            this.disableMenuItem(doc, "toolbar-file-save-as", disableTransMenu && disableJobMenu && disableMetaMenu || disableSave);
            this.disableMenuItem(doc, "file-save-as-vfs", disableTransMenu && disableJobMenu && disableMetaMenu);
            this.disableMenuItem(doc, "file-close", disableTransMenu && disableJobMenu && disableMetaMenu);
            this.disableMenuItem(doc, "file-print", disableTransMenu && disableJobMenu);
            this.disableMenuItem(doc, "file-export-to-xml", disableTransMenu && disableJobMenu);
            this.disableMenuItem(doc, "file-export-all-to-xml", disableTransMenu && disableJobMenu);
            this.disableMenuItem(doc, UNDO_MENU_ITEM, disableTransMenu && disableJobMenu);
            this.disableMenuItem(doc, REDO_MENU_ITEM, disableTransMenu && disableJobMenu);
            this.disableMenuItem(doc, "edit-clear-selection", disableTransMenu && disableJobMenu);
            this.disableMenuItem(doc, "edit-select-all", disableTransMenu && disableJobMenu);
            this.updateSettingsMenu(doc, disableTransMenu, disableJobMenu);
            this.disableMenuItem(doc, "edit-settings", disableTransMenu && disableJobMenu && disableMetaMenu);
            ((XulMenuitem)doc.getElementById("view-results")).setSelected(this.isExecutionResultsPaneVisible());
            this.disableMenuItem(doc, "view-results", transGraph == null && disableJobMenu);
            this.disableMenuItem(doc, "view-zoom-in", disableTransMenu && disableJobMenu);
            this.disableMenuItem(doc, "view-zoom-out", disableTransMenu && disableJobMenu);
            this.disableMenuItem(doc, "view-zoom-100pct", disableTransMenu && disableJobMenu);
            this.disableMenuItem(doc, "process-run", disableTransMenu && disablePreviewButton && disableJobMenu);
            this.disableMenuItem(doc, "trans-replay", disableTransMenu && disablePreviewButton);
            this.disableMenuItem(doc, "trans-preview", disableTransMenu && disablePreviewButton);
            this.disableMenuItem(doc, "trans-debug", disableTransMenu && disablePreviewButton);
            this.disableMenuItem(doc, "trans-verify", disableTransMenu);
            this.disableMenuItem(doc, "trans-impact", disableTransMenu);
            this.disableMenuItem(doc, "trans-get-sql", disableTransMenu);
            this.disableMenuItem(doc, "trans-last-impact", disableTransMenu);
            this.disableMenuItem(doc, "repository-connect", isRepositoryRunning);
            this.disableMenuItem(doc, "repository-disconnect", !isRepositoryRunning);
            this.disableMenuItem(doc, "repository-explore", !isRepositoryRunning);
            this.disableMenuItem(doc, "repository-clear-shared-object-cache", !isRepositoryRunning);
            this.disableMenuItem(doc, "toolbar-expore-repository", !isRepositoryRunning);
            this.disableMenuItem(doc, "repository-export-all", !isRepositoryRunning);
            this.disableMenuItem(doc, "repository-import-directory", !isRepositoryRunning);
            this.disableMenuItem(doc, "trans-last-preview", !isRepositoryRunning || disableTransMenu);
            this.disableMenuItem(doc, "wizard-connection", disableTransMenu && disableJobMenu);
            this.disableMenuItem(doc, "wizard-copy-table", disableTransMenu && disableJobMenu);
            this.disableMenuItem(doc, "wizard-copy-tables", isRepositoryRunning && disableTransMenu && disableJobMenu);
            this.disableMenuItem(doc, "database-inst-dependancy", !isRepositoryRunning);
            SpoonPluginManager.getInstance().notifyLifecycleListeners(SpoonLifecycleListener.SpoonLifeCycleEvent.MENUS_REFRESHED);
            MenuManager menuManager = this.getMenuBarManager();
            menuManager.updateAll(true);
            this.refreshCoreObjects();
            this.fireMenuControlers();
        }
    }

    private void updateSettingsMenu(Document doc, boolean disableTransMenu, boolean disableJobMenu) {
        XulMenuitem settingsItem = (XulMenuitem)doc.getElementById("edit-settings");
        if (settingsItem != null) {
            if (disableTransMenu && !disableJobMenu) {
                settingsItem.setAcceltext("CTRL-J");
                settingsItem.setAccesskey("ctrl-j");
            } else if (!disableTransMenu && disableJobMenu) {
                settingsItem.setAcceltext("CTRL-T");
                settingsItem.setAccesskey("ctrl-t");
            } else {
                settingsItem.setAcceltext("");
                settingsItem.setAccesskey("");
            }
        }
    }

    public void addSpoonMenuController(ISpoonMenuController menuController) {
        if (this.menuControllers != null) {
            this.menuControllers.add(menuController);
        }
    }

    public boolean removeSpoonMenuController(ISpoonMenuController menuController) {
        if (this.menuControllers != null) {
            return this.menuControllers.remove(menuController);
        }
        return false;
    }

    public ISpoonMenuController removeSpoonMenuController(String menuControllerName) {
        ISpoonMenuController result = null;
        if (this.menuControllers != null) {
            for (ISpoonMenuController menuController : this.menuControllers) {
                if (!menuController.getName().equals(menuControllerName)) continue;
                result = menuController;
                this.menuControllers.remove(result);
                break;
            }
        }
        return result;
    }

    private void disableMenuItem(Document doc, String itemId, boolean disable) {
        XulComponent menuItem = doc.getElementById(itemId);
        if (menuItem != null) {
            menuItem.setDisabled(disable);
        } else {
            log.logError("Non-Fatal error : Menu Item with id = " + itemId + " does not exist! Check 'menubar.xul'");
        }
    }

    private void markTabsChanged() {
        for (TabMapEntry entry : this.delegates.tabs.getTabs()) {
            if (entry.getTabItem().isDisposed()) continue;
            boolean changed = entry.getObject().hasContentChanged();
            entry.getTabItem().setChanged(changed);
        }
    }

    public boolean isTabsChanged() {
        for (TabMapEntry entry : this.delegates.tabs.getTabs()) {
            if (entry.getTabItem().isDisposed() || !entry.getObject().hasContentChanged()) continue;
            return true;
        }
        return false;
    }

    public void printFile() {
        JobMeta jobMeta;
        TransMeta transMeta = this.getActiveTransformation();
        if (transMeta != null) {
            this.printTransFile(transMeta);
        }
        if ((jobMeta = this.getActiveJob()) != null) {
            this.printJobFile(jobMeta);
        }
    }

    private void printTransFile(TransMeta transMeta) {
        TransGraph transGraph = this.getActiveTransGraph();
        if (transGraph == null) {
            return;
        }
        PrintSpool ps = new PrintSpool();
        Printer printer = ps.getPrinter(this.shell);
        org.pentaho.di.core.gui.Point max = transMeta.getMaximum();
        Image img = transGraph.getTransformationImage((Device)printer, max.x, max.y, 1.0f);
        ps.printImage(this.shell, img);
        img.dispose();
        ps.dispose();
    }

    private void printJobFile(JobMeta jobMeta) {
        JobGraph jobGraph = this.getActiveJobGraph();
        if (jobGraph == null) {
            return;
        }
        PrintSpool ps = new PrintSpool();
        Printer printer = ps.getPrinter(this.shell);
        org.pentaho.di.core.gui.Point max = jobMeta.getMaximum();
        Image img = jobGraph.getJobImage((Device)printer, max.x, max.y, 1.0f);
        ps.printImage(this.shell, img);
        img.dispose();
        ps.dispose();
    }

    public TransGraph getActiveTransGraph() {
        TabMapEntry mapEntry;
        if (this.tabfolder != null) {
            if (this.tabfolder.getSelected() == null) {
                return null;
            }
        } else {
            return null;
        }
        if (this.delegates != null && this.delegates.tabs != null && (mapEntry = this.delegates.tabs.getTab(this.tabfolder.getSelected())) != null && mapEntry.getObject() instanceof TransGraph) {
            return (TransGraph)mapEntry.getObject();
        }
        return null;
    }

    public JobGraph getActiveJobGraph() {
        TabMapEntry mapEntry;
        if (this.delegates != null && this.delegates.tabs != null && this.tabfolder != null && (mapEntry = this.delegates.tabs.getTab(this.tabfolder.getSelected())).getObject() instanceof JobGraph) {
            return (JobGraph)mapEntry.getObject();
        }
        return null;
    }

    public EngineMetaInterface getActiveMeta() {
        SpoonPerspectiveManager manager = SpoonPerspectiveManager.getInstance();
        if (manager != null && manager.getActivePerspective() != null) {
            return manager.getActivePerspective().getActiveMeta();
        }
        return null;
    }

    public TabItemInterface getActiveTabitem() {
        if (this.tabfolder == null) {
            return null;
        }
        TabItem tabItem = this.tabfolder.getSelected();
        if (tabItem == null) {
            return null;
        }
        if (this.delegates != null && this.delegates.tabs != null) {
            TabMapEntry mapEntry = this.delegates.tabs.getTab(tabItem);
            if (mapEntry != null) {
                return mapEntry.getObject();
            }
            return null;
        }
        return null;
    }

    public TransMeta getActiveTransformation() {
        EngineMetaInterface meta = this.getActiveMeta();
        if (meta instanceof TransMeta) {
            return (TransMeta)meta;
        }
        return null;
    }

    public JobMeta getActiveJob() {
        EngineMetaInterface meta = this.getActiveMeta();
        if (meta instanceof JobMeta) {
            return (JobMeta)meta;
        }
        return null;
    }

    public UndoInterface getActiveUndoInterface() {
        return (UndoInterface)this.getActiveMeta();
    }

    public TransMeta findTransformation(String tabItemText) {
        if (this.delegates != null && this.delegates.trans != null) {
            return this.delegates.trans.getTransformation(tabItemText);
        }
        return null;
    }

    public JobMeta findJob(String tabItemText) {
        if (this.delegates != null && this.delegates.jobs != null) {
            return this.delegates.jobs.getJob(tabItemText);
        }
        return null;
    }

    public TransMeta[] getLoadedTransformations() {
        if (this.delegates != null && this.delegates.trans != null) {
            List<TransMeta> list = this.delegates.trans.getTransformationList();
            return list.toArray(new TransMeta[list.size()]);
        }
        return null;
    }

    public JobMeta[] getLoadedJobs() {
        if (this.delegates != null && this.delegates.jobs != null) {
            List<JobMeta> list = this.delegates.jobs.getJobList();
            return list.toArray(new JobMeta[list.size()]);
        }
        return null;
    }

    public void saveSettings() {
        if (this.shell.isDisposed()) {
            return;
        }
        WindowProperty windowProperty = new WindowProperty(this.shell);
        windowProperty.setName(APP_TITLE);
        this.props.setScreen(windowProperty);
        this.props.setLogLevel(DefaultLogLevel.getLogLevel().getCode());
        this.props.setSashWeights(this.sashform.getWeights());
        this.props.getOpenTabFiles().clear();
        for (TabMapEntry entry : this.delegates.tabs.getTabs()) {
            String fileType = null;
            String filename = null;
            String directory = null;
            int openType = 0;
            if (entry.getObjectType() == TabMapEntry.ObjectType.TRANSFORMATION_GRAPH) {
                fileType = "Trans";
                TransMeta transMeta = (TransMeta)entry.getObject().getManagedObject();
                filename = this.rep != null ? transMeta.getName() : transMeta.getFilename();
                directory = transMeta.getRepositoryDirectory().toString();
                openType = 1;
            } else if (entry.getObjectType() == TabMapEntry.ObjectType.JOB_GRAPH) {
                fileType = "Job";
                JobMeta jobMeta = (JobMeta)entry.getObject().getManagedObject();
                filename = this.rep != null ? jobMeta.getName() : jobMeta.getFilename();
                directory = jobMeta.getRepositoryDirectory().toString();
                openType = 1;
            }
            if (fileType == null) continue;
            this.props.addOpenTabFile(fileType, filename, directory, this.rep != null, this.rep != null ? this.rep.getName() : null, openType);
        }
        this.props.saveProps();
    }

    public void loadSettings() {
        LogLevel logLevel = LogLevel.getLogLevelForCode((String)this.props.getLogLevel());
        DefaultLogLevel.setLogLevel((LogLevel)logLevel);
        log.setLogLevel(logLevel);
        KettleLogStore.getAppender().setMaxNrLines(this.props.getMaxNrLinesInLog());
        DBCache.getInstance().setActive(this.props.useDBCache());
    }

    public void changeLooks() {
        if (!this.selectionTree.isDisposed()) {
            this.props.setLook((Control)this.selectionTree);
        }
        this.props.setLook((Control)this.tabfolder.getSwtTabset(), 5);
        this.refreshTree();
        this.refreshGraph();
    }

    public void undoAction(UndoInterface undoInterface) {
        if (undoInterface == null) {
            return;
        }
        TransAction ta = undoInterface.previousUndo();
        if (ta == null) {
            return;
        }
        this.setUndoMenu(undoInterface);
        if (undoInterface instanceof TransMeta) {
            this.delegates.trans.undoTransformationAction((TransMeta)undoInterface, ta);
        }
        if (undoInterface instanceof JobMeta) {
            this.delegates.jobs.undoJobAction((JobMeta)undoInterface, ta);
        }
        if (undoInterface instanceof TransMeta) {
            TransGraph transGraph = this.delegates.trans.findTransGraphOfTransformation((TransMeta)undoInterface);
            transGraph.forceFocus();
        }
        if (undoInterface instanceof JobMeta) {
            JobGraph jobGraph = this.delegates.jobs.findJobGraphOfJob((JobMeta)undoInterface);
            jobGraph.forceFocus();
        }
    }

    public void redoAction(UndoInterface undoInterface) {
        if (undoInterface == null) {
            return;
        }
        TransAction ta = undoInterface.nextUndo();
        if (ta == null) {
            return;
        }
        this.setUndoMenu(undoInterface);
        if (undoInterface instanceof TransMeta) {
            this.delegates.trans.redoTransformationAction((TransMeta)undoInterface, ta);
        }
        if (undoInterface instanceof JobMeta) {
            this.delegates.jobs.redoJobAction((JobMeta)undoInterface, ta);
        }
        if (undoInterface instanceof TransMeta) {
            TransGraph transGraph = this.delegates.trans.findTransGraphOfTransformation((TransMeta)undoInterface);
            transGraph.forceFocus();
        }
        if (undoInterface instanceof JobMeta) {
            JobGraph jobGraph = this.delegates.jobs.findJobGraphOfJob((JobMeta)undoInterface);
            jobGraph.forceFocus();
        }
    }

    public void setUndoMenu(UndoInterface undoInterface) {
        if (this.shell.isDisposed()) {
            return;
        }
        TransAction prev = undoInterface != null ? undoInterface.viewThisUndo() : null;
        TransAction next = undoInterface != null ? undoInterface.viewNextUndo() : null;
        XulMenuitem item = (XulMenuitem)this.mainSpoonContainer.getDocumentRoot().getElementById(UNDO_MENU_ITEM);
        item.setLabel(prev == null ? UNDO_UNAVAILABLE : BaseMessages.getString(PKG, (String)"Spoon.Menu.Undo.Available", (String[])new String[]{prev.toString()}));
        item.setDisabled(prev == null);
        item = (XulMenuitem)this.mainSpoonContainer.getDocumentRoot().getElementById(REDO_MENU_ITEM);
        item.setLabel(next == null ? REDO_UNAVAILABLE : BaseMessages.getString(PKG, (String)"Spoon.Menu.Redo.Available", (String[])new String[]{next.toString()}));
        item.setDisabled(next == null);
    }

    public void addUndoNew(UndoInterface undoInterface, Object[] obj, int[] position) {
        this.addUndoNew(undoInterface, obj, position, false);
    }

    public void addUndoNew(UndoInterface undoInterface, Object[] obj, int[] position, boolean nextAlso) {
        undoInterface.addUndo(obj, null, position, null, null, 2, nextAlso);
        this.setUndoMenu(undoInterface);
    }

    public void addUndoDelete(UndoInterface undoInterface, Object[] obj, int[] position) {
        this.addUndoDelete(undoInterface, obj, position, false);
    }

    public void addUndoDelete(UndoInterface undoInterface, Object[] obj, int[] position, boolean nextAlso) {
        undoInterface.addUndo(obj, null, position, null, null, 3, nextAlso);
        this.setUndoMenu(undoInterface);
    }

    public void addUndoPosition(UndoInterface undoInterface, Object[] obj, int[] pos, org.pentaho.di.core.gui.Point[] prev, org.pentaho.di.core.gui.Point[] curr) {
        undoInterface.addUndo(obj, null, pos, prev, curr, 4, false);
        this.setUndoMenu(undoInterface);
    }

    public void addUndoChange(UndoInterface undoInterface, Object[] from, Object[] to, int[] pos) {
        this.addUndoChange(undoInterface, from, to, pos, false);
    }

    public void addUndoChange(UndoInterface undoInterface, Object[] from, Object[] to, int[] pos, boolean nextAlso) {
        undoInterface.addUndo(from, to, pos, null, null, 1, nextAlso);
        this.setUndoMenu(undoInterface);
    }

    public void checkTrans(TransMeta transMeta) {
        this.checkTrans(transMeta, false);
    }

    public void checkTrans(TransMeta transMeta, boolean only_selected) {
        if (transMeta == null) {
            return;
        }
        TransGraph transGraph = this.delegates.trans.findTransGraphOfTransformation(transMeta);
        if (transGraph == null) {
            return;
        }
        CheckTransProgressDialog ctpd = new CheckTransProgressDialog(this.shell, transMeta, transGraph.getRemarks(), only_selected);
        ctpd.open();
        this.showLastTransCheck();
    }

    public void showLastTransCheck() {
        StepMeta stepMeta;
        TransMeta transMeta = this.getActiveTransformation();
        if (transMeta == null) {
            return;
        }
        TransGraph transGraph = this.delegates.trans.findTransGraphOfTransformation(transMeta);
        if (transGraph == null) {
            return;
        }
        CheckResultDialog crd = new CheckResultDialog(transMeta, this.shell, 0, transGraph.getRemarks());
        String stepName = crd.open();
        if (stepName != null && (stepMeta = transMeta.findStep(stepName)) != null) {
            this.delegates.steps.editStep(transMeta, stepMeta);
        }
    }

    public void analyseImpact(TransMeta transMeta) {
        if (transMeta == null) {
            return;
        }
        TransGraph transGraph = this.delegates.trans.findTransGraphOfTransformation(transMeta);
        if (transGraph == null) {
            return;
        }
        AnalyseImpactProgressDialog aipd = new AnalyseImpactProgressDialog(this.shell, transMeta, transGraph.getImpact());
        transGraph.setImpactFinished(aipd.open());
        if (transGraph.isImpactFinished()) {
            this.showLastImpactAnalyses(transMeta);
        }
    }

    public void showLastImpactAnalyses(TransMeta transMeta) {
        if (transMeta == null) {
            return;
        }
        TransGraph transGraph = this.delegates.trans.findTransGraphOfTransformation(transMeta);
        if (transGraph == null) {
            return;
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        RowMetaInterface rowMeta = null;
        for (int i = 0; i < transGraph.getImpact().size(); ++i) {
            DatabaseImpact ii = transGraph.getImpact().get(i);
            RowMetaAndData row = ii.getRow();
            rowMeta = row.getRowMeta();
            rows.add(row.getData());
        }
        if (rows.size() > 0) {
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, Variables.getADefaultVariableSpace(), 0, "-", rowMeta, rows);
            prd.setTitleMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.ImpactAnalyses.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ImpactAnalyses.Message", (String[])new String[0]));
            prd.open();
        } else {
            MessageBox mb = new MessageBox(this.shell, 34);
            if (transGraph.isImpactFinished()) {
                mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.TransformationNoImpactOnDatabase.Message", (String[])new String[0]));
            } else {
                mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.RunImpactAnalysesFirst.Message", (String[])new String[0]));
            }
            mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.ImpactAnalyses.Title", (String[])new String[0]));
            mb.open();
        }
    }

    public void toClipboard(String clipText) {
        try {
            GUIResource.getInstance().toClipboard(clipText);
        }
        catch (Throwable e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ExceptionCopyToClipboard.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ExceptionCopyToClipboard.Message", (String[])new String[0]), e);
        }
    }

    public String fromClipboard() {
        try {
            return GUIResource.getInstance().fromClipboard();
        }
        catch (Throwable e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ExceptionPasteFromClipboard.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ExceptionPasteFromClipboard.Message", (String[])new String[0]), e);
            return null;
        }
    }

    public void pasteTransformation() {
        if (RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.MODIFY_TRANSFORMATION, RepositoryOperation.EXECUTE_TRANSFORMATION)) {
            return;
        }
        if (log.isDetailed()) {
            log.logDetailed(BaseMessages.getString(PKG, (String)"Spoon.Log.PasteTransformationFromClipboard", (String[])new String[0]));
        }
        String xml = this.fromClipboard();
        try {
            org.w3c.dom.Document doc = XMLHandler.loadXMLString((String)xml);
            TransMeta transMeta = new TransMeta(XMLHandler.getSubNode((Node)doc, (String)"transformation"), this.rep);
            this.setTransMetaVariables(transMeta);
            this.addTransGraph(transMeta);
            this.sharedObjectsFileMap.put(transMeta.getSharedObjects().getFilename(), transMeta.getSharedObjects());
            this.refreshGraph();
            this.refreshTree();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorPastingTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorPastingTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void pasteJob() {
        if (RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.MODIFY_JOB, RepositoryOperation.EXECUTE_JOB)) {
            return;
        }
        String xml = this.fromClipboard();
        try {
            org.w3c.dom.Document doc = XMLHandler.loadXMLString((String)xml);
            JobMeta jobMeta = new JobMeta(XMLHandler.getSubNode((Node)doc, (String)"job"), this.rep, (OverwritePrompter)this);
            this.addJobGraph(jobMeta);
            this.refreshGraph();
            this.refreshTree();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorPastingJob.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorPastingJob.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void copyTransformation(TransMeta transMeta) {
        if (transMeta == null) {
            return;
        }
        try {
            if (RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.MODIFY_TRANSFORMATION, RepositoryOperation.EXECUTE_TRANSFORMATION)) {
                return;
            }
            this.toClipboard(XMLHandler.getXMLHeader() + transMeta.getXML());
        }
        catch (Exception ex) {
            new ErrorDialog(this.getShell(), "Error", "Error encoding to XML", ex);
        }
    }

    public void copyJob(JobMeta jobMeta) {
        if (jobMeta == null) {
            return;
        }
        if (RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.MODIFY_JOB, RepositoryOperation.EXECUTE_JOB)) {
            return;
        }
        this.toClipboard(XMLHandler.getXMLHeader() + jobMeta.getXML());
    }

    public void copyTransformationImage(TransMeta transMeta) {
        TransGraph transGraph = this.delegates.trans.findTransGraphOfTransformation(transMeta);
        if (transGraph == null) {
            return;
        }
        Clipboard clipboard = GUIResource.getInstance().getNewClipboard();
        org.pentaho.di.core.gui.Point area = transMeta.getMaximum();
        Image image = transGraph.getTransformationImage((Device)Display.getCurrent(), area.x, area.y, 1.0f);
        clipboard.setContents(new Object[]{image.getImageData()}, new Transfer[]{ImageDataTransfer.getInstance()});
    }

    public HasDatabasesInterface getActiveHasDatabasesInterface() {
        TransMeta transMeta = this.getActiveTransformation();
        if (transMeta != null) {
            return transMeta;
        }
        return this.getActiveJob();
    }

    public void createDatabaseWizard() {
        HasDatabasesInterface hasDatabasesInterface = this.getActiveHasDatabasesInterface();
        if (hasDatabasesInterface == null) {
            return;
        }
        CreateDatabaseWizard cdw = new CreateDatabaseWizard();
        DatabaseMeta newDBInfo = cdw.createAndRunDatabaseWizard(this.shell, this.props, hasDatabasesInterface.getDatabases());
        if (newDBInfo != null) {
            hasDatabasesInterface.addDatabase(newDBInfo);
            this.refreshTree();
            this.refreshGraph();
        }
    }

    public List<DatabaseMeta> getActiveDatabases() {
        Hashtable<String, DatabaseMeta> map = new Hashtable<String, DatabaseMeta>();
        HasDatabasesInterface hasDatabasesInterface = this.getActiveHasDatabasesInterface();
        if (hasDatabasesInterface != null) {
            for (int i = 0; i < hasDatabasesInterface.nrDatabases(); ++i) {
                map.put(hasDatabasesInterface.getDatabase(i).getName(), hasDatabasesInterface.getDatabase(i));
            }
        }
        if (this.rep != null) {
            try {
                List repDBs = this.rep.readDatabases();
                for (DatabaseMeta databaseMeta : repDBs) {
                    map.put(databaseMeta.getName(), databaseMeta);
                }
            }
            catch (Exception e) {
                log.logError("Unexpected error reading databases from the repository: " + e.toString());
                log.logError(Const.getStackTracker((Throwable)e));
            }
        }
        ArrayList<DatabaseMeta> databases = new ArrayList<DatabaseMeta>();
        databases.addAll(map.values());
        return databases;
    }

    public void copyTableWizard() {
        List<DatabaseMeta> databases = this.getActiveDatabases();
        if (databases.size() == 0) {
            return;
        }
        final CopyTableWizardPage1 page1 = new CopyTableWizardPage1("1", databases);
        page1.createControl((Composite)this.shell);
        final CopyTableWizardPage2 page2 = new CopyTableWizardPage2("2");
        page2.createControl((Composite)this.shell);
        Wizard wizard = new Wizard(){

            public boolean performFinish() {
                return Spoon.this.delegates.db.copyTable(page1.getSourceDatabase(), page1.getTargetDatabase(), page2.getSelection());
            }

            public boolean canFinish() {
                return page2.canFinish();
            }
        };
        wizard.addPage((IWizardPage)page1);
        wizard.addPage((IWizardPage)page2);
        WizardDialog wd = new WizardDialog(this.shell, (IWizard)wizard);
        WizardDialog.setDefaultImage((Image)GUIResource.getInstance().getImageWizard());
        wd.setMinimumPageSize(700, 400);
        wd.updateSize();
        wd.open();
    }

    public String toString() {
        return APP_NAME;
    }

    public void selectRep(CommandLineOption[] options) {
        StringBuffer optionRepname = Spoon.getCommandLineOption(options, "rep").getArgument();
        StringBuffer optionFilename = Spoon.getCommandLineOption(options, "file").getArgument();
        StringBuffer optionUsername = Spoon.getCommandLineOption(options, "user").getArgument();
        StringBuffer optionPassword = Spoon.getCommandLineOption(options, "pass").getArgument();
        if (Const.isEmpty((StringBuffer)optionRepname) && Const.isEmpty((StringBuffer)optionFilename) && this.props.showRepositoriesDialogAtStartup()) {
            if (log.isBasic()) {
                log.logBasic(BaseMessages.getString(PKG, (String)"Spoon.Log.AskingForRepository", (String[])new String[0]));
            }
            this.loginDialog = new RepositoriesDialog(this.shell, null, new ILoginCallback(){

                @Override
                public void onSuccess(Repository repository) {
                    Spoon.this.setRepository(repository);
                    SpoonPluginManager.getInstance().notifyLifecycleListeners(SpoonLifecycleListener.SpoonLifeCycleEvent.REPOSITORY_CONNECTED);
                }

                @Override
                public void onError(Throwable t) {
                    Spoon.this.onLoginError(t);
                }

                @Override
                public void onCancel() {
                }
            });
            this.hideSplash();
            this.loginDialog.show();
            this.showSplash();
        } else if (!Const.isEmpty((StringBuffer)optionRepname) && Const.isEmpty((StringBuffer)optionFilename)) {
            RepositoriesMeta repsInfo = new RepositoriesMeta();
            try {
                repsInfo.readData();
                RepositoryMeta repositoryMeta = repsInfo.findRepository(optionRepname.toString());
                if (repositoryMeta != null && !Const.isEmpty((StringBuffer)optionUsername) && !Const.isEmpty((StringBuffer)optionPassword)) {
                    Repository repo = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, (Object)repositoryMeta, Repository.class);
                    repo.init(repositoryMeta);
                    repo.connect(optionUsername != null ? optionUsername.toString() : null, optionPassword != null ? optionPassword.toString() : null);
                    this.setRepository(repo);
                } else {
                    if (!Const.isEmpty((StringBuffer)optionUsername) && !Const.isEmpty((StringBuffer)optionPassword)) {
                        String msg = BaseMessages.getString(PKG, (String)"Spoon.Log.NoRepositoriesDefined", (String[])new String[0]);
                        log.logError(msg);
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Error.Repository.NotFound", (String[])new String[]{optionRepname.toString()}));
                        mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Error.Repository.NotFound.Title", (String[])new String[0]));
                        mb.open();
                    }
                    this.loginDialog = new RepositoriesDialog(this.shell, null, new ILoginCallback(){

                        @Override
                        public void onSuccess(Repository repository) {
                            Spoon.this.setRepository(repository);
                            SpoonPluginManager.getInstance().notifyLifecycleListeners(SpoonLifecycleListener.SpoonLifeCycleEvent.REPOSITORY_CONNECTED);
                        }

                        @Override
                        public void onError(Throwable t) {
                            Spoon.this.onLoginError(t);
                        }

                        @Override
                        public void onCancel() {
                        }
                    });
                    this.hideSplash();
                    this.loginDialog.show();
                    this.showSplash();
                }
            }
            catch (Exception e) {
                this.hideSplash();
                log.logError("Error reading repositories xml file", (Throwable)e);
            }
        }
    }

    public void handleStartOptions(CommandLineOption[] options) {
        StringBuffer optionRepname = Spoon.getCommandLineOption(options, "rep").getArgument();
        StringBuffer optionFilename = Spoon.getCommandLineOption(options, "file").getArgument();
        StringBuffer optionDirname = Spoon.getCommandLineOption(options, "dir").getArgument();
        StringBuffer optionTransname = Spoon.getCommandLineOption(options, "trans").getArgument();
        StringBuffer optionJobname = Spoon.getCommandLineOption(options, "job").getArgument();
        try {
            if (!Const.isEmpty((StringBuffer)optionRepname) || !Const.isEmpty((StringBuffer)optionFilename)) {
                if (!Const.isEmpty((StringBuffer)optionRepname)) {
                    if (this.rep != null) {
                        int t;
                        if (Const.isEmpty((StringBuffer)optionDirname)) {
                            optionDirname = new StringBuffer("/");
                        }
                        if ((t = (Const.isEmpty((StringBuffer)optionFilename) ? 0 : 1) + (Const.isEmpty((StringBuffer)optionJobname) ? 0 : 1) + (Const.isEmpty((StringBuffer)optionTransname) ? 0 : 1)) > 1) {
                            log.logError(BaseMessages.getString(PKG, (String)"Spoon.Log.MutuallyExcusive", (String[])new String[0]));
                        } else if (t == 1) {
                            if (!Const.isEmpty((StringBuffer)optionFilename)) {
                                this.openFile(optionFilename.toString(), false);
                            } else {
                                RepositoryDirectoryInterface rdi = this.rep.findDirectory(optionDirname.toString());
                                if (rdi == null) {
                                    log.logError(BaseMessages.getString(PKG, (String)"Spoon.Log.UnableFindDirectory", (String[])new String[]{optionDirname.toString()}));
                                } else if (!Const.isEmpty((StringBuffer)optionTransname)) {
                                    TransMeta transMeta = this.rep.loadTransformation(optionTransname.toString(), rdi, null, true, null);
                                    transMeta.clearChanged();
                                    transMeta.setInternalKettleVariables();
                                    this.addTransGraph(transMeta);
                                } else {
                                    JobMeta jobMeta = this.rep.loadJob(optionJobname.toString(), rdi, null, null);
                                    jobMeta.clearChanged();
                                    jobMeta.setInternalKettleVariables();
                                    this.addJobGraph(jobMeta);
                                }
                            }
                        }
                    } else {
                        log.logError(BaseMessages.getString(PKG, (String)"Spoon.Log.NoRepositoriesDefined", (String[])new String[0]));
                    }
                } else if (!Const.isEmpty((StringBuffer)optionFilename)) {
                    this.openFile(optionFilename.toString(), false);
                }
            }
        }
        catch (KettleException ke) {
            this.hideSplash();
            log.logError(BaseMessages.getString(PKG, (String)"Spoon.Log.ErrorOccurred", (String[])new String[0]) + Const.CR + ke.getMessage());
            log.logError(Const.getStackTracker((Throwable)ke));
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Log.ErrorOccurred", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Log.ErrorOccurred", (String[])new String[0]) + Const.CR + ke.getMessage(), (Exception)((Object)ke));
            this.rep = null;
        }
    }

    private void loadLastUsedFiles() {
        if (this.props.openLastFile()) {
            if (log.isDetailed()) {
                log.logDetailed(BaseMessages.getString(PKG, (String)"Spoon.Log.TryingOpenLastUsedFile", (String[])new String[0]));
            }
            List<LastUsedFile> lastUsedFiles = this.props.getOpenTabFiles();
            for (LastUsedFile lastUsedFile : lastUsedFiles) {
                try {
                    if (lastUsedFile.isSourceRepository() && (!lastUsedFile.isSourceRepository() || this.rep == null || !this.rep.getName().equals(lastUsedFile.getRepositoryName()))) continue;
                    this.loadLastUsedFile(lastUsedFile, this.rep == null ? null : this.rep.getName(), false);
                }
                catch (Exception e) {
                    this.hideSplash();
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.LoadLastUsedFile.Exception.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.LoadLastUsedFile.Exception.Message", (String[])new String[]{lastUsedFile.toString()}), e);
                }
            }
        }
    }

    public void start(CommandLineOption[] options) throws KettleException {
        this.selectRep(options);
        this.handleStartOptions(options);
        this.loadLastUsedFiles();
        this.enableMenus();
        SpoonPerspectiveManager.getInstance().setForcePerspective(false);
        if (this.props.showTips()) {
            TipsDialog tip = new TipsDialog(this.shell);
            this.hideSplash();
            tip.open();
        }
        if (splash != null) {
            splash.dispose();
            splash = null;
        }
        if (!ValueMeta.convertStringToBoolean((String)System.getProperty("KETTLE_HIDE_DEVELOPMENT_VERSION_WARNING", "N")).booleanValue() && Const.RELEASE.equals((Object)Const.ReleaseType.MILESTONE)) {
            MessageBox dialog = new MessageBox(this.shell, 8);
            dialog.setText(BaseMessages.getString(PKG, (String)"Spoon.Warning.DevelopmentRelease.Title", (String[])new String[0]));
            dialog.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Warning.DevelopmentRelease.Message", (String[])new String[]{Const.CR, BuildVersion.getInstance().getVersion()}));
            dialog.open();
        }
    }

    private void waitForDispose() {
        boolean retryAfterError;
        do {
            retryAfterError = false;
            try {
                while (this.getShell() != null && !this.getShell().isDisposed()) {
                    if (this.readAndDispatch()) continue;
                    this.sleep();
                }
            }
            catch (Throwable e) {
                log.logError(BaseMessages.getString(PKG, (String)"Spoon.Log.UnexpectedErrorOccurred", (String[])new String[0]) + Const.CR + e.getMessage());
                log.logError(Const.getStackTracker((Throwable)e));
                try {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Log.UnexpectedErrorOccurred", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Log.UnexpectedErrorOccurred", (String[])new String[0]) + Const.CR + e.getMessage(), e);
                    MessageBox mb = new MessageBox(this.shell, 196);
                    mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Log.UnexpectedErrorRetry.Titel", (String[])new String[0]));
                    mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Log.UnexpectedErrorRetry.Message", (String[])new String[0]));
                    if (mb.open() != 64) continue;
                    retryAfterError = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        } while (retryAfterError);
        if (!this.display.isDisposed()) {
            this.display.update();
        }
        this.dispose();
        if (log.isBasic()) {
            log.logBasic(APP_NAME + " " + BaseMessages.getString(PKG, (String)"Spoon.Log.AppHasEnded", (String[])new String[0]));
        }
        if (fileLoggingEventListener != null) {
            try {
                fileLoggingEventListener.close();
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Error closing logging file", (Throwable)e);
            }
            KettleLogStore.getAppender().removeLoggingEventListener((KettleLoggingEventListener)fileLoggingEventListener);
        }
    }

    public static CommandLineOption getCommandLineOption(CommandLineOption[] options, String opt) {
        for (CommandLineOption option : options) {
            if (!option.getOption().equals(opt)) continue;
            return option;
        }
        return null;
    }

    public static CommandLineOption[] getCommandLineArgs(List<String> args) {
        CommandLineOption[] clOptions = new CommandLineOption[]{new CommandLineOption("rep", "Repository name", new StringBuffer()), new CommandLineOption("user", "Repository username", new StringBuffer()), new CommandLineOption("pass", "Repository password", new StringBuffer()), new CommandLineOption("job", "The name of the job to launch", new StringBuffer()), new CommandLineOption("trans", "The name of the transformation to launch", new StringBuffer()), new CommandLineOption("dir", "The directory (don't forget the leading /)", new StringBuffer()), new CommandLineOption("file", "The filename (Transformation in XML) to launch", new StringBuffer()), new CommandLineOption("level", "The logging level (Basic, Detailed, Debug, Rowlevel, Error, Nothing)", new StringBuffer()), new CommandLineOption("logfile", "The logging file to write to", new StringBuffer()), new CommandLineOption("log", "The logging file to write to (deprecated)", new StringBuffer(), false, true), new CommandLineOption("perspective", "The perspective to start in", new StringBuffer(), false, true)};
        log = new LogChannel((Object)APP_NAME);
        if (!CommandLineOption.parseArguments(args, (CommandLineOption[])clOptions, (LogChannelInterface)log)) {
            log.logError("Command line option not understood");
            System.exit(8);
        }
        String kettleRepname = Const.getEnvironmentVariable((String)"KETTLE_REPOSITORY", null);
        String kettleUsername = Const.getEnvironmentVariable((String)"KETTLE_USER", null);
        String kettlePassword = Const.getEnvironmentVariable((String)"KETTLE_PASSWORD", null);
        if (!Const.isEmpty((String)kettleRepname)) {
            clOptions[0].setArgument(new StringBuffer(kettleRepname));
        }
        if (!Const.isEmpty((String)kettleUsername)) {
            clOptions[1].setArgument(new StringBuffer(kettleUsername));
        }
        if (!Const.isEmpty((String)kettlePassword)) {
            clOptions[2].setArgument(new StringBuffer(kettlePassword));
        }
        return clOptions;
    }

    private void loadLastUsedFile(LastUsedFile lastUsedFile, String repositoryName) throws KettleException {
        this.loadLastUsedFile(lastUsedFile, repositoryName, true);
    }

    private void loadLastUsedFile(LastUsedFile lastUsedFile, String repositoryName, boolean trackIt) throws KettleException {
        RepositoryDirectoryInterface rdi;
        boolean useRepository;
        boolean bl = useRepository = repositoryName != null;
        if (lastUsedFile.isSourceRepository() && !Const.isEmpty((String)lastUsedFile.getRepositoryName()) && useRepository && !lastUsedFile.getRepositoryName().equalsIgnoreCase(repositoryName)) {
            useRepository = false;
        }
        if (useRepository && lastUsedFile.isSourceRepository() && this.rep != null && this.rep.getName().equalsIgnoreCase(lastUsedFile.getRepositoryName()) && (rdi = this.rep.findDirectory(lastUsedFile.getDirectory())) != null) {
            JobLoadProgressDialog progressDialog;
            JobMeta jobMeta;
            if (lastUsedFile.isTransformation()) {
                TransLoadProgressDialog tlpd;
                TransMeta transMeta;
                if (log.isDetailed()) {
                    log.logDetailed(BaseMessages.getString(PKG, (String)"Spoon.Log.AutoLoadingTransformation", (String[])new String[]{lastUsedFile.getFilename(), lastUsedFile.getDirectory()}));
                }
                if ((transMeta = (tlpd = new TransLoadProgressDialog(this.shell, this.rep, lastUsedFile.getFilename(), rdi, null)).open()) != null) {
                    if (trackIt) {
                        this.props.addLastFile("Trans", lastUsedFile.getFilename(), rdi.getPath(), true, this.rep.getName());
                    }
                    transMeta.clearChanged();
                    this.addTransGraph(transMeta);
                    this.refreshTree();
                }
            } else if (lastUsedFile.isJob() && (jobMeta = (progressDialog = new JobLoadProgressDialog(this.shell, this.rep, lastUsedFile.getFilename(), rdi, null)).open()) != null) {
                if (trackIt) {
                    this.props.addLastFile("Job", lastUsedFile.getFilename(), rdi.getPath(), true, this.rep.getName());
                }
                jobMeta.clearChanged();
                this.addJobGraph(jobMeta);
            }
            this.refreshTree();
        }
        if (!lastUsedFile.isSourceRepository() && !Const.isEmpty((String)lastUsedFile.getFilename())) {
            if (lastUsedFile.isTransformation()) {
                this.openFile(lastUsedFile.getFilename(), false);
            }
            if (lastUsedFile.isJob()) {
                this.openFile(lastUsedFile.getFilename(), false);
            }
            this.refreshTree();
        }
    }

    public void generateFieldMapping(TransMeta transMeta, StepMeta stepMeta) {
        block6: {
            try {
                if (stepMeta != null) {
                    StepMetaInterface smi = stepMeta.getStepMetaInterface();
                    RowMetaInterface targetFields = smi.getRequiredFields((VariableSpace)transMeta);
                    RowMetaInterface sourceFields = transMeta.getPrevStepFields(stepMeta);
                    String[] source = sourceFields.getFieldNames();
                    int i = 0;
                    while (i < source.length) {
                        ValueMetaInterface v = sourceFields.getValueMeta(i);
                        int n = i++;
                        source[n] = source[n] + "            (" + v.getOrigin() + ")";
                    }
                    String[] target = targetFields.getFieldNames();
                    EnterMappingDialog dialog = new EnterMappingDialog(this.shell, source, target);
                    List<SourceToTargetMapping> mappings = dialog.open();
                    if (mappings != null) {
                        SelectValuesMeta svm = new SelectValuesMeta();
                        svm.allocate(mappings.size(), 0, 0);
                        for (int i2 = 0; i2 < mappings.size(); ++i2) {
                            SourceToTargetMapping mapping = mappings.get(i2);
                            svm.getSelectName()[i2] = sourceFields.getValueMeta(mapping.getSourcePosition()).getName();
                            svm.getSelectRename()[i2] = target[mapping.getTargetPosition()];
                            svm.getSelectLength()[i2] = -1;
                            svm.getSelectPrecision()[i2] = -1;
                        }
                        String stepName = stepMeta.getName() + " Mapping";
                        stepName = transMeta.getAlternativeStepname(stepName);
                        StepMeta newStep = new StepMeta("SelectValues", stepName, (StepMetaInterface)svm);
                        newStep.setLocation(stepMeta.getLocation().x + 20, stepMeta.getLocation().y + 20);
                        newStep.setDraw(true);
                        transMeta.addStep(newStep);
                        this.addUndoNew((UndoInterface)transMeta, new StepMeta[]{newStep}, new int[]{transMeta.indexOfStep(newStep)});
                        this.refreshTree();
                        this.refreshGraph();
                    }
                    break block6;
                }
                throw new KettleException("There is no target to do a field mapping against!");
            }
            catch (KettleException e) {
                new ErrorDialog(this.shell, "Error creating mapping", "There was an error when Kettle tried to generate a field mapping against the target step", (Exception)((Object)e));
            }
        }
    }

    public boolean isDefinedSchemaExist(String[] schemaNames) {
        if (schemaNames == null || schemaNames.length == 0) {
            MessageBox box = new MessageBox(this.shell, 33);
            box.setText("Create a partition schema");
            box.setMessage("You first need to create one or more partition schemas in the transformation settings dialog before you can select one!");
            box.open();
            return false;
        }
        return true;
    }

    public void editPartitioning(TransMeta transMeta, StepMeta stepMeta) {
        String[] schemaNames;
        try {
            schemaNames = this.pickupPartitionSchemaNames(transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorFetchingFromRepo.PartitioningSchemas", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        try {
            if (this.isDefinedSchemaExist(schemaNames)) {
                PluginRegistry registry = PluginRegistry.getInstance();
                List plugins = registry.getPlugins(PartitionerPluginType.class);
                int exactSize = StepPartitioningMeta.methodDescriptions.length + plugins.size();
                PartitionSettings settings = new PartitionSettings(exactSize, transMeta, stepMeta, this);
                settings.fillOptionsAndCodesByPlugins(plugins);
                PartitionMethodSelector methodSelector = new PartitionMethodSelector();
                String partitionMethodDescription = methodSelector.askForPartitionMethod(this.shell, settings);
                if (!StringUtil.isEmpty((String)partitionMethodDescription)) {
                    String method = settings.getMethodByMethodDescription(partitionMethodDescription);
                    int methodType = StepPartitioningMeta.getMethodType((String)method);
                    settings.updateMethodType(methodType);
                    settings.updateMethod(method);
                    MethodProcessor methodProcessor = MethodProcessorFactory.create(methodType);
                    methodProcessor.schemaSelection(settings, this.shell, this.delegates);
                }
                this.addUndoChange((UndoInterface)settings.getTransMeta(), new StepMeta[]{settings.getBefore()}, new StepMeta[]{settings.getAfter()}, new int[]{settings.getTransMeta().indexOfStep(settings.getStepMeta())});
                this.refreshGraph();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "There was an unexpected error while editing the partitioning method specifics:", e);
        }
    }

    public void editClustering(TransMeta transMeta, StepMeta stepMeta) {
        this.editClustering(transMeta, Collections.singletonList(stepMeta));
    }

    private String[] pickupClusterSchemas(TransMeta transMeta) throws KettleException {
        return this.rep == null ? transMeta.getClusterSchemaNames() : this.rep.getClusterNames(false);
    }

    public void editClustering(TransMeta transMeta, List<StepMeta> stepMetas) {
        EnterSelectionDialog dialog;
        String schemaName;
        String[] clusterSchemaNames;
        try {
            clusterSchemaNames = this.pickupClusterSchemas(transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.ErrorDialog.ErrorFetchingFromRepo.ClusterSchemas", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        StepMeta stepMeta = stepMetas.get(0);
        int idx = -1;
        if (stepMeta.getClusterSchema() != null) {
            idx = transMeta.getClusterSchemas().indexOf(stepMeta.getClusterSchema());
        }
        if ((schemaName = (dialog = new EnterSelectionDialog(this.shell, clusterSchemaNames, BaseMessages.getString(PKG, (String)"Spoon.Dialog.SelectClusteringSchema.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.SelectClusteringSchema.Message", (String[])new String[0]))).open(idx)) == null) {
            for (StepMeta step : stepMetas) {
                step.setClusterSchema(null);
            }
        } else {
            ClusterSchema clusterSchema = transMeta.findClusterSchema(schemaName);
            for (StepMeta step : stepMetas) {
                step.setClusterSchema(clusterSchema);
            }
        }
        this.refreshTree();
        this.refreshGraph();
    }

    public void createKettleArchive(TransMeta transMeta) {
        if (transMeta == null) {
            return;
        }
        JarfileGenerator.generateJarFile((TransMeta)transMeta);
    }

    public void newPartitioningSchema(TransMeta transMeta) {
        PartitionSchema partitionSchema = new PartitionSchema();
        PartitionSchemaDialog dialog = new PartitionSchemaDialog(this.shell, partitionSchema, transMeta.getDatabases(), (VariableSpace)transMeta);
        if (dialog.open()) {
            transMeta.getPartitionSchemas().add(partitionSchema);
            if (this.rep != null) {
                try {
                    if (this.rep.getSecurityProvider().isReadOnly()) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"Spoon.Dialog.Exception.ReadOnlyRepositoryUser", (String[])new String[0]));
                    }
                    this.rep.save((RepositoryElementInterface)partitionSchema, "Creation of initial version", null);
                }
                catch (KettleException e) {
                    new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingPartition.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingPartition.Message", (String[])new String[]{partitionSchema.getName()}), (Exception)((Object)e));
                }
            }
            this.refreshTree();
        }
    }

    private void editPartitionSchema(TransMeta transMeta, PartitionSchema partitionSchema) {
        PartitionSchemaDialog dialog = new PartitionSchemaDialog(this.shell, partitionSchema, transMeta.getDatabases(), (VariableSpace)transMeta);
        if (dialog.open()) {
            this.refreshTree();
        }
    }

    private void delPartitionSchema(TransMeta transMeta, PartitionSchema partitionSchema) {
        try {
            if (this.rep != null && partitionSchema.getObjectId() != null) {
                this.rep.deletePartitionSchema(partitionSchema.getObjectId());
            }
            int idx = transMeta.getPartitionSchemas().indexOf(partitionSchema);
            transMeta.getPartitionSchemas().remove(idx);
            this.refreshTree();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorDeletingClusterSchema.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorDeletingClusterSchema.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void newClusteringSchema(TransMeta transMeta) {
        ClusterSchema clusterSchema = new ClusterSchema();
        ClusterSchemaDialog dialog = new ClusterSchemaDialog(this.shell, clusterSchema, transMeta.getSlaveServers());
        if (dialog.open()) {
            transMeta.getClusterSchemas().add(clusterSchema);
            if (this.rep != null) {
                try {
                    if (this.rep.getSecurityProvider().isReadOnly()) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"Spoon.Dialog.Exception.ReadOnlyRepositoryUser", (String[])new String[0]));
                    }
                    this.rep.save((RepositoryElementInterface)clusterSchema, "Creation of initial version", null);
                }
                catch (KettleException e) {
                    new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingCluster.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorSavingCluster.Message", (String[])new String[]{clusterSchema.getName()}), (Exception)((Object)e));
                }
            }
            this.refreshTree();
        }
    }

    private void editClusterSchema(TransMeta transMeta, ClusterSchema clusterSchema) {
        ClusterSchemaDialog dialog = new ClusterSchemaDialog(this.shell, clusterSchema, transMeta.getSlaveServers());
        if (dialog.open()) {
            this.refreshTree();
        }
    }

    private void delClusterSchema(TransMeta transMeta, ClusterSchema clusterSchema) {
        try {
            if (this.rep != null && clusterSchema.getObjectId() != null) {
                this.rep.deleteClusterSchema(clusterSchema.getObjectId());
            }
            int idx = transMeta.getClusterSchemas().indexOf(clusterSchema);
            transMeta.getClusterSchemas().remove(idx);
            this.refreshTree();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorDeletingPartitionSchema.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorDeletingPartitionSchema.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void newSlaveServer(HasSlaveServersInterface hasSlaveServersInterface) {
        this.delegates.slaves.newSlaveServer(hasSlaveServersInterface);
    }

    public void delSlaveServer(HasSlaveServersInterface hasSlaveServersInterface, SlaveServer slaveServer) {
        try {
            this.delegates.slaves.delSlaveServer(hasSlaveServersInterface, slaveServer);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorDeletingSlave.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorDeletingSlave.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void sendTransformationXMLToSlaveServer(TransMeta transMeta, TransExecutionConfiguration executionConfiguration) {
        try {
            Trans.sendToSlaveServer((TransMeta)transMeta, (TransExecutionConfiguration)executionConfiguration, (Repository)this.rep, (IMetaStore)this.metaStore);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error sending transformation to server", e);
        }
    }

    public void runFile() {
        this.executeFile(true, false, false, false, false, null, false);
    }

    public void replayTransformation() {
        TransExecutionConfiguration tc = this.getTransExecutionConfiguration();
        this.executeFile(tc.isExecutingLocally(), tc.isExecutingRemotely(), tc.isExecutingClustered(), false, false, new Date(), false);
    }

    public void previewFile() {
        this.executeFile(true, false, false, true, false, null, true);
    }

    public void debugFile() {
        this.executeFile(true, false, false, false, true, null, true);
    }

    public void executeFile(boolean local, boolean remote, boolean cluster, boolean preview, boolean debug, Date replayDate, boolean safe) {
        JobMeta jobMeta;
        TransMeta transMeta = this.getActiveTransformation();
        if (transMeta != null) {
            this.executeTransformation(transMeta, local, remote, cluster, preview, debug, replayDate, safe, this.transExecutionConfiguration.getLogLevel());
        }
        if ((jobMeta = this.getActiveJob()) != null) {
            this.executeJob(jobMeta, local, remote, replayDate, safe, null, 0);
        }
    }

    public void executeTransformation(final TransMeta transMeta, final boolean local, final boolean remote, final boolean cluster, final boolean preview, final boolean debug, final Date replayDate, final boolean safe, final LogLevel logLevel) {
        if (RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.EXECUTE_TRANSFORMATION)) {
            return;
        }
        Thread thread = new Thread(){

            @Override
            public void run() {
                Spoon.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Spoon.this.delegates.trans.executeTransformation(transMeta, local, remote, cluster, preview, debug, replayDate, safe, logLevel);
                        }
                        catch (Exception e) {
                            new ErrorDialog(Spoon.this.shell, "Execute transformation", "There was an error during transformation execution", e);
                        }
                    }
                });
            }
        };
        thread.start();
    }

    public void executeJob(JobMeta jobMeta, boolean local, boolean remote, Date replayDate, boolean safe, String startCopyName, int startCopyNr) {
        if (RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.EXECUTE_JOB)) {
            return;
        }
        try {
            this.delegates.jobs.executeJob(jobMeta, local, remote, replayDate, safe, startCopyName, startCopyNr);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Execute job", "There was an error during job execution", e);
        }
    }

    public void addSpoonSlave(SlaveServer slaveServer) {
        this.delegates.slaves.addSpoonSlave(slaveServer);
    }

    public void addJobHistory(JobMeta jobMeta, boolean select) {
        JobGraph activeJobGraph = this.getActiveJobGraph();
        if (activeJobGraph != null) {
            activeJobGraph.jobHistoryDelegate.addJobHistory();
        }
    }

    public void paste() {
        String clipContent = this.fromClipboard();
        if (clipContent != null) {
            try {
                JobGraph jobGraph;
                boolean jobEntries;
                org.w3c.dom.Document document = XMLHandler.loadXMLString((String)clipContent);
                boolean transformation = XMLHandler.getSubNode((Node)document, (String)"transformation") != null;
                boolean job = XMLHandler.getSubNode((Node)document, (String)"job") != null;
                boolean steps = XMLHandler.getSubNode((Node)document, (String)XML_TAG_TRANSFORMATION_STEPS) != null;
                boolean bl = jobEntries = XMLHandler.getSubNode((Node)document, (String)XML_TAG_JOB_JOB_ENTRIES) != null;
                if (transformation) {
                    this.pasteTransformation();
                } else if (job) {
                    this.pasteJob();
                } else if (steps) {
                    TransGraph transGraph = this.getActiveTransGraph();
                    if (transGraph != null && transGraph.getLastMove() != null) {
                        this.pasteXML(transGraph.getManagedObject(), clipContent, transGraph.screen2real(transGraph.getLastMove().x, transGraph.getLastMove().y));
                    }
                } else if (jobEntries && (jobGraph = this.getActiveJobGraph()) != null && jobGraph.getLastMove() != null) {
                    this.pasteXML(jobGraph.getManagedObject(), clipContent, jobGraph.getLastMove());
                }
            }
            catch (KettleXMLException e) {
                log.logError("Unable to paste", (Throwable)e);
            }
        }
    }

    public JobEntryCopy newJobEntry(JobMeta jobMeta, String typeDesc, boolean openit) {
        return this.delegates.jobs.newJobEntry(jobMeta, typeDesc, openit);
    }

    public JobEntryDialogInterface getJobEntryDialog(JobEntryInterface jei, JobMeta jobMeta) {
        return this.delegates.jobs.getJobEntryDialog(jei, jobMeta);
    }

    public StepDialogInterface getStepEntryDialog(StepMetaInterface stepMeta, TransMeta transMeta, String stepName) {
        try {
            return this.delegates.steps.getStepDialog(stepMeta, transMeta, stepName);
        }
        catch (Throwable t) {
            log.logError("Could not create dialog for " + stepMeta.getDialogClassName(), t);
            return null;
        }
    }

    public void editJobEntry(JobMeta jobMeta, JobEntryCopy je) {
        this.delegates.jobs.editJobEntry(jobMeta, je);
    }

    public void deleteJobEntryCopies(JobMeta jobMeta, JobEntryCopy jobEntry) {
        this.delegates.jobs.deleteJobEntryCopies(jobMeta, jobEntry);
    }

    public void pasteXML(JobMeta jobMeta, String clipContent, org.pentaho.di.core.gui.Point loc) {
        if (RepositorySecurityUI.verifyOperations(this.shell, this.rep, RepositoryOperation.MODIFY_JOB, RepositoryOperation.EXECUTE_JOB)) {
            return;
        }
        this.delegates.jobs.pasteXML(jobMeta, clipContent, loc);
    }

    public void newJobHop(JobMeta jobMeta, JobEntryCopy fr, JobEntryCopy to) {
        this.delegates.jobs.newJobHop(jobMeta, fr, to);
    }

    public void ripDBWizard() {
        this.delegates.jobs.ripDBWizard();
    }

    public JobMeta ripDB(List<DatabaseMeta> databases, String jobName, RepositoryDirectory repdir, String directory, DatabaseMeta sourceDbInfo, DatabaseMeta targetDbInfo, String[] tables) {
        return this.delegates.jobs.ripDB(databases, jobName, (RepositoryDirectoryInterface)repdir, directory, sourceDbInfo, targetDbInfo, tables);
    }

    public void setCoreObjectsState(int state) {
        this.coreObjectsState = state;
    }

    public int getCoreObjectsState() {
        return this.coreObjectsState;
    }

    public LogChannelInterface getLog() {
        return log;
    }

    public Repository getRepository() {
        return this.rep;
    }

    public void setRepository(Repository rep) {
        this.rep = rep;
        try {
            if (this.metaStore.getMetaStoreList().size() > 1) {
                this.metaStore.getMetaStoreList().remove(0);
                this.metaStore.setActiveMetaStoreName(((IMetaStore)this.metaStore.getMetaStoreList().get(0)).getName());
            }
            if (rep != null) {
                this.capabilities = rep.getRepositoryMeta().getRepositoryCapabilities();
                IMetaStore repositoryMetaStore = rep.getMetaStore();
                if (repositoryMetaStore != null) {
                    this.metaStore.addMetaStore(0, repositoryMetaStore);
                    this.metaStore.setActiveMetaStoreName(repositoryMetaStore.getName());
                    log.logBasic("Connected to metastore : " + repositoryMetaStore.getName() + ", added to delegating metastore");
                } else {
                    log.logBasic("No metastore found in the repository : " + rep.getName() + ", connected? " + rep.isConnected());
                }
            }
        }
        catch (MetaStoreException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorAddingRepositoryMetaStore.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorReadingSharedObjects.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        UISupportRegistery.getInstance().registerUISupport(RepositorySecurityProvider.class, BaseRepositoryExplorerUISupport.class);
        UISupportRegistery.getInstance().registerUISupport(RepositorySecurityManager.class, ManageUserUISupport.class);
        if (rep != null) {
            SpoonPluginManager.getInstance().notifyLifecycleListeners(SpoonLifecycleListener.SpoonLifeCycleEvent.REPOSITORY_CHANGED);
        }
        this.delegates.update(this);
        this.enableMenus();
    }

    public void addMenuListener(String id, Object listener, String methodName) {
        this.menuListeners.add(new Object[]{id, listener, methodName});
    }

    public void addTransGraph(TransMeta transMeta) {
        this.delegates.trans.addTransGraph(transMeta);
    }

    public void addJobGraph(JobMeta jobMeta) {
        this.delegates.jobs.addJobGraph(jobMeta);
    }

    public boolean addSpoonBrowser(String name, String urlString, LocationListener locationListener) {
        return this.delegates.tabs.addSpoonBrowser(name, urlString, locationListener);
    }

    public boolean addSpoonBrowser(String name, String urlString) {
        return this.delegates.tabs.addSpoonBrowser(name, urlString, null);
    }

    public TransExecutionConfiguration getTransExecutionConfiguration() {
        return this.transExecutionConfiguration;
    }

    public void editStepErrorHandling(TransMeta transMeta, StepMeta stepMeta) {
        this.delegates.steps.editStepErrorHandling(transMeta, stepMeta);
    }

    public String editStep(TransMeta transMeta, StepMeta stepMeta) {
        return this.delegates.steps.editStep(transMeta, stepMeta);
    }

    public void dupeStep(TransMeta transMeta, StepMeta stepMeta) {
        this.delegates.steps.dupeStep(transMeta, stepMeta);
    }

    public void delStep(TransMeta transMeta, StepMeta stepMeta) {
        this.delegates.steps.delStep(transMeta, stepMeta);
    }

    public String makeTabName(EngineMetaInterface transMeta, boolean showingLocation) {
        return this.delegates.tabs.makeTabName(transMeta, showingLocation);
    }

    public void newConnection() {
        this.delegates.db.newConnection();
    }

    public void newNamedCluster() {
        Object vs = null;
        vs = this.getActiveMeta() instanceof TransMeta ? this.getActiveTransformation() : this.getActiveJob();
        this.delegates.nc.newNamedCluster((VariableSpace)vs, (IMetaStore)this.metaStore, this.getShell());
    }

    public void editNamedCluster() {
        NamedCluster nc = (NamedCluster)this.selectionObject;
        this.delegates.nc.editNamedCluster((IMetaStore)this.metaStore, nc, this.getShell());
    }

    public void delNamedCluster() {
        NamedCluster nc = (NamedCluster)this.selectionObject;
        MessageBox mb = new MessageBox(this.shell, 196);
        mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.DeleteNamedClusterAsk.Message", (String[])new String[]{nc.getName()}));
        mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.DeleteNamedClusterAsk.Title", (String[])new String[0]));
        int response = mb.open();
        if (response != 64) {
            return;
        }
        this.delegates.nc.delNamedCluster((IMetaStore)this.metaStore, nc);
    }

    public void dupeNamedCluster() {
        NamedCluster nc = (NamedCluster)this.selectionObject;
        this.delegates.nc.dupeNamedCluster((IMetaStore)this.metaStore, nc, this.getShell());
    }

    public void getSQL() {
        this.delegates.db.getSQL();
    }

    public boolean overwritePrompt(String message, String rememberText, String rememberPropertyName) {
        return new PopupOverwritePrompter(this.shell, this.props).overwritePrompt(message, rememberText, rememberPropertyName);
    }

    public Object[] messageDialogWithToggle(String dialogTitle, Object image, String message, int dialogImageType, String[] buttonLabels, int defaultIndex, String toggleMessage, boolean toggleState) {
        return GUIResource.getInstance().messageDialogWithToggle(this.shell, dialogTitle, (Image)image, message, dialogImageType, buttonLabels, defaultIndex, toggleMessage, toggleState);
    }

    public boolean messageBox(final String message, final String text, final boolean allowCancel, final int type) {
        final StringBuffer answer = new StringBuffer("N");
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                int flags = 32;
                if (allowCancel) {
                    flags |= 0x100;
                }
                switch (type) {
                    case 3: {
                        flags |= 2;
                        break;
                    }
                    case 2: {
                        flags |= 1;
                        break;
                    }
                    case 1: {
                        flags |= 8;
                        break;
                    }
                }
                MessageBox mb = new MessageBox(Spoon.this.shell, flags);
                mb.setMessage(message);
                mb.setText(text);
                if (mb.open() == 32) {
                    answer.setCharAt(0, 'Y');
                }
            }
        });
        return "Y".equalsIgnoreCase(answer.toString());
    }

    public TransExecutionConfiguration getTransPreviewExecutionConfiguration() {
        return this.transPreviewExecutionConfiguration;
    }

    public void setTransPreviewExecutionConfiguration(TransExecutionConfiguration previewExecutionConfiguration) {
        this.transPreviewExecutionConfiguration = previewExecutionConfiguration;
    }

    public TransExecutionConfiguration getTransDebugExecutionConfiguration() {
        return this.transDebugExecutionConfiguration;
    }

    public void setTransDebugExecutionConfiguration(TransExecutionConfiguration debugExecutionConfiguration) {
        this.transDebugExecutionConfiguration = debugExecutionConfiguration;
    }

    public void setTransExecutionConfiguration(TransExecutionConfiguration executionConfiguration) {
        this.transExecutionConfiguration = executionConfiguration;
    }

    public JobExecutionConfiguration getJobExecutionConfiguration() {
        return this.jobExecutionConfiguration;
    }

    public void setJobExecutionConfiguration(JobExecutionConfiguration jobExecutionConfiguration) {
        this.jobExecutionConfiguration = jobExecutionConfiguration;
    }

    public void update(ChangedFlagInterface o, Object arg) {
        try {
            Method m = this.getClass().getMethod(arg.toString(), new Class[0]);
            if (m != null) {
                m.invoke((Object)this, new Object[0]);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to update: " + e.getLocalizedMessage());
        }
    }

    public void consume(final LifeEventInfo info) {
        if (info.hasHint(LifeEventInfo.Hint.DISPLAY_BROWSER)) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Spoon.this.delegates.tabs.addSpoonBrowser(info.getName(), info.getMessage(), false, null);
                }
            });
        } else {
            MessageBox box = new MessageBox(this.shell, (info.getState() != LifeEventInfo.State.SUCCESS ? 1 : 2) | 0x20);
            box.setText(info.getName());
            box.setMessage(info.getMessage());
            box.open();
        }
    }

    public void setLog() {
        LogSettingsDialog lsd = new LogSettingsDialog(this.shell, 0, this.props);
        lsd.open();
        log.setLogLevel(DefaultLogLevel.getLogLevel());
    }

    public Display getDisplay() {
        return this.display;
    }

    public void zoomIn() {
        JobGraph jobGraph;
        TransGraph transGraph = this.getActiveTransGraph();
        if (transGraph != null) {
            transGraph.zoomIn();
        }
        if ((jobGraph = this.getActiveJobGraph()) != null) {
            jobGraph.zoomIn();
        }
    }

    public void zoomOut() {
        JobGraph jobGraph;
        TransGraph transGraph = this.getActiveTransGraph();
        if (transGraph != null) {
            transGraph.zoomOut();
        }
        if ((jobGraph = this.getActiveJobGraph()) != null) {
            jobGraph.zoomOut();
        }
    }

    public void zoom100Percent() {
        JobGraph jobGraph;
        TransGraph transGraph = this.getActiveTransGraph();
        if (transGraph != null) {
            transGraph.zoom100Percent();
        }
        if ((jobGraph = this.getActiveJobGraph()) != null) {
            jobGraph.zoom100Percent();
        }
    }

    public void setParametersAsVariablesInUI(NamedParams namedParameters, VariableSpace space) {
        for (String param : namedParameters.listParameters()) {
            try {
                space.setVariable(param, Const.NVL((String)namedParameters.getParameterValue(param), (String)Const.NVL((String)namedParameters.getParameterDefault(param), (String)Const.NVL((String)space.getVariable(param), (String)""))));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void browseVersionHistory() {
        JobGraph jobGraph;
        if (this.rep == null) {
            return;
        }
        TransGraph transGraph = this.getActiveTransGraph();
        if (transGraph != null) {
            transGraph.browseVersionHistory();
        }
        if ((jobGraph = this.getActiveJobGraph()) != null) {
            jobGraph.browseVersionHistory();
        }
    }

    public Trans findActiveTrans(Job job, JobEntryCopy jobEntryCopy) {
        JobEntryTrans jobEntryTrans = (JobEntryTrans)job.getActiveJobEntryTransformations().get(jobEntryCopy);
        if (jobEntryTrans == null) {
            return null;
        }
        return jobEntryTrans.getTrans();
    }

    public Job findActiveJob(Job job, JobEntryCopy jobEntryCopy) {
        JobEntryJob jobEntryJob = (JobEntryJob)job.getActiveJobEntryJobs().get(jobEntryCopy);
        if (jobEntryJob == null) {
            return null;
        }
        return jobEntryJob.getJob();
    }

    public Object getSelectionObject() {
        return this.selectionObject;
    }

    public RepositoryDirectoryInterface getDefaultSaveLocation(RepositoryElementInterface repositoryElement) {
        try {
            if (this.getRepository() != this.defaultSaveLocationRepository) {
                this.defaultSaveLocation = null;
                this.defaultSaveLocationRepository = null;
            }
            if (this.defaultSaveLocation == null) {
                if (this.getRepository() != null) {
                    this.defaultSaveLocation = this.getRepository().getDefaultSaveDirectory(repositoryElement);
                    this.defaultSaveLocationRepository = this.getRepository();
                } else {
                    this.defaultSaveLocation = new RepositoryDirectory();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.defaultSaveLocation;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String attr, Object previousVal, Object newVal) {
        if (previousVal == null && newVal == null) {
            return;
        }
        this.changeSupport.firePropertyChange(attr, previousVal, newVal);
    }

    public Object getData() {
        return null;
    }

    public String getName() {
        return "spoon";
    }

    public XulDomContainer getXulDomContainer() {
        return this.getMainSpoonContainer();
    }

    public void setData(Object arg0) {
    }

    public void setName(String arg0) {
    }

    public void setXulDomContainer(XulDomContainer arg0) {
    }

    public RepositorySecurityManager getSecurityManager() {
        return this.rep.getSecurityManager();
    }

    public void displayDbDependancies() {
        int nrChilds;
        TreeItem[] selection = this.selectionTree.getSelection();
        if (selection == null || selection.length != 1) {
            return;
        }
        TreeItem parent = selection[0];
        if (parent != null && (nrChilds = parent.getItemCount()) > 0) {
            for (int i = 0; i < nrChilds; ++i) {
                parent.getItem(i).dispose();
            }
        }
        if (this.rep == null) {
            return;
        }
        try {
            DatabaseMeta databaseMeta = (DatabaseMeta)this.selectionObject;
            String[] jobList = this.rep.getJobsUsingDatabase(databaseMeta.getObjectId());
            String[] transList = this.rep.getTransformationsUsingDatabase(databaseMeta.getObjectId());
            if (jobList.length == 0 && transList.length == 0) {
                MessageBox box = new MessageBox(this.shell, 34);
                box.setText("Connection dependencies");
                box.setMessage("This connection is not used by a job nor a transformation.");
                box.open();
            } else {
                for (String aJobList : jobList) {
                    if (aJobList == null) continue;
                    this.createTreeItem(parent, aJobList, GUIResource.getInstance().getImageJobGraph());
                }
                for (String aTransList : transList) {
                    if (aTransList == null) continue;
                    this.createTreeItem(parent, aTransList, GUIResource.getInstance().getImageTransGraph());
                }
                parent.setExpanded(true);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error getting dependencies! :", e);
        }
    }

    public void fireMenuControlers() {
        if (!Display.getDefault().getThread().equals(Thread.currentThread())) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Spoon.this.fireMenuControlers();
                }
            });
            return;
        }
        if (this.mainSpoonContainer != null) {
            Document doc = this.mainSpoonContainer.getDocumentRoot();
            for (ISpoonMenuController menuController : this.menuControllers) {
                menuController.updateMenu(doc);
            }
        }
    }

    public void hideSplash() {
        if (splash != null) {
            splash.hide();
        }
    }

    private void showSplash() {
        if (splash != null) {
            splash.show();
        }
    }

    public void setMainToolbarVisible(boolean visible) {
        this.mainToolbar.setVisible(visible);
    }

    public void setMenuBarVisible(boolean visible) {
        this.mainSpoonContainer.getDocumentRoot().getElementById("edit").setVisible(visible);
        this.mainSpoonContainer.getDocumentRoot().getElementById("file").setVisible(visible);
        this.mainSpoonContainer.getDocumentRoot().getElementById("view").setVisible(visible);
        this.mainSpoonContainer.getDocumentRoot().getElementById("action").setVisible(visible);
        this.mainSpoonContainer.getDocumentRoot().getElementById("tools").setVisible(visible);
        this.mainSpoonContainer.getDocumentRoot().getElementById("help").setVisible(visible);
        MenuManager menuManager = this.getMenuBarManager();
        menuManager.getMenu().setVisible(visible);
        menuManager.updateAll(true);
    }

    protected Control createContents(Composite parent) {
        MessageBox box;
        this.shell = this.getShell();
        this.init(null);
        this.openSpoon();
        try {
            this.lifecycleSupport.onStart((LifeEventHandler)this);
        }
        catch (LifecycleException e) {
            box = new MessageBox(this.shell, (e.isSevere() ? 1 : 8) | 0x20);
            box.setMessage(e.getMessage());
            box.open();
        }
        try {
            this.start(this.commandLineOptions);
        }
        catch (KettleException e) {
            box = new MessageBox(this.shell, 33);
            box.setMessage(e.getMessage());
            box.open();
        }
        this.getMenuBarManager().updateAll(true);
        return parent;
    }

    public void start() {
        this.setBlockOnOpen(false);
        try {
            this.open();
            this.waitForDispose();
        }
        catch (Throwable e) {
            LogChannel.GENERAL.logError("Error starting Spoon shell", e);
        }
        System.out.println("stopping");
    }

    public String getStartupPerspective() {
        return this.startupPerspective;
    }

    public DelegatingMetaStore getMetaStore() {
        return this.metaStore;
    }

    public void setMetaStore(DelegatingMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    private void onLoginError(Throwable t) {
        if (t instanceof KettleAuthException) {
            ShowMessageDialog dialog = new ShowMessageDialog(this.loginDialog.getShell(), 33, BaseMessages.getString(PKG, (String)"Spoon.Dialog.LoginFailed.Title", (String[])new String[0]), t.getLocalizedMessage());
            dialog.open();
        } else {
            new ErrorDialog(this.loginDialog.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.LoginFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.LoginFailed.Message", (Object[])new Object[]{t}), t);
        }
    }

    protected void handleShellCloseEvent() {
        try {
            if (this.quitFile(true)) {
                SpoonPluginManager.getInstance().notifyLifecycleListeners(SpoonLifecycleListener.SpoonLifeCycleEvent.SHUTDOWN);
                super.handleShellCloseEvent();
            }
        }
        catch (Exception e) {
            LogChannel.GENERAL.logError("Error closing Spoon", (Throwable)e);
        }
    }

    public void showAuthenticationOptions() {
        AuthProviderDialog authProviderDialog = new AuthProviderDialog(this.shell);
        authProviderDialog.show();
    }

    static {
        APP_TITLE = APP_NAME;
        STRING_WELCOME_TAB_NAME = BaseMessages.getString(PKG, (String)"Spoon.Title.STRING_WELCOME", (String[])new String[0]);
        STRING_DOCUMENT_TAB_NAME = BaseMessages.getString(PKG, (String)"Spoon.Documentation", (String[])new String[0]);
        FILE_WELCOME_PAGE = Const.safeAppendDirectory((String)BasePropertyHandler.getProperty((String)"documentationDirBase", (String)"docs/"), (String)BaseMessages.getString(PKG, (String)"Spoon.Title.STRING_DOCUMENT_WELCOME", (String[])new String[0]));
        FILE_DOCUMENT_MAP = Const.safeAppendDirectory((String)BasePropertyHandler.getProperty((String)"documentationDirBase", (String)"docs/"), (String)BaseMessages.getString(PKG, (String)"Spoon.Title.STRING_DOCUMENT_MAP", (String[])new String[0]));
        FILE_DOCUMENT_INSTAVIEW = Const.safeAppendDirectory((String)BasePropertyHandler.getProperty((String)"documentationDirBase", (String)"docs/"), (String)BaseMessages.getString(PKG, (String)"Spoon.Title.STRING_DOCUMENT_INSTAVIEW", (String[])new String[0]));
        UNDO_UNAVAILABLE = BaseMessages.getString(PKG, (String)"Spoon.Menu.Undo.NotAvailable", (String[])new String[0]);
        REDO_UNAVAILABLE = BaseMessages.getString(PKG, (String)"Spoon.Menu.Redo.NotAvailable", (String[])new String[0]);
    }
}

