/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.dialog;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryCapabilities;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.repository.RepositorySecurityProvider;
import org.pentaho.di.repository.UserInfo;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.cluster.dialog.ClusterSchemaDialog;
import org.pentaho.di.ui.cluster.dialog.SlaveServerDialog;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.dialog.EnterStringDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.DoubleClickInterface;
import org.pentaho.di.ui.core.widget.TreeItemAccelerator;
import org.pentaho.di.ui.core.widget.TreeMemory;
import org.pentaho.di.ui.partition.dialog.PartitionSchemaDialog;
import org.pentaho.di.ui.repository.RepositoryDirectoryUI;
import org.pentaho.di.ui.repository.RepositorySecurityUI;
import org.pentaho.di.ui.repository.dialog.RepositoryExportProgressDialog;
import org.pentaho.di.ui.repository.dialog.RepositoryImportProgressDialog;
import org.pentaho.di.ui.repository.dialog.RepositoryRevisionBrowserDialogInterface;
import org.pentaho.di.ui.repository.dialog.SelectDirectoryDialog;
import org.pentaho.di.ui.repository.dialog.UserDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RepositoryExplorerDialog
extends Dialog {
    private static Class<?> PKG = RepositoryExplorerDialog.class;
    private static final String REPOSITORY_PKG = "org.pentaho.di.ui.repository";
    private static final String STRING_DATABASES = BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Tree.String.Connections", (String[])new String[0]);
    private static final String STRING_PARTITIONS = BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Tree.String.Partitions", (String[])new String[0]);
    private static final String STRING_SLAVES = BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Tree.String.Slaves", (String[])new String[0]);
    private static final String STRING_CLUSTERS = BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Tree.String.Clusters", (String[])new String[0]);
    public static final String STRING_TRANSFORMATIONS = BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Tree.String.Transformations", (String[])new String[0]);
    public static final String STRING_JOBS = BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Tree.String.Jobs", (String[])new String[0]);
    private static final String STRING_USERS = BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Tree.String.Users", (String[])new String[0]);
    private static final int ITEM_CATEGORY_NONE = 0;
    private static final int ITEM_CATEGORY_ROOT = 1;
    private static final int ITEM_CATEGORY_DATABASES_ROOT = 2;
    private static final int ITEM_CATEGORY_DATABASE = 3;
    private static final int ITEM_CATEGORY_TRANSFORMATIONS_ROOT = 4;
    private static final int ITEM_CATEGORY_TRANSFORMATION = 5;
    private static final int ITEM_CATEGORY_TRANSFORMATION_DIRECTORY = 6;
    private static final int ITEM_CATEGORY_JOBS_ROOT = 7;
    private static final int ITEM_CATEGORY_JOB = 8;
    private static final int ITEM_CATEGORY_JOB_DIRECTORY = 9;
    private static final int ITEM_CATEGORY_USERS_ROOT = 10;
    private static final int ITEM_CATEGORY_USER = 11;
    private static final int ITEM_CATEGORY_PARTITIONS_ROOT = 14;
    private static final int ITEM_CATEGORY_PARTITION = 15;
    private static final int ITEM_CATEGORY_SLAVES_ROOT = 16;
    private static final int ITEM_CATEGORY_SLAVE = 17;
    private static final int ITEM_CATEGORY_CLUSTERS_ROOT = 18;
    private static final int ITEM_CATEGORY_CLUSTER = 19;
    private Shell shell;
    private Tree wTree;
    private Button wOK;
    private LogChannelInterface log;
    private PropsUI props = PropsUI.getInstance();
    private Repository rep;
    private String debug;
    private int sortColumn;
    private boolean ascending;
    private TreeColumn nameColumn;
    private TreeColumn typeColumn;
    private TreeColumn userColumn;
    private TreeColumn changedColumn;
    private TreeColumn descriptionColumn;
    private TreeColumn lockColumn;
    private RepositoryExplorerCallback callback;
    private RepositoryObjectReference lastOpened;
    private VariableSpace variableSpace;
    private ToolItem exportToXML;
    private ToolItem importFromXML;
    private ToolItem showHideDeleted;
    private ToolItem expandAll;
    private ToolItem collapseAll;
    private FormData fdTreeTb;
    private RepositoryDirectoryInterface directoryTree;
    private RepositoryMeta repositoryMeta;
    private RepositoryCapabilities capabilities;
    private boolean readonly;
    private RepositorySecurityProvider securityProvider;
    private RepositorySecurityManager securityManager;
    private boolean includeDeleted;
    private Map<String, RepositoryElementMetaInterface> objectMap;
    DatabaseDialog databaseDialog;
    private static final String STRING_REPOSITORY_EXPLORER_TREE_NAME = "Repository Exporer Tree Name";

    private RepositoryExplorerDialog(Shell par, int style, Repository rep, VariableSpace variableSpace) {
        super(par, style);
        this.rep = rep;
        this.log = rep.getLog();
        this.variableSpace = variableSpace;
        this.sortColumn = 0;
        this.ascending = false;
        this.objectMap = new HashMap<String, RepositoryElementMetaInterface>();
        this.repositoryMeta = rep.getRepositoryMeta();
        this.capabilities = this.repositoryMeta.getRepositoryCapabilities();
        this.securityProvider = rep.getSecurityProvider();
        this.securityManager = rep.getSecurityManager();
        this.readonly = this.securityProvider.isReadOnly();
        this.includeDeleted = false;
    }

    public RepositoryExplorerDialog(Shell par, int style, Repository rep, RepositoryExplorerCallback callback, VariableSpace variableSpace) {
        this(par, style, rep, variableSpace);
        this.callback = callback;
    }

    private DatabaseDialog getDatabaseDialog() {
        if (this.databaseDialog != null) {
            return this.databaseDialog;
        }
        this.databaseDialog = new DatabaseDialog(this.shell);
        return this.databaseDialog;
    }

    public RepositoryObjectReference open() {
        this.debug = "opening repository explorer";
        try {
            this.debug = "open new independent shell";
            Shell parent = this.getParent();
            Display display = parent.getDisplay();
            this.shell = new Shell(display, 3312);
            this.props.setLook((Control)this.shell);
            this.shell.setImage(GUIResource.getInstance().getImageFolderConnections());
            this.shell.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Title", (String[])new String[0]) + this.rep.getName() + "]");
            FormLayout formLayout = new FormLayout();
            formLayout.marginWidth = 5;
            formLayout.marginHeight = 5;
            this.shell.setLayout((Layout)formLayout);
            ToolBar treeTb = new ToolBar((Composite)this.shell, 0x800100);
            this.props.setLook((Control)treeTb);
            this.fdTreeTb = new FormData();
            this.fdTreeTb.left = new FormAttachment(0, 0);
            this.fdTreeTb.top = new FormAttachment(0, 0);
            treeTb.setLayoutData((Object)this.fdTreeTb);
            this.exportToXML = new ToolItem(treeTb, 8);
            this.exportToXML.setImage(GUIResource.getInstance().getImageExport());
            this.exportToXML.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.ToolItem.ExportToXML.Label", (String[])new String[0]));
            this.exportToXML.setToolTipText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.ToolItem.ExportToXML.Tooltip", (String[])new String[0]));
            this.importFromXML = new ToolItem(treeTb, 8);
            this.importFromXML.setImage(GUIResource.getInstance().getImageImport());
            this.importFromXML.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.ToolItem.ImportFromXML.Label", (String[])new String[0]));
            this.importFromXML.setToolTipText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.ToolItem.ImportFromXML.Tooltip", (String[])new String[0]));
            new ToolItem(treeTb, 2);
            this.showHideDeleted = new ToolItem(treeTb, 8);
            this.showHideDeleted.setImage(GUIResource.getInstance().getImageShowDeleted());
            this.showHideDeleted.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.ToolItem.ShowDeleted.Label", (String[])new String[0]));
            this.showHideDeleted.setToolTipText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.ToolItem.ShowDeleted.Tooltip", (String[])new String[0]));
            this.showHideDeleted.setEnabled(this.rep.getRepositoryMeta().getRepositoryCapabilities().supportsRevisions());
            new ToolItem(treeTb, 2);
            this.expandAll = new ToolItem(treeTb, 8);
            this.expandAll.setImage(GUIResource.getInstance().getImageExpandAll());
            this.expandAll.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.ToolItem.ExpandAll.Label", (String[])new String[0]));
            this.expandAll.setToolTipText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.ToolItem.ExpandAll.Tooltip", (String[])new String[0]));
            this.collapseAll = new ToolItem(treeTb, 8);
            this.collapseAll.setImage(GUIResource.getInstance().getImageCollapseAll());
            this.collapseAll.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.ToolItem.CollapseAll.Label", (String[])new String[0]));
            this.collapseAll.setToolTipText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.ToolItem.CollapseAll.Tooltip", (String[])new String[0]));
            this.wTree = new Tree((Composite)this.shell, 2050);
            this.wTree.setHeaderVisible(true);
            this.props.setLook((Control)this.wTree);
            this.nameColumn = new TreeColumn(this.wTree, 16384);
            this.nameColumn.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Column.Name", (String[])new String[0]));
            this.nameColumn.setWidth(350);
            this.nameColumn.setAlignment(10);
            this.nameColumn.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    RepositoryExplorerDialog.this.setSort(0);
                }
            });
            this.typeColumn = new TreeColumn(this.wTree, 16384);
            this.typeColumn.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Column.Type", (String[])new String[0]));
            this.typeColumn.setWidth(100);
            this.typeColumn.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    RepositoryExplorerDialog.this.setSort(1);
                }
            });
            this.userColumn = new TreeColumn(this.wTree, 16384);
            this.userColumn.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Column.User", (String[])new String[0]));
            this.userColumn.setWidth(100);
            this.userColumn.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    RepositoryExplorerDialog.this.setSort(2);
                }
            });
            this.changedColumn = new TreeColumn(this.wTree, 16384);
            this.changedColumn.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Column.Changed", (String[])new String[0]));
            this.changedColumn.setWidth(120);
            this.changedColumn.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    RepositoryExplorerDialog.this.setSort(3);
                }
            });
            this.descriptionColumn = new TreeColumn(this.wTree, 16384);
            this.descriptionColumn.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Column.Description", (String[])new String[0]));
            this.descriptionColumn.setWidth(120);
            this.descriptionColumn.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    RepositoryExplorerDialog.this.setSort(4);
                }
            });
            this.lockColumn = new TreeColumn(this.wTree, 16384);
            this.lockColumn.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Column.LockMessage", (String[])new String[0]));
            this.lockColumn.setWidth(120);
            this.lockColumn.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    RepositoryExplorerDialog.this.setSort(5);
                }
            });
            TreeMemory.addTreeListener(this.wTree, STRING_REPOSITORY_EXPLORER_TREE_NAME);
            this.wOK = new Button((Composite)this.shell, 8);
            this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
            FormData fdTree = new FormData();
            int margin = 10;
            fdTree.left = new FormAttachment(0, 0);
            fdTree.top = new FormAttachment((Control)treeTb, 0);
            fdTree.right = new FormAttachment(100, 0);
            fdTree.bottom = new FormAttachment(100, -50);
            this.wTree.setLayoutData((Object)fdTree);
            BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK}, margin, null);
            this.wOK.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    RepositoryExplorerDialog.this.close();
                }
            });
            this.wTree.addMenuDetectListener(new MenuDetectListener(){

                public void menuDetected(MenuDetectEvent e) {
                    RepositoryExplorerDialog.this.setTreeMenu();
                }
            });
            this.wTree.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    if (e.button == 1) {
                        RepositoryExplorerDialog.this.doDoubleClick();
                    }
                }
            });
            this.wTree.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 0x100000B && !RepositoryExplorerDialog.this.readonly) {
                        RepositoryExplorerDialog.this.renameInTree();
                    }
                    if (e.keyCode == 0x100000E) {
                        RepositoryExplorerDialog.this.refreshTree();
                    }
                }
            });
            this.expandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    RepositoryExplorerDialog.this.expandAllItems(RepositoryExplorerDialog.this.wTree.getItems(), true);
                }
            });
            this.collapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    RepositoryExplorerDialog.this.expandAllItems(RepositoryExplorerDialog.this.wTree.getItems(), false);
                }
            });
            this.importFromXML.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    RepositoryExplorerDialog.this.importAll();
                }
            });
            this.exportToXML.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    RepositoryExplorerDialog.this.exportAll(null);
                }
            });
            this.showHideDeleted.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    RepositoryExplorerDialog.this.includeDeleted = !RepositoryExplorerDialog.this.includeDeleted;
                    if (RepositoryExplorerDialog.this.includeDeleted) {
                        RepositoryExplorerDialog.this.showHideDeleted.setText(BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.ToolItem.HideDeleted.Label", (String[])new String[0]));
                        RepositoryExplorerDialog.this.showHideDeleted.setToolTipText(BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.ToolItem.HideDeleted.Tooltip", (String[])new String[0]));
                    } else {
                        RepositoryExplorerDialog.this.showHideDeleted.setText(BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.ToolItem.ShowDeleted.Label", (String[])new String[0]));
                        RepositoryExplorerDialog.this.showHideDeleted.setToolTipText(BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.ToolItem.ShowDeleted.Tooltip", (String[])new String[0]));
                    }
                    RepositoryExplorerDialog.this.refreshTree();
                }
            });
            Transfer[] ttypes = new Transfer[]{TextTransfer.getInstance()};
            DragSource ddSource = new DragSource((Control)this.wTree, 2);
            ddSource.setTransfer(ttypes);
            ddSource.addDragListener(new DragSourceListener(){

                public void dragStart(DragSourceEvent event) {
                    RepositoryExplorerDialog.this.debug = "drag start";
                    event.doit = true;
                }

                public void dragSetData(DragSourceEvent event) {
                    RepositoryExplorerDialog.this.debug = "drag set data";
                    event.data = "";
                    event.doit = false;
                    TreeItem[] ti = RepositoryExplorerDialog.this.wTree.getSelection();
                    if (ti.length >= 1) {
                        int cat = RepositoryExplorerDialog.this.getItemCategory(ti[0]);
                        if (cat == 5) {
                            RepositoryExplorerDialog.this.debug = "drag set: drag around transformation";
                            RepositoryDirectoryInterface repdir = RepositoryExplorerDialog.this.getDirectory(ti[0]);
                            if (repdir != null) {
                                String xml = XMLHandler.getXMLHeader();
                                xml = xml + "<dragdrop>" + Const.CR;
                                xml = xml + "  " + XMLHandler.addTagValue((String)"directory", (String)repdir.getPath());
                                xml = xml + "  " + XMLHandler.addTagValue((String)"transformation", (String)ti[0].getText());
                                xml = xml + "</dragdrop>" + Const.CR;
                                event.data = xml;
                                event.doit = true;
                            }
                        } else if (cat == 8) {
                            RepositoryExplorerDialog.this.debug = "drag set: drag around job";
                            RepositoryDirectoryInterface repdir = RepositoryExplorerDialog.this.getDirectory(ti[0]);
                            if (repdir != null) {
                                String xml = XMLHandler.getXMLHeader();
                                xml = xml + "<dragdrop>" + Const.CR;
                                xml = xml + "  " + XMLHandler.addTagValue((String)"directory", (String)repdir.getPath());
                                xml = xml + "  " + XMLHandler.addTagValue((String)"job", (String)ti[0].getText());
                                xml = xml + "</dragdrop>" + Const.CR;
                                event.data = xml;
                                event.doit = true;
                            }
                        } else {
                            RepositoryExplorerDialog.this.debug = "do nothing";
                            String xml = XMLHandler.getXMLHeader();
                            xml = xml + "<dragdrop>" + Const.CR;
                            xml = xml + "</dragdrop>" + Const.CR;
                            event.data = xml;
                            event.doit = true;
                        }
                    }
                }

                public void dragFinished(DragSourceEvent event) {
                }
            });
            DropTarget ddTarget = new DropTarget((Control)this.wTree, 2);
            ddTarget.setTransfer(ttypes);
            ddTarget.addDropListener(new DropTargetListener(){

                public void dragEnter(DropTargetEvent event) {
                }

                public void dragLeave(DropTargetEvent event) {
                    RepositoryExplorerDialog.this.debug = "drag leave";
                }

                public void dragOperationChanged(DropTargetEvent event) {
                }

                public void dragOver(DropTargetEvent event) {
                    RepositoryExplorerDialog.this.debug = "drag over";
                }

                public void drop(DropTargetEvent event) {
                    try {
                        RepositoryExplorerDialog.this.debug = "Drop item in tree";
                        if (event.data == null) {
                            event.detail = 0;
                            return;
                        }
                        TreeItem ti = (TreeItem)event.item;
                        if (ti != null) {
                            RepositoryExplorerDialog.this.debug = "Get category";
                            int category = RepositoryExplorerDialog.this.getItemCategory(ti);
                            if (category == 6 || category == 5) {
                                RepositoryExplorerDialog.this.debug = "Get directory";
                                RepositoryDirectoryInterface repdir = RepositoryExplorerDialog.this.getDirectory(ti);
                                if (repdir != null) {
                                    event.feedback = 9;
                                    if (RepositoryExplorerDialog.this.moveTransformation((String)event.data, repdir)) {
                                        RepositoryExplorerDialog.this.refreshTree();
                                    } else {
                                        MessageBox mb = new MessageBox(RepositoryExplorerDialog.this.shell, 34);
                                        mb.setMessage(BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.Trans.Move.UnableToMove.Message", (String[])new String[0]));
                                        mb.setText(BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.Trans.Move.UnableToMove.Title", (String[])new String[0]));
                                        mb.open();
                                    }
                                }
                            } else if (category == 9 || category == 8) {
                                RepositoryExplorerDialog.this.debug = "Get directory";
                                RepositoryDirectoryInterface repdir = RepositoryExplorerDialog.this.getDirectory(ti);
                                if (repdir != null) {
                                    event.feedback = 9;
                                    if (RepositoryExplorerDialog.this.moveJob((String)event.data, repdir)) {
                                        RepositoryExplorerDialog.this.refreshTree();
                                    } else {
                                        MessageBox mb = new MessageBox(RepositoryExplorerDialog.this.shell, 34);
                                        mb.setMessage(BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.Job.Move.UnableToMove.Message", (String[])new String[0]));
                                        mb.setText(BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.Job.Move.UnableToMove.Title", (String[])new String[0]));
                                        mb.open();
                                    }
                                }
                            } else {
                                MessageBox mb = new MessageBox(RepositoryExplorerDialog.this.shell, 34);
                                mb.setMessage(BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.Trans.Move.SorryOneItemAtATime.Message", (String[])new String[0]));
                                mb.setText(BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.Trans.Move.SorryOneItemAtATime.Title", (String[])new String[0]));
                                mb.open();
                            }
                        }
                    }
                    catch (Throwable e) {
                        new ErrorDialog(RepositoryExplorerDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.Drop.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.Drop.UnexpectedError.Message1", (String[])new String[0]) + RepositoryExplorerDialog.this.debug + "]" + Const.CR + BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.Drop.UnexpectedError.Message2", (String[])new String[0]), e);
                    }
                }

                public void dropAccept(DropTargetEvent event) {
                    RepositoryExplorerDialog.this.debug = "drop accept";
                }
            });
            this.shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    RepositoryExplorerDialog.this.close();
                }
            });
            this.debug = "set screen size and position";
            BaseStepDialog.setSize(this.shell, 400, 480, true);
            this.setSort(0);
            this.shell.open();
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Throwable e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Main.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Main.UnexpectedError.Message1", (String[])new String[0]) + this.debug + "]" + Const.CR + BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Main.UnexpectedError.Message2", (String[])new String[0]) + Const.CR + BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Main.UnexpectedError.Message3", (String[])new String[0]), e);
        }
        return this.lastOpened;
    }

    private void expandAllItems(TreeItem[] treeitems, boolean expand) {
        for (TreeItem item : treeitems) {
            item.setExpanded(expand);
            TreeMemory.getInstance().storeExpanded(STRING_REPOSITORY_EXPLORER_TREE_NAME, ConstUI.getTreeStrings(item), expand);
            if (item.getItemCount() <= 0) continue;
            this.expandAllItems(item.getItems(), expand);
        }
    }

    protected void setSort(int i) {
        if (this.sortColumn == i) {
            this.ascending = !this.ascending;
        } else {
            this.sortColumn = i;
            this.ascending = true;
        }
        if (this.sortColumn >= 0 && this.sortColumn < 5) {
            TreeColumn column = this.wTree.getColumn(this.sortColumn);
            this.wTree.setSortColumn(column);
            this.wTree.setSortDirection(this.ascending ? 128 : 1024);
        }
        this.refreshTree();
    }

    public RepositoryDirectoryInterface getDirectory(TreeItem ti) {
        RepositoryDirectoryInterface repdir = null;
        int level = ConstUI.getTreeLevel(ti);
        String[] path = ConstUI.getTreeStrings(ti);
        if (level > 1) {
            int cat = this.getItemCategory(ti);
            switch (cat) {
                case 5: 
                case 8: {
                    String[] realpath = new String[level - 2];
                    for (int i = 0; i < realpath.length; ++i) {
                        realpath[i] = path[i + 2];
                    }
                    repdir = this.directoryTree.findDirectory(realpath);
                    break;
                }
                case 6: 
                case 9: {
                    String[] realpath = new String[level - 1];
                    for (int i = 0; i < realpath.length; ++i) {
                        realpath[i] = path[i + 2];
                    }
                    repdir = this.directoryTree.findDirectory(realpath);
                    break;
                }
            }
        }
        return repdir;
    }

    public boolean sameCategory(TreeItem[] tisel) {
        if (tisel.length == 0) {
            return false;
        }
        int cat = this.getItemCategory(tisel[0]);
        for (int i = 1; i < tisel.length; ++i) {
            if (cat == this.getItemCategory(tisel[i])) continue;
            return false;
        }
        return true;
    }

    public void doDoubleClick() {
        TreeItem[] tisel = this.wTree.getSelection();
        if (tisel.length == 1 || this.sameCategory(tisel)) {
            TreeItem ti = tisel[0];
            int level = ConstUI.getTreeLevel(ti);
            int cat = this.getItemCategory(ti);
            if (level >= 2 && (cat == 9 || cat == 6 || cat == 8 || cat == 5)) {
                String[] realpath = cat == 9 || cat == 6 ? new String[level - 1] : new String[level - 2];
                String[] path = ConstUI.getTreeStrings(ti);
                for (int i = 0; i < realpath.length; ++i) {
                    realpath[i] = path[i + 2];
                }
                RepositoryDirectoryInterface repdir = this.directoryTree.findDirectory(realpath);
                switch (cat) {
                    case 6: 
                    case 9: {
                        if (this.readonly) break;
                        this.createDirectory(ti, repdir);
                        break;
                    }
                    case 5: {
                        this.openTransformation(ti.getText(), repdir);
                        break;
                    }
                    case 8: {
                        this.openJob(ti.getText(), repdir);
                        break;
                    }
                }
            }
        }
    }

    public void setTreeMenu() {
        Menu mTree = new Menu((Decorations)this.shell, 8);
        TreeItem[] tisel = this.wTree.getSelection();
        if (tisel.length == 1 || this.sameCategory(tisel)) {
            final TreeItem ti = tisel[0];
            int level = ConstUI.getTreeLevel(ti);
            String[] path = ConstUI.getTreeStrings(ti);
            String fullPath = ConstUI.getTreePath(ti, 0);
            final String item = ti.getText();
            RepositoryElementMetaInterface repositoryObject = this.objectMap.get(fullPath);
            int cat = this.getItemCategory(ti);
            switch (cat) {
                case 1: {
                    MenuItem miExp = new MenuItem(mTree, 8);
                    miExp.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Objects.ExportAll", (String[])new String[0]));
                    SelectionAdapter lsExp = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.exportAll(RepositoryExplorerDialog.this.directoryTree);
                        }
                    };
                    miExp.addSelectionListener((SelectionListener)lsExp);
                    MenuItem miImp = new MenuItem(mTree, 8);
                    miImp.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Objects.ImportAll", (String[])new String[0]));
                    SelectionAdapter lsImp = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.importAll();
                        }
                    };
                    miImp.addSelectionListener((SelectionListener)lsImp);
                    miImp.setEnabled(!this.readonly);
                    MenuItem miTrans = new MenuItem(mTree, 8);
                    miTrans.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Objects.ExportTrans", (String[])new String[0]));
                    SelectionAdapter lsTrans = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.exportTransformations(RepositoryExplorerDialog.this.directoryTree);
                        }
                    };
                    miTrans.addSelectionListener((SelectionListener)lsTrans);
                    MenuItem miJobs = new MenuItem(mTree, 8);
                    miJobs.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Objects.ExportJob", (String[])new String[0]));
                    SelectionAdapter lsJobs = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.exportJobs(RepositoryExplorerDialog.this.directoryTree);
                        }
                    };
                    miJobs.addSelectionListener((SelectionListener)lsJobs);
                    break;
                }
                case 2: {
                    MenuItem miNew = new MenuItem(mTree, 8);
                    miNew.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.ConnectionsRoot.New", (String[])new String[0]));
                    SelectionAdapter lsNew = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.newDatabase();
                        }
                    };
                    miNew.addSelectionListener((SelectionListener)lsNew);
                    miNew.setEnabled(!this.readonly);
                    break;
                }
                case 3: {
                    MenuItem miNew = new MenuItem(mTree, 8);
                    miNew.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Connections.New", (String[])new String[0]));
                    SelectionAdapter lsNew = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.newDatabase();
                        }
                    };
                    miNew.addSelectionListener((SelectionListener)lsNew);
                    miNew.setEnabled(!this.readonly);
                    MenuItem miEdit = new MenuItem(mTree, 8);
                    miEdit.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Connections.Edit", (String[])new String[0]));
                    SelectionAdapter lsEdit = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.editDatabase(item);
                        }
                    };
                    miEdit.addSelectionListener((SelectionListener)lsEdit);
                    miEdit.setEnabled(!this.readonly);
                    MenuItem miDel = new MenuItem(mTree, 8);
                    miDel.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Connections.Delete", (String[])new String[0]));
                    SelectionAdapter lsDel = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.delDatabase(item);
                        }
                    };
                    miDel.addSelectionListener((SelectionListener)lsDel);
                    miDel.setEnabled(!this.readonly);
                    break;
                }
                case 16: {
                    MenuItem miNew = new MenuItem(mTree, 8);
                    miNew.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Slave.New", (String[])new String[0]));
                    SelectionAdapter lsNew = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.newSlaveServer();
                        }
                    };
                    miNew.addSelectionListener((SelectionListener)lsNew);
                    miNew.setEnabled(!this.readonly);
                    break;
                }
                case 17: {
                    MenuItem miNew = new MenuItem(mTree, 8);
                    miNew.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Slave.New", (String[])new String[0]));
                    SelectionAdapter lsNew = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.newSlaveServer();
                        }
                    };
                    miNew.addSelectionListener((SelectionListener)lsNew);
                    miNew.setEnabled(!this.readonly);
                    MenuItem miEdit = new MenuItem(mTree, 8);
                    miEdit.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Slave.Edit", (String[])new String[0]));
                    SelectionAdapter lsEdit = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.editSlaveServer(item);
                        }
                    };
                    miEdit.addSelectionListener((SelectionListener)lsEdit);
                    miEdit.setEnabled(!this.readonly);
                    MenuItem miDel = new MenuItem(mTree, 8);
                    miDel.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Slave.Delete", (String[])new String[0]));
                    SelectionAdapter lsDel = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.delSlaveServer(item);
                        }
                    };
                    miDel.addSelectionListener((SelectionListener)lsDel);
                    miDel.setEnabled(!this.readonly);
                    break;
                }
                case 14: {
                    MenuItem miNew = new MenuItem(mTree, 8);
                    miNew.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.PartitionSchema.New", (String[])new String[0]));
                    SelectionAdapter lsNew = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.newPartitionSchema();
                        }
                    };
                    miNew.addSelectionListener((SelectionListener)lsNew);
                    miNew.setEnabled(!this.readonly);
                    break;
                }
                case 15: {
                    MenuItem miNew = new MenuItem(mTree, 8);
                    miNew.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.PartitionSchema.New", (String[])new String[0]));
                    SelectionAdapter lsNew = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.newPartitionSchema();
                        }
                    };
                    miNew.addSelectionListener((SelectionListener)lsNew);
                    miNew.setEnabled(!this.readonly);
                    MenuItem miEdit = new MenuItem(mTree, 8);
                    miEdit.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.PartitionSchema.Edit", (String[])new String[0]));
                    SelectionAdapter lsEdit = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.editPartitionSchema(item);
                        }
                    };
                    miEdit.addSelectionListener((SelectionListener)lsEdit);
                    miEdit.setEnabled(!this.readonly);
                    MenuItem miDel = new MenuItem(mTree, 8);
                    miDel.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.PartitionSchema.Delete", (String[])new String[0]));
                    SelectionAdapter lsDel = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.delPartitionSchema(item);
                        }
                    };
                    miDel.addSelectionListener((SelectionListener)lsDel);
                    miDel.setEnabled(!this.readonly);
                    break;
                }
                case 18: {
                    MenuItem miNew = new MenuItem(mTree, 8);
                    miNew.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Cluster.New", (String[])new String[0]));
                    SelectionAdapter lsNew = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.newCluster();
                        }
                    };
                    miNew.addSelectionListener((SelectionListener)lsNew);
                    miNew.setEnabled(!this.readonly);
                    break;
                }
                case 19: {
                    MenuItem miNew = new MenuItem(mTree, 8);
                    miNew.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Cluster.New", (String[])new String[0]));
                    SelectionAdapter lsNew = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.newCluster();
                        }
                    };
                    miNew.addSelectionListener((SelectionListener)lsNew);
                    miNew.setEnabled(!this.readonly);
                    MenuItem miEdit = new MenuItem(mTree, 8);
                    miEdit.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Cluster.Edit", (String[])new String[0]));
                    SelectionAdapter lsEdit = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.editCluster(item);
                        }
                    };
                    miEdit.addSelectionListener((SelectionListener)lsEdit);
                    miEdit.setEnabled(!this.readonly);
                    MenuItem miDel = new MenuItem(mTree, 8);
                    miDel.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Cluster.Delete", (String[])new String[0]));
                    SelectionAdapter lsDel = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.delCluster(item);
                        }
                    };
                    miDel.addSelectionListener((SelectionListener)lsDel);
                    miDel.setEnabled(!this.readonly);
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    if (level < 2 || repositoryObject == null) break;
                    final RepositoryDirectoryInterface repdir = repositoryObject.getRepositoryDirectory();
                    if (tisel.length == 1 && !repositoryObject.isDeleted()) {
                        MenuItem miOpen = new MenuItem(mTree, 8);
                        miOpen.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Transformations.Open", (String[])new String[0]));
                        miOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                RepositoryExplorerDialog.this.openTransformation(item, repdir);
                            }
                        });
                        MenuItem miRen = new MenuItem(mTree, 8);
                        miRen.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Transformations.Rename", (String[])new String[0]));
                        miRen.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                RepositoryExplorerDialog.this.renameTransformation(item, repdir);
                            }
                        });
                        miRen.setEnabled(!this.readonly);
                    }
                    if (repositoryObject.isDeleted()) {
                        if (!this.capabilities.supportsRevisions()) break;
                        MenuItem miRestore = new MenuItem(mTree, 8);
                        miRestore.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Transformations.Restore", (String[])new String[0]));
                        miRestore.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                RepositoryExplorerDialog.this.restoreSelectedObjects();
                            }
                        });
                        break;
                    }
                    MenuItem miDel = new MenuItem(mTree, 8);
                    miDel.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Transformations.Delete", (String[])new String[0]));
                    miDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.delSelectedObjects();
                        }
                    });
                    miDel.setEnabled(!this.readonly);
                    break;
                }
                case 6: 
                case 9: {
                    if (level < 2) break;
                    String[] realpath = new String[level - 1];
                    for (int i = 0; i < realpath.length; ++i) {
                        realpath[i] = path[i + 2];
                    }
                    final RepositoryDirectoryInterface repdir = this.directoryTree.findDirectory(realpath);
                    MenuItem miExp = new MenuItem(mTree, 8);
                    miExp.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Objects.ExportAll", (String[])new String[0]));
                    SelectionAdapter lsExp = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.exportAll(repdir);
                        }
                    };
                    miExp.addSelectionListener((SelectionListener)lsExp);
                    miExp.setEnabled(!this.readonly);
                    if (cat == 6) {
                        MenuItem miTrans = new MenuItem(mTree, 8);
                        miTrans.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Objects.ExportTrans", (String[])new String[0]));
                        SelectionAdapter lsTrans = new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                RepositoryExplorerDialog.this.exportTransformations(repdir);
                            }
                        };
                        miTrans.addSelectionListener((SelectionListener)lsTrans);
                    }
                    if (cat == 9) {
                        MenuItem miJobs = new MenuItem(mTree, 8);
                        miJobs.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Objects.ExportJob", (String[])new String[0]));
                        SelectionAdapter lsJobs = new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                RepositoryExplorerDialog.this.exportJobs(repdir);
                            }
                        };
                        miJobs.addSelectionListener((SelectionListener)lsJobs);
                    }
                    MenuItem miCreate = new MenuItem(mTree, 8);
                    miCreate.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.TransDirectory.Create", (String[])new String[0]));
                    miCreate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.createDirectory(ti, repdir);
                        }
                    });
                    if (level <= 2) break;
                    MenuItem miRename = new MenuItem(mTree, 8);
                    miRename.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.TransDirectory.Rename", (String[])new String[0]));
                    miRename.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.renameDirectory(ti, repdir);
                        }
                    });
                    MenuItem miDelete = new MenuItem(mTree, 8);
                    miDelete.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.TransDirectory.Delete", (String[])new String[0]));
                    miDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.delDirectory(ti, repdir);
                        }
                    });
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    if (level < 2 || repositoryObject == null) break;
                    final RepositoryDirectoryInterface repdir = repositoryObject.getRepositoryDirectory();
                    if (tisel.length == 1 && !repositoryObject.isDeleted()) {
                        MenuItem miOpen = new MenuItem(mTree, 8);
                        miOpen.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Jobs.Open", (String[])new String[0]));
                        miOpen.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                RepositoryExplorerDialog.this.openJob(item, repdir);
                            }
                        });
                        MenuItem miRen = new MenuItem(mTree, 8);
                        miRen.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Jobs.Rename", (String[])new String[0]));
                        miRen.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                RepositoryExplorerDialog.this.renameJob(ti, item, repdir);
                            }
                        });
                        miRen.setEnabled(!this.readonly);
                    }
                    if (repositoryObject.isDeleted()) {
                        if (!this.capabilities.supportsRevisions()) break;
                        MenuItem miRestore = new MenuItem(mTree, 8);
                        miRestore.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Jobs.Restore", (String[])new String[0]));
                        miRestore.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                RepositoryExplorerDialog.this.restoreSelectedObjects();
                            }
                        });
                        break;
                    }
                    MenuItem miDel = new MenuItem(mTree, 8);
                    miDel.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Jobs.Delete", (String[])new String[0]));
                    miDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.delSelectedObjects();
                        }
                    });
                    miDel.setEnabled(!this.readonly);
                    break;
                }
                case 10: {
                    mTree = new Menu((Decorations)this.shell, 8);
                    MenuItem miNew = new MenuItem(mTree, 8);
                    miNew.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.UsersRoot.New", (String[])new String[0]));
                    SelectionAdapter lsNew = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.newUser();
                        }
                    };
                    miNew.addSelectionListener((SelectionListener)lsNew);
                    miNew.setEnabled(!this.readonly);
                    break;
                }
                case 11: {
                    MenuItem miNew = new MenuItem(mTree, 8);
                    miNew.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Users.New", (String[])new String[0]));
                    SelectionAdapter lsNew = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.newUser();
                        }
                    };
                    miNew.addSelectionListener((SelectionListener)lsNew);
                    miNew.setEnabled(!this.readonly);
                    MenuItem miEdit = new MenuItem(mTree, 8);
                    miEdit.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Users.Edit", (String[])new String[0]));
                    SelectionAdapter lsEdit = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.editUser(item);
                        }
                    };
                    miEdit.addSelectionListener((SelectionListener)lsEdit);
                    miEdit.setEnabled(!this.readonly);
                    MenuItem miRen = new MenuItem(mTree, 8);
                    miRen.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Users.Rename", (String[])new String[0]));
                    SelectionAdapter lsRen = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.renameUser();
                        }
                    };
                    miRen.addSelectionListener((SelectionListener)lsRen);
                    miRen.setEnabled(!this.readonly);
                    MenuItem miDel = new MenuItem(mTree, 8);
                    miDel.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Users.Delete", (String[])new String[0]));
                    SelectionAdapter lsDel = new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            RepositoryExplorerDialog.this.delUser(item);
                        }
                    };
                    miDel.addSelectionListener((SelectionListener)lsDel);
                    miDel.setEnabled(!this.readonly);
                    break;
                }
                default: {
                    mTree = null;
                }
            }
        }
        ConstUI.displayMenu(mTree, (Control)this.wTree);
    }

    public void renameInTree() {
        TreeItem[] ti = this.wTree.getSelection();
        if (ti.length == 1) {
            TreeItem item = ti[0];
            int level = ConstUI.getTreeLevel(item);
            String[] text = ConstUI.getTreeStrings(item);
            int cat = this.getItemCategory(item);
            switch (cat) {
                case 3: {
                    this.renameDatabase();
                    break;
                }
                case 5: {
                    String name = item.getText();
                    String[] path = new String[level - 2];
                    for (int i = 0; i < path.length; ++i) {
                        path[i] = text[i + 2];
                    }
                    RepositoryDirectoryInterface repdir = this.directoryTree.findDirectory(path);
                    if (repdir == null) break;
                    this.renameTransformation(name, repdir);
                    break;
                }
                case 8: {
                    String name = item.getText();
                    String[] path = new String[level - 2];
                    for (int i = 0; i < path.length; ++i) {
                        path[i] = text[i + 2];
                    }
                    RepositoryDirectoryInterface repdir = this.directoryTree.findDirectory(path);
                    if (repdir == null) break;
                    this.renameJob(name, repdir);
                    break;
                }
                case 11: {
                    this.renameUser();
                    break;
                }
            }
        }
    }

    public void close() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void refreshTree() {
        try {
            TreeItem newItem;
            int i;
            this.wTree.removeAll();
            this.objectMap.clear();
            this.directoryTree = this.rep.loadRepositoryDirectoryTree();
            TreeItem tiTree = new TreeItem(this.wTree, 0);
            tiTree.setImage(GUIResource.getInstance().getImageFolderConnections());
            tiTree.setText(this.rep.getName() == null ? "-" : this.rep.getName());
            TreeItem tiParent = new TreeItem(tiTree, 0);
            tiParent.setImage(GUIResource.getInstance().getImageBol());
            tiParent.setText(STRING_DATABASES);
            if (this.readonly) {
                TreeItemAccelerator.addDoubleClick(tiParent, new DoubleClickInterface(){

                    @Override
                    public void action(TreeItem treeItem) {
                        RepositoryExplorerDialog.this.newDatabase();
                    }
                });
            }
            String[] names = this.rep.getDatabaseNames(this.includeDeleted);
            for (i = 0; i < names.length; ++i) {
                TreeItem newDB = new TreeItem(tiParent, 0);
                newDB.setImage(GUIResource.getInstance().getImageConnection());
                newDB.setText(Const.NVL((String)names[i], (String)""));
                if (this.readonly) continue;
                TreeItemAccelerator.addDoubleClick(newDB, new DoubleClickInterface(){

                    @Override
                    public void action(TreeItem treeItem) {
                        RepositoryExplorerDialog.this.editDatabase(treeItem.getText());
                    }
                });
            }
            tiParent = new TreeItem(tiTree, 0);
            tiParent.setImage(GUIResource.getInstance().getImageBol());
            tiParent.setText(STRING_PARTITIONS);
            if (!this.readonly) {
                TreeItemAccelerator.addDoubleClick(tiParent, new DoubleClickInterface(){

                    @Override
                    public void action(TreeItem treeItem) {
                        RepositoryExplorerDialog.this.newPartitionSchema();
                    }
                });
            }
            names = this.rep.getPartitionSchemaNames(this.includeDeleted);
            for (i = 0; i < names.length; ++i) {
                newItem = new TreeItem(tiParent, 0);
                newItem.setImage(GUIResource.getInstance().getImageFolderConnections());
                newItem.setText(Const.NVL((String)names[i], (String)""));
                if (this.readonly) continue;
                TreeItemAccelerator.addDoubleClick(newItem, new DoubleClickInterface(){

                    @Override
                    public void action(TreeItem treeItem) {
                        RepositoryExplorerDialog.this.editPartitionSchema(treeItem.getText());
                    }
                });
            }
            tiParent = new TreeItem(tiTree, 0);
            tiParent.setImage(GUIResource.getInstance().getImageBol());
            tiParent.setText(STRING_SLAVES);
            if (!this.readonly) {
                TreeItemAccelerator.addDoubleClick(tiParent, new DoubleClickInterface(){

                    @Override
                    public void action(TreeItem treeItem) {
                        RepositoryExplorerDialog.this.newSlaveServer();
                    }
                });
            }
            names = this.rep.getSlaveNames(this.includeDeleted);
            for (i = 0; i < names.length; ++i) {
                newItem = new TreeItem(tiParent, 0);
                newItem.setImage(GUIResource.getInstance().getImageSlave());
                newItem.setText(Const.NVL((String)names[i], (String)""));
                if (this.readonly) continue;
                TreeItemAccelerator.addDoubleClick(newItem, new DoubleClickInterface(){

                    @Override
                    public void action(TreeItem treeItem) {
                        RepositoryExplorerDialog.this.editSlaveServer(treeItem.getText());
                    }
                });
            }
            tiParent = new TreeItem(tiTree, 0);
            tiParent.setImage(GUIResource.getInstance().getImageBol());
            tiParent.setText(STRING_CLUSTERS);
            if (!this.readonly) {
                TreeItemAccelerator.addDoubleClick(tiParent, new DoubleClickInterface(){

                    @Override
                    public void action(TreeItem treeItem) {
                        RepositoryExplorerDialog.this.newCluster();
                    }
                });
            }
            names = this.rep.getClusterNames(this.includeDeleted);
            for (i = 0; i < names.length; ++i) {
                newItem = new TreeItem(tiParent, 0);
                newItem.setImage(GUIResource.getInstance().getImageCluster());
                newItem.setText(Const.NVL((String)names[i], (String)""));
                if (this.readonly) continue;
                TreeItemAccelerator.addDoubleClick(newItem, new DoubleClickInterface(){

                    @Override
                    public void action(TreeItem treeItem) {
                        RepositoryExplorerDialog.this.editCluster(treeItem.getText());
                    }
                });
            }
            TreeItem tiTrans = new TreeItem(tiTree, 0);
            tiTrans.setImage(GUIResource.getInstance().getImageTransGraph());
            tiTrans.setText(STRING_TRANSFORMATIONS);
            TreeItem newCat = new TreeItem(tiTrans, 0);
            newCat.setImage(GUIResource.getInstance().getImageLogoSmall());
            Color dircolor = GUIResource.getInstance().getColorDirectory();
            RepositoryDirectoryUI.getTreeWithNames(newCat, this.rep, dircolor, this.sortColumn, this.includeDeleted, this.ascending, true, false, this.directoryTree, null, null);
            TreeItem tiJob = new TreeItem(tiTree, 0);
            tiJob.setImage(GUIResource.getInstance().getImageJobGraph());
            tiJob.setText(STRING_JOBS);
            TreeItem newJob = new TreeItem(tiJob, 0);
            newJob.setImage(GUIResource.getInstance().getImageLogoSmall());
            RepositoryDirectoryUI.getTreeWithNames(newJob, this.rep, dircolor, this.sortColumn, this.includeDeleted, this.ascending, false, true, this.directoryTree, null, null);
            if (this.capabilities.supportsUsers() && this.capabilities.managesUsers()) {
                TreeItem tiUser = new TreeItem(tiTree, 0);
                tiUser.setImage(GUIResource.getInstance().getImageBol());
                tiUser.setText(STRING_USERS);
                if (!this.readonly) {
                    TreeItemAccelerator.addDoubleClick(tiUser, new DoubleClickInterface(){

                        @Override
                        public void action(TreeItem treeItem) {
                            RepositoryExplorerDialog.this.newUser();
                        }
                    });
                }
                String[] users = this.securityProvider.getUserLogins();
                for (int i2 = 0; i2 < users.length; ++i2) {
                    if (users[i2] == null) continue;
                    TreeItem newUser = new TreeItem(tiUser, 0);
                    newUser.setImage(GUIResource.getInstance().getImageUser());
                    newUser.setText(users[i2]);
                    if (this.readonly) continue;
                    TreeItemAccelerator.addDoubleClick(newUser, new DoubleClickInterface(){

                        @Override
                        public void action(TreeItem treeItem) {
                            RepositoryExplorerDialog.this.editUser(treeItem.getText());
                        }
                    });
                }
            }
            TreeMemory.getInstance().storeExpanded(STRING_REPOSITORY_EXPLORER_TREE_NAME, new String[]{tiTree.getText()}, true);
            TreeMemory.setExpandedFromMemory(this.wTree, STRING_REPOSITORY_EXPLORER_TREE_NAME);
        }
        catch (KettleException dbe) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Dialog.ErrorRefreshingTree.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PopupMenu.Dialog.ErrorRefreshingTree.Message", (String[])new String[0]), (Exception)((Object)dbe));
        }
    }

    public void openTransformation(String name, RepositoryDirectoryInterface repdir) {
        this.lastOpened = new RepositoryObjectReference(RepositoryObjectType.TRANSFORMATION, repdir, name);
        if (this.callback != null) {
            if (this.callback.open(this.lastOpened)) {
                this.close();
            }
        } else {
            this.close();
        }
    }

    public void openJob(String name, RepositoryDirectoryInterface repdir) {
        this.lastOpened = new RepositoryObjectReference(RepositoryObjectType.JOB, repdir, name);
        if (this.callback != null) {
            if (this.callback.open(this.lastOpened)) {
                this.close();
            }
        } else {
            this.close();
        }
    }

    public boolean delSelectedObjects() {
        TreeItem[] items = this.wTree.getSelection();
        boolean error = false;
        MessageBox mb = new MessageBox(this.shell, 200);
        mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Delete.Confirm.Message1", (String[])new String[0]) + (items.length > 1 ? BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Delete.Confirm.Message2", (String[])new String[0]) + items.length + BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Delete.Confirm.Message3", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Delete.Confirm.Message4", (String[])new String[0])));
        mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Delete.Confirm.Title", (String[])new String[0]));
        int answer = mb.open();
        if (answer != 64) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            RepositoryElementMetaInterface repositoryObject = this.objectMap.get(ConstUI.getTreePath(items[i], 0));
            if (repositoryObject == null) continue;
            try {
                switch (repositoryObject.getObjectType()) {
                    case TRANSFORMATION: {
                        this.rep.deleteTransformation(repositoryObject.getObjectId());
                        break;
                    }
                    case JOB: {
                        this.rep.deleteJob(repositoryObject.getObjectId());
                        break;
                    }
                }
                continue;
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Delete.ErrorRemoving.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Delete.ErrorRemoving.Message", (String[])new String[0]) + repositoryObject.getName() + "]", e);
                error = true;
            }
        }
        this.refreshTree();
        return !error;
    }

    public boolean restoreSelectedObjects() {
        TreeItem[] items = this.wTree.getSelection();
        boolean error = false;
        for (int i = 0; i < items.length; ++i) {
            RepositoryElementMetaInterface repositoryObject = this.objectMap.get(ConstUI.getTreePath(items[i], 0));
            if (repositoryObject == null) continue;
            try {
                this.rep.undeleteObject(repositoryObject);
                continue;
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Delete.ErrorRestoring.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Delete.ErrorRestoring.Message", (String[])new String[0]), e);
                error = true;
            }
        }
        this.refreshTree();
        return !error;
    }

    public boolean renameTransformation(String name, RepositoryDirectoryInterface repdir) {
        boolean retval = false;
        final TreeItem ti = this.wTree.getSelection()[0];
        if (ti.getItemCount() == 0) {
            final String fname = name;
            final RepositoryDirectoryInterface frepdir = repdir;
            TreeEditor editor = new TreeEditor(this.wTree);
            editor.setItem(ti);
            final Text text = new Text((Composite)this.wTree, 0);
            this.props.setLook((Control)text);
            text.setText(name);
            text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent arg0) {
                    String newname = text.getText();
                    if (RepositoryExplorerDialog.this.renameTransformation(fname, newname, frepdir)) {
                        ti.setText(newname);
                    }
                    text.dispose();
                }
            });
            text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 27) {
                        text.dispose();
                    }
                    if (e.character == '\r') {
                        String newname = text.getText();
                        if (RepositoryExplorerDialog.this.renameTransformation(fname, newname, frepdir)) {
                            ti.setText(newname);
                        }
                        text.dispose();
                    }
                }
            });
            editor.horizontalAlignment = 16384;
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.minimumWidth = 50;
            text.selectAll();
            text.setFocus();
            editor.layout();
            editor.setEditor((Control)text);
        }
        return retval;
    }

    public boolean renameTransformation(String name, String newname, RepositoryDirectoryInterface repdir) {
        boolean retval = false;
        try {
            if (Const.isEmpty((String)newname)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Exception.NameCanNotBeEmpty", (String[])new String[0]));
            }
            if (!name.equals(newname)) {
                ObjectId id = this.rep.getTransformationID(name, repdir);
                if (id != null) {
                    String comment = BaseMessages.getString((String)REPOSITORY_PKG, (String)"Repository.Rename", (String[])new String[]{name, newname});
                    this.rep.renameTransformation(id, comment, repdir, newname);
                    retval = true;
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Rename.ErrorFinding.Message1", (String[])new String[0]) + name + "]" + Const.CR + BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Rename.ErrorFinding.Message2", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Rename.ErrorFinding.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException dbe) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Rename.ErrorRenaming.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Rename.ErrorRenaming.Message", (String[])new String[0]) + name + "]!", (Exception)((Object)dbe));
        }
        return retval;
    }

    public boolean moveTransformation(String xml, RepositoryDirectoryInterface repdir) {
        this.debug = "Move transformation";
        boolean retval = false;
        try {
            this.debug = "parse xml";
            Document doc = XMLHandler.loadXMLString((String)xml);
            String dirname = XMLHandler.getTagValue((Node)doc, (String)"dragdrop", (String)"directory");
            String transname = XMLHandler.getTagValue((Node)doc, (String)"dragdrop", (String)"transformation");
            if (dirname != null && transname != null) {
                this.debug = "dirname=" + dirname + ", transname=" + transname;
                RepositoryDirectoryInterface fromdir = this.directoryTree.findDirectory(dirname);
                if (fromdir != null) {
                    this.debug = "fromdir found: move transformation!";
                    ObjectId existingTransID = this.rep.getTransformationID(transname, repdir);
                    if (existingTransID == null) {
                        ObjectId id = this.rep.getTransformationID(transname, fromdir);
                        this.rep.renameTransformation(id, repdir, transname);
                        retval = true;
                    } else {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Move.ErrorDuplicate.Message", (String[])new String[]{transname}) + Const.CR);
                        mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Move.ErrorDuplicate.Title", (String[])new String[0]));
                        mb.open();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Move.ErrorMoving.Message", (String[])new String[0]) + dirname + "]" + Const.CR);
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Move.ErrorMoving.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (Exception dbe) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Move.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Move.UnexpectedError.Message", (String[])new String[0]), dbe);
        }
        return retval;
    }

    public boolean moveJob(String xml, RepositoryDirectoryInterface repdir) {
        this.debug = "Move Job";
        boolean retval = false;
        try {
            this.debug = "parse xml";
            Document doc = XMLHandler.loadXMLString((String)xml);
            String dirname = XMLHandler.getTagValue((Node)doc, (String)"dragdrop", (String)"directory");
            String jobname = XMLHandler.getTagValue((Node)doc, (String)"dragdrop", (String)"job");
            if (dirname != null && jobname != null) {
                this.debug = "dirname=" + dirname + ", jobname=" + jobname;
                RepositoryDirectoryInterface fromdir = this.directoryTree.findDirectory(dirname);
                if (fromdir != null) {
                    this.debug = "fromdir found: move job!";
                    ObjectId existingjobID = this.rep.getJobId(jobname, repdir);
                    if (existingjobID == null) {
                        ObjectId id = this.rep.getJobId(jobname, fromdir);
                        this.rep.renameJob(id, repdir, jobname);
                        retval = true;
                    } else {
                        MessageBox mb = new MessageBox(this.shell, 33);
                        mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Move.ErrorDuplicate.Message", (String[])new String[]{jobname}) + Const.CR);
                        mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Move.ErrorDuplicate.Title", (String[])new String[0]));
                        mb.open();
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Move.ErrorMoving.Message", (String[])new String[0]) + dirname + "]" + Const.CR);
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Move.ErrorMoving.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (Exception dbe) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Move.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Trans.Move.UnexpectedError.Message", (String[])new String[0]), dbe);
        }
        return retval;
    }

    public boolean renameJob(String name, RepositoryDirectoryInterface repdir) {
        boolean retval = false;
        final TreeItem ti = this.wTree.getSelection()[0];
        if (ti.getItemCount() == 0) {
            final String fname = name;
            final RepositoryDirectoryInterface frepdir = repdir;
            TreeEditor editor = new TreeEditor(this.wTree);
            editor.setItem(ti);
            final Text text = new Text((Composite)this.wTree, 0);
            this.props.setLook((Control)text);
            text.setText(name);
            text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent arg0) {
                    String newname = text.getText();
                    if (RepositoryExplorerDialog.this.renameJob(fname, newname, frepdir)) {
                        ti.setText(newname);
                    }
                    text.dispose();
                }
            });
            text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 27) {
                        text.dispose();
                    }
                    if (e.character == '\r') {
                        String newname = text.getText();
                        if (RepositoryExplorerDialog.this.renameJob(fname, newname, frepdir)) {
                            ti.setText(newname);
                        }
                        text.dispose();
                    }
                }
            });
            editor.horizontalAlignment = 16384;
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.minimumWidth = 50;
            text.selectAll();
            text.setFocus();
            editor.layout();
            editor.setEditor((Control)text);
        }
        return retval;
    }

    public boolean renameJob(String name, String newname, RepositoryDirectoryInterface repdir) {
        boolean retval = false;
        try {
            if (Const.isEmpty((String)newname)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Exception.NameCanNotBeEmpty", (String[])new String[0]));
            }
            if (!name.equals(newname)) {
                ObjectId id = this.rep.getJobId(name, repdir);
                if (id != null) {
                    System.out.println("Renaming job [" + name + "] with ID = " + id);
                    String comment = BaseMessages.getString((String)REPOSITORY_PKG, (String)"Repository.Rename", (String[])new String[]{name, newname});
                    this.rep.renameJob(id, comment, repdir, newname);
                    retval = true;
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Move.ErrorFinding.Message1", (String[])new String[0]) + name + "]" + Const.CR + BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Move.ErrorFinding.Message2", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Move.ErrorFinding.Title", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException dbe) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Move.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Move.UnexpectedError.Message", (String[])new String[0]) + name + "]", (Exception)((Object)dbe));
        }
        return retval;
    }

    public void renameJob(TreeItem treeitem, String jobname, RepositoryDirectoryInterface repositorydir) {
        final TreeItem ti = treeitem;
        final String name = jobname;
        final RepositoryDirectoryInterface repdir = repositorydir;
        TreeEditor editor = new TreeEditor(this.wTree);
        editor.setItem(ti);
        final Text text = new Text((Composite)this.wTree, 0);
        this.props.setLook((Control)text);
        text.setText(name);
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                String newname = text.getText();
                if (RepositoryExplorerDialog.this.renameJob(name, repdir, newname)) {
                    ti.setText(newname);
                }
                text.dispose();
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    text.dispose();
                }
                if (e.character == '\r') {
                    String newname = text.getText();
                    if (RepositoryExplorerDialog.this.renameJob(name, repdir, newname)) {
                        ti.setText(newname);
                    }
                    text.dispose();
                }
            }
        });
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.minimumWidth = 50;
        text.selectAll();
        text.setFocus();
        editor.layout();
        editor.setEditor((Control)text);
    }

    public boolean renameJob(String name, RepositoryDirectoryInterface repdir, String newname) {
        boolean retval = false;
        try {
            if (Const.isEmpty((String)newname)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Exception.NameCanNotBeEmpty", (String[])new String[0]));
            }
            if (!name.equals(newname)) {
                ObjectId id = this.rep.getJobId(name, repdir);
                if (id != null) {
                    String comment = BaseMessages.getString((String)REPOSITORY_PKG, (String)"Repository.Rename", (String[])new String[]{name, newname});
                    this.rep.renameJob(id, comment, repdir, newname);
                    retval = true;
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Rename.ErrorFinding.Message1", (String[])new String[0]) + name + "]" + Const.CR + BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Rename.ErrorFinding.Message2", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Rename.ErrorFinding.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (KettleException dbe) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Rename.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Job.Rename.UnexpectedError.Message", (String[])new String[0]) + name + "]", (Exception)((Object)dbe));
        }
        return retval;
    }

    public void editUser(String login) {
        try {
            IUser uinfo = this.securityManager.loadUserInfo(login);
            UserDialog ud = new UserDialog(this.shell, 0, this.rep, uinfo);
            IUser ui = ud.open();
            if (!this.readonly) {
                if (ui != null) {
                    this.securityManager.saveUserInfo(ui);
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 40);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.User.Edit.NotAllowed.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.User.Edit.NotAllowed.Title", (String[])new String[0]));
                mb.open();
            }
            if (ui != null && !login.equalsIgnoreCase(ui.getLogin())) {
                this.refreshTree();
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.User.Edit.UnexpectedError.Message.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.User.Edit.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void newUser() {
        UserDialog ud = new UserDialog(this.shell, 0, this.rep, (IUser)new UserInfo());
        IUser ui = ud.open();
        if (ui != null) {
            this.refreshTree();
        }
    }

    public void delUser(String login) {
        try {
            ObjectId idUser = this.securityManager.getUserID(login);
            if (idUser != null) {
                this.securityManager.delUser(idUser);
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.User.Delete.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.User.Delete.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        this.refreshTree();
    }

    public boolean renameUser() {
        boolean retval = false;
        final TreeItem ti = this.wTree.getSelection()[0];
        if (ti.getItemCount() == 0) {
            final String name = ti.getText();
            TreeEditor editor = new TreeEditor(this.wTree);
            editor.setItem(ti);
            final Text text = new Text((Composite)this.wTree, 0);
            this.props.setLook((Control)text);
            text.setText(name);
            text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent arg0) {
                    String newname = text.getText();
                    if (RepositoryExplorerDialog.this.renameUser(name, newname)) {
                        ti.setText(newname);
                    }
                    text.dispose();
                }
            });
            text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 27) {
                        text.dispose();
                    }
                    if (e.character == '\r') {
                        String newname = text.getText();
                        if (RepositoryExplorerDialog.this.renameUser(name, newname)) {
                            ti.setText(newname);
                        }
                        text.dispose();
                    }
                }
            });
            editor.horizontalAlignment = 16384;
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.minimumWidth = 50;
            text.selectAll();
            text.setFocus();
            editor.layout();
            editor.setEditor((Control)text);
        }
        return retval;
    }

    public boolean renameUser(String name, String newname) {
        boolean retval = false;
        try {
            if (Const.isEmpty((String)newname)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Exception.NameCanNotBeEmpty", (String[])new String[0]));
            }
            if (!name.equals(newname)) {
                ObjectId id = this.securityManager.getUserID(name);
                if (id != null) {
                    this.securityManager.renameUser(id, newname);
                    retval = true;
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.User.Rename.ErrorFinding.Message1", (String[])new String[0]) + name + "]" + Const.CR + BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.User.Rename.ErrorFinding.Message2", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.User.Rename.ErrorFinding.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.User.Rename.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.User.Rename.UnexpectedError.Message", (String[])new String[0]) + name + "]", (Exception)((Object)e));
        }
        return retval;
    }

    public void editDatabase(String databasename) {
        try {
            ObjectId idDatabase = this.rep.getDatabaseID(databasename);
            DatabaseMeta databaseMeta = this.rep.loadDatabaseMeta(idDatabase, null);
            this.getDatabaseDialog().setDatabaseMeta(databaseMeta);
            String name = this.getDatabaseDialog().open();
            if (name != null) {
                if (!this.readonly) {
                    this.rep.insertLogEntry("Updating database connection '" + this.getDatabaseDialog().getDatabaseMeta().getName() + "'");
                    this.rep.save((RepositoryElementInterface)databaseMeta, "Modification by user", null);
                } else {
                    MessageBox mb = new MessageBox(this.shell, 40);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.NotAllowed.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.NotAllowed.Title", (String[])new String[0]));
                    mb.open();
                }
                if (!databasename.equalsIgnoreCase(name)) {
                    this.refreshTree();
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Edit.UnexpectedError.Message", (String[])new String[0]) + databasename + "]", (Exception)((Object)e));
        }
    }

    public void newDatabase() {
        try {
            DatabaseMeta databaseMeta = new DatabaseMeta();
            databaseMeta.initializeVariablesFrom(null);
            this.getDatabaseDialog().setDatabaseMeta(databaseMeta);
            String name = this.getDatabaseDialog().open();
            if (name != null) {
                ObjectId idDatabase = this.rep.getDatabaseID(name);
                if (idDatabase == null) {
                    this.rep.insertLogEntry("Creating new database '" + databaseMeta.getName() + "'");
                    this.rep.save((RepositoryElementInterface)databaseMeta, "Creation of initial version", null);
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.AlreadyExists.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.AlreadyExists.Title", (String[])new String[0]));
                    mb.open();
                }
                this.refreshTree();
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void delDatabase(String databasename) {
        try {
            this.rep.deleteDatabaseMeta(databasename);
            this.refreshTree();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Delete.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Delete.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public boolean renameDatabase() {
        boolean retval = false;
        final TreeItem ti = this.wTree.getSelection()[0];
        if (ti.getItemCount() == 0) {
            final String name = ti.getText();
            TreeEditor editor = new TreeEditor(this.wTree);
            editor.setItem(ti);
            final Text text = new Text((Composite)this.wTree, 0);
            this.props.setLook((Control)text);
            text.setText(name);
            text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent arg0) {
                    String newname = text.getText();
                    if (RepositoryExplorerDialog.this.renameDatabase(name, newname)) {
                        ti.setText(newname);
                    }
                    text.dispose();
                }
            });
            text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.keyCode == 27) {
                        text.dispose();
                    }
                    if (e.character == '\r' && ti.getText().equals(name)) {
                        String newname = text.getText();
                        if (RepositoryExplorerDialog.this.renameDatabase(name, newname)) {
                            ti.setText(newname);
                        }
                        text.dispose();
                    }
                }
            });
            editor.horizontalAlignment = 16384;
            editor.grabHorizontal = true;
            editor.grabVertical = true;
            editor.minimumWidth = 50;
            text.selectAll();
            text.setFocus();
            editor.layout();
            editor.setEditor((Control)text);
        }
        return retval;
    }

    public boolean renameDatabase(String name, String newname) {
        boolean retval = false;
        try {
            if (Const.isEmpty((String)newname)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Exception.NameCanNotBeEmpty", (String[])new String[0]));
            }
            if (!name.equals(newname)) {
                ObjectId id = this.rep.getDatabaseID(name);
                if (id != null) {
                    DatabaseMeta databaseMeta = this.rep.loadDatabaseMeta(id, null);
                    databaseMeta.setName(newname);
                    this.rep.insertLogEntry("Renaming database connection '" + this.getDatabaseDialog().getDatabaseMeta().getName() + "'");
                    this.rep.save((RepositoryElementInterface)databaseMeta, "Modification by user", null);
                    retval = true;
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Rename.ErrorFinding.Message1", (String[])new String[0]) + name + "]" + Const.CR + BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Rename.ErrorFinding.Message2", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Rename.ErrorFinding.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Rename.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Rename.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        return retval;
    }

    public void renameDirectory(TreeItem treeitem, RepositoryDirectoryInterface rd) {
        final TreeItem ti = treeitem;
        final RepositoryDirectoryInterface repdir = rd;
        final String name = ti.getText();
        TreeEditor editor = new TreeEditor(this.wTree);
        editor.setItem(ti);
        final Text text = new Text((Composite)this.wTree, 0);
        this.props.setLook((Control)text);
        text.setText(name);
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                String newname = text.getText();
                if (RepositoryExplorerDialog.this.renameDirectory(repdir, name, newname)) {
                    ti.setText(newname);
                }
                text.dispose();
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    text.dispose();
                }
                if (e.character == '\r') {
                    String newname = text.getText();
                    if (RepositoryExplorerDialog.this.renameDirectory(repdir, name, newname)) {
                        ti.setText(newname);
                    }
                    text.dispose();
                }
            }
        });
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.minimumWidth = 50;
        text.selectAll();
        text.setFocus();
        editor.layout();
        editor.setEditor((Control)text);
    }

    public boolean renameDirectory(RepositoryDirectoryInterface repdir, String name, String newname) {
        boolean retval = false;
        try {
            if (Const.isEmpty((String)newname)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Exception.NameCanNotBeEmpty", (String[])new String[0]));
            }
            if (!name.equals(newname)) {
                repdir.setName(newname);
                try {
                    this.rep.renameRepositoryDirectory(repdir.getObjectId(), repdir, newname);
                    retval = true;
                }
                catch (Exception exception) {
                    retval = false;
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Rename.UnexpectedError.Message1", (String[])new String[0]) + name + "]" + Const.CR + BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Rename.UnexpectedError.Message2", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Rename.UnexpectedError.Title", (String[])new String[0]), exception);
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Rename.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Rename.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        return retval;
    }

    public void createDirectory(TreeItem ti, RepositoryDirectoryInterface repdir) {
        EnterStringDialog esd = new EnterStringDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Create.AskName.Default", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Create.AskName.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Create.AskName.Message", (String[])new String[0]));
        String newdir = esd.open();
        if (newdir != null) {
            RepositoryDirectory rd = new RepositoryDirectory(repdir, newdir);
            String[] path = rd.getPathArray();
            RepositoryDirectoryInterface exists = this.directoryTree.findDirectory(path);
            if (exists == null) {
                try {
                    this.rep.saveRepositoryDirectory((RepositoryDirectoryInterface)rd);
                }
                catch (Exception exception) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Create.UnexpectedError.Message1", (String[])new String[0]) + newdir + BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Create.UnexpectedError.Message2", (String[])new String[0]) + repdir.getPath() + "]", BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Create.UnexpectedError.Title", (String[])new String[0]), exception);
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Create.AlreadyExists.Message1", (String[])new String[0]) + newdir + BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Create.AlreadyExists.Message2", (String[])new String[0]) + repdir.getPath() + BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Create.AlreadyExists.Message3", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Create.AlreadyExists.Title", (String[])new String[0]));
                mb.open();
            }
        }
    }

    public void delDirectory(TreeItem ti, RepositoryDirectoryInterface repdir) {
        try {
            this.rep.deleteRepositoryDirectory(repdir);
            this.refreshTree();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Delete.ErrorRemoving.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Directory.Delete.ErrorRemoving.Message1", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void exportTransformations(RepositoryDirectoryInterface root) {
        try {
            DirectoryDialog dialog = new DirectoryDialog(this.shell, 4096);
            if (dialog.open() != null) {
                String directory = dialog.getFilterPath();
                ObjectId[] dirids = (root == null ? this.directoryTree : root).getDirectoryIDs();
                for (int d = 0; d < dirids.length; ++d) {
                    RepositoryDirectoryInterface repdir = this.directoryTree.findDirectory(dirids[d]);
                    String[] trans = this.rep.getTransformationNames(dirids[d], false);
                    File dir = new File(directory + repdir.getPath());
                    if (!dir.exists()) {
                        dir.mkdir();
                        this.log.logBasic("Exporting transformation", new Object[]{"Created directory [" + dir.getName() + "]"});
                    }
                    for (int i = 0; i < trans.length; ++i) {
                        TransMeta ti = this.rep.loadTransformation(trans[i], repdir, null, true, null);
                        if (this.log.isBasic()) {
                            this.log.logBasic("Exporting transformation", new Object[]{"[" + trans[i] + "] in directory [" + repdir.getPath() + "]"});
                        }
                        String xml = XMLHandler.getXMLHeader() + ti.getXML();
                        String filename = directory + repdir.getPath() + Const.FILE_SEPARATOR + this.fixFileName(trans[i]) + ".ktr";
                        File f = new File(filename);
                        try {
                            FileOutputStream fos = new FileOutputStream(f);
                            fos.write(xml.getBytes("UTF-8"));
                            fos.close();
                            continue;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Exporting transformation: Couldn't create file [" + filename + "]", e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.ExportTrans.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.ExportTrans.UnexpectedError.Message", (String[])new String[0]), e);
        }
    }

    private String fixFileName(String filename) {
        filename = filename.replace('/', '_');
        if (!"/".equals(Const.FILE_SEPARATOR)) {
            filename = Const.replace((String)filename, (String)Const.FILE_SEPARATOR, (String)"_");
        }
        return filename;
    }

    public void exportJobs(RepositoryDirectoryInterface root) {
        try {
            DirectoryDialog dialog = new DirectoryDialog(this.shell, 4096);
            if (dialog.open() != null) {
                String directory = dialog.getFilterPath();
                ObjectId[] dirids = (null == root ? this.directoryTree : root).getDirectoryIDs();
                for (int d = 0; d < dirids.length; ++d) {
                    RepositoryDirectoryInterface repdir = this.directoryTree.findDirectory(dirids[d]);
                    String[] jobs = this.rep.getJobNames(dirids[d], false);
                    File dir = new File(directory + repdir.getPath());
                    if (!dir.exists()) {
                        dir.mkdir();
                        this.log.logBasic("Exporting Jobs", new Object[]{"Created directory [" + dir.getName() + "]"});
                    }
                    for (int i = 0; i < jobs.length; ++i) {
                        JobMeta ji = this.rep.loadJob(jobs[i], repdir, null, null);
                        this.log.logBasic("Exporting Jobs", new Object[]{"[" + jobs[i] + "] in directory [" + repdir.getPath() + "]"});
                        String xml = XMLHandler.getXMLHeader() + ji.getXML();
                        String filename = directory + repdir.getPath() + Const.FILE_SEPARATOR + this.fixFileName(jobs[i]) + ".kjb";
                        File f = new File(filename);
                        try {
                            FileOutputStream fos = new FileOutputStream(f);
                            fos.write(xml.getBytes("UTF-8"));
                            fos.close();
                            continue;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Exporting jobs: Couldn't create file [" + filename + "]", e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.ExportJobs.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.ExportJobs.UnexpectedError.Message", (String[])new String[0]), e);
        }
    }

    public void exportAll(RepositoryDirectoryInterface dir) {
        int answer;
        FileDialog dialog = Spoon.getInstance().getExportFileDialog();
        if (dialog.open() == null) {
            return;
        }
        String filename = dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName();
        MessageBox box = RepositoryExportProgressDialog.checkIsFileIsAcceptable(this.shell, this.log, filename);
        int n = answer = box == null ? 32 : box.open();
        if (answer != 32) {
            return;
        }
        if (this.log.isBasic()) {
            this.log.logBasic("Exporting All", new Object[]{"Export objects to file [" + filename + "]"});
        }
        RepositoryExportProgressDialog repd = new RepositoryExportProgressDialog(this.shell, this.rep, dir, filename);
        repd.open();
    }

    public void importAll() {
        SelectDirectoryDialog sdd;
        RepositoryDirectoryInterface baseDirectory;
        FileDialog dialog = new FileDialog(this.shell, 4098);
        if (dialog.open() != null && (baseDirectory = (sdd = new SelectDirectoryDialog(this.shell, 0, this.rep)).open()) != null) {
            String versionComment = null;
            boolean versionOk = false;
            while (!versionOk) {
                versionComment = RepositorySecurityUI.getVersionComment(this.shell, this.rep, "Import of files into [" + baseDirectory.getPath() + "]");
                if (this.rep != null && this.rep.getSecurityProvider() != null && this.rep.getSecurityProvider().allowsVersionComments() && versionComment == null) {
                    return;
                }
                if (Const.isEmpty((String)versionComment) && this.rep.getSecurityProvider().isVersionCommentMandatory()) {
                    if (RepositorySecurityUI.showVersionCommentMandatoryDialog(this.shell)) continue;
                    versionOk = true;
                    continue;
                }
                versionOk = true;
            }
            String[] filenames = dialog.getFileNames();
            if (filenames.length > 0) {
                RepositoryImportProgressDialog ripd = new RepositoryImportProgressDialog(this.shell, 0, this.rep, dialog.getFilterPath(), filenames, baseDirectory, versionComment);
                ripd.open();
                this.refreshTree();
            }
        }
    }

    private int getItemCategory(TreeItem ti) {
        int cat = 0;
        int level = ConstUI.getTreeLevel(ti);
        String[] path = ConstUI.getTreeStrings(ti);
        String item = "";
        String parent = "";
        if (ti != null) {
            item = ti.getText();
            if (ti.getParentItem() != null) {
                parent = ti.getParentItem().getText();
            }
        }
        if (level == 0) {
            cat = 1;
        } else if (level == 1) {
            if (item.equals(STRING_USERS)) {
                cat = 10;
            } else if (item.equals(STRING_DATABASES)) {
                cat = 2;
            } else if (item.equals(STRING_PARTITIONS)) {
                cat = 14;
            } else if (item.equals(STRING_SLAVES)) {
                cat = 16;
            } else if (item.equals(STRING_CLUSTERS)) {
                cat = 18;
            } else if (item.equals(STRING_TRANSFORMATIONS)) {
                cat = 4;
            } else if (item.equals(STRING_JOBS)) {
                cat = 7;
            }
        } else if (level >= 2) {
            if (parent.equals(STRING_USERS)) {
                cat = 11;
            } else if (parent.equals(STRING_DATABASES)) {
                cat = 3;
            } else if (parent.equals(STRING_PARTITIONS)) {
                cat = 15;
            } else if (parent.equals(STRING_SLAVES)) {
                cat = 17;
            } else if (parent.equals(STRING_CLUSTERS)) {
                cat = 19;
            }
            Color dircolor = GUIResource.getInstance().getColorDirectory();
            if (path[1].equals(STRING_TRANSFORMATIONS)) {
                cat = ti.getForeground().equals((Object)dircolor) ? 6 : 5;
            } else if (path[1].equals(STRING_JOBS)) {
                cat = ti.getForeground().equals((Object)dircolor) ? 9 : 8;
            }
        }
        return cat;
    }

    public void newSlaveServer() {
        try {
            SlaveServer slaveServer = new SlaveServer();
            SlaveServerDialog dd = new SlaveServerDialog(this.shell, slaveServer);
            if (dd.open()) {
                ObjectId idSlave = this.rep.getSlaveID(slaveServer.getName());
                if (idSlave == null) {
                    this.rep.insertLogEntry("Creating new slave server '" + slaveServer.getName() + "'");
                    this.rep.save((RepositoryElementInterface)slaveServer, "Creation of initial version", null);
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Create.AlreadyExists.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Create.AlreadyExists.Title", (String[])new String[0]));
                    mb.open();
                }
                this.refreshTree();
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Connection.Create.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void editSlaveServer(String slaveName) {
        try {
            ObjectId id = this.rep.getSlaveID(slaveName);
            SlaveServer slaveServer = this.rep.loadSlaveServer(id, null);
            SlaveServerDialog dd = new SlaveServerDialog(this.shell, slaveServer);
            if (dd.open()) {
                this.rep.insertLogEntry("Updating slave server '" + slaveServer.getName() + "'");
                this.rep.save((RepositoryElementInterface)slaveServer, "Modification by user", null);
                if (!slaveName.equalsIgnoreCase(slaveServer.getName())) {
                    this.refreshTree();
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Edit.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Edit.UnexpectedError.Message", (String[])new String[0]) + slaveName + "]", (Exception)((Object)e));
        }
    }

    public void delSlaveServer(String slaveName) {
        try {
            ObjectId id = this.rep.getSlaveID(slaveName);
            if (id != null) {
                this.rep.deleteSlave(id);
            }
            this.refreshTree();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Delete.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Slave.Delete.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void newPartitionSchema() {
        try {
            PartitionSchema partitionSchema = new PartitionSchema();
            PartitionSchemaDialog dd = new PartitionSchemaDialog(this.shell, partitionSchema, this.rep.readDatabases(), this.variableSpace);
            if (dd.open()) {
                ObjectId idPartitionSchema = this.rep.getPartitionSchemaID(partitionSchema.getName());
                if (idPartitionSchema == null) {
                    this.rep.insertLogEntry("Creating new partition schema '" + partitionSchema.getName() + "'");
                    this.rep.save((RepositoryElementInterface)partitionSchema, "Creation of initial version", null);
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PartitionSchema.Create.AlreadyExists.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PartitionSchema.Create.AlreadyExists.Title", (String[])new String[0]));
                    mb.open();
                }
                this.refreshTree();
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PartitionSchema.Create.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PartitionSchema.Create.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void editPartitionSchema(String partitionSchemaName) {
        try {
            ObjectId id = this.rep.getPartitionSchemaID(partitionSchemaName);
            PartitionSchema partitionSchema = this.rep.loadPartitionSchema(id, null);
            PartitionSchemaDialog dd = new PartitionSchemaDialog(this.shell, partitionSchema, this.rep.readDatabases(), this.variableSpace);
            if (dd.open()) {
                this.rep.insertLogEntry("Updating partition schema '" + partitionSchema.getName() + "'");
                this.rep.save((RepositoryElementInterface)partitionSchema, "Modification by user", null);
                if (!partitionSchemaName.equalsIgnoreCase(partitionSchema.getName())) {
                    this.refreshTree();
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PartitionSchema.Edit.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PartitionSchema.Edit.UnexpectedError.Message", (String[])new String[0]) + partitionSchemaName + "]", (Exception)((Object)e));
        }
    }

    public void delPartitionSchema(String partitionSchemaName) {
        try {
            ObjectId id = this.rep.getPartitionSchemaID(partitionSchemaName);
            if (id != null) {
                this.rep.deletePartitionSchema(id);
            }
            this.refreshTree();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PartitionSchema.Delete.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.PartitionSchema.Delete.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void newCluster() {
        try {
            ClusterSchema cluster = new ClusterSchema();
            ClusterSchemaDialog dd = new ClusterSchemaDialog(this.shell, cluster, this.rep.getSlaveServers());
            if (dd.open()) {
                ObjectId idCluster = this.rep.getClusterID(cluster.getName());
                if (idCluster == null) {
                    this.rep.insertLogEntry("Creating new cluster '" + cluster.getName() + "'");
                    this.rep.save((RepositoryElementInterface)cluster, "Creation of initial version", null);
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Create.AlreadyExists.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Create.AlreadyExists.Title", (String[])new String[0]));
                    mb.open();
                }
                this.refreshTree();
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Create.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Create.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public void editCluster(String clusterName) {
        try {
            ObjectId id = this.rep.getClusterID(clusterName);
            ClusterSchema cluster = this.rep.loadClusterSchema(id, this.rep.getSlaveServers(), null);
            ClusterSchemaDialog dd = new ClusterSchemaDialog(this.shell, cluster, this.rep.getSlaveServers());
            if (dd.open()) {
                this.rep.insertLogEntry("Updating cluster '" + cluster.getName() + "'");
                this.rep.save((RepositoryElementInterface)cluster, "Modification by user", null);
                if (!clusterName.equalsIgnoreCase(cluster.getName())) {
                    this.refreshTree();
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Edit.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Edit.UnexpectedError.Message", (String[])new String[0]) + clusterName + "]", (Exception)((Object)e));
        }
    }

    public void delCluster(String clusterName) {
        try {
            ObjectId id = this.rep.getClusterID(clusterName);
            if (id != null) {
                this.rep.deleteClusterSchema(id);
            }
            this.refreshTree();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Delete.UnexpectedError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryExplorerDialog.Cluster.Delete.UnexpectedError.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    protected RepositoryRevisionBrowserDialogInterface getVersionBrowserDialog(RepositoryElementInterface element) throws Exception {
        return RepositoryExplorerDialog.getVersionBrowserDialog(this.shell, this.rep, element);
    }

    public static final RepositoryRevisionBrowserDialogInterface getVersionBrowserDialog(Shell shell, Repository repository, RepositoryElementInterface element) throws Exception {
        String className = repository.getRepositoryMeta().getRevisionBrowserDialogClassName();
        PluginRegistry registry = PluginRegistry.getInstance();
        PluginInterface plugin = registry.getPlugin(RepositoryPluginType.class, repository.getRepositoryMeta().getId());
        Class dialogClass = (Class)registry.getClass(plugin, className);
        Constructor constructor = dialogClass.getConstructor(Shell.class, Integer.TYPE, Repository.class, RepositoryElementInterface.class);
        return (RepositoryRevisionBrowserDialogInterface)constructor.newInstance(shell, 0, repository, element);
    }

    public class RepositoryObjectReference {
        private RepositoryObjectType type;
        private RepositoryDirectoryInterface directory;
        private String name;
        private String versionLabel;

        public RepositoryObjectReference(RepositoryObjectType type, RepositoryDirectoryInterface dir, String name) {
            this(type, dir, name, null);
        }

        public RepositoryObjectReference(RepositoryObjectType type, RepositoryDirectoryInterface dir, String name, String versionLabel) {
            this.type = type;
            this.directory = dir;
            this.name = name;
            this.versionLabel = versionLabel;
        }

        public RepositoryDirectoryInterface getDirectory() {
            return this.directory;
        }

        public String getName() {
            return this.name;
        }

        public RepositoryObjectType getType() {
            return this.type;
        }

        public String getVersionLabel() {
            return this.versionLabel;
        }
    }

    public static interface RepositoryExplorerCallback {
        public boolean open(RepositoryObjectReference var1);
    }
}

