/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.fileexists;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.fileexists.JobEntryFileExists;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class JobEntryFileExistsDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryFileExists.class;
    private static final String[] EXTENSIONS = new String[]{"*.txt", "*.csv", "*"};
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"JobFileExists.Filetype.Text", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobFileExists.Filetype.CSV", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobFileExists.Filetype.All", (String[])new String[0])};
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private Label wlFilename;
    private Button wbFilename;
    private TextVar wFilename;
    private FormData fdlFilename;
    private FormData fdbFilename;
    private FormData fdFilename;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private JobEntryFileExists jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;

    public JobEntryFileExistsDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryFileExists)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobFileExists.Name.Default", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryFileExistsDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobFileExists.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"JobFileExists.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.right = new FormAttachment(middle, -margin);
        this.fdlName.top = new FormAttachment(0, margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, 0);
        this.fdName.top = new FormAttachment(0, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wlFilename = new Label((Composite)this.shell, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"JobFileExists.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilename);
        this.fdlFilename = new FormData();
        this.fdlFilename.left = new FormAttachment(0, 0);
        this.fdlFilename.top = new FormAttachment((Control)this.wName, margin);
        this.fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)this.fdlFilename);
        this.wbFilename = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbFilename);
        this.wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbFilename = new FormData();
        this.fdbFilename.right = new FormAttachment(100, 0);
        this.fdbFilename.top = new FormAttachment((Control)this.wName, 0);
        this.wbFilename.setLayoutData((Object)this.fdbFilename);
        this.wFilename = new TextVar((VariableSpace)this.jobMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        this.fdFilename = new FormData();
        this.fdFilename.left = new FormAttachment(middle, 0);
        this.fdFilename.top = new FormAttachment((Control)this.wName, margin);
        this.fdFilename.right = new FormAttachment((Control)this.wbFilename, -margin);
        this.wFilename.setLayoutData(this.fdFilename);
        this.wFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryFileExistsDialog.this.wFilename.setToolTipText(JobEntryFileExistsDialog.this.jobMeta.environmentSubstitute(JobEntryFileExistsDialog.this.wFilename.getText()));
            }
        });
        this.wbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    FileObject fileName = null;
                    try {
                        String curFile = JobEntryFileExistsDialog.this.wFilename.getText();
                        fileName = curFile.trim().length() > 0 ? KettleVFS.getInstance().getFileSystemManager().resolveFile(JobEntryFileExistsDialog.this.jobMeta.environmentSubstitute(JobEntryFileExistsDialog.this.wFilename.getText())) : KettleVFS.getInstance().getFileSystemManager().resolveFile(Const.getUserHomeDirectory());
                    }
                    catch (FileSystemException ex) {
                        fileName = KettleVFS.getInstance().getFileSystemManager().resolveFile(Const.getUserHomeDirectory());
                    }
                    VfsFileChooserDialog vfsFileChooser = Spoon.getInstance().getVfsFileChooserDialog(fileName.getParent(), fileName);
                    FileObject selected = vfsFileChooser.open(JobEntryFileExistsDialog.this.shell, null, EXTENSIONS, FILETYPES, 0);
                    JobEntryFileExistsDialog.this.wFilename.setText(selected != null ? selected.getURL().toString() : "");
                }
                catch (FileSystemException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fd = new FormData();
        fd.right = new FormAttachment(50, -10);
        fd.bottom = new FormAttachment(100, 0);
        fd.width = 100;
        this.wOK.setLayoutData((Object)fd);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(50, 10);
        fd.bottom = new FormAttachment(100, 0);
        fd.width = 100;
        this.wCancel.setLayoutData((Object)fd);
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wFilename);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryFileExistsDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryFileExistsDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryFileExistsDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.wFilename.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryFileExistsDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobFileExistsDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        if (this.jobEntry.getName() != null) {
            this.wName.setText(this.jobEntry.getName());
        }
        if (this.jobEntry.getFilename() != null) {
            this.wFilename.setText(this.jobEntry.getFilename());
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setFilename(this.wFilename.getText());
        this.dispose();
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }
}

