/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.namedcluster.dialog;

import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.namedcluster.NamedClusterUIHelper;
import org.pentaho.di.ui.core.namedcluster.dialog.NamedClusterComposite;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.metastore.api.exceptions.MetaStoreException;

public class NamedClusterDialog
extends Dialog {
    private static Class<?> PKG = NamedClusterDialog.class;
    private Shell shell;
    private PropsUI props = PropsUI.getInstance();
    private Button wOK;
    private Button wCancel;
    private int margin;
    private NamedCluster originalNamedCluster;
    private NamedCluster namedCluster;
    private boolean newClusterCheck = false;
    private String result;

    public NamedClusterDialog(Shell parent) {
        super(parent);
    }

    public NamedClusterDialog(Shell parent, NamedCluster namedCluster) {
        super(parent);
        this.namedCluster = namedCluster;
        this.originalNamedCluster = namedCluster.clone();
    }

    public NamedCluster getNamedCluster() {
        return this.namedCluster;
    }

    public void setNamedCluster(NamedCluster namedCluster) {
        this.namedCluster = namedCluster;
        this.originalNamedCluster = namedCluster.clone();
    }

    public boolean isNewClusterCheck() {
        return this.newClusterCheck;
    }

    public void setNewClusterCheck(boolean newClusterCheck) {
        this.newClusterCheck = newClusterCheck;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3297);
        this.shell.setSize(480, 550);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        this.margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setText(BaseMessages.getString(PKG, (String)"NamedClusterDialog.Shell.Title", (String[])new String[0]));
        this.shell.setLayout((Layout)new FormLayout());
        NamedClusterComposite namedClusterComposite = new NamedClusterComposite((Composite)this.shell, this.namedCluster, this.props);
        FormData fd = new FormData(470, 480);
        namedClusterComposite.setLayoutData(fd);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        Button[] buttons = new Button[]{this.wOK, this.wCancel};
        BaseStepDialog.positionBottomButtons((Composite)this.shell, buttons, this.margin, null);
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NamedClusterDialog.this.ok();
            }
        });
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                NamedClusterDialog.this.cancel();
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                NamedClusterDialog.this.cancel();
            }
        });
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void cancel() {
        this.result = null;
        this.dispose();
    }

    public void ok() {
        this.result = this.namedCluster.getName();
        if (StringUtils.isEmpty((String)this.result)) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"NamedClusterDialog.Error", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"NamedClusterDialog.ClusterNameMissing", (String[])new String[0]));
            mb.open();
            return;
        }
        if (this.newClusterCheck || !this.originalNamedCluster.getName().equals(this.result)) {
            try {
                NamedCluster fetched = NamedClusterUIHelper.getNamedCluster(this.result);
                if (fetched != null) {
                    MessageBox mb = new MessageBox(this.shell, 196);
                    mb.setText(BaseMessages.getString(PKG, (String)"NamedClusterDialog.Warning", (String[])new String[0]));
                    mb.setMessage(BaseMessages.getString(PKG, (String)"NamedClusterDialog.ClusterNameExists", (String[])new String[]{this.result}));
                    if (128 == mb.open()) {
                        return;
                    }
                }
            }
            catch (MetaStoreException metaStoreException) {
                // empty catch block
            }
        }
        this.dispose();
    }
}

