/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class StepFieldsDialog
extends Dialog {
    private static Class<?> PKG = StepFieldsDialog.class;
    private Label wlStepname;
    private Text wStepname;
    private FormData fdlStepname;
    private FormData fdStepname;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Button wEdit;
    private Button wCancel;
    private Button wClose;
    private Listener lsEdit;
    private Listener lsCancel;
    private RowMetaInterface input;
    private Shell shell;
    private PropsUI props;
    private String stepname;
    private SelectionAdapter lsDef;
    private VariableSpace variables;
    private String shellText;
    private String originText;
    private boolean showEditButton = true;

    public StepFieldsDialog(Shell parent, VariableSpace space, int style, String stepname, RowMetaInterface input) {
        super(parent, style);
        this.stepname = stepname;
        this.input = input;
        this.variables = space;
        this.props = PropsUI.getInstance();
        this.shellText = BaseMessages.getString(PKG, (String)"StepFieldsDialog.Title", (String[])new String[0]);
        this.originText = BaseMessages.getString(PKG, (String)"StepFieldsDialog.Name.Label", (String[])new String[0]);
        this.showEditButton = true;
    }

    public Object open() {
        Button[] buttons;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setImage(GUIResource.getInstance().getImageTransGraph());
        this.shell.setText(this.shellText);
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 0);
        this.wlStepname.setText(this.originText);
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 16396);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment((Control)this.wlStepname, margin);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"StepFieldsDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wlStepname, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsRows = this.input.size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"StepFieldsDialog.TableCol.Fieldname", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"StepFieldsDialog.TableCol.Type", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"StepFieldsDialog.TableCol.Length", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"StepFieldsDialog.TableCol.Precision", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"StepFieldsDialog.TableCol.Origin", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"StepFieldsDialog.TableCol.StorageType", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"StepFieldsDialog.TableCol.ConversionMask", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"StepFieldsDialog.TableCol.Currency", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"StepFieldsDialog.TableCol.Decimal", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"StepFieldsDialog.TableCol.Group", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"StepFieldsDialog.TableCol.TrimType", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"StepFieldsDialog.TableCol.Comments", (String[])new String[0]), 1, false, true)};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, FieldsRows, true, null, this.props);
        this.wFields.optWidth(true);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                StepFieldsDialog.this.cancel();
            }
        };
        this.lsEdit = new Listener(){

            public void handleEvent(Event e) {
                StepFieldsDialog.this.edit();
            }
        };
        if (this.showEditButton) {
            this.wEdit = new Button((Composite)this.shell, 8);
            this.wEdit.setText(BaseMessages.getString(PKG, (String)"StepFieldsDialog.Buttons.EditOrigin", (String[])new String[0]));
            this.wEdit.addListener(13, this.lsEdit);
            this.wCancel = new Button((Composite)this.shell, 8);
            this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
            this.wCancel.addListener(13, this.lsCancel);
            buttons = new Button[]{this.wEdit, this.wCancel};
        } else {
            this.wClose = new Button((Composite)this.shell, 8);
            this.wClose.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
            this.wClose.addListener(13, this.lsCancel);
            buttons = new Button[]{this.wClose};
        }
        BaseStepDialog.positionBottomButtons((Composite)this.shell, buttons, margin, (Control)this.wFields);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                StepFieldsDialog.this.edit();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                StepFieldsDialog.this.cancel();
            }
        });
        this.wFields.table.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
                StepFieldsDialog.this.edit();
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        for (int i = 0; i < this.input.size(); ++i) {
            TableItem item = this.wFields.table.getItem(i);
            ValueMetaInterface v = this.input.getValueMeta(i);
            int idx = 1;
            if (v.getName() != null) {
                item.setText(idx++, v.getName());
            }
            item.setText(idx++, v.getTypeDesc());
            item.setText(idx++, v.getLength() < 0 ? "-" : "" + v.getLength());
            item.setText(idx++, v.getPrecision() < 0 ? "-" : "" + v.getPrecision());
            item.setText(idx++, Const.NVL((String)v.getOrigin(), (String)""));
            item.setText(idx++, ValueMeta.getStorageTypeCode((int)v.getStorageType()));
            item.setText(idx++, Const.NVL((String)v.getConversionMask(), (String)""));
            item.setText(idx++, Const.NVL((String)v.getCurrencySymbol(), (String)""));
            item.setText(idx++, Const.NVL((String)v.getDecimalSymbol(), (String)""));
            item.setText(idx++, Const.NVL((String)v.getGroupingSymbol(), (String)""));
            item.setText(idx++, ValueMeta.getTrimTypeDesc((int)v.getTrimType()));
            item.setText(idx++, Const.NVL((String)v.getComments(), (String)""));
        }
        this.wFields.optWidth(true);
    }

    private void cancel() {
        this.stepname = null;
        this.dispose();
    }

    private void edit() {
        int idx = this.wFields.table.getSelectionIndex();
        if (idx >= 0) {
            this.stepname = this.wFields.table.getItem(idx).getText(5);
            this.dispose();
        } else {
            this.stepname = null;
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"StepFieldsDialog.OriginStep.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"StepFieldsDialog.OriginStep.Message", (String[])new String[0]));
            mb.open();
        }
    }

    public String getShellText() {
        return this.shellText;
    }

    public void setShellText(String shellText) {
        this.shellText = shellText;
    }

    public String getOriginText() {
        return this.originText;
    }

    public void setOriginText(String originText) {
        this.originText = originText;
    }

    public boolean isShowEditButton() {
        return this.showEditButton;
    }

    public void setShowEditButton(boolean showEditButton) {
        this.showEditButton = showEditButton;
    }
}

