/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.dialog;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.Spoon;

public class GetTableSizeProgressDialog {
    private static Class<?> PKG = GetTableSizeProgressDialog.class;
    private Shell shell;
    private DatabaseMeta dbMeta;
    private String tableName;
    private Long size;
    private Database db;

    public GetTableSizeProgressDialog(Shell shell, DatabaseMeta dbInfo, String tableName) {
        this(shell, dbInfo, tableName, null);
    }

    public GetTableSizeProgressDialog(Shell shell, DatabaseMeta dbInfo, String tableName, String schemaName) {
        this.shell = shell;
        this.dbMeta = dbInfo;
        this.tableName = dbInfo.getQuotedSchemaTableCombination(schemaName, tableName);
    }

    public Long open() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                GetTableSizeProgressDialog.this.db = new Database(Spoon.loggingObject, GetTableSizeProgressDialog.this.dbMeta);
                try {
                    GetTableSizeProgressDialog.this.db.connect();
                    String sql = GetTableSizeProgressDialog.this.dbMeta.getDatabaseInterface().getSelectCountStatement(GetTableSizeProgressDialog.this.tableName);
                    RowMetaAndData row = GetTableSizeProgressDialog.this.db.getOneRow(sql);
                    GetTableSizeProgressDialog.this.size = row.getRowMeta().getInteger(row.getData(), 0);
                    if (monitor.isCanceled()) {
                        throw new InvocationTargetException(new Exception("This operation was cancelled!"));
                    }
                }
                catch (KettleException e) {
                    throw new InvocationTargetException(e, "Couldn't get a result because of an error :" + e.toString());
                }
                finally {
                    GetTableSizeProgressDialog.this.db.disconnect();
                }
            }
        };
        try {
            final ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    IProgressMonitor monitor = pmd.getProgressMonitor();
                    while (pmd.getShell() == null || !pmd.getShell().isDisposed() && !monitor.isCanceled()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {}
                    }
                    if (monitor.isCanceled()) {
                        try {
                            GetTableSizeProgressDialog.this.db.cancelQuery();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            };
            new Thread(run).start();
            pmd.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            this.showErrorDialog(e);
            return null;
        }
        catch (InterruptedException e) {
            this.showErrorDialog(e);
            return null;
        }
        return this.size;
    }

    private void showErrorDialog(Exception e) {
        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetTableSizeProgressDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetTableSizeProgressDialog.Error.Message", (String[])new String[0]), e);
    }
}

