/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.cluster.dialog;

import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.cluster.dialog.SlaveServerDialog;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class ClusterSchemaDialog
extends Dialog {
    private static Class<?> PKG = ClusterSchemaDialog.class;
    private ClusterSchema clusterSchema;
    private Shell shell;
    private Text wName;
    private TableView wServers;
    private Button wOK;
    private Button wCancel;
    private ModifyListener lsMod;
    private PropsUI props;
    private int middle;
    private int margin;
    private ClusterSchema originalSchema;
    private boolean ok;
    private Button wSelect;
    private TextVar wPort;
    private TextVar wBufferSize;
    private TextVar wFlushInterval;
    private Button wCompressed;
    private Button wDynamic;
    private List<SlaveServer> slaveServers;

    public ClusterSchemaDialog(Shell par, ClusterSchema clusterSchema, List<SlaveServer> slaveServers) {
        super(par, 0);
        this.clusterSchema = clusterSchema.clone();
        this.originalSchema = clusterSchema;
        this.slaveServers = slaveServers;
        this.props = PropsUI.getInstance();
        this.ok = false;
    }

    public boolean open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageCluster());
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ClusterSchemaDialog.this.clusterSchema.setChanged();
            }
        };
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setText(BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.Shell.Title", (String[])new String[0]));
        this.shell.setLayout((Layout)formLayout);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        Button[] buttons = new Button[]{this.wOK, this.wCancel};
        BaseStepDialog.positionBottomButtons((Composite)this.shell, buttons, this.margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.Schema.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, 0);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(this.middle, 0);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(this.lsMod);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment(0, 0);
        fdName.left = new FormAttachment(this.middle, this.margin);
        fdName.right = new FormAttachment(95, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlPort = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlPort);
        wlPort.setText(BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.Port.Label", (String[])new String[0]));
        FormData fdlPort = new FormData();
        fdlPort.top = new FormAttachment((Control)this.wName, this.margin);
        fdlPort.left = new FormAttachment(0, 0);
        fdlPort.right = new FormAttachment(this.middle, 0);
        wlPort.setLayoutData((Object)fdlPort);
        this.wPort = new TextVar((VariableSpace)this.clusterSchema, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPort);
        this.wPort.addModifyListener(this.lsMod);
        FormData fdPort = new FormData();
        fdPort.top = new FormAttachment((Control)this.wName, this.margin);
        fdPort.left = new FormAttachment(this.middle, this.margin);
        fdPort.right = new FormAttachment(95, 0);
        this.wPort.setLayoutData(fdPort);
        Label wlBufferSize = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlBufferSize);
        wlBufferSize.setText(BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.SocketBufferSize.Label", (String[])new String[0]));
        FormData fdlBufferSize = new FormData();
        fdlBufferSize.top = new FormAttachment((Control)this.wPort, this.margin);
        fdlBufferSize.left = new FormAttachment(0, 0);
        fdlBufferSize.right = new FormAttachment(this.middle, 0);
        wlBufferSize.setLayoutData((Object)fdlBufferSize);
        this.wBufferSize = new TextVar((VariableSpace)this.clusterSchema, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wBufferSize);
        this.wBufferSize.addModifyListener(this.lsMod);
        FormData fdBufferSize = new FormData();
        fdBufferSize.top = new FormAttachment((Control)this.wPort, this.margin);
        fdBufferSize.left = new FormAttachment(this.middle, this.margin);
        fdBufferSize.right = new FormAttachment(95, 0);
        this.wBufferSize.setLayoutData(fdBufferSize);
        Label wlFlushInterval = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlFlushInterval);
        wlFlushInterval.setText(BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.SocketFlushRows.Label", (String[])new String[0]));
        FormData fdlFlushInterval = new FormData();
        fdlFlushInterval.top = new FormAttachment((Control)this.wBufferSize, this.margin);
        fdlFlushInterval.left = new FormAttachment(0, 0);
        fdlFlushInterval.right = new FormAttachment(this.middle, 0);
        wlFlushInterval.setLayoutData((Object)fdlFlushInterval);
        this.wFlushInterval = new TextVar((VariableSpace)this.clusterSchema, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFlushInterval);
        this.wFlushInterval.addModifyListener(this.lsMod);
        FormData fdFlushInterval = new FormData();
        fdFlushInterval.top = new FormAttachment((Control)this.wBufferSize, this.margin);
        fdFlushInterval.left = new FormAttachment(this.middle, this.margin);
        fdFlushInterval.right = new FormAttachment(95, 0);
        this.wFlushInterval.setLayoutData(fdFlushInterval);
        Label wlCompressed = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlCompressed);
        wlCompressed.setText(BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.SocketDataCompressed.Label", (String[])new String[0]));
        FormData fdlCompressed = new FormData();
        fdlCompressed.top = new FormAttachment((Control)this.wFlushInterval, this.margin);
        fdlCompressed.left = new FormAttachment(0, 0);
        fdlCompressed.right = new FormAttachment(this.middle, 0);
        wlCompressed.setLayoutData((Object)fdlCompressed);
        this.wCompressed = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wCompressed);
        FormData fdCompressed = new FormData();
        fdCompressed.top = new FormAttachment((Control)this.wFlushInterval, this.margin);
        fdCompressed.left = new FormAttachment(this.middle, this.margin);
        fdCompressed.right = new FormAttachment(95, 0);
        this.wCompressed.setLayoutData((Object)fdCompressed);
        Label wlDynamic = new Label((Composite)this.shell, 131072);
        wlDynamic.setToolTipText(BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.DynamicCluster.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlDynamic);
        wlDynamic.setText(BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.DynamicCluster.Label", (String[])new String[0]));
        FormData fdlDynamic = new FormData();
        fdlDynamic.top = new FormAttachment((Control)this.wCompressed, this.margin);
        fdlDynamic.left = new FormAttachment(0, 0);
        fdlDynamic.right = new FormAttachment(this.middle, 0);
        wlDynamic.setLayoutData((Object)fdlDynamic);
        this.wDynamic = new Button((Composite)this.shell, 32);
        this.wDynamic.setToolTipText(BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.DynamicCluster.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wDynamic);
        FormData fdDynamic = new FormData();
        fdDynamic.top = new FormAttachment((Control)this.wCompressed, this.margin);
        fdDynamic.left = new FormAttachment(this.middle, this.margin);
        fdDynamic.right = new FormAttachment(95, 0);
        this.wDynamic.setLayoutData((Object)fdDynamic);
        Label wlServers = new Label((Composite)this.shell, 131072);
        wlServers.setText(BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.SlaveServers.Label", (String[])new String[0]));
        this.props.setLook((Control)wlServers);
        FormData fdlServers = new FormData();
        fdlServers.left = new FormAttachment(0, 0);
        fdlServers.right = new FormAttachment(this.middle, 0);
        fdlServers.top = new FormAttachment((Control)this.wDynamic, this.margin);
        wlServers.setLayoutData((Object)fdlServers);
        this.wSelect = new Button((Composite)this.shell, 8);
        this.wSelect.setText(BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.SelectSlaveServers.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wSelect);
        FormData fdSelect = new FormData();
        fdSelect.right = new FormAttachment(100, 0);
        fdSelect.top = new FormAttachment((Control)wlServers, 5 * this.margin);
        this.wSelect.setLayoutData((Object)fdSelect);
        this.wSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClusterSchemaDialog.this.selectSlaveServers();
            }
        });
        ColumnInfo[] partitionColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.ColumnInfoName.Label", (String[])new String[0]), 1, true, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.ColumnInfoServiceURL.Label", (String[])new String[0]), 1, true, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.ColumnInfoMaster.Label", (String[])new String[0]), 1, true, true)};
        this.wServers = new TableView((VariableSpace)this.clusterSchema, (Composite)this.shell, 67588, partitionColumns, 1, this.lsMod, this.props);
        this.wServers.setReadonly(false);
        this.props.setLook((Control)this.wServers);
        FormData fdServers = new FormData();
        fdServers.left = new FormAttachment(this.middle, this.margin);
        fdServers.right = new FormAttachment((Control)this.wSelect, -2 * this.margin);
        fdServers.top = new FormAttachment((Control)this.wDynamic, this.margin);
        fdServers.bottom = new FormAttachment((Control)this.wOK, -this.margin * 2);
        this.wServers.setLayoutData(fdServers);
        this.wServers.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ClusterSchemaDialog.this.editSlaveServer();
            }
        });
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ClusterSchemaDialog.this.ok();
            }
        });
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ClusterSchemaDialog.this.cancel();
            }
        });
        SelectionAdapter selAdapter = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ClusterSchemaDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)selAdapter);
        this.wPort.addSelectionListener(selAdapter);
        this.wBufferSize.addSelectionListener(selAdapter);
        this.wFlushInterval.addSelectionListener(selAdapter);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ClusterSchemaDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.ok;
    }

    private void editSlaveServer() {
        SlaveServerDialog dialog;
        SlaveServer slaveServer;
        int idx = this.wServers.getSelectionIndex();
        if (idx >= 0 && (slaveServer = this.clusterSchema.findSlaveServer(this.wServers.getItems(0)[idx])) != null && (dialog = new SlaveServerDialog(this.shell, slaveServer)).open()) {
            this.refreshSlaveServers();
        }
    }

    private void selectSlaveServers() {
        String[] names = SlaveServer.getSlaveServerNames(this.slaveServers);
        int[] idx = Const.indexsOfFoundStrings((String[])this.wServers.getItems(0), (String[])names);
        EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, names, BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.SelectServers.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ClusterSchemaDialog.SelectServersCluster.Label", (String[])new String[0]));
        dialog.setAvoidQuickSearch();
        dialog.setSelectedNrs(idx);
        dialog.setMulti(true);
        if (dialog.open() != null) {
            this.clusterSchema.getSlaveServers().clear();
            int[] indeces = dialog.getSelectionIndeces();
            for (int i = 0; i < indeces.length; ++i) {
                SlaveServer slaveServer = SlaveServer.findSlaveServer(this.slaveServers, (String)names[indeces[i]]);
                this.clusterSchema.getSlaveServers().add(slaveServer);
            }
            this.refreshSlaveServers();
        }
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.NVL((String)this.clusterSchema.getName(), (String)""));
        this.wPort.setText(Const.NVL((String)this.clusterSchema.getBasePort(), (String)""));
        this.wBufferSize.setText(Const.NVL((String)this.clusterSchema.getSocketsBufferSize(), (String)""));
        this.wFlushInterval.setText(Const.NVL((String)this.clusterSchema.getSocketsFlushInterval(), (String)""));
        this.wCompressed.setSelection(this.clusterSchema.isSocketsCompressed());
        this.wDynamic.setSelection(this.clusterSchema.isDynamic());
        this.refreshSlaveServers();
        this.wName.setFocus();
    }

    private void refreshSlaveServers() {
        this.wServers.clearAll(false);
        List slServers = this.clusterSchema.getSlaveServers();
        for (int i = 0; i < slServers.size(); ++i) {
            TableItem item = new TableItem(this.wServers.table, 0);
            SlaveServer slaveServer = (SlaveServer)slServers.get(i);
            item.setText(1, Const.NVL((String)slaveServer.getName(), (String)""));
            item.setText(2, Const.NVL((String)slaveServer.toString(), (String)""));
            item.setText(3, slaveServer.isMaster() ? "Y" : "N");
        }
        this.wServers.removeEmptyRows();
        this.wServers.setRowNums();
        this.wServers.optWidth(true);
    }

    private void cancel() {
        this.originalSchema = null;
        this.dispose();
    }

    public void ok() {
        this.getInfo();
        this.originalSchema.setName(this.clusterSchema.getName());
        this.originalSchema.setBasePort(this.clusterSchema.getBasePort());
        this.originalSchema.setSocketsBufferSize(this.clusterSchema.getSocketsBufferSize());
        this.originalSchema.setSocketsFlushInterval(this.clusterSchema.getSocketsFlushInterval());
        this.originalSchema.setSocketsCompressed(this.clusterSchema.isSocketsCompressed());
        this.originalSchema.setDynamic(this.clusterSchema.isDynamic());
        this.originalSchema.setSlaveServers(this.clusterSchema.getSlaveServers());
        this.originalSchema.setChanged();
        this.ok = true;
        this.dispose();
    }

    private void getInfo() {
        this.clusterSchema.setName(this.wName.getText());
        this.clusterSchema.setBasePort(this.wPort.getText());
        this.clusterSchema.setSocketsBufferSize(this.wBufferSize.getText());
        this.clusterSchema.setSocketsFlushInterval(this.wFlushInterval.getText());
        this.clusterSchema.setSocketsCompressed(this.wCompressed.getSelection());
        this.clusterSchema.setDynamic(this.wDynamic.getSelection());
        String[] names = SlaveServer.getSlaveServerNames(this.slaveServers);
        int[] idx = Const.indexsOfFoundStrings((String[])this.wServers.getItems(0), (String[])names);
        this.clusterSchema.getSlaveServers().clear();
        for (int i = 0; i < idx.length; ++i) {
            SlaveServer slaveServer = SlaveServer.findSlaveServer(this.slaveServers, (String)names[idx[i]]);
            this.clusterSchema.getSlaveServers().add(slaveServer);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

