/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTransactionRollbackException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnListImpl;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnState;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.util.StringUtils;

public class TxnHandler {
    public static final String INITIATED_RESPONSE = "initiated";
    public static final String WORKING_RESPONSE = "working";
    public static final String CLEANING_RESPONSE = "ready for cleaning";
    protected static final char INITIATED_STATE = 'i';
    protected static final char WORKING_STATE = 'w';
    protected static final char READY_FOR_CLEANING = 'r';
    protected static final char MAJOR_TYPE = 'a';
    protected static final char MINOR_TYPE = 'i';
    protected static final char TXN_ABORTED = 'a';
    protected static final char TXN_OPEN = 'o';
    private static final char LOCK_ACQUIRED = 'a';
    private static final char LOCK_WAITING = 'w';
    private static final char LOCK_EXCLUSIVE = 'e';
    private static final char LOCK_SHARED = 'r';
    private static final char LOCK_SEMI_SHARED = 'w';
    private static final int ALLOWED_REPEATED_DEADLOCKS = 5;
    private static final Log LOG = LogFactory.getLog((String)TxnHandler.class.getName());
    private static BoneCP connPool;
    private static Boolean lockLock;
    protected int deadlockCnt;
    protected HiveConf conf;
    private long timeout;
    private static Map<LockType, Map<LockType, Map<LockState, LockAction>>> jumpTable;

    public TxnHandler(HiveConf conf) {
        this.conf = conf;
        this.checkQFileTestHack();
        try {
            TxnHandler.setupJdbcConnectionPool(conf);
        }
        catch (SQLException e) {
            String msg = "Unable to instantiate JDBC connection pooling, " + e.getMessage();
            LOG.error((Object)msg);
            throw new RuntimeException(e);
        }
        this.timeout = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
        this.deadlockCnt = 0;
        TxnHandler.buildJumpTable();
    }

    public GetOpenTxnsInfoResponse getOpenTxnsInfo() throws MetaException {
        Connection dbConn = this.getDbConn();
        try {
            Statement stmt = dbConn.createStatement();
            LOG.debug((Object)"Going to execute query <select ntxn_next - 1 from NEXT_TXN_ID>");
            ResultSet rs = stmt.executeQuery("select ntxn_next - 1 from NEXT_TXN_ID");
            if (!rs.next()) {
                throw new MetaException("Transaction tables not properly initialized, no record found in next_txn_id");
            }
            long hwm = rs.getLong(1);
            if (rs.wasNull()) {
                throw new MetaException("Transaction tables not properly initialized, null record found in next_txn_id");
            }
            ArrayList<TxnInfo> txnInfo = new ArrayList<TxnInfo>();
            LOG.debug((Object)"Going to execute query<select txn_id, txn_state from TXNS>");
            rs = stmt.executeQuery("select txn_id, txn_state, txn_user, txn_host from TXNS");
            while (rs.next()) {
                TxnState state;
                char c = rs.getString(2).charAt(0);
                switch (c) {
                    case 'a': {
                        state = TxnState.ABORTED;
                        break;
                    }
                    case 'o': {
                        state = TxnState.OPEN;
                        break;
                    }
                    default: {
                        throw new MetaException("Unexpected transaction state " + c + " found in txns table");
                    }
                }
                txnInfo.add(new TxnInfo(rs.getLong(1), state, rs.getString(3), rs.getString(4)));
            }
            stmt.close();
            LOG.debug((Object)"Going to rollback");
            dbConn.rollback();
            GetOpenTxnsInfoResponse getOpenTxnsInfoResponse = new GetOpenTxnsInfoResponse(hwm, txnInfo);
            return getOpenTxnsInfoResponse;
        }
        catch (SQLException e) {
            try {
                LOG.debug((Object)"Going to rollback");
                dbConn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new MetaException("Unable to select from transaction database, " + StringUtils.stringifyException((Throwable)e));
        }
        finally {
            this.closeDbConn(dbConn);
        }
    }

    public GetOpenTxnsResponse getOpenTxns() throws MetaException {
        Connection dbConn = this.getDbConn();
        try {
            Statement stmt = dbConn.createStatement();
            LOG.debug((Object)"Going to execute query <select ntxn_next - 1 from NEXT_TXN_ID>");
            ResultSet rs = stmt.executeQuery("select ntxn_next - 1 from NEXT_TXN_ID");
            if (!rs.next()) {
                throw new MetaException("Transaction tables not properly initialized, no record found in next_txn_id");
            }
            long hwm = rs.getLong(1);
            if (rs.wasNull()) {
                throw new MetaException("Transaction tables not properly initialized, null record found in next_txn_id");
            }
            HashSet<Long> openList = new HashSet<Long>();
            LOG.debug((Object)"Going to execute query<select txn_id from TXNS>");
            rs = stmt.executeQuery("select txn_id from TXNS");
            while (rs.next()) {
                openList.add(rs.getLong(1));
            }
            stmt.close();
            LOG.debug((Object)"Going to rollback");
            dbConn.rollback();
            GetOpenTxnsResponse getOpenTxnsResponse = new GetOpenTxnsResponse(hwm, openList);
            return getOpenTxnsResponse;
        }
        catch (SQLException e) {
            try {
                LOG.debug((Object)"Going to rollback");
                dbConn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new MetaException("Unable to select from transaction database, " + StringUtils.stringifyException((Throwable)e));
        }
        finally {
            this.closeDbConn(dbConn);
        }
    }

    public static ValidTxnList createValidTxnList(GetOpenTxnsResponse txns) {
        long highWater = txns.getTxn_high_water_mark();
        Set<Long> open = txns.getOpen_txns();
        long[] exceptions = new long[open.size()];
        int i = 0;
        for (long txn : open) {
            exceptions[i++] = txn;
        }
        return new ValidTxnListImpl(exceptions, highWater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenTxnsResponse openTxns(OpenTxnRequest rqst) throws MetaException {
        int numTxns = rqst.getNum_txns();
        try {
            Connection dbConn = this.getDbConn();
            try {
                int maxTxns = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_MAX_OPEN_BATCH);
                if (numTxns > maxTxns) {
                    numTxns = maxTxns;
                }
                Statement stmt = dbConn.createStatement();
                LOG.debug((Object)"Going to execute query <select ntxn_next from NEXT_TXN_ID  for update>");
                ResultSet rs = stmt.executeQuery("select ntxn_next from NEXT_TXN_ID for update");
                if (!rs.next()) {
                    throw new MetaException("Transaction database not properly configured, can't find next transaction id.");
                }
                long first = rs.getLong(1);
                String s = "update NEXT_TXN_ID set ntxn_next = " + (first + (long)numTxns);
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                stmt.executeUpdate(s);
                long now = System.currentTimeMillis();
                s = "insert into TXNS (txn_id, txn_state, txn_started, txn_last_heartbeat, txn_user, txn_host) values (?, 'o', " + now + ", " + now + ", '" + rqst.getUser() + "', '" + rqst.getHostname() + "')";
                LOG.debug((Object)("Going to prepare statement <" + s + ">"));
                PreparedStatement ps = dbConn.prepareStatement(s);
                ArrayList<Long> txnIds = new ArrayList<Long>(numTxns);
                for (long i = first; i < first + (long)numTxns; ++i) {
                    ps.setLong(1, i);
                    ps.executeUpdate();
                    txnIds.add(i);
                }
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
                OpenTxnsResponse openTxnsResponse = new OpenTxnsResponse(txnIds);
                this.closeDbConn(dbConn);
                return openTxnsResponse;
            }
            catch (SQLException e) {
                try {
                    try {
                        try {
                            LOG.debug((Object)"Going to rollback");
                            dbConn.rollback();
                        }
                        catch (SQLException e1) {
                            // empty catch block
                        }
                        this.detectDeadlock(e, "openTxns");
                        throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException((Throwable)e));
                    }
                    catch (Throwable throwable) {
                        this.closeDbConn(dbConn);
                        throw throwable;
                    }
                }
                catch (DeadlockException e2) {
                    OpenTxnsResponse openTxnsResponse = this.openTxns(rqst);
                    return openTxnsResponse;
                }
            }
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortTxn(AbortTxnRequest rqst) throws NoSuchTxnException, MetaException {
        long txnid = rqst.getTxnid();
        try {
            Connection dbConn = this.getDbConn();
            try {
                Statement stmt = dbConn.createStatement();
                String s = "delete from HIVE_LOCKS where hl_txnid = " + txnid;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                stmt.executeUpdate(s);
                s = "update TXNS set txn_state = 'a' where txn_id = " + txnid;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                int updateCnt = stmt.executeUpdate(s);
                if (updateCnt != 1) {
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                    throw new NoSuchTxnException("No such transaction: " + txnid);
                }
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                this.detectDeadlock(e, "abortTxn");
                throw new MetaException("Unable to update transaction database " + StringUtils.stringifyException((Throwable)e));
            }
            finally {
                this.closeDbConn(dbConn);
            }
        }
        catch (DeadlockException e) {
            this.abortTxn(rqst);
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTxn(CommitTxnRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        long txnid = rqst.getTxnid();
        try {
            Connection dbConn = this.getDbConn();
            try {
                Statement stmt = dbConn.createStatement();
                this.heartbeatTxn(dbConn, txnid);
                String s = "insert into COMPLETED_TXN_COMPONENTS select tc_txnid, tc_database, tc_table, tc_partition from TXN_COMPONENTS where tc_txnid = " + txnid;
                LOG.debug((Object)("Going to execute insert <" + s + ">"));
                if (stmt.executeUpdate(s) < 1) {
                    LOG.warn((Object)"Expected to move at least one record from txn_components to completed_txn_components when committing txn!");
                }
                s = "delete from TXN_COMPONENTS where tc_txnid = " + txnid;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                stmt.executeUpdate(s);
                s = "delete from HIVE_LOCKS where hl_txnid = " + txnid;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                stmt.executeUpdate(s);
                s = "delete from TXNS where txn_id = " + txnid;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                stmt.executeUpdate(s);
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                this.detectDeadlock(e, "commitTxn");
                throw new MetaException("Unable to update transaction database " + StringUtils.stringifyException((Throwable)e));
            }
            finally {
                this.closeDbConn(dbConn);
            }
        }
        catch (DeadlockException e) {
            this.commitTxn(rqst);
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockResponse lock(LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        try {
            Connection dbConn = this.getDbConn();
            try {
                LockResponse lockResponse = this.lock(dbConn, rqst, true);
                this.closeDbConn(dbConn);
                return lockResponse;
            }
            catch (SQLException e) {
                try {
                    try {
                        try {
                            LOG.debug((Object)"Going to rollback");
                            dbConn.rollback();
                        }
                        catch (SQLException e1) {
                            // empty catch block
                        }
                        this.detectDeadlock(e, "lock");
                        throw new MetaException("Unable to update transaction database " + StringUtils.stringifyException((Throwable)e));
                    }
                    catch (Throwable throwable) {
                        this.closeDbConn(dbConn);
                        throw throwable;
                    }
                }
                catch (DeadlockException e2) {
                    LockResponse lockResponse = this.lock(rqst);
                    return lockResponse;
                }
            }
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockResponse lockNoWait(LockRequest rqst) throws NoSuchTxnException, TxnAbortedException, MetaException {
        try {
            Connection dbConn = this.getDbConn();
            try {
                LockResponse lockResponse = this.lock(dbConn, rqst, false);
                this.closeDbConn(dbConn);
                return lockResponse;
            }
            catch (SQLException e) {
                try {
                    try {
                        try {
                            LOG.debug((Object)"Going to rollback");
                            dbConn.rollback();
                        }
                        catch (SQLException e1) {
                            // empty catch block
                        }
                        this.detectDeadlock(e, "lockNoWait");
                        throw new MetaException("Unable to update transaction database " + StringUtils.stringifyException((Throwable)e));
                    }
                    catch (Throwable throwable) {
                        this.closeDbConn(dbConn);
                        throw throwable;
                    }
                }
                catch (DeadlockException e2) {
                    LockResponse lockResponse = this.lockNoWait(rqst);
                    return lockResponse;
                }
            }
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockResponse checkLock(CheckLockRequest rqst) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        try {
            Connection dbConn = this.getDbConn();
            try {
                long extLockId = rqst.getLockid();
                this.timeOutLocks(dbConn);
                this.heartbeatLock(dbConn, extLockId);
                long txnid = this.getTxnIdFromLockId(dbConn, extLockId);
                if (txnid > 0L) {
                    this.heartbeatTxn(dbConn, txnid);
                }
                LockResponse lockResponse = this.checkLock(dbConn, extLockId, txnid, true);
                this.closeDbConn(dbConn);
                return lockResponse;
            }
            catch (SQLException e) {
                try {
                    try {
                        try {
                            LOG.debug((Object)"Going to rollback");
                            dbConn.rollback();
                        }
                        catch (SQLException e1) {
                            // empty catch block
                        }
                        this.detectDeadlock(e, "checkLock");
                        throw new MetaException("Unable to update transaction database " + StringUtils.stringifyException((Throwable)e));
                    }
                    catch (Throwable throwable) {
                        this.closeDbConn(dbConn);
                        throw throwable;
                    }
                }
                catch (DeadlockException e2) {
                    LockResponse lockResponse = this.checkLock(rqst);
                    return lockResponse;
                }
            }
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(UnlockRequest rqst) throws NoSuchLockException, TxnOpenException, MetaException {
        try {
            Connection dbConn = this.getDbConn();
            try {
                long extLockId = rqst.getLockid();
                this.heartbeatLock(dbConn, extLockId);
                long txnid = this.getTxnIdFromLockId(dbConn, extLockId);
                if (txnid > 0L) {
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                    String msg = "Unlocking locks associated with transaction not permitted.  Lockid " + extLockId + " is associated with " + "transaction " + txnid;
                    LOG.error((Object)msg);
                    throw new TxnOpenException(msg);
                }
                Statement stmt = dbConn.createStatement();
                String s = "delete from HIVE_LOCKS where hl_lock_ext_id = " + extLockId;
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                int rc = stmt.executeUpdate(s);
                if (rc < 1) {
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                    throw new NoSuchLockException("No such lock: " + extLockId);
                }
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                this.detectDeadlock(e, "unlock");
                throw new MetaException("Unable to update transaction database " + StringUtils.stringifyException((Throwable)e));
            }
            finally {
                this.closeDbConn(dbConn);
            }
        }
        catch (DeadlockException e) {
            this.unlock(rqst);
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    public ShowLocksResponse showLocks(ShowLocksRequest rqst) throws MetaException {
        Connection dbConn = this.getDbConn();
        ShowLocksResponse rsp = new ShowLocksResponse();
        ArrayList<ShowLocksResponseElement> elems = new ArrayList<ShowLocksResponseElement>();
        try {
            Statement stmt = dbConn.createStatement();
            String s = "select hl_lock_ext_id, hl_txnid, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_last_heartbeat, hl_acquired_at, hl_user, hl_host from HIVE_LOCKS";
            LOG.debug((Object)("Doing to execute query <" + s + ">"));
            ResultSet rs = stmt.executeQuery(s);
            while (rs.next()) {
                ShowLocksResponseElement e = new ShowLocksResponseElement();
                e.setLockid(rs.getLong(1));
                long txnid = rs.getLong(2);
                if (!rs.wasNull()) {
                    e.setTxnid(txnid);
                }
                e.setDbname(rs.getString(3));
                e.setTablename(rs.getString(4));
                String partition = rs.getString(5);
                if (partition != null) {
                    e.setPartname(partition);
                }
                switch (rs.getString(6).charAt(0)) {
                    case 'a': {
                        e.setState(LockState.ACQUIRED);
                        break;
                    }
                    case 'w': {
                        e.setState(LockState.WAITING);
                        break;
                    }
                    default: {
                        throw new MetaException("Unknown lock state " + rs.getString(6).charAt(0));
                    }
                }
                switch (rs.getString(7).charAt(0)) {
                    case 'w': {
                        e.setType(LockType.SHARED_WRITE);
                        break;
                    }
                    case 'e': {
                        e.setType(LockType.EXCLUSIVE);
                        break;
                    }
                    case 'r': {
                        e.setType(LockType.SHARED_READ);
                        break;
                    }
                    default: {
                        throw new MetaException("Unknown lock type " + rs.getString(6).charAt(0));
                    }
                }
                e.setLastheartbeat(rs.getLong(8));
                long acquiredAt = rs.getLong(9);
                if (!rs.wasNull()) {
                    e.setAcquiredat(acquiredAt);
                }
                e.setUser(rs.getString(10));
                e.setHostname(rs.getString(11));
                elems.add(e);
            }
            LOG.debug((Object)"Going to rollback");
            dbConn.rollback();
        }
        catch (SQLException e) {
            throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException((Throwable)e));
        }
        finally {
            this.closeDbConn(dbConn);
        }
        rsp.setLocks(elems);
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void heartbeat(HeartbeatRequest ids) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException {
        try {
            Connection dbConn = this.getDbConn();
            try {
                this.heartbeatLock(dbConn, ids.getLockid());
                this.heartbeatTxn(dbConn, ids.getTxnid());
            }
            catch (SQLException e) {
                try {
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                this.detectDeadlock(e, "heartbeat");
                throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException((Throwable)e));
            }
            finally {
                this.closeDbConn(dbConn);
            }
        }
        catch (DeadlockException e) {
            this.heartbeat(ids);
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    public HeartbeatTxnRangeResponse heartbeatTxnRange(HeartbeatTxnRangeRequest rqst) throws MetaException {
        Connection dbConn = this.getDbConn();
        HeartbeatTxnRangeResponse rsp = new HeartbeatTxnRangeResponse();
        HashSet<Long> nosuch = new HashSet<Long>();
        HashSet<Long> aborted = new HashSet<Long>();
        rsp.setNosuch(nosuch);
        rsp.setAborted(aborted);
        try {
            for (long txn = rqst.getMin(); txn <= rqst.getMax(); ++txn) {
                try {
                    this.heartbeatTxn(dbConn, txn);
                    continue;
                }
                catch (NoSuchTxnException e) {
                    nosuch.add(txn);
                    continue;
                }
                catch (TxnAbortedException e) {
                    aborted.add(txn);
                }
            }
            HeartbeatTxnRangeResponse txn = rsp;
            this.closeDbConn(dbConn);
            return txn;
        }
        catch (SQLException e) {
            try {
                try {
                    try {
                        LOG.debug((Object)"Going to rollback");
                        dbConn.rollback();
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                    this.detectDeadlock(e, "heartbeatTxnRange");
                    throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException((Throwable)e));
                }
                catch (Throwable throwable) {
                    this.closeDbConn(dbConn);
                    throw throwable;
                }
            }
            catch (DeadlockException e2) {
                return this.heartbeatTxnRange(rqst);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact(CompactionRequest rqst) throws MetaException {
        try {
            Connection dbConn = this.getDbConn();
            try {
                Statement stmt = dbConn.createStatement();
                String s = "select ncq_next from NEXT_COMPACTION_QUEUE_ID for update";
                LOG.debug((Object)("going to execute query <" + s + ">"));
                ResultSet rs = stmt.executeQuery(s);
                if (!rs.next()) {
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                    throw new MetaException("Transaction tables not properly initiated, no record found in next_compaction_queue_id");
                }
                long id = rs.getLong(1);
                s = "update NEXT_COMPACTION_QUEUE_ID set ncq_next = " + (id + 1L);
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                stmt.executeUpdate(s);
                StringBuilder buf = new StringBuilder("insert into COMPACTION_QUEUE (cq_id, cq_database, cq_table, ");
                String partName = rqst.getPartitionname();
                if (partName != null) {
                    buf.append("cq_partition, ");
                }
                buf.append("cq_state, cq_type");
                if (rqst.getRunas() != null) {
                    buf.append(", cq_run_as");
                }
                buf.append(") values (");
                buf.append(id);
                buf.append(", '");
                buf.append(rqst.getDbname());
                buf.append("', '");
                buf.append(rqst.getTablename());
                buf.append("', '");
                if (partName != null) {
                    buf.append(partName);
                    buf.append("', '");
                }
                buf.append('i');
                buf.append("', '");
                switch (rqst.getType()) {
                    case MAJOR: {
                        buf.append('a');
                        break;
                    }
                    case MINOR: {
                        buf.append('i');
                        break;
                    }
                    default: {
                        LOG.debug((Object)"Going to rollback");
                        dbConn.rollback();
                        throw new MetaException("Unexpected compaction type " + rqst.getType().toString());
                    }
                }
                if (rqst.getRunas() != null) {
                    buf.append("', '");
                    buf.append(rqst.getRunas());
                }
                buf.append("')");
                s = buf.toString();
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                stmt.executeUpdate(s);
                LOG.debug((Object)"Going to commit");
                dbConn.commit();
            }
            catch (SQLException e) {
                try {
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                this.detectDeadlock(e, "compact");
                throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException((Throwable)e));
            }
            finally {
                this.closeDbConn(dbConn);
            }
        }
        catch (DeadlockException e) {
            this.compact(rqst);
        }
        finally {
            this.deadlockCnt = 0;
        }
    }

    public ShowCompactResponse showCompact(ShowCompactRequest rqst) throws MetaException {
        ShowCompactResponse response = new ShowCompactResponse();
        Connection dbConn = this.getDbConn();
        try {
            Statement stmt = dbConn.createStatement();
            String s = "select cq_database, cq_table, cq_partition, cq_state, cq_type, cq_worker_id, cq_start, cq_run_as from COMPACTION_QUEUE";
            LOG.debug((Object)("Going to execute query <" + s + ">"));
            ResultSet rs = stmt.executeQuery(s);
            while (rs.next()) {
                ShowCompactResponseElement e = new ShowCompactResponseElement();
                e.setDbname(rs.getString(1));
                e.setTablename(rs.getString(2));
                e.setPartitionname(rs.getString(3));
                switch (rs.getString(4).charAt(0)) {
                    case 'i': {
                        e.setState(INITIATED_RESPONSE);
                        break;
                    }
                    case 'w': {
                        e.setState(WORKING_RESPONSE);
                        break;
                    }
                    case 'r': {
                        e.setState(CLEANING_RESPONSE);
                        break;
                    }
                    default: {
                        throw new MetaException("Unexpected compaction state " + rs.getString(4));
                    }
                }
                switch (rs.getString(5).charAt(0)) {
                    case 'a': {
                        e.setType(CompactionType.MAJOR);
                        break;
                    }
                    case 'i': {
                        e.setType(CompactionType.MINOR);
                        break;
                    }
                    default: {
                        throw new MetaException("Unexpected compaction type " + rs.getString(5));
                    }
                }
                e.setWorkerid(rs.getString(6));
                e.setStart(rs.getLong(7));
                e.setRunAs(rs.getString(8));
                response.addToCompacts(e);
            }
            LOG.debug((Object)"Going to rollback");
            dbConn.rollback();
        }
        catch (SQLException e) {
            LOG.debug((Object)"Going to rollback");
            try {
                dbConn.rollback();
            }
            catch (SQLException e1) {
                // empty catch block
            }
            throw new MetaException("Unable to select from transaction database " + StringUtils.stringifyException((Throwable)e));
        }
        finally {
            this.closeDbConn(dbConn);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numLocksInLockTable() throws SQLException, MetaException {
        Connection dbConn = this.getDbConn();
        try {
            Statement stmt = dbConn.createStatement();
            String s = "select count(*) from HIVE_LOCKS";
            LOG.debug((Object)("Going to execute query <" + s + ">"));
            ResultSet rs = stmt.executeQuery(s);
            rs.next();
            int rc = rs.getInt(1);
            dbConn.rollback();
            int n = rc;
            return n;
        }
        finally {
            this.closeDbConn(dbConn);
        }
    }

    long setTimeout(long milliseconds) {
        long previous_timeout = this.timeout;
        this.timeout = milliseconds;
        return previous_timeout;
    }

    protected Connection getDbConn() throws MetaException {
        try {
            Connection dbConn = connPool.getConnection();
            dbConn.setAutoCommit(false);
            dbConn.setTransactionIsolation(4);
            return dbConn;
        }
        catch (SQLException e) {
            String msg = "Unable to get jdbc connection from pool, " + e.getMessage();
            throw new MetaException(msg);
        }
    }

    protected void closeDbConn(Connection dbConn) {
        try {
            if (dbConn != null) {
                dbConn.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)("Failed to close db connection " + e.getMessage()));
        }
    }

    protected void detectDeadlock(SQLException e, String caller) throws DeadlockException {
        String mysqlDeadlock = "Deadlock found when trying to get lock; try restarting transaction";
        if (e.getMessage().contains("Deadlock found when trying to get lock; try restarting transaction") || e instanceof SQLTransactionRollbackException) {
            if (this.deadlockCnt++ < 5) {
                LOG.warn((Object)("Deadlock detected in " + caller + ", trying again."));
                throw new DeadlockException();
            }
            LOG.error((Object)("Too many repeated deadlocks in " + caller + ", giving up."));
            this.deadlockCnt = 0;
        }
    }

    private void checkQFileTestHack() {
        block3: {
            boolean hackOn = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST);
            if (hackOn) {
                LOG.info((Object)"Hacking in canned values for transaction manager");
                TxnDbUtil.setConfValues(this.conf);
                try {
                    TxnDbUtil.prepDb();
                }
                catch (Exception e) {
                    if (e.getMessage().contains("already exists")) break block3;
                    throw new RuntimeException("Unable to set up transaction database for testing: " + e.getMessage());
                }
            }
        }
    }

    private LockResponse lock(Connection dbConn, LockRequest rqst, boolean wait) throws NoSuchTxnException, TxnAbortedException, MetaException, SQLException {
        Boolean bl = lockLock;
        synchronized (bl) {
            this.timeOutLocks(dbConn);
            try {
                Statement stmt = dbConn.createStatement();
                LOG.debug((Object)"Going to execute query <select nl_next from NEXT_LOCK_ID for update>");
                ResultSet rs = stmt.executeQuery("select nl_next from NEXT_LOCK_ID for update");
                if (!rs.next()) {
                    LOG.debug((Object)"Going to rollback");
                    dbConn.rollback();
                    throw new MetaException("Transaction tables not properly initialized, no record found in next_lock_id");
                }
                long extLockId = rs.getLong(1);
                String s = "update NEXT_LOCK_ID set nl_next = " + (extLockId + 1L);
                LOG.debug((Object)("Going to execute update <" + s + ">"));
                stmt.executeUpdate(s);
                LOG.debug((Object)"Going to commit.");
                dbConn.commit();
                long txnid = rqst.getTxnid();
                if (txnid > 0L) {
                    this.heartbeatTxn(dbConn, txnid);
                    for (LockComponent lc : rqst.getComponent()) {
                        String dbName = lc.getDbname();
                        String tblName = lc.getTablename();
                        String partName = lc.getPartitionname();
                        s = "insert into TXN_COMPONENTS (tc_txnid, tc_database, tc_table, tc_partition) values (" + txnid + ", '" + dbName + "', " + (tblName == null ? "null" : "'" + tblName + "'") + ", " + (partName == null ? "null" : "'" + partName + "'") + ")";
                        LOG.debug((Object)("Going to execute update <" + s + ">"));
                        stmt.executeUpdate(s);
                    }
                }
                long intLockId = 0L;
                for (LockComponent lc : rqst.getComponent()) {
                    ++intLockId;
                    String dbName = lc.getDbname();
                    String tblName = lc.getTablename();
                    String partName = lc.getPartitionname();
                    LockType lockType = lc.getType();
                    char lockChar = 'z';
                    switch (lockType) {
                        case EXCLUSIVE: {
                            lockChar = 'e';
                            break;
                        }
                        case SHARED_READ: {
                            lockChar = 'r';
                            break;
                        }
                        case SHARED_WRITE: {
                            lockChar = 'w';
                        }
                    }
                    long now = System.currentTimeMillis();
                    s = "insert into HIVE_LOCKS  (hl_lock_ext_id, hl_lock_int_id, hl_txnid, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type, hl_last_heartbeat, hl_user, hl_host) values (" + extLockId + ", " + intLockId + "," + (txnid >= 0L ? Long.valueOf(txnid) : "null") + ", '" + dbName + "', " + (tblName == null ? "null" : "'" + tblName + "'") + ", " + (partName == null ? "null" : "'" + partName + "'") + ", '" + 'w' + "', " + "'" + lockChar + "', " + now + ", '" + rqst.getUser() + "', '" + rqst.getHostname() + "')";
                    LOG.debug((Object)("Going to execute update <" + s + ">"));
                    stmt.executeUpdate(s);
                }
                LockResponse rsp = this.checkLock(dbConn, extLockId, txnid, wait);
                if (!wait && rsp.getState() != LockState.ACQUIRED) {
                    LOG.debug((Object)"Lock not acquired, going to rollback");
                    dbConn.rollback();
                    rsp = new LockResponse();
                    rsp.setState(LockState.NOT_ACQUIRED);
                }
                return rsp;
            }
            catch (NoSuchLockException e) {
                throw new MetaException("Couldn't find a lock we just created!");
            }
        }
    }

    private LockResponse checkLock(Connection dbConn, long extLockId, long txnid, boolean alwaysCommit) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, MetaException, SQLException {
        List<LockInfo> locksBeingChecked = this.getLockInfoFromLockId(dbConn, extLockId);
        LockResponse response = new LockResponse();
        response.setLockid(extLockId);
        long now = System.currentTimeMillis();
        LOG.debug((Object)"Setting savepoint");
        Savepoint save = dbConn.setSavepoint();
        Statement stmt = dbConn.createStatement();
        StringBuilder query = new StringBuilder("select hl_lock_ext_id, hl_lock_int_id, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type from HIVE_LOCKS where hl_db in (");
        HashSet<String> strings = new HashSet<String>(locksBeingChecked.size());
        for (LockInfo info : locksBeingChecked) {
            strings.add(info.db);
        }
        boolean first = true;
        for (String s : strings) {
            if (first) {
                first = false;
            } else {
                query.append(", ");
            }
            query.append('\'');
            query.append(s);
            query.append('\'');
        }
        query.append(")");
        boolean sawNull = false;
        strings.clear();
        for (LockInfo info : locksBeingChecked) {
            if (info.table == null) {
                sawNull = true;
                break;
            }
            strings.add(info.table);
        }
        if (!sawNull) {
            query.append(" and (hl_table is null or hl_table in(");
            first = true;
            for (String s : strings) {
                if (first) {
                    first = false;
                } else {
                    query.append(", ");
                }
                query.append('\'');
                query.append(s);
                query.append('\'');
            }
            query.append("))");
            sawNull = false;
            strings.clear();
            for (LockInfo info : locksBeingChecked) {
                if (info.partition == null) {
                    sawNull = true;
                    break;
                }
                strings.add(info.partition);
            }
            if (!sawNull) {
                query.append(" and (hl_partition is null or hl_partition in(");
                first = true;
                for (String s : strings) {
                    if (first) {
                        first = false;
                    } else {
                        query.append(", ");
                    }
                    query.append('\'');
                    query.append(s);
                    query.append('\'');
                }
                query.append("))");
            }
        }
        query.append(" for update");
        LOG.debug((Object)("Going to execute query <" + query.toString() + ">"));
        ResultSet rs = stmt.executeQuery(query.toString());
        TreeSet<LockInfo> lockSet = new TreeSet<LockInfo>(new LockInfoComparator());
        while (rs.next()) {
            lockSet.add(new LockInfo(rs));
        }
        LockInfo[] locks = lockSet.toArray(new LockInfo[1]);
        for (LockInfo info : locksBeingChecked) {
            int i;
            int index = -1;
            for (i = 0; i < locks.length; ++i) {
                if (!locks[i].equals(info)) continue;
                index = i;
                break;
            }
            if (index == -1) {
                LOG.debug((Object)"Going to rollback");
                dbConn.rollback();
                throw new MetaException("How did we get here, we heartbeated our lock before we started!");
            }
            if (locks[index].state == LockState.ACQUIRED) continue;
            block14: for (i = index - 1; i >= 0; --i) {
                if (!locks[index].db.equals(locks[i].db) || locks[index].table != null && locks[i].table != null && !locks[index].table.equals(locks[i].table) || locks[index].partition != null && locks[i].partition != null && !locks[index].partition.equals(locks[i].partition)) continue;
                switch (jumpTable.get((Object)locks[index].type).get((Object)locks[i].type).get((Object)locks[i].state)) {
                    case ACQUIRE: {
                        this.acquire(dbConn, stmt, extLockId, info.intLockId);
                        continue block14;
                    }
                    case WAIT: {
                        this.wait(dbConn, save);
                        if (alwaysCommit) {
                            LOG.debug((Object)"Going to commit");
                            dbConn.commit();
                        }
                        response.setState(LockState.WAITING);
                        return response;
                    }
                    case KEEP_LOOKING: {
                        continue block14;
                    }
                }
            }
            this.acquire(dbConn, stmt, extLockId, info.intLockId);
        }
        LOG.debug((Object)"Going to commit");
        dbConn.commit();
        response.setState(LockState.ACQUIRED);
        return response;
    }

    private void wait(Connection dbConn, Savepoint save) throws SQLException {
        LOG.debug((Object)"Going to rollback to savepoint");
        dbConn.rollback(save);
    }

    private void acquire(Connection dbConn, Statement stmt, long extLockId, long intLockId) throws SQLException, NoSuchLockException {
        long now = System.currentTimeMillis();
        String s = "update HIVE_LOCKS set hl_lock_state = 'a', hl_last_heartbeat = " + now + ", hl_acquired_at = " + now + " where hl_lock_ext_id = " + extLockId + " and hl_lock_int_id = " + intLockId;
        LOG.debug((Object)("Going to execute update <" + s + ">"));
        int rc = stmt.executeUpdate(s);
        if (rc < 1) {
            LOG.debug((Object)"Going to rollback");
            dbConn.rollback();
            throw new NoSuchLockException("No such lock: (" + extLockId + "," + intLockId + ")");
        }
    }

    private void heartbeatLock(Connection dbConn, long extLockId) throws NoSuchLockException, SQLException {
        if (extLockId == 0L) {
            return;
        }
        Statement stmt = dbConn.createStatement();
        long now = System.currentTimeMillis();
        String s = "update HIVE_LOCKS set hl_last_heartbeat = " + now + " where hl_lock_ext_id = " + extLockId;
        LOG.debug((Object)("Going to execute update <" + s + ">"));
        int rc = stmt.executeUpdate(s);
        if (rc < 1) {
            LOG.debug((Object)"Going to rollback");
            dbConn.rollback();
            throw new NoSuchLockException("No such lock: " + extLockId);
        }
        LOG.debug((Object)"Going to commit");
        dbConn.commit();
    }

    private void heartbeatTxn(Connection dbConn, long txnid) throws NoSuchTxnException, TxnAbortedException, SQLException {
        if (txnid == 0L) {
            return;
        }
        Statement stmt = dbConn.createStatement();
        long now = System.currentTimeMillis();
        String s = "select txn_state from TXNS where txn_id = " + txnid + " for update";
        LOG.debug((Object)("Going to execute query <" + s + ">"));
        ResultSet rs = stmt.executeQuery(s);
        if (!rs.next()) {
            LOG.debug((Object)"Going to rollback");
            dbConn.rollback();
            throw new NoSuchTxnException("No such transaction: " + txnid);
        }
        if (rs.getString(1).charAt(0) == 'a') {
            LOG.debug((Object)"Going to rollback");
            dbConn.rollback();
            throw new TxnAbortedException("Transaction " + txnid + " already aborted");
        }
        s = "update TXNS set txn_last_heartbeat = " + now + " where txn_id = " + txnid;
        LOG.debug((Object)("Going to execute update <" + s + ">"));
        stmt.executeUpdate(s);
        LOG.debug((Object)"Going to commit");
        dbConn.commit();
    }

    private long getTxnIdFromLockId(Connection dbConn, long extLockId) throws NoSuchLockException, MetaException, SQLException {
        Statement stmt = dbConn.createStatement();
        String s = "select hl_txnid from HIVE_LOCKS where hl_lock_ext_id = " + extLockId;
        LOG.debug((Object)("Going to execute query <" + s + ">"));
        ResultSet rs = stmt.executeQuery(s);
        if (!rs.next()) {
            throw new MetaException("This should never happen!  We already checked the lock existed but now we can't find it!");
        }
        long txnid = rs.getLong(1);
        LOG.debug((Object)("Return txnid " + (rs.wasNull() ? -1L : txnid)));
        return rs.wasNull() ? -1L : txnid;
    }

    private List<LockInfo> getLockInfoFromLockId(Connection dbConn, long extLockId) throws NoSuchLockException, MetaException, SQLException {
        Statement stmt = dbConn.createStatement();
        String s = "select hl_lock_ext_id, hl_lock_int_id, hl_db, hl_table, hl_partition, hl_lock_state, hl_lock_type from HIVE_LOCKS where hl_lock_ext_id = " + extLockId;
        LOG.debug((Object)("Going to execute query <" + s + ">"));
        ResultSet rs = stmt.executeQuery(s);
        boolean sawAtLeastOne = false;
        ArrayList<LockInfo> ourLockInfo = new ArrayList<LockInfo>();
        while (rs.next()) {
            ourLockInfo.add(new LockInfo(rs));
            sawAtLeastOne = true;
        }
        if (!sawAtLeastOne) {
            throw new MetaException("This should never happen!  We already checked the lock existed but now we can't find it!");
        }
        return ourLockInfo;
    }

    private void timeOutLocks(Connection dbConn) throws SQLException {
        long now = System.currentTimeMillis();
        Statement stmt = dbConn.createStatement();
        String s = "delete from HIVE_LOCKS where hl_last_heartbeat < " + (now - this.timeout);
        LOG.debug((Object)("Going to execute update <" + s + ">"));
        stmt.executeUpdate(s);
        LOG.debug((Object)"Going to commit");
        dbConn.commit();
    }

    private static synchronized void setupJdbcConnectionPool(HiveConf conf) throws SQLException {
        if (connPool != null) {
            return;
        }
        String driverUrl = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORECONNECTURLKEY);
        String user = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_CONNECTION_USER_NAME);
        String passwd = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREPWD);
        BoneCPConfig config = new BoneCPConfig();
        config.setJdbcUrl(driverUrl);
        config.setMaxConnectionsPerPartition(10);
        config.setPartitionCount(1);
        config.setUser(user);
        config.setPassword(passwd);
        connPool = new BoneCP(config);
    }

    private static synchronized void buildJumpTable() {
        if (jumpTable != null) {
            return;
        }
        jumpTable = new HashMap<LockType, Map<LockType, Map<LockState, LockAction>>>(3);
        HashMap m = new HashMap(3);
        jumpTable.put(LockType.SHARED_READ, m);
        HashMap<LockState, LockAction> m2 = new HashMap<LockState, LockAction>(2);
        m.put(LockType.SHARED_READ, m2);
        m2.put(LockState.ACQUIRED, LockAction.ACQUIRE);
        m2.put(LockState.WAITING, LockAction.KEEP_LOOKING);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_WRITE, m2);
        m2.put(LockState.ACQUIRED, LockAction.ACQUIRE);
        m2.put(LockState.WAITING, LockAction.KEEP_LOOKING);
        m2 = new HashMap(2);
        m.put(LockType.EXCLUSIVE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m = new HashMap(3);
        jumpTable.put(LockType.SHARED_WRITE, m);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_READ, m2);
        m2.put(LockState.ACQUIRED, LockAction.KEEP_LOOKING);
        m2.put(LockState.WAITING, LockAction.KEEP_LOOKING);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_WRITE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m2 = new HashMap(2);
        m.put(LockType.EXCLUSIVE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m = new HashMap(3);
        jumpTable.put(LockType.EXCLUSIVE, m);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_READ, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m2 = new HashMap(2);
        m.put(LockType.SHARED_WRITE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
        m2 = new HashMap(2);
        m.put(LockType.EXCLUSIVE, m2);
        m2.put(LockState.ACQUIRED, LockAction.WAIT);
        m2.put(LockState.WAITING, LockAction.WAIT);
    }

    static {
        lockLock = new Boolean("true");
    }

    private static enum LockAction {
        ACQUIRE,
        WAIT,
        KEEP_LOOKING;

    }

    private static class LockInfoComparator
    implements Comparator<LockInfo> {
        private LockInfoComparator() {
        }

        @Override
        public boolean equals(Object other) {
            return this == other;
        }

        @Override
        public int compare(LockInfo info1, LockInfo info2) {
            if (info1.state == LockState.ACQUIRED && info2.state != LockState.ACQUIRED) {
                return -1;
            }
            if (info1.state != LockState.ACQUIRED && info2.state == LockState.ACQUIRED) {
                return 1;
            }
            if (info1.extLockId < info2.extLockId) {
                return -1;
            }
            if (info1.extLockId > info2.extLockId) {
                return 1;
            }
            if (info1.intLockId < info2.intLockId) {
                return -1;
            }
            if (info1.intLockId > info2.intLockId) {
                return 1;
            }
            return 0;
        }
    }

    private static class LockInfo {
        long extLockId;
        long intLockId;
        long txnId;
        String db;
        String table;
        String partition;
        LockState state;
        LockType type;

        LockInfo(ResultSet rs) throws SQLException {
            this.extLockId = rs.getLong("hl_lock_ext_id");
            this.intLockId = rs.getLong("hl_lock_int_id");
            this.db = rs.getString("hl_db");
            String t = rs.getString("hl_table");
            this.table = rs.wasNull() ? null : t;
            String p = rs.getString("hl_partition");
            this.partition = rs.wasNull() ? null : p;
            switch (rs.getString("hl_lock_state").charAt(0)) {
                case 'w': {
                    this.state = LockState.WAITING;
                    break;
                }
                case 'a': {
                    this.state = LockState.ACQUIRED;
                }
            }
            switch (rs.getString("hl_lock_type").charAt(0)) {
                case 'e': {
                    this.type = LockType.EXCLUSIVE;
                    break;
                }
                case 'r': {
                    this.type = LockType.SHARED_READ;
                    break;
                }
                case 'w': {
                    this.type = LockType.SHARED_WRITE;
                }
            }
        }

        public boolean equals(Object other) {
            if (!(other instanceof LockInfo)) {
                return false;
            }
            LockInfo o = (LockInfo)other;
            return this.extLockId == o.extLockId && this.intLockId == o.intLockId;
        }

        public String toString() {
            return "extLockId:" + Long.toString(this.extLockId) + " intLockId:" + this.intLockId + " txnId:" + Long.toString(this.txnId) + " db:" + this.db + " table:" + this.table + " partition:" + this.partition + " state:" + (this.state == null ? "null" : this.state.toString()) + " type:" + (this.type == null ? "null" : this.type.toString());
        }
    }

    protected class DeadlockException
    extends Exception {
        protected DeadlockException() {
        }
    }
}

