/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class HadoopConfigurationClassLoader
extends URLClassLoader {
    private Set<String> loadClassesFromParent;

    public HadoopConfigurationClassLoader(URL[] urls, ClassLoader parent, String ... ignoredClasses) {
        super(urls, parent);
        if (parent == null) {
            throw new NullPointerException("parent ClassLoader is required");
        }
        this.loadClassesFromParent = new HashSet<String>();
        if (ignoredClasses != null) {
            this.loadClassesFromParent.addAll(Arrays.asList(ignoredClasses));
        }
        this.loadClassesFromParent.add("org.apache.commons.log");
        this.loadClassesFromParent.add("org.apache.log4j");
    }

    protected boolean ignoreClass(String name) {
        if (name == null || this.loadClassesFromParent.contains(name)) {
            return true;
        }
        for (String prefix : this.loadClassesFromParent) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.ignoreClass(name)) {
            Class<?> c = Class.forName(name, false, this.getParent());
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.findClass(name);
            }
            catch (ClassNotFoundException ex) {
                c = Class.forName(name, false, this.getParent());
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (url == null) {
            url = this.findResource(name);
        }
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final Enumeration<URL> myResources = this.findResources(name);
        final Enumeration<URL> parentResources = this.getParent().getResources(name);
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return myResources.hasMoreElements() || parentResources.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                if (myResources.hasMoreElements()) {
                    return (URL)myResources.nextElement();
                }
                return (URL)parentResources.nextElement();
            }
        };
    }

    public String generateClassPathString() {
        StringBuilder sb = new StringBuilder();
        for (URL url : this.getURLs()) {
            if (sb.length() != 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(url.getFile());
        }
        return sb.toString();
    }
}

