/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.hadoop.LauncherURIHandler;
import org.apache.oozie.action.hadoop.LauncherURIHandlerFactory;
import org.apache.oozie.dependency.FSURIHandler;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.dependency.URIHandlerException;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.XLog;

public class URIHandlerService
implements Service {
    private static final String CONF_PREFIX = "oozie.service.URIHandlerService.";
    public static final String URI_HANDLERS = "oozie.service.URIHandlerService.uri.handlers";
    public static final String URI_HANDLER_DEFAULT = "oozie.service.URIHandlerService.uri.handler.default";
    public static final String URI_HANDLER_SUPPORTED_SCHEMES_PREFIX = "oozie.service.URIHandlerService.uri.handler.";
    public static final String URI_HANDLER_SUPPORTED_SCHEMES_SUFFIX = ".supported.schemes";
    private static XLog LOG = XLog.getLog(URIHandlerService.class);
    private Configuration launcherConf;
    private Set<Class<?>> launcherClassesToShip;
    private Map<String, URIHandler> cache;
    private URIHandler defaultHandler;

    @Override
    public void init(Services services) throws ServiceException {
        try {
            this.init(services.getConf());
        }
        catch (Exception e) {
            throw new ServiceException(ErrorCode.E0902, e);
        }
    }

    private void init(Configuration conf) throws ClassNotFoundException {
        Object[] classes;
        this.cache = new HashMap<String, URIHandler>();
        for (String string : classes = conf.getStrings(URI_HANDLERS, new String[]{FSURIHandler.class.getName()})) {
            Class<?> clazz = Class.forName(string.trim());
            URIHandler uriHandler = (URIHandler)ReflectionUtils.newInstance(clazz, null);
            uriHandler.init(conf);
            for (String scheme : uriHandler.getSupportedSchemes()) {
                this.cache.put(scheme, uriHandler);
            }
        }
        Class defaultClass = conf.getClass(URI_HANDLER_DEFAULT, null);
        this.defaultHandler = defaultClass == null ? new FSURIHandler() : (URIHandler)ReflectionUtils.newInstance((Class)defaultClass, null);
        this.defaultHandler.init(conf);
        for (String scheme : this.defaultHandler.getSupportedSchemes()) {
            this.cache.put(scheme, this.defaultHandler);
        }
        this.initLauncherClassesToShip();
        this.initLauncherURIHandlerConf();
        LOG.info("Loaded urihandlers {0}", Arrays.toString(classes));
        LOG.info("Loaded default urihandler {0}", this.defaultHandler.getClass().getName());
    }

    private void initLauncherClassesToShip() {
        this.launcherClassesToShip = new HashSet();
        this.launcherClassesToShip.add(LauncherURIHandlerFactory.class);
        this.launcherClassesToShip.add(LauncherURIHandler.class);
        for (URIHandler handler : this.cache.values()) {
            this.launcherClassesToShip.add(handler.getLauncherURIHandlerClass());
            List<Class<?>> classes = handler.getClassesForLauncher();
            if (classes == null) continue;
            this.launcherClassesToShip.addAll(classes);
        }
        this.launcherClassesToShip.add(this.defaultHandler.getLauncherURIHandlerClass());
    }

    private void initLauncherURIHandlerConf() {
        this.launcherConf = new Configuration(false);
        for (URIHandler handler : this.cache.values()) {
            for (String scheme : handler.getSupportedSchemes()) {
                String schemeConf = "oozie.launcher.action.urihandler.scheme." + scheme;
                this.launcherConf.set(schemeConf, handler.getLauncherURIHandlerClass().getName());
            }
        }
        for (String scheme : this.defaultHandler.getSupportedSchemes()) {
            String schemeConf = "oozie.launcher.action.urihandler.scheme." + scheme;
            this.launcherConf.set(schemeConf, this.defaultHandler.getLauncherURIHandlerClass().getName());
        }
    }

    @Override
    public void destroy() {
        HashSet<URIHandler> handlers = new HashSet<URIHandler>();
        handlers.addAll(this.cache.values());
        for (URIHandler handler : handlers) {
            handler.destroy();
        }
        this.cache.clear();
    }

    @Override
    public Class<? extends Service> getInterface() {
        return URIHandlerService.class;
    }

    public Set<Class<?>> getClassesForLauncher() {
        return this.launcherClassesToShip;
    }

    public Configuration getLauncherConfig() {
        return this.launcherConf;
    }

    public URIHandler getURIHandler(String uri) throws URIHandlerException {
        try {
            return this.getURIHandler(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new URIHandlerException(ErrorCode.E0902, e);
        }
    }

    public URIHandler getURIHandler(URI uri) throws URIHandlerException {
        return this.getURIHandler(uri, false);
    }

    public URIHandler getURIHandler(URI uri, boolean validateURI) throws URIHandlerException {
        if (uri.getScheme() == null) {
            if (validateURI) {
                throw new URIHandlerException(ErrorCode.E0905, uri);
            }
            return this.defaultHandler;
        }
        URIHandler handler = this.cache.get(uri.getScheme());
        if (handler == null && (handler = this.cache.get("*")) == null) {
            throw new URIHandlerException(ErrorCode.E0904, uri.getScheme(), uri.toString());
        }
        return handler;
    }

    public URI getAuthorityWithScheme(String uri) throws URIHandlerException {
        int index = uri.indexOf("://");
        try {
            if (index == -1) {
                LOG.trace("Relative path for uri-template " + uri);
                return new URI("/");
            }
            if (uri.indexOf(":///") != -1) {
                return new URI(uri.substring(0, index + 4));
            }
            int pathIndex = uri.indexOf("/", index + 4);
            if (pathIndex == -1) {
                return new URI(uri.substring(0));
            }
            return new URI(uri.substring(0, pathIndex));
        }
        catch (URISyntaxException e) {
            throw new URIHandlerException(ErrorCode.E0906, uri, e);
        }
    }
}

