/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import com.google.common.primitives.Longs;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.io.HiveIOExceptionHandlerUtil;
import org.apache.hadoop.hive.shims.CombineHiveKey;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.DelegationTokenIdentifier;
import org.apache.hadoop.hive.thrift.DelegationTokenSelector;
import org.apache.hadoop.http.HtmlQuoting;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileInputFormat;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.tools.HadoopArchives;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public abstract class HadoopShimsSecure
implements HadoopShims {
    static final Log LOG = LogFactory.getLog(HadoopShimsSecure.class);
    String[] ret = new String[2];

    public String unquoteHtmlChars(String item) {
        return HtmlQuoting.unquoteHtmlChars((String)item);
    }

    public HadoopShims.CombineFileInputFormatShim getCombineFileInputFormat() {
        return new CombineFileInputFormatShim(){

            public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
                throw new IOException("CombineFileInputFormat.getRecordReader not needed.");
            }
        };
    }

    public String getInputFormatClassName() {
        return "org.apache.hadoop.hive.ql.io.CombineHiveInputFormat";
    }

    public int createHadoopArchive(Configuration conf, Path sourceDir, Path destDir, String archiveName) throws Exception {
        HadoopArchives har = new HadoopArchives(conf);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-archiveName");
        args.add(archiveName);
        args.add("-p");
        args.add(sourceDir.toString());
        args.add(destDir.toString());
        return ToolRunner.run((Tool)har, (String[])args.toArray(new String[0]));
    }

    public URI getHarUri(URI original, URI base, URI originalBase) throws URISyntaxException {
        URI relative = originalBase.relativize(original);
        if (relative.isAbsolute()) {
            throw new URISyntaxException("Couldn't create URI for location.", "Relative: " + relative + " Base: " + base + " OriginalBase: " + originalBase);
        }
        return base.resolve(relative);
    }

    public void prepareJobOutput(JobConf conf) {
        conf.setOutputCommitter(NullOutputCommitter.class);
        conf.setBoolean((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDSETUPCLEANUPNEEDED"), false);
        conf.setBoolean((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDTASKCLEANUPNEEDED"), false);
    }

    public UserGroupInformation getUGIForConf(Configuration conf) throws IOException {
        return UserGroupInformation.getCurrentUser();
    }

    public boolean isSecureShimImpl() {
        return true;
    }

    public String getShortUserName(UserGroupInformation ugi) {
        return ugi.getShortUserName();
    }

    public String getTokenStrForm(String tokenSignature) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        DelegationTokenSelector tokenSelector = new DelegationTokenSelector();
        Token token = tokenSelector.selectToken(tokenSignature == null ? new Text() : new Text(tokenSignature), ugi.getTokens());
        return token != null ? token.encodeToUrlString() : null;
    }

    public void setTokenStr(UserGroupInformation ugi, String tokenStr, String tokenService) throws IOException {
        Token<DelegationTokenIdentifier> delegationToken = this.createToken(tokenStr, tokenService);
        ugi.addToken(delegationToken);
    }

    public String addServiceToToken(String tokenStr, String tokenService) throws IOException {
        Token<DelegationTokenIdentifier> delegationToken = this.createToken(tokenStr, tokenService);
        return delegationToken.encodeToUrlString();
    }

    private Token<DelegationTokenIdentifier> createToken(String tokenStr, String tokenService) throws IOException {
        Token delegationToken = new Token();
        delegationToken.decodeFromUrlString(tokenStr);
        delegationToken.setService(new Text(tokenService));
        return delegationToken;
    }

    public <T> T doAs(UserGroupInformation ugi, PrivilegedExceptionAction<T> pvea) throws IOException, InterruptedException {
        return (T)ugi.doAs(pvea);
    }

    public Path createDelegationTokenFile(Configuration conf) throws IOException {
        String uname = UserGroupInformation.getLoginUser().getShortUserName();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Token fsToken = fs.getDelegationToken(uname);
        File t = File.createTempFile("hive_hadoop_delegation_token", null);
        Path tokenPath = new Path(t.toURI());
        Credentials cred = new Credentials();
        cred.addToken(fsToken.getService(), fsToken);
        cred.writeTokenStorageFile(tokenPath, conf);
        return tokenPath;
    }

    public UserGroupInformation createProxyUser(String userName) throws IOException {
        return UserGroupInformation.createProxyUser((String)userName, (UserGroupInformation)UserGroupInformation.getLoginUser());
    }

    public void authorizeProxyAccess(String proxyUser, UserGroupInformation realUserUgi, String ipAddress, Configuration conf) throws IOException {
        ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
        ProxyUsers.authorize((UserGroupInformation)UserGroupInformation.createProxyUser((String)proxyUser, (UserGroupInformation)realUserUgi), (String)ipAddress, (Configuration)conf);
    }

    public boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }

    public UserGroupInformation createRemoteUser(String userName, List<String> groupNames) {
        return UserGroupInformation.createRemoteUser((String)userName);
    }

    public void closeAllForUGI(UserGroupInformation ugi) {
        try {
            FileSystem.closeAllForUGI((UserGroupInformation)ugi);
        }
        catch (IOException e) {
            LOG.error((Object)("Could not clean up file-system handles for UGI: " + ugi), (Throwable)e);
        }
    }

    public void loginUserFromKeytab(String principal, String keytabFile) throws IOException {
        String hostPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
        UserGroupInformation.loginUserFromKeytab((String)hostPrincipal, (String)keytabFile);
    }

    public UserGroupInformation loginUserFromKeytabAndReturnUGI(String principal, String keytabFile) throws IOException {
        String hostPrincipal = SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0");
        return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)hostPrincipal, (String)keytabFile);
    }

    public String getTokenFileLocEnvName() {
        return "HADOOP_TOKEN_FILE_LOCATION";
    }

    public void reLoginUserFromKeytab() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        if (ugi.isFromKeytab()) {
            ugi.checkTGTAndReloginFromKeytab();
        }
    }

    public boolean isLoginKeytabBased() throws IOException {
        return UserGroupInformation.isLoginKeytabBased();
    }

    public abstract HadoopShims.JobTrackerState getJobTrackerState(ClusterStatus var1) throws Exception;

    public abstract TaskAttemptContext newTaskAttemptContext(Configuration var1, Progressable var2);

    public abstract org.apache.hadoop.mapreduce.JobContext newJobContext(Job var1);

    public abstract boolean isLocalMode(Configuration var1);

    public abstract void setJobLauncherRpcAddress(Configuration var1, String var2);

    public abstract String getJobLauncherHttpAddress(Configuration var1);

    public abstract String getJobLauncherRpcAddress(Configuration var1);

    public abstract short getDefaultReplication(FileSystem var1, Path var2);

    public abstract long getDefaultBlockSize(FileSystem var1, Path var2);

    public abstract boolean moveToAppropriateTrash(FileSystem var1, Path var2, Configuration var3) throws IOException;

    public abstract FileSystem createProxyFileSystem(FileSystem var1, URI var2);

    public abstract FileSystem getNonCachedFileSystem(URI var1, Configuration var2) throws IOException;

    protected void run(FsShell shell, String[] command) throws Exception {
        LOG.debug((Object)ArrayUtils.toString((Object)command));
        int retval = shell.run(command);
        LOG.debug((Object)("Return value is :" + retval));
    }

    private static Set<Integer> getDirIndices(Path[] paths, JobConf conf) throws IOException {
        HashSet<Integer> result = new HashSet<Integer>();
        for (int i = 0; i < paths.length; ++i) {
            FileSystem fs = paths[i].getFileSystem((Configuration)conf);
            if (fs.isFile(paths[i])) continue;
            result.add(i);
        }
        return result;
    }

    private static <K> List<K> prune(Set<Integer> indicesToPrune, List<K> elms) {
        ArrayList<K> result = new ArrayList<K>();
        int i = 0;
        for (K elm : elms) {
            if (indicesToPrune.contains(i)) continue;
            result.add(elm);
            ++i;
        }
        return result;
    }

    private static String[] dedup(String[] locations) throws IOException {
        HashSet dedup = new HashSet();
        Collections.addAll(dedup, locations);
        return dedup.toArray(new String[dedup.size()]);
    }

    public static class NullOutputCommitter
    extends OutputCommitter {
        public void setupJob(JobContext jobContext) {
        }

        public void cleanupJob(JobContext jobContext) {
        }

        public void setupTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) {
        }

        public boolean needsTaskCommit(org.apache.hadoop.mapred.TaskAttemptContext taskContext) {
            return false;
        }

        public void commitTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) {
        }

        public void abortTask(org.apache.hadoop.mapred.TaskAttemptContext taskContext) {
        }
    }

    public static abstract class CombineFileInputFormatShim<K, V>
    extends CombineFileInputFormat<K, V>
    implements HadoopShims.CombineFileInputFormatShim<K, V> {
        public Path[] getInputPathsShim(JobConf conf) {
            try {
                return FileInputFormat.getInputPaths((JobConf)conf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void createPool(JobConf conf, PathFilter ... filters) {
            super.createPool(conf, filters);
        }

        public InputSplitShim[] getSplits(JobConf job, int numSplits) throws IOException {
            long minSize = job.getLong((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDMINSPLITSIZE"), 0L);
            if (job.getLong((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDMINSPLITSIZEPERNODE"), 0L) == 0L) {
                super.setMinSplitSizeNode(minSize);
            }
            if (job.getLong((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDMINSPLITSIZEPERRACK"), 0L) == 0L) {
                super.setMinSplitSizeRack(minSize);
            }
            if (job.getLong((String)ShimLoader.getHadoopShims().getHadoopConfNames().get("MAPREDMAXSPLITSIZE"), 0L) == 0L) {
                super.setMaxSplitSize(minSize);
            }
            InputSplit[] splits = super.getSplits(job, numSplits);
            ArrayList<InputSplitShim> inputSplitShims = new ArrayList<InputSplitShim>();
            for (int pos = 0; pos < splits.length; ++pos) {
                CombineFileSplit split = (CombineFileSplit)splits[pos];
                Set dirIndices = HadoopShimsSecure.getDirIndices(split.getPaths(), job);
                if (dirIndices.size() == split.getPaths().length) continue;
                List prunedPaths = HadoopShimsSecure.prune(dirIndices, Arrays.asList(split.getPaths()));
                List prunedStartOffsets = HadoopShimsSecure.prune(dirIndices, Arrays.asList(ArrayUtils.toObject((long[])split.getStartOffsets())));
                List prunedLengths = HadoopShimsSecure.prune(dirIndices, Arrays.asList(ArrayUtils.toObject((long[])split.getLengths())));
                inputSplitShims.add(new InputSplitShim(job, prunedPaths.toArray(new Path[prunedPaths.size()]), Longs.toArray((Collection)prunedStartOffsets), Longs.toArray((Collection)prunedLengths), split.getLocations()));
            }
            return inputSplitShims.toArray(new InputSplitShim[inputSplitShims.size()]);
        }

        public InputSplitShim getInputSplitShim() throws IOException {
            return new InputSplitShim();
        }

        public RecordReader getRecordReader(JobConf job, HadoopShims.InputSplitShim split, Reporter reporter, Class<RecordReader<K, V>> rrClass) throws IOException {
            CombineFileSplit cfSplit = (CombineFileSplit)split;
            return new CombineFileRecordReader<K, V>(job, cfSplit, reporter, rrClass);
        }
    }

    public static class CombineFileRecordReader<K, V>
    implements RecordReader<K, V> {
        static final Class[] constructorSignature = new Class[]{InputSplit.class, Configuration.class, Reporter.class, Integer.class};
        protected CombineFileSplit split;
        protected JobConf jc;
        protected Reporter reporter;
        protected Class<RecordReader<K, V>> rrClass;
        protected Constructor<RecordReader<K, V>> rrConstructor;
        protected FileSystem fs;
        protected int idx;
        protected long progress;
        protected RecordReader<K, V> curReader;
        protected boolean isShrinked;
        protected long shrinkedLength;

        public boolean next(K key, V value) throws IOException {
            while (this.curReader == null || !this.doNextWithExceptionHandler(((CombineHiveKey)key).getKey(), value)) {
                if (this.initNextRecordReader(key)) continue;
                return false;
            }
            return true;
        }

        public K createKey() {
            Object newKey = this.curReader.createKey();
            return (K)new CombineHiveKey(newKey);
        }

        public V createValue() {
            return (V)this.curReader.createValue();
        }

        public long getPos() throws IOException {
            return this.progress;
        }

        public void close() throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
            }
        }

        public float getProgress() throws IOException {
            return Math.min(1.0f, (float)this.progress / (float)this.split.getLength());
        }

        public CombineFileRecordReader(JobConf job, CombineFileSplit split, Reporter reporter, Class<RecordReader<K, V>> rrClass) throws IOException {
            this.split = split;
            this.jc = job;
            this.rrClass = rrClass;
            this.reporter = reporter;
            this.idx = 0;
            this.curReader = null;
            this.progress = 0L;
            this.isShrinked = false;
            assert (split instanceof InputSplitShim);
            if (((InputSplitShim)split).isShrinked()) {
                this.isShrinked = true;
                this.shrinkedLength = ((InputSplitShim)split).getShrinkedLength();
            }
            try {
                this.rrConstructor = rrClass.getDeclaredConstructor(constructorSignature);
                this.rrConstructor.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(rrClass.getName() + " does not have valid constructor", e);
            }
            this.initNextRecordReader(null);
        }

        private boolean doNextWithExceptionHandler(K key, V value) throws IOException {
            try {
                return this.curReader.next(key, value);
            }
            catch (Exception e) {
                return HiveIOExceptionHandlerUtil.handleRecordReaderNextException((Exception)e, (JobConf)this.jc);
            }
        }

        protected boolean initNextRecordReader(K key) throws IOException {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
                if (this.idx > 0) {
                    this.progress += this.split.getLength(this.idx - 1);
                }
            }
            if (this.idx == this.split.getNumPaths() || this.isShrinked && this.progress > this.shrinkedLength) {
                return false;
            }
            try {
                this.curReader = this.rrConstructor.newInstance(this.split, this.jc, this.reporter, this.idx);
                if (key != null) {
                    Object newKey = this.curReader.createKey();
                    ((CombineHiveKey)key).setKey(newKey);
                }
                this.jc.set("map.input.file", this.split.getPath(this.idx).toString());
                this.jc.setLong("map.input.start", this.split.getOffset(this.idx));
                this.jc.setLong("map.input.length", this.split.getLength(this.idx));
            }
            catch (Exception e) {
                this.curReader = HiveIOExceptionHandlerUtil.handleRecordReaderCreationException((Exception)e, (JobConf)this.jc);
            }
            ++this.idx;
            return true;
        }
    }

    public static class InputSplitShim
    extends CombineFileSplit
    implements HadoopShims.InputSplitShim {
        long shrinkedLength;
        boolean _isShrinked = false;

        public InputSplitShim() {
        }

        public InputSplitShim(JobConf conf, Path[] paths, long[] startOffsets, long[] lengths, String[] locations) throws IOException {
            super(conf, paths, startOffsets, lengths, HadoopShimsSecure.dedup(locations));
        }

        public void shrinkSplit(long length) {
            this._isShrinked = true;
            this.shrinkedLength = length;
        }

        public boolean isShrinked() {
            return this._isShrinked;
        }

        public long getShrinkedLength() {
            return this.shrinkedLength;
        }

        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            this._isShrinked = in.readBoolean();
            if (this._isShrinked) {
                this.shrinkedLength = in.readLong();
            }
        }

        public void write(DataOutput out) throws IOException {
            super.write(out);
            out.writeBoolean(this._isShrinked);
            if (this._isShrinked) {
                out.writeLong(this.shrinkedLength);
            }
        }
    }
}

