/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formatting;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.pentaho.reporting.libraries.formatting.DummyFieldPosition;
import org.pentaho.reporting.libraries.formatting.FastFormat;

public class FastDateFormat
implements FastFormat {
    private TimeZone timeZone;
    private Locale locale;
    private SimpleDateFormat dateFormat;
    private String pattern;
    private transient StringBuffer buffer;
    private transient DummyFieldPosition fieldPosition;

    public FastDateFormat(String pattern) {
        this(pattern, Locale.getDefault(), TimeZone.getDefault());
    }

    public FastDateFormat(String pattern, Locale locale) {
        this(pattern, locale, TimeZone.getDefault());
    }

    public FastDateFormat(String pattern, Locale locale, TimeZone timeZone) {
        if (pattern == null) {
            throw new NullPointerException();
        }
        if (locale == null) {
            throw new NullPointerException();
        }
        if (timeZone == null) {
            throw new NullPointerException();
        }
        this.timeZone = timeZone;
        this.pattern = pattern;
        this.locale = locale;
        this.dateFormat = new SimpleDateFormat(pattern, new DateFormatSymbols(locale));
        this.dateFormat.setTimeZone(timeZone);
    }

    public FastDateFormat(int dateStyle, int timeStyle, Locale locale) {
        this(dateStyle, timeStyle, locale, TimeZone.getDefault());
    }

    public FastDateFormat(int dateStyle, int timeStyle, Locale locale, TimeZone timeZone) {
        if (locale == null) {
            throw new NullPointerException();
        }
        this.locale = locale;
        this.timeZone = timeZone;
        DateFormat dateFormat = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        if (dateFormat instanceof SimpleDateFormat) {
            this.dateFormat = (SimpleDateFormat)dateFormat;
            this.pattern = this.dateFormat.toPattern();
        } else {
            String timeText;
            String dateText;
            ResourceBundle datePatterns = ResourceBundle.getBundle("org.pentaho.reporting.libraries.formatting.format-patterns");
            switch (dateStyle) {
                case 3: {
                    dateText = datePatterns.getString("format.date.short");
                    break;
                }
                case 2: {
                    dateText = datePatterns.getString("format.date.medium");
                    break;
                }
                case 1: {
                    dateText = datePatterns.getString("format.date.long");
                    break;
                }
                case 0: {
                    dateText = datePatterns.getString("format.date.full");
                    break;
                }
                default: {
                    dateText = null;
                }
            }
            switch (timeStyle) {
                case 3: {
                    timeText = datePatterns.getString("format.time.short");
                    break;
                }
                case 2: {
                    timeText = datePatterns.getString("format.time.medium");
                    break;
                }
                case 1: {
                    timeText = datePatterns.getString("format.time.long");
                    break;
                }
                case 0: {
                    timeText = datePatterns.getString("format.time.full");
                    break;
                }
                default: {
                    timeText = null;
                }
            }
            if (dateText == null && timeText == null) {
                throw new IllegalArgumentException();
            }
            if (dateText == null) {
                this.pattern = timeText;
            } else if (timeText == null) {
                this.pattern = dateText;
            } else {
                String messagePattern = datePatterns.getString("format.datetime");
                this.pattern = MessageFormat.format(messagePattern, dateText, timeText);
            }
            this.dateFormat = new SimpleDateFormat(this.pattern, new DateFormatSymbols(locale));
        }
        this.dateFormat.setTimeZone(timeZone);
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        if (this.locale.equals(locale)) {
            return;
        }
        this.locale = locale;
        this.dateFormat = (SimpleDateFormat)this.dateFormat.clone();
        this.dateFormat.setDateFormatSymbols(new DateFormatSymbols(locale));
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String format(Object parameters) {
        if (parameters == null) {
            throw new NullPointerException();
        }
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        } else {
            this.buffer.delete(0, this.buffer.length());
        }
        if (this.fieldPosition == null) {
            this.fieldPosition = new DummyFieldPosition();
        } else {
            this.fieldPosition.clear();
        }
        StringBuffer stringBuffer = this.dateFormat.format(parameters, this.buffer, (FieldPosition)new DummyFieldPosition());
        return stringBuffer.toString();
    }

    @Override
    public FastDateFormat clone() {
        try {
            FastDateFormat clone = (FastDateFormat)super.clone();
            clone.dateFormat = (SimpleDateFormat)this.dateFormat.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.dateFormat = (SimpleDateFormat)this.dateFormat.clone();
        this.dateFormat.setTimeZone(timeZone);
    }
}

