/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.util.avro;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.avro.generic.GenericArray;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.util.avro.AvroTupleWrapper;

public final class AvroBagWrapper<T>
implements DataBag {
    private GenericArray<T> theArray;

    public AvroBagWrapper(GenericArray<T> a) {
        this.theArray = a;
    }

    @Override
    public long spill() {
        return 0L;
    }

    @Override
    public long getMemorySize() {
        return 0L;
    }

    public void readFields(DataInput d) throws IOException {
        throw new IOException(this.getClass().toString() + ".readFields not implemented yet");
    }

    public void write(DataOutput d) throws IOException {
        throw new IOException(this.getClass().toString() + ".write not implemented yet");
    }

    public int compareTo(Object o) {
        return GenericData.get().compare(this.theArray, o, this.theArray.getSchema());
    }

    @Override
    public long size() {
        return this.theArray.size();
    }

    @Override
    public boolean isSorted() {
        return false;
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return Iterators.transform((Iterator)this.theArray.iterator(), (Function)new Function<T, Tuple>(){

            public Tuple apply(T arg) {
                if (arg instanceof IndexedRecord) {
                    return new AvroTupleWrapper<IndexedRecord>((IndexedRecord)arg);
                }
                return TupleFactory.getInstance().newTuple(arg);
            }
        });
    }

    @Override
    public void add(Tuple t) {
        this.theArray.add((Object)t);
    }

    @Override
    public void addAll(DataBag b) {
        for (Tuple t : b) {
            this.add(t);
        }
    }

    @Override
    public void clear() {
        this.theArray.clear();
    }

    @Override
    public void markStale(boolean stale) {
    }
}

