/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.map.WrappedMapper;
import org.apache.hadoop.mapreduce.task.MapContextImpl;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.IllustrateDummyReporter;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigGenericMapBase;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.PigNullableWritable;
import org.apache.pig.impl.util.Pair;

public abstract class PigMapBase
extends PigGenericMapBase {
    @Override
    public Mapper.Context getIllustratorContext(Configuration conf, DataBag input, List<Pair<PigNullableWritable, Writable>> output, InputSplit split) throws IOException, InterruptedException {
        Mapper.Context mapperContext = new WrappedMapper().getMapContext((MapContext)new IllustratorContext(conf, input, output, split));
        return mapperContext;
    }

    @Override
    public boolean inIllustrator(Mapper.Context context) {
        return ((WrappedMapper.Context)context).getConfiguration().get("inIllustrator") != null;
    }

    public class IllustratorContext
    extends MapContextImpl<Text, Tuple, PigNullableWritable, Writable> {
        private DataBag input;
        List<Pair<PigNullableWritable, Writable>> output;
        private Iterator<Tuple> it;
        private Tuple value;
        private boolean init;

        public IllustratorContext(Configuration conf, DataBag input, List<Pair<PigNullableWritable, Writable>> output, InputSplit split) throws IOException, InterruptedException {
            super(conf, new TaskAttemptID(), null, null, null, (StatusReporter)new IllustrateDummyReporter(), split);
            this.it = null;
            this.value = null;
            this.init = false;
            conf.set("inIllustrator", "true");
            if (output == null) {
                throw new IOException("Null output can not be used");
            }
            this.input = input;
            this.output = output;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (this.input == null) {
                if (!this.init) {
                    this.init = true;
                    return true;
                }
                return false;
            }
            if (this.it == null) {
                this.it = this.input.iterator();
            }
            if (!this.it.hasNext()) {
                return false;
            }
            this.value = this.it.next();
            return true;
        }

        public Text getCurrentKey() {
            return null;
        }

        public Tuple getCurrentValue() {
            return this.value;
        }

        public void write(PigNullableWritable key, Writable value) throws IOException, InterruptedException {
            this.output.add(new Pair<PigNullableWritable, Writable>(key, value));
        }

        public void progress() {
        }
    }
}

