/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xsdvalidator;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.provider.http.HttpFileObject;
import org.apache.commons.vfs.provider.local.LocalFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xsdvalidator.XsdValidatorData;
import org.pentaho.di.trans.steps.xsdvalidator.XsdValidatorMeta;
import org.xml.sax.SAXException;

public class XsdValidator
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = XsdValidatorMeta.class;
    private XsdValidatorMeta meta;
    private XsdValidatorData data;
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";

    public XsdValidator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (XsdValidatorMeta)smi;
        this.data = (XsdValidatorData)sdi;
        Object[] row = this.getRow();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this, this.repository, this.metaStore);
            if (this.meta.getXMLStream() != null) {
                this.data.xmlindex = this.getInputRowMeta().indexOfValue(this.meta.getXMLStream());
                if (this.data.xmlindex < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.ErrorFindingField", (String[])new String[0]) + "[" + this.meta.getXMLStream() + "]");
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.CouldnotFindField", (String[])new String[]{this.meta.getXMLStream()}));
                }
                if (this.meta.getResultfieldname() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.ErrorResultFieldMissing", (String[])new String[0]));
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.ErrorResultFieldMissing", (String[])new String[0]));
                }
                if (this.meta.getXSDSource().equals(this.meta.SPECIFY_FILENAME)) {
                    if (this.meta.getXSDFilename() == null) {
                        this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.ErrorXSDFileMissing", (String[])new String[0]));
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.ErrorXSDFileMissing", (String[])new String[0]));
                    }
                    FileObject xsdfile = null;
                    try {
                        xsdfile = KettleVFS.getFileObject((String)this.environmentSubstitute(this.meta.getXSDFilename()), (VariableSpace)this.getTransMeta());
                        if (!xsdfile.exists()) {
                            this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.Error.XSDFileNotExists", (String[])new String[0]));
                            throw new KettleStepException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.XSDFileNotExists", (String[])new String[0]));
                        }
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.Error.GettingXSDFile", (String[])new String[0]));
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.GettingXSDFile", (String[])new String[0]));
                    }
                    finally {
                        try {
                            if (xsdfile != null) {
                                xsdfile.close();
                            }
                        }
                        catch (IOException e) {}
                    }
                }
                if (this.meta.getXSDSource().equals(this.meta.SPECIFY_FIELDNAME)) {
                    if (this.meta.getXSDDefinedField() == null) {
                        this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.Error.XSDFieldMissing", (String[])new String[0]));
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.XSDFieldMissing", (String[])new String[0]));
                    }
                    this.data.xsdindex = this.getInputRowMeta().indexOfValue(this.meta.getXSDDefinedField());
                    if (this.data.xsdindex < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.ErrorFindingXSDField", (String[])new String[]{this.meta.getXSDDefinedField()}));
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.ErrorFindingXSDField", (String[])new String[]{this.meta.getXSDDefinedField()}));
                    }
                }
            } else {
                this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.Error.XmlStreamFieldMissing", (String[])new String[0]));
                throw new KettleStepException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.XmlStreamFieldMissing", (String[])new String[0]));
            }
        }
        try {
            String XMLFieldvalue = this.getInputRowMeta().getString(row, this.data.xmlindex);
            boolean isvalid = false;
            String xsdfilename = null;
            if (this.meta.getXSDSource().equals(this.meta.SPECIFY_FILENAME)) {
                xsdfilename = this.environmentSubstitute(this.meta.getXSDFilename());
            } else if (this.meta.getXSDSource().equals(this.meta.SPECIFY_FIELDNAME)) {
                xsdfilename = this.getInputRowMeta().getString(row, this.data.xsdindex);
            }
            FileObject xsdfile = null;
            String validationmsg = null;
            try {
                SchemaFactory factoryXSDValidator = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                xsdfile = KettleVFS.getFileObject((String)xsdfilename, (VariableSpace)this.getTransMeta());
                StreamSource sourceXML = new StreamSource(new StringReader(XMLFieldvalue));
                if (this.meta.getXMLSourceFile()) {
                    File xmlfileValidator = new File(XMLFieldvalue);
                    if (!xmlfileValidator.exists()) {
                        this.logError(BaseMessages.getString(PKG, (String)"XsdValidator.Log.Error.XMLfileMissing", (String[])new String[]{XMLFieldvalue}));
                        throw new KettleStepException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.XMLfileMissing", (String[])new String[]{XMLFieldvalue}));
                    }
                    sourceXML = new StreamSource(xmlfileValidator);
                }
                Schema SchematXSD = null;
                if (xsdfile instanceof LocalFile) {
                    SchematXSD = factoryXSDValidator.newSchema(new File(KettleVFS.getFilename((FileObject)xsdfile)));
                } else if (xsdfile instanceof HttpFileObject) {
                    SchematXSD = factoryXSDValidator.newSchema(new URL(KettleVFS.getFilename((FileObject)xsdfile)));
                } else {
                    throw new KettleStepException(BaseMessages.getString(PKG, (String)"XsdValidator.Exception.CannotCreateSchema", (String[])new String[]{xsdfile.getClass().getName()}));
                }
                if (this.meta.getXSDSource().equals(this.meta.NO_NEED)) {
                    SchematXSD = factoryXSDValidator.newSchema();
                }
                Validator XSDValidator = SchematXSD.newValidator();
                XSDValidator.validate(sourceXML);
                isvalid = true;
            }
            catch (SAXException ex) {
                validationmsg = ex.getMessage();
            }
            catch (IOException ex) {
                validationmsg = ex.getMessage();
            }
            finally {
                try {
                    if (xsdfile != null) {
                        xsdfile.close();
                    }
                }
                catch (IOException e) {}
            }
            Object[] outputRowData = null;
            Object[] outputRowData2 = null;
            outputRowData = this.meta.getOutputStringField() ? (isvalid ? RowDataUtil.addValueData((Object[])row, (int)this.getInputRowMeta().size(), (Object)this.environmentSubstitute(this.meta.getIfXmlValid())) : RowDataUtil.addValueData((Object[])row, (int)this.getInputRowMeta().size(), (Object)this.environmentSubstitute(this.meta.getIfXmlInvalid()))) : RowDataUtil.addValueData((Object[])row, (int)this.getInputRowMeta().size(), (Object)isvalid);
            outputRowData2 = this.meta.useAddValidationMessage() ? RowDataUtil.addValueData((Object[])outputRowData, (int)(this.getInputRowMeta().size() + 1), (Object)validationmsg) : outputRowData;
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"XsdValidator.Log.ReadRow", (String[])new String[0]) + " " + this.getInputRowMeta().getString(row));
            }
            this.putRow(this.data.outputRowMeta, outputRowData2);
        }
        catch (KettleException e) {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (this.getStepMeta().isDoingErrorHandling()) {
                sendToErrorRow = true;
                errorMessage = e.toString();
            }
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, null, "XSD001");
            }
            this.logError(BaseMessages.getString(PKG, (String)("XsdValidator.ErrorProcesing : " + e.getMessage()), (String[])new String[0]));
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"XsdValidator.ErrorProcesing", (String[])new String[0]), (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XsdValidatorMeta)smi;
        this.data = (XsdValidatorData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XsdValidatorMeta)smi;
        this.data = (XsdValidatorData)sdi;
        super.dispose(smi, sdi);
    }
}

