/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.getpop;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.mail.Flags;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.getpop.MailConnection;
import org.pentaho.di.job.entries.getpop.MailConnectionMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryGetPOP
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryGetPOP.class;
    public int actiontype = 0;
    public int conditionReceivedDate;
    public int valueimaplist = 0;
    public int aftergetimap = 0;
    private String servername = null;
    private String username = null;
    private String password = null;
    private boolean usessl = false;
    private String sslport = null;
    private boolean useproxy = false;
    private String proxyusername = null;
    private String outputdirectory = null;
    private String filenamepattern = "name_{SYS|hhmmss_MMddyyyy|}_#IdFile#.mail";
    private String firstmails = null;
    public int retrievemails = 0;
    private boolean delete = false;
    private String protocol = "POP3";
    private boolean saveattachment = true;
    private boolean savemessage = true;
    private boolean usedifferentfolderforattachment = false;
    private String attachmentfolder = null;
    private String attachmentwildcard = null;
    private String imapfirstmails = "0";
    private String imapfolder = null;
    private String senderSearch = null;
    private boolean notTermSenderSearch = false;
    private String receipientSearch = null;
    private String subjectSearch = null;
    private String bodySearch = null;
    private boolean notTermBodySearch = false;
    private String receivedDate1 = null;
    private String receivedDate2 = null;
    private boolean notTermSubjectSearch = false;
    private boolean notTermReceipientSearch = false;
    private boolean notTermReceivedDateSearch = false;
    private boolean includesubfolders = false;
    private String moveToIMAPFolder = null;
    private boolean createmovetofolder = false;
    private boolean createlocalfolder = false;
    private static final String DEFAULT_FILE_NAME_PATTERN = "name_{SYS|hhmmss_MMddyyyy|}_#IdFile#.mail";
    public static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String FILENAME_ID_PATTERN = "#IdFile#";
    private static final String FILENAME_SYS_DATE_OPEN = "{SYS|";
    private static final String FILENAME_SYS_DATE_CLOSE = "|}";
    private Pattern attachementPattern;

    public JobEntryGetPOP(String n) {
        super(n, "");
    }

    public JobEntryGetPOP() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryGetPOP je = (JobEntryGetPOP)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.servername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.username));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usessl", (boolean)this.usessl));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sslport", (String)this.sslport));
        retval.append("      ").append(XMLHandler.addTagValue((String)"outputdirectory", (String)this.outputdirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filenamepattern", (String)this.filenamepattern));
        retval.append("      ").append(XMLHandler.addTagValue((String)"retrievemails", (int)this.retrievemails));
        retval.append("      ").append(XMLHandler.addTagValue((String)"firstmails", (String)this.firstmails));
        retval.append("      ").append(XMLHandler.addTagValue((String)"delete", (boolean)this.delete));
        retval.append("      ").append(XMLHandler.addTagValue((String)"savemessage", (boolean)this.savemessage));
        retval.append("      ").append(XMLHandler.addTagValue((String)"saveattachment", (boolean)this.saveattachment));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usedifferentfolderforattachment", (boolean)this.usedifferentfolderforattachment));
        retval.append("      ").append(XMLHandler.addTagValue((String)"protocol", (String)this.protocol));
        retval.append("      ").append(XMLHandler.addTagValue((String)"attachmentfolder", (String)this.attachmentfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"attachmentwildcard", (String)this.attachmentwildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"valueimaplist", (String)MailConnectionMeta.getValueImapListCode(this.valueimaplist)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"imapfirstmails", (String)this.imapfirstmails));
        retval.append("      ").append(XMLHandler.addTagValue((String)"imapfolder", (String)this.imapfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"sendersearch", (String)this.senderSearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nottermsendersearch", (boolean)this.notTermSenderSearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"receipientsearch", (String)this.receipientSearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nottermreceipientsearch", (boolean)this.notTermReceipientSearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"subjectsearch", (String)this.subjectSearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nottermsubjectsearch", (boolean)this.notTermSubjectSearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"bodysearch", (String)this.bodySearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nottermbodysearch", (boolean)this.notTermBodySearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"conditionreceiveddate", (String)MailConnectionMeta.getConditionDateCode(this.conditionReceivedDate)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nottermreceiveddatesearch", (boolean)this.notTermReceivedDateSearch));
        retval.append("      ").append(XMLHandler.addTagValue((String)"receiveddate1", (String)this.receivedDate1));
        retval.append("      ").append(XMLHandler.addTagValue((String)"receiveddate2", (String)this.receivedDate2));
        retval.append("      ").append(XMLHandler.addTagValue((String)"actiontype", (String)MailConnectionMeta.getActionTypeCode(this.actiontype)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"movetoimapfolder", (String)this.moveToIMAPFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createmovetofolder", (boolean)this.createmovetofolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createlocalfolder", (boolean)this.createlocalfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"aftergetimap", (String)MailConnectionMeta.getAfterGetIMAPCode(this.aftergetimap)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"includesubfolders", (boolean)this.includesubfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"useproxy", (boolean)this.useproxy));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxyusername", (String)this.proxyusername));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.servername = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.username = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.usessl = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"usessl"));
            this.sslport = XMLHandler.getTagValue((Node)entrynode, (String)"sslport");
            this.outputdirectory = XMLHandler.getTagValue((Node)entrynode, (String)"outputdirectory");
            this.filenamepattern = XMLHandler.getTagValue((Node)entrynode, (String)"filenamepattern");
            if (Const.isEmpty((String)this.filenamepattern)) {
                this.filenamepattern = DEFAULT_FILE_NAME_PATTERN;
            }
            this.retrievemails = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"retrievemails"), (int)-1);
            this.firstmails = XMLHandler.getTagValue((Node)entrynode, (String)"firstmails");
            this.delete = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"delete"));
            this.protocol = Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"protocol"), (String)"POP3");
            String sm = XMLHandler.getTagValue((Node)entrynode, (String)"savemessage");
            this.savemessage = Const.isEmpty((String)sm) ? true : "Y".equalsIgnoreCase(sm);
            String sa = XMLHandler.getTagValue((Node)entrynode, (String)"saveattachment");
            this.saveattachment = Const.isEmpty((String)sa) ? true : "Y".equalsIgnoreCase(sa);
            this.usedifferentfolderforattachment = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"usedifferentfolderforattachment"));
            this.attachmentfolder = XMLHandler.getTagValue((Node)entrynode, (String)"attachmentfolder");
            this.attachmentwildcard = XMLHandler.getTagValue((Node)entrynode, (String)"attachmentwildcard");
            this.valueimaplist = MailConnectionMeta.getValueImapListByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"valueimaplist"), (String)""));
            this.imapfirstmails = XMLHandler.getTagValue((Node)entrynode, (String)"imapfirstmails");
            this.imapfolder = XMLHandler.getTagValue((Node)entrynode, (String)"imapfolder");
            this.senderSearch = XMLHandler.getTagValue((Node)entrynode, (String)"sendersearch");
            this.notTermSenderSearch = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"nottermsendersearch"));
            this.receipientSearch = XMLHandler.getTagValue((Node)entrynode, (String)"receipientsearch");
            this.notTermReceipientSearch = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"nottermreceipientsearch"));
            this.subjectSearch = XMLHandler.getTagValue((Node)entrynode, (String)"subjectsearch");
            this.notTermSubjectSearch = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"nottermsubjectsearch"));
            this.bodySearch = XMLHandler.getTagValue((Node)entrynode, (String)"bodysearch");
            this.notTermBodySearch = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"nottermbodysearch"));
            this.conditionReceivedDate = MailConnectionMeta.getConditionByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"conditionreceiveddate"), (String)""));
            this.notTermReceivedDateSearch = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"nottermreceiveddatesearch"));
            this.receivedDate1 = XMLHandler.getTagValue((Node)entrynode, (String)"receivedDate1");
            this.receivedDate2 = XMLHandler.getTagValue((Node)entrynode, (String)"receivedDate2");
            this.actiontype = MailConnectionMeta.getActionTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"actiontype"), (String)""));
            this.moveToIMAPFolder = XMLHandler.getTagValue((Node)entrynode, (String)"movetoimapfolder");
            this.createmovetofolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createmovetofolder"));
            this.createlocalfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createlocalfolder"));
            this.aftergetimap = MailConnectionMeta.getAfterGetIMAPByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"aftergetimap"), (String)""));
            this.includesubfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"includesubfolders"));
            this.useproxy = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"useproxy"));
            this.proxyusername = XMLHandler.getTagValue((Node)entrynode, (String)"proxyusername");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'get pop' from XML node", (Throwable)xe);
        }
    }

    public int getValueImapList() {
        return this.valueimaplist;
    }

    public void setValueImapList(int value) {
        this.valueimaplist = value;
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.servername = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.username = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.usessl = rep.getJobEntryAttributeBoolean(id_jobentry, "usessl");
            this.sslport = rep.getJobEntryAttributeString(id_jobentry, "sslport");
            this.outputdirectory = rep.getJobEntryAttributeString(id_jobentry, "outputdirectory");
            this.filenamepattern = rep.getJobEntryAttributeString(id_jobentry, "filenamepattern");
            if (Const.isEmpty((String)this.filenamepattern)) {
                this.filenamepattern = DEFAULT_FILE_NAME_PATTERN;
            }
            this.retrievemails = (int)rep.getJobEntryAttributeInteger(id_jobentry, "retrievemails");
            this.firstmails = rep.getJobEntryAttributeString(id_jobentry, "firstmails");
            this.delete = rep.getJobEntryAttributeBoolean(id_jobentry, "delete");
            this.protocol = Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "protocol"), (String)"POP3");
            String sv = rep.getStepAttributeString(id_jobentry, "savemessage");
            this.savemessage = Const.isEmpty((String)sv) ? true : rep.getStepAttributeBoolean(id_jobentry, "savemessage");
            String sa = rep.getStepAttributeString(id_jobentry, "saveattachment");
            this.saveattachment = Const.isEmpty((String)sa) ? true : rep.getStepAttributeBoolean(id_jobentry, "saveattachment");
            this.usedifferentfolderforattachment = rep.getJobEntryAttributeBoolean(id_jobentry, "usedifferentfolderforattachment");
            this.attachmentfolder = rep.getJobEntryAttributeString(id_jobentry, "attachmentfolder");
            this.attachmentwildcard = rep.getJobEntryAttributeString(id_jobentry, "attachmentwildcard");
            this.valueimaplist = MailConnectionMeta.getValueListImapListByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "valueimaplist"), (String)""));
            this.imapfirstmails = rep.getJobEntryAttributeString(id_jobentry, "imapfirstmails");
            this.imapfolder = rep.getJobEntryAttributeString(id_jobentry, "imapfolder");
            this.senderSearch = rep.getJobEntryAttributeString(id_jobentry, "sendersearch");
            this.notTermSenderSearch = rep.getJobEntryAttributeBoolean(id_jobentry, "nottermsendersearch");
            this.receipientSearch = rep.getJobEntryAttributeString(id_jobentry, "receipientsearch");
            this.notTermReceipientSearch = rep.getJobEntryAttributeBoolean(id_jobentry, "nottermreceipientsearch");
            this.subjectSearch = rep.getJobEntryAttributeString(id_jobentry, "subjectsearch");
            this.notTermSubjectSearch = rep.getJobEntryAttributeBoolean(id_jobentry, "nottermsubjectsearch");
            this.bodySearch = rep.getJobEntryAttributeString(id_jobentry, "bodysearch");
            this.notTermBodySearch = rep.getJobEntryAttributeBoolean(id_jobentry, "nottermbodysearch");
            this.conditionReceivedDate = MailConnectionMeta.getConditionByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "conditionreceiveddate"), (String)""));
            this.notTermReceivedDateSearch = rep.getJobEntryAttributeBoolean(id_jobentry, "nottermreceiveddatesearch");
            this.receivedDate1 = rep.getJobEntryAttributeString(id_jobentry, "receiveddate1");
            this.receivedDate2 = rep.getJobEntryAttributeString(id_jobentry, "receiveddate2");
            this.actiontype = MailConnectionMeta.getActionTypeByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "actiontype"), (String)""));
            this.moveToIMAPFolder = rep.getJobEntryAttributeString(id_jobentry, "movetoimapfolder");
            this.createmovetofolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createmovetofolder");
            this.createlocalfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createlocalfolder");
            this.aftergetimap = MailConnectionMeta.getAfterGetIMAPByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "aftergetimap"), (String)""));
            this.includesubfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "includesubfolders");
            this.useproxy = rep.getJobEntryAttributeBoolean(id_jobentry, "useproxy");
            this.proxyusername = rep.getJobEntryAttributeString(id_jobentry, "proxyusername");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'get pop' exists from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "servername", this.servername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "username", this.username);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "usessl", this.usessl);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "sslport", this.sslport);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "outputdirectory", this.outputdirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filenamepattern", this.filenamepattern);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "retrievemails", this.retrievemails);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "firstmails", this.firstmails);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "delete", this.delete);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "protocol", this.protocol);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "savemessage", this.savemessage);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "saveattachment", this.saveattachment);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "usedifferentfolderforattachment", this.usedifferentfolderforattachment);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "attachmentfolder", this.attachmentfolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "attachmentwildcard", this.attachmentwildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "valueimaplist", MailConnectionMeta.getValueImapListCode(this.valueimaplist));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "imapfirstmails", this.imapfirstmails);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "imapfolder", this.imapfolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "sendersearch", this.senderSearch);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nottermsendersearch", this.notTermSenderSearch);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "receipientsearch", this.receipientSearch);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nottermreceipientsearch", this.notTermReceipientSearch);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "subjectsearch", this.subjectSearch);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nottermsubjectsearch", this.notTermSubjectSearch);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "bodysearch", this.bodySearch);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nottermbodysearch", this.notTermBodySearch);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "conditionreceiveddate", MailConnectionMeta.getConditionDateCode(this.conditionReceivedDate));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nottermreceiveddatesearch", this.notTermReceivedDateSearch);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "receiveddate1", this.receivedDate1);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "receiveddate2", this.receivedDate2);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "actiontype", MailConnectionMeta.getActionTypeCode(this.actiontype));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "movetoimapfolder", this.moveToIMAPFolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createmovetofolder", this.createmovetofolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createlocalfolder", this.createlocalfolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "aftergetimap", MailConnectionMeta.getAfterGetIMAPCode(this.aftergetimap));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "includesubfolders", this.includesubfolders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "useproxy", this.useproxy);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxyusername", this.proxyusername);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'get pop' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public String getPort() {
        return this.sslport;
    }

    public String getRealPort() {
        return this.environmentSubstitute(this.getPort());
    }

    public void setPort(String sslport) {
        this.sslport = sslport;
    }

    public void setFirstMails(String firstmails) {
        this.firstmails = firstmails;
    }

    public String getFirstMails() {
        return this.firstmails;
    }

    public boolean isIncludeSubFolders() {
        return this.includesubfolders;
    }

    public void setIncludeSubFolders(boolean includesubfolders) {
        this.includesubfolders = includesubfolders;
    }

    public void setFirstIMAPMails(String firstmails) {
        this.imapfirstmails = firstmails;
    }

    public String getFirstIMAPMails() {
        return this.imapfirstmails;
    }

    public void setSenderSearchTerm(String senderSearch) {
        this.senderSearch = senderSearch;
    }

    public String getSenderSearchTerm() {
        return this.senderSearch;
    }

    public void setNotTermSenderSearch(boolean notTermSenderSearch) {
        this.notTermSenderSearch = notTermSenderSearch;
    }

    public boolean isNotTermSenderSearch() {
        return this.notTermSenderSearch;
    }

    public void setNotTermSubjectSearch(boolean notTermSubjectSearch) {
        this.notTermSubjectSearch = notTermSubjectSearch;
    }

    public void setNotTermBodySearch(boolean notTermBodySearch) {
        this.notTermBodySearch = notTermBodySearch;
    }

    public boolean isNotTermSubjectSearch() {
        return this.notTermSubjectSearch;
    }

    public boolean isNotTermBodySearch() {
        return this.notTermBodySearch;
    }

    public void setNotTermReceivedDateSearch(boolean notTermReceivedDateSearch) {
        this.notTermReceivedDateSearch = notTermReceivedDateSearch;
    }

    public boolean isNotTermReceivedDateSearch() {
        return this.notTermReceivedDateSearch;
    }

    public void setNotTermReceipientSearch(boolean notTermReceipientSearch) {
        this.notTermReceipientSearch = notTermReceipientSearch;
    }

    public boolean isNotTermReceipientSearch() {
        return this.notTermReceipientSearch;
    }

    public void setCreateMoveToFolder(boolean createfolder) {
        this.createmovetofolder = createfolder;
    }

    public boolean isCreateMoveToFolder() {
        return this.createmovetofolder;
    }

    public void setReceipientSearch(String receipientSearch) {
        this.receipientSearch = receipientSearch;
    }

    public String getReceipientSearch() {
        return this.receipientSearch;
    }

    public void setSubjectSearch(String subjectSearch) {
        this.subjectSearch = subjectSearch;
    }

    public String getSubjectSearch() {
        return this.subjectSearch;
    }

    public void setBodySearch(String bodySearch) {
        this.bodySearch = bodySearch;
    }

    public String getBodySearch() {
        return this.bodySearch;
    }

    public String getReceivedDate1() {
        return this.receivedDate1;
    }

    public void setReceivedDate1(String inputDate) {
        this.receivedDate1 = inputDate;
    }

    public String getReceivedDate2() {
        return this.receivedDate2;
    }

    public void setReceivedDate2(String inputDate) {
        this.receivedDate2 = inputDate;
    }

    public void setMoveToIMAPFolder(String foldername) {
        this.moveToIMAPFolder = foldername;
    }

    public String getMoveToIMAPFolder() {
        return this.moveToIMAPFolder;
    }

    public void setCreateLocalFolder(boolean createfolder) {
        this.createlocalfolder = createfolder;
    }

    public boolean isCreateLocalFolder() {
        return this.createlocalfolder;
    }

    public void setConditionOnReceivedDate(int conditionReceivedDate) {
        this.conditionReceivedDate = conditionReceivedDate;
    }

    public int getConditionOnReceivedDate() {
        return this.conditionReceivedDate;
    }

    public void setActionType(int actiontype) {
        this.actiontype = actiontype;
    }

    public int getActionType() {
        return this.actiontype;
    }

    public void setAfterGetIMAP(int afterget) {
        this.aftergetimap = afterget;
    }

    public int getAfterGetIMAP() {
        return this.aftergetimap;
    }

    public String getRealFirstMails() {
        return this.environmentSubstitute(this.getFirstMails());
    }

    public void setServerName(String servername) {
        this.servername = servername;
    }

    public String getServerName() {
        return this.servername;
    }

    public void setUserName(String username) {
        this.username = username;
    }

    public String getUserName() {
        return this.username;
    }

    public void setOutputDirectory(String outputdirectory) {
        this.outputdirectory = outputdirectory;
    }

    public void setFilenamePattern(String filenamepattern) {
        this.filenamepattern = filenamepattern;
    }

    public void setRetrievemails(int nr) {
        this.retrievemails = nr;
    }

    public int getRetrievemails() {
        return this.retrievemails;
    }

    public String getFilenamePattern() {
        return this.filenamepattern;
    }

    public String getOutputDirectory() {
        return this.outputdirectory;
    }

    public String getRealOutputDirectory() {
        return this.environmentSubstitute(this.getOutputDirectory());
    }

    public String getRealFilenamePattern() {
        return this.environmentSubstitute(this.getFilenamePattern());
    }

    public String getRealUsername() {
        return this.environmentSubstitute(this.getUserName());
    }

    public String getRealServername() {
        return this.environmentSubstitute(this.getServerName());
    }

    public String getRealProxyUsername() {
        return this.environmentSubstitute(this.geProxyUsername());
    }

    public String geProxyUsername() {
        return this.proxyusername;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRealPassword() {
        return this.environmentSubstitute(this.getPassword());
    }

    public String getAttachmentFolder() {
        return this.attachmentfolder;
    }

    public void setAttachmentFolder(String foldername) {
        this.attachmentfolder = foldername;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean getDelete() {
        return this.delete;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getIMAPFolder() {
        return this.imapfolder;
    }

    public void setIMAPFolder(String folder) {
        this.imapfolder = folder;
    }

    public void setAttachmentWildcard(String wildcard) {
        this.attachmentwildcard = wildcard;
    }

    public String getAttachmentWildcard() {
        return this.attachmentwildcard;
    }

    public void setUseSSL(boolean usessl) {
        this.usessl = usessl;
    }

    public boolean isUseSSL() {
        return this.usessl;
    }

    public boolean isUseProxy() {
        return this.useproxy;
    }

    public void setUseProxy(boolean useprox) {
        this.useproxy = useprox;
    }

    public boolean isSaveAttachment() {
        return this.saveattachment;
    }

    public void setProxyUsername(String username) {
        this.proxyusername = username;
    }

    public String getProxyUsername() {
        return this.proxyusername;
    }

    public void setSaveAttachment(boolean saveattachment) {
        this.saveattachment = saveattachment;
    }

    public boolean isSaveMessage() {
        return this.savemessage;
    }

    public void setSaveMessage(boolean savemessage) {
        this.savemessage = savemessage;
    }

    public void setDifferentFolderForAttachment(boolean usedifferentfolder) {
        this.usedifferentfolderforattachment = usedifferentfolder;
    }

    public boolean isDifferentFolderForAttachment() {
        return this.usedifferentfolderforattachment;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) throws KettleException {
        Result result = previousResult;
        result.setResult(false);
        MailConnection mailConn = null;
        Date beginDate = null;
        Date endDate = null;
        SimpleDateFormat df = new SimpleDateFormat(DATE_PATTERN);
        try {
            String realSearchBody;
            String realSearchSubject;
            String realSearchReceipient;
            String realSearchSender;
            boolean usePOP3 = this.getProtocol().equals("POP3");
            boolean moveafter = false;
            int nbrmailtoretrieve = usePOP3 ? (this.getRetrievemails() == 2 ? Const.toInt((String)this.getFirstMails(), (int)0) : 0) : Const.toInt((String)this.getFirstIMAPMails(), (int)0);
            String realOutputFolder = this.getRealOutputDirectory();
            String targetAttachmentFolder = null;
            if (this.getActionType() == 0) {
                boolean useDifferentFolderForAttachment;
                FileObject fileObject = KettleVFS.getFileObject((String)realOutputFolder, (VariableSpace)this);
                if (fileObject.exists()) {
                    if (fileObject.getType() != FileType.FOLDER) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.NotAFolderNot", (String[])new String[]{realOutputFolder}));
                    }
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Log.OutputFolderExists", (String[])new String[]{realOutputFolder}));
                    }
                } else if (this.isCreateLocalFolder()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Log.OutputFolderNotExist", (String[])new String[]{realOutputFolder}));
                    }
                    fileObject.createFolder();
                } else {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.FolderNotExists1.Label", (String[])new String[0]) + realOutputFolder + BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.FolderNotExists2.Label", (String[])new String[0]));
                }
                targetAttachmentFolder = KettleVFS.getFilename((FileObject)fileObject);
                boolean bl = useDifferentFolderForAttachment = this.isSaveAttachment() && this.isDifferentFolderForAttachment();
                if (useDifferentFolderForAttachment) {
                    String realFolderAttachment = this.environmentSubstitute(this.getAttachmentFolder());
                    if (Const.isEmpty((String)realFolderAttachment)) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.AttachmentFolderEmpty", (String[])new String[0]));
                    }
                    try {
                        fileObject.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    fileObject = KettleVFS.getFileObject((String)realFolderAttachment, (VariableSpace)this);
                    if (!fileObject.exists()) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.AttachmentFolderNotExist", (String[])new String[]{realFolderAttachment}));
                    }
                    if (fileObject.getType() != FileType.FOLDER) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.AttachmentFolderNotAFolder", (String[])new String[]{realFolderAttachment}));
                    }
                    targetAttachmentFolder = KettleVFS.getFilename((FileObject)fileObject);
                }
                try {
                    fileObject.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            String realMoveToIMAPFolder = this.environmentSubstitute(this.getMoveToIMAPFolder());
            if (this.getProtocol().equals("IMAP") && this.getActionType() == 1 || this.getActionType() == 0 && this.getAfterGetIMAP() == 2) {
                if (Const.isEmpty((String)realMoveToIMAPFolder)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.MoveToIMAPFolderEmpty", (String[])new String[0]));
                }
                moveafter = true;
            }
            switch (this.getConditionOnReceivedDate()) {
                case 1: 
                case 2: 
                case 3: {
                    String realBeginDate = this.environmentSubstitute(this.getReceivedDate1());
                    if (Const.isEmpty((String)realBeginDate)) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.ReceivedDateSearchTermEmpty", (String[])new String[0]));
                    }
                    beginDate = df.parse(realBeginDate);
                    break;
                }
                case 4: {
                    String realBeginDate = this.environmentSubstitute(this.getReceivedDate1());
                    if (Const.isEmpty((String)realBeginDate)) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                    }
                    beginDate = df.parse(realBeginDate);
                    String realEndDate = this.environmentSubstitute(this.getReceivedDate2());
                    if (Const.isEmpty((String)realEndDate)) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                    }
                    endDate = df.parse(realEndDate);
                    break;
                }
            }
            String realserver = this.getRealServername();
            String realusername = this.getRealUsername();
            String realpassword = this.getRealPassword();
            String realFilenamePattern = this.getRealFilenamePattern();
            int realport = Const.toInt((String)this.environmentSubstitute(this.sslport), (int)-1);
            String realIMAPFolder = this.environmentSubstitute(this.getIMAPFolder());
            String realProxyUsername = this.getRealProxyUsername();
            this.initVariables();
            mailConn = new MailConnection(this.log, MailConnectionMeta.getProtocolFromString(this.getProtocol(), 1), realserver, realport, realusername, realpassword, this.isUseSSL(), this.isUseProxy(), realProxyUsername);
            mailConn.connect();
            if (moveafter) {
                mailConn.setDestinationFolder(realMoveToIMAPFolder, this.isCreateMoveToFolder());
            }
            if (!Const.isEmpty((String)(realSearchSender = this.environmentSubstitute(this.getSenderSearchTerm())))) {
                mailConn.setSenderTerm(realSearchSender, this.isNotTermSenderSearch());
            }
            if (!Const.isEmpty((String)(realSearchReceipient = this.environmentSubstitute(this.getReceipientSearch())))) {
                mailConn.setReceipientTerm(realSearchReceipient);
            }
            if (!Const.isEmpty((String)(realSearchSubject = this.environmentSubstitute(this.getSubjectSearch())))) {
                mailConn.setSubjectTerm(realSearchSubject, this.isNotTermSubjectSearch());
            }
            if (!Const.isEmpty((String)(realSearchBody = this.environmentSubstitute(this.getBodySearch())))) {
                mailConn.setBodyTerm(realSearchBody, this.isNotTermBodySearch());
            }
            switch (this.getConditionOnReceivedDate()) {
                case 1: {
                    mailConn.setReceivedDateTermEQ(beginDate);
                    break;
                }
                case 3: {
                    mailConn.setReceivedDateTermGT(beginDate);
                    break;
                }
                case 2: {
                    mailConn.setReceivedDateTermLT(beginDate);
                    break;
                }
                case 4: {
                    mailConn.setReceivedDateTermBetween(beginDate, endDate);
                    break;
                }
            }
            if (usePOP3) {
                if (this.getRetrievemails() == 1) {
                    mailConn.setFlagTermUnread();
                }
            } else {
                switch (this.getValueImapList()) {
                    case 1: {
                        mailConn.setFlagTermNew();
                        break;
                    }
                    case 2: {
                        mailConn.setFlagTermOld();
                        break;
                    }
                    case 3: {
                        mailConn.setFlagTermRead();
                        break;
                    }
                    case 4: {
                        mailConn.setFlagTermUnread();
                        break;
                    }
                    case 5: {
                        mailConn.setFlagTermFlagged();
                        break;
                    }
                    case 6: {
                        mailConn.setFlagTermNotFlagged();
                        break;
                    }
                    case 7: {
                        mailConn.setFlagTermDraft();
                        break;
                    }
                    case 8: {
                        mailConn.setFlagTermNotDraft();
                        break;
                    }
                }
            }
            this.fetchOneFolder(mailConn, usePOP3, realIMAPFolder, realOutputFolder, targetAttachmentFolder, realMoveToIMAPFolder, realFilenamePattern, nbrmailtoretrieve, df);
            if (this.isIncludeSubFolders()) {
                String[] subfolders;
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobGetPOP.FetchingSubFolders", (String[])new String[0]));
                }
                if ((subfolders = mailConn.returnAllFolders()).length == 0) {
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"JobGetPOP.NoSubFolders", (String[])new String[0]));
                    }
                } else {
                    for (int i = 0; i < subfolders.length; ++i) {
                        this.fetchOneFolder(mailConn, usePOP3, subfolders[i], realOutputFolder, targetAttachmentFolder, realMoveToIMAPFolder, realFilenamePattern, nbrmailtoretrieve, df);
                    }
                }
            }
            result.setResult(true);
            result.setNrFilesRetrieved((long)mailConn.getSavedAttachedFilesCounter());
            result.setNrLinesWritten((long)mailConn.getSavedMessagesCounter());
            result.setNrLinesDeleted((long)mailConn.getDeletedMessagesCounter());
            result.setNrLinesUpdated((long)mailConn.getMovedMessagesCounter());
            if (this.isDetailed()) {
                this.logDetailed("=======================================");
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobGetPOP.Log.Info.SavedMessages", (String[])new String[]{"" + mailConn.getSavedMessagesCounter()}));
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobGetPOP.Log.Info.DeletedMessages", (String[])new String[]{"" + mailConn.getDeletedMessagesCounter()}));
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobGetPOP.Log.Info.MovedMessages", (String[])new String[]{"" + mailConn.getMovedMessagesCounter()}));
                if (this.getActionType() == 0 && this.isSaveAttachment()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobGetPOP.Log.Info.AttachedMessagesSuccess", (String[])new String[]{"" + mailConn.getSavedAttachedFilesCounter()}));
                }
                this.logDetailed("=======================================");
            }
        }
        catch (Exception e) {
            result.setNrErrors(1L);
            this.logError("Unexpected error: " + e.getMessage());
            this.logError(Const.getStackTracker((Throwable)e));
        }
        finally {
            try {
                if (mailConn != null) {
                    mailConn.disconnect();
                    mailConn = null;
                }
            }
            catch (Exception e) {}
        }
        return result;
    }

    void fetchOneFolder(MailConnection mailConn, boolean usePOP3, String realIMAPFolder, String realOutputFolder, String targetAttachmentFolder, String realMoveToIMAPFolder, String realFilenamePattern, int nbrmailtoretrieve, SimpleDateFormat df) throws KettleException {
        block29: {
            try {
                if (!usePOP3 && !Const.isEmpty((String)realIMAPFolder)) {
                    mailConn.openFolder(realIMAPFolder, true);
                } else {
                    mailConn.openFolder(true);
                }
                mailConn.retrieveMessages();
                int messagesCount = mailConn.getMessagesCount();
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.TotalMessagesFolder.Label", (String[])new String[]{"" + messagesCount, Const.NVL((String)mailConn.getFolderName(), (String)"INBOX")}));
                }
                int n = nbrmailtoretrieve > 0 ? (nbrmailtoretrieve > messagesCount ? messagesCount : nbrmailtoretrieve) : (messagesCount = messagesCount);
                if (messagesCount <= 0) break block29;
                switch (this.getActionType()) {
                    case 2: {
                        if (nbrmailtoretrieve > 0) {
                            for (int i = 0; i < messagesCount && !this.parentJob.isStopped(); ++i) {
                                mailConn.fetchNext();
                                mailConn.deleteMessage();
                                if (!this.isDebug()) continue;
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.MessageDeleted", (String[])new String[]{"" + i}));
                            }
                        } else {
                            mailConn.deleteMessages(true);
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.MessagesDeleted", (String[])new String[]{"" + messagesCount}));
                            }
                        }
                        break;
                    }
                    case 1: {
                        if (nbrmailtoretrieve > 0) {
                            for (int i = 0; i < messagesCount && !this.parentJob.isStopped(); ++i) {
                                mailConn.fetchNext();
                                mailConn.moveMessage();
                                if (!this.isDebug()) continue;
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.MessageMoved", (String[])new String[]{"" + i, realMoveToIMAPFolder}));
                            }
                        } else {
                            mailConn.moveMessages();
                            if (this.isDebug()) {
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.MessagesMoved", (String[])new String[]{"" + messagesCount, realMoveToIMAPFolder}));
                            }
                        }
                        break;
                    }
                    default: {
                        block12: for (int i = 0; i < messagesCount && !this.parentJob.isStopped(); ++i) {
                            boolean okIMAP;
                            mailConn.fetchNext();
                            int messagenumber = mailConn.getMessage().getMessageNumber();
                            boolean okPOP3 = usePOP3;
                            boolean bl = okIMAP = !usePOP3;
                            if (!okPOP3 && !okIMAP) continue;
                            if (this.isDebug() && mailConn.getMessage() != null) {
                                this.logDebug("--------------------------------------------------");
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.MessageNumber.Label", (String[])new String[]{"" + messagenumber}));
                                if (mailConn.getMessage().getReceivedDate() != null) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.ReceivedDate.Label", (String[])new String[]{df.format(mailConn.getMessage().getReceivedDate())}));
                                }
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.ContentType.Label", (String[])new String[]{mailConn.getMessage().getContentType()}));
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.EmailFrom.Label", (String[])new String[]{Const.NVL((String)mailConn.getMessage().getFrom()[0].toString(), (String)"")}));
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.EmailSubject.Label", (String[])new String[]{Const.NVL((String)mailConn.getMessage().getSubject(), (String)"")}));
                            }
                            if (this.isSaveMessage()) {
                                String localfilename_message = this.replaceTokens(realFilenamePattern, i);
                                if (this.isDebug()) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.LocalFilename.Label", (String[])new String[]{localfilename_message}));
                                }
                                mailConn.saveMessageContentToFile(localfilename_message, realOutputFolder);
                                mailConn.getMessage().setFlag(Flags.Flag.SEEN, true);
                                if (this.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.MessageSaved.Label", (String[])new String[]{"" + messagenumber, localfilename_message, realOutputFolder}));
                                }
                            }
                            if (this.isSaveAttachment()) {
                                mailConn.saveAttachedFiles(targetAttachmentFolder, this.attachementPattern);
                            }
                            if (usePOP3) {
                                if (!this.getDelete()) continue;
                                mailConn.deleteMessage();
                                if (!this.isDebug()) continue;
                                this.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.MessageDeleted", (String[])new String[]{"" + messagenumber}));
                                continue;
                            }
                            switch (this.getAfterGetIMAP()) {
                                case 1: {
                                    mailConn.deleteMessage();
                                    if (!this.isDebug()) continue block12;
                                    this.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.MessageDeleted", (String[])new String[]{"" + messagenumber}));
                                    continue block12;
                                }
                                case 2: {
                                    mailConn.moveMessage();
                                    if (!this.isDebug()) continue block12;
                                    this.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.MessageMoved", (String[])new String[]{"" + messagenumber, realMoveToIMAPFolder}));
                                    continue block12;
                                }
                            }
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    private String replaceTokens(String aString, int idfile) {
        String localfilename_message = aString;
        localfilename_message = localfilename_message.replaceAll(FILENAME_ID_PATTERN, "" + (idfile + 1));
        localfilename_message = this.substituteDate(localfilename_message, FILENAME_SYS_DATE_OPEN, FILENAME_SYS_DATE_CLOSE, new Date());
        return localfilename_message;
    }

    private String substituteDate(String aString, String open, String close, Date datetime) {
        if (aString == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String rest = aString;
        int i = rest.indexOf(open);
        while (i > -1) {
            int j = rest.indexOf(close, i + open.length());
            if (j > -1) {
                String varName = rest.substring(i + open.length(), j);
                SimpleDateFormat dateFormat = new SimpleDateFormat(varName);
                String Value = dateFormat.format(datetime);
                buffer.append(rest.substring(0, i));
                buffer.append((Object)Value);
                rest = rest.substring(j + close.length());
            } else {
                buffer.append(rest);
                rest = "";
            }
            i = rest.indexOf(close);
        }
        buffer.append(rest);
        return buffer.toString();
    }

    private void initVariables() {
        this.attachementPattern = null;
        String realAttachmentWildcard = this.environmentSubstitute(this.getAttachmentWildcard());
        if (!Const.isEmpty((String)realAttachmentWildcard)) {
            this.attachementPattern = Pattern.compile(realAttachmentWildcard);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "outputDirectory", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "SSLPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.servername)) {
            String realServername = jobMeta.environmentSubstitute(this.servername);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServername, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }
}

