/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.eigenbase.resgen.AbstractJavaGenerator;
import org.eigenbase.resgen.Generator;
import org.eigenbase.resgen.JavaBaseGenerator;
import org.eigenbase.resgen.JavaFunctorBaseGenerator;
import org.eigenbase.resgen.JavaLocaleGenerator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceGen;
import org.eigenbase.resgen.ResourceGenTask;
import org.eigenbase.resgen.Util;

abstract class FileTask {
    ResourceGenTask.Include include;
    String className;
    String fileName;
    String cppClassName;
    boolean outputJava;
    boolean outputCpp;

    FileTask() {
    }

    abstract void process(ResourceGen var1) throws IOException;

    File getFile() {
        return new File(this.include.root.src, this.fileName);
    }

    String getFileForComments() {
        int slashPos;
        String file = this.getFile().toString().replace('\\', '/');
        if (this.include.root.commentStyle == 2 && (slashPos = file.lastIndexOf(47)) > 0) {
            file = "..." + file.substring(slashPos);
        }
        return file;
    }

    boolean checkUpToDate(ResourceGen generator, File file) {
        if (file.exists() && file.lastModified() >= this.getFile().lastModified()) {
            generator.comment(file + " is up to date");
            return true;
        }
        return false;
    }

    void makeParentDirs(File file) {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
    }

    private String getPackageName() {
        int lastDot = this.className.lastIndexOf(46);
        if (lastDot < 0) {
            return null;
        }
        return this.className.substring(0, lastDot);
    }

    private File getPackageDirectory(File file) {
        String packageName = this.getPackageName();
        if (packageName == null) {
            return file;
        }
        return new File(file, packageName.replace('.', Util.fileSep));
    }

    File getSrcDirectory() {
        return this.getPackageDirectory(this.include.root.src);
    }

    File getDestDirectory() {
        return this.getPackageDirectory(this.include.root.dest);
    }

    File getResourceDirectory() {
        return this.getPackageDirectory(this.include.root.res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateJava(ResourceGen generator, ResourceDef.ResourceBundle resourceList, Locale locale) {
        FileOutputStream out;
        String fileName = Util.getClassNameSansPackage(this.className, locale) + ".java";
        File file = new File(this.getDestDirectory(), fileName);
        if (!this.include.root.force && this.checkUpToDate(generator, file)) {
            return;
        }
        generator.comment("Generating " + file);
        try {
            this.makeParentDirs(file);
            out = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Error while writing " + file, (Throwable)e);
        }
        PrintWriter pw = new PrintWriter(out);
        try {
            AbstractJavaGenerator gen;
            if (locale == null) {
                String baseClassName = this.include.baseClassName;
                if (baseClassName == null) {
                    baseClassName = "org.eigenbase.resgen.ShadowResourceBundle";
                }
                switch (this.include.root.style) {
                    case 1: {
                        gen = new JavaBaseGenerator(this.getFile(), file, this.className, baseClassName, resourceList);
                        break;
                    }
                    case 2: {
                        gen = new JavaFunctorBaseGenerator(this.getFile(), file, this.className, baseClassName, resourceList);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unexpected style " + this.include.root.style));
                    }
                }
            } else {
                String className = this.className + "_" + locale.toString();
                String baseClassName = this.className;
                gen = new JavaLocaleGenerator(this.getFile(), file, className, resourceList, locale, baseClassName);
            }
            this.configureCommentStyle(gen);
            gen.generateModule(generator, resourceList, pw);
        }
        finally {
            pw.close();
        }
    }

    protected void configureCommentStyle(Generator gen) {
        switch (this.include.root.commentStyle) {
            case 1: {
                gen.setScmSafeComments(false);
                break;
            }
            case 2: {
                gen.setScmSafeComments(true);
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected comment style " + this.include.root.commentStyle));
            }
        }
    }
}

