/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.database.event;

import java.io.InputStream;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.plugins.DatabasePluginType;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.ui.database.Messages;
import org.pentaho.ui.database.event.DataHandler;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;

public class FragmentHandler
extends AbstractXulEventHandler {
    private XulListbox connectionBox;
    private XulListbox accessBox;
    private String packagePath = "org/pentaho/ui/database/";

    private void loadDatabaseOptionsFragment(String fragmentUri) throws XulException {
        XulComponent groupElement = this.document.getElementById("database-options-box");
        XulComponent parentElement = groupElement.getParent();
        XulDomContainer fragmentContainer = null;
        try {
            fragmentContainer = this.xulDomContainer.loadFragment(fragmentUri, (Object)Messages.getBundle());
            XulComponent newGroup = fragmentContainer.getDocumentRoot().getFirstChild();
            parentElement.replaceChild(groupElement, newGroup);
        }
        catch (XulException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void refreshOptions() {
        int port;
        this.connectionBox = (XulListbox)this.document.getElementById("connection-type-list");
        this.accessBox = (XulListbox)this.document.getElementById("access-type-list");
        String connectionKey = DataHandler.connectionNametoID.get(this.connectionBox.getSelectedItem());
        String databaseName = null;
        try {
            databaseName = PluginRegistry.getInstance().getPlugin(DatabasePluginType.class, "" + connectionKey).getIds()[0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DatabaseInterface database = (DatabaseInterface)DataHandler.connectionMap.get(this.connectionBox.getSelectedItem());
        Object accessKey = this.accessBox.getSelectedItem();
        int access = DatabaseMeta.getAccessType((String)((String)accessKey));
        String fragment = null;
        DataHandler dataHandler = null;
        try {
            dataHandler = (DataHandler)this.xulDomContainer.getEventHandler("dataHandler");
            dataHandler.pushCache();
        }
        catch (XulException e) {
            // empty catch block
        }
        switch (access) {
            case 4: {
                fragment = this.getFragment(database, databaseName, "_jndi.xul", "common_jndi.xul");
                break;
            }
            case 0: {
                fragment = this.getFragment(database, databaseName, "_native.xul", "common_native.xul");
                break;
            }
            case 2: {
                fragment = this.getFragment(database, databaseName, "_oci.xul", "common_native.xul");
                break;
            }
            case 1: {
                fragment = this.getFragment(database, databaseName, "_odbc.xul", "common_odbc.xul");
                break;
            }
            case 3: {
                fragment = this.getFragment(database, databaseName, "_plugin.xul", "common_native.xul");
                break;
            }
        }
        try {
            this.loadDatabaseOptionsFragment(fragment.toLowerCase());
        }
        catch (XulException e) {
            this.showMessage(Messages.getString("FragmentHandler.USER.CANT_LOAD_OPTIONS", databaseName));
        }
        XulTextbox portBox = (XulTextbox)this.document.getElementById("port-number-text");
        if (portBox != null && (port = database.getDefaultDatabasePort()) > 0) {
            portBox.setValue(Integer.toString(port));
        }
        if (dataHandler != null) {
            dataHandler.popCache();
        }
    }

    private String getFragment(DatabaseInterface database, String dbName, String extension, String defaultFragment) {
        String fragment = database.getXulOverlayFile() != null ? this.packagePath.concat(database.getXulOverlayFile()).concat(extension) : this.packagePath.concat(dbName).concat(extension);
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(fragment.toLowerCase());
        if (in == null) {
            fragment = this.packagePath.concat(defaultFragment);
        }
        return fragment;
    }

    public Object getData() {
        return null;
    }

    public void setData(Object arg0) {
    }

    private void showMessage(String message) {
        try {
            XulMessageBox box = (XulMessageBox)this.document.createElement("messagebox");
            box.setMessage(message);
            box.open();
        }
        catch (XulException e) {
            System.out.println("Error creating messagebox " + e.getMessage());
        }
    }
}

