/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeException;
import org.apache.hadoop.hive.serde2.avro.SchemaResolutionProblem;
import org.apache.hadoop.mapred.JobConf;

public class AvroSerdeUtils {
    private static final Log LOG = LogFactory.getLog(AvroSerdeUtils.class);
    public static final String SCHEMA_LITERAL = "avro.schema.literal";
    public static final String SCHEMA_URL = "avro.schema.url";
    public static final String SCHEMA_NONE = "none";
    public static final String EXCEPTION_MESSAGE = "Neither avro.schema.literal nor avro.schema.url specified, can't determine table schema";
    public static final String AVRO_SERDE_SCHEMA = "avro.serde.schema";

    public static Schema determineSchemaOrThrowException(Properties properties) throws IOException, AvroSerdeException {
        String schemaString = properties.getProperty(SCHEMA_LITERAL);
        if (schemaString != null && !schemaString.equals(SCHEMA_NONE)) {
            return Schema.parse(schemaString);
        }
        schemaString = properties.getProperty(SCHEMA_URL);
        if (schemaString == null || schemaString.equals(SCHEMA_NONE)) {
            throw new AvroSerdeException(EXCEPTION_MESSAGE);
        }
        try {
            if (schemaString.toLowerCase().startsWith("maprfs://") || schemaString.toLowerCase().startsWith("hdfs://")) {
                return AvroSerdeUtils.getSchemaFromHDFS(schemaString, new Configuration());
            }
        }
        catch (IOException ioe) {
            throw new AvroSerdeException("Unable to read schema from MapRFS: " + schemaString, ioe);
        }
        return Schema.parse(new URL(schemaString).openStream());
    }

    public static Schema determineSchemaOrReturnErrorSchema(Properties props) {
        try {
            return AvroSerdeUtils.determineSchemaOrThrowException(props);
        }
        catch (AvroSerdeException he) {
            LOG.warn((Object)"Encountered AvroSerdeException determining schema. Returning signal schema to indicate problem", (Throwable)he);
            return SchemaResolutionProblem.SIGNAL_BAD_SCHEMA;
        }
        catch (Exception e) {
            LOG.warn((Object)"Encountered exception determining schema. Returning signal schema to indicate problem", (Throwable)e);
            return SchemaResolutionProblem.SIGNAL_BAD_SCHEMA;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Schema getSchemaFromHDFS(String schemaHDFSUrl, Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        try (FSDataInputStream in = null;){
            Schema s;
            in = fs.open(new Path(schemaHDFSUrl));
            Schema schema = s = Schema.parse((InputStream)in);
            return schema;
        }
    }

    public static boolean isNullableType(Schema schema) {
        return schema.getType().equals((Object)Schema.Type.UNION) && schema.getTypes().size() == 2 && (schema.getTypes().get(0).getType().equals((Object)Schema.Type.NULL) || schema.getTypes().get(1).getType().equals((Object)Schema.Type.NULL));
    }

    public static Schema getOtherTypeFromNullableType(Schema schema) {
        List<Schema> types = schema.getTypes();
        return types.get(0).getType().equals((Object)Schema.Type.NULL) ? types.get(1) : types.get(0);
    }

    public static boolean insideMRJob(JobConf job) {
        return job != null && HiveConf.getVar((Configuration)job, HiveConf.ConfVars.PLAN) != null && !HiveConf.getVar((Configuration)job, HiveConf.ConfVars.PLAN).isEmpty();
    }
}

