/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.InformationSchemaManager;
import com.cloudera.sqoop.util.ImportException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.StringUtils;
import org.apache.sqoop.manager.ImportJobContext;

public class MySQLManager
extends InformationSchemaManager {
    public static final Log LOG = LogFactory.getLog((String)MySQLManager.class.getName());
    private static final String DRIVER_CLASS = "com.mysql.jdbc.Driver";
    private static boolean warningPrinted = false;

    public MySQLManager(SqoopOptions opts) {
        super(DRIVER_CLASS, opts);
    }

    @Override
    protected void initOptionDefaults() {
        if (this.options.getFetchSize() == null) {
            LOG.info((Object)"Preparing to use a MySQL streaming resultset.");
            this.options.setFetchSize(Integer.MIN_VALUE);
        } else if (!this.options.getFetchSize().equals(Integer.MIN_VALUE) && !this.options.getFetchSize().equals(0)) {
            LOG.info((Object)("Argument '--fetch-size " + this.options.getFetchSize() + "' will probably get ignored by MySQL JDBC driver."));
        }
    }

    @Override
    protected String getColNamesQuery(String tableName) {
        return "SELECT t.* FROM " + this.escapeTableName(tableName) + " AS t LIMIT 1";
    }

    @Override
    public void importTable(com.cloudera.sqoop.manager.ImportJobContext context) throws IOException, ImportException {
        String connectString;
        if (!warningPrinted && null != (connectString = context.getOptions().getConnectString())) {
            LOG.warn((Object)"It looks like you are importing from mysql.");
            LOG.warn((Object)"This transfer can be faster! Use the --direct");
            LOG.warn((Object)"option to exercise a MySQL-specific fast path.");
            MySQLManager.markWarningPrinted();
        }
        this.checkDateTimeBehavior(context);
        super.importTable(context);
    }

    protected static void markWarningPrinted() {
        warningPrinted = true;
    }

    private void checkDateTimeBehavior(ImportJobContext context) {
        String ZERO_BEHAVIOR_STR = "zeroDateTimeBehavior";
        String CONVERT_TO_NULL = "=convertToNull";
        String connectStr = context.getOptions().getConnectString();
        if (connectStr.indexOf("jdbc:") != 0) {
            return;
        }
        String uriComponent = connectStr.substring(5);
        try {
            URI uri = new URI(uriComponent);
            String query = uri.getQuery();
            if (null == query) {
                connectStr = connectStr + "?" + "zeroDateTimeBehavior" + "=convertToNull";
                LOG.info((Object)"Setting zero DATETIME behavior to convertToNull (mysql)");
            } else if (query.length() == 0) {
                connectStr = connectStr + "zeroDateTimeBehavior" + "=convertToNull";
                LOG.info((Object)"Setting zero DATETIME behavior to convertToNull (mysql)");
            } else if (query.indexOf("zeroDateTimeBehavior") == -1) {
                if (!connectStr.endsWith("&")) {
                    connectStr = connectStr + "&";
                }
                connectStr = connectStr + "zeroDateTimeBehavior" + "=convertToNull";
                LOG.info((Object)"Setting zero DATETIME behavior to convertToNull (mysql)");
            }
            LOG.debug((Object)("Rewriting connect string to " + connectStr));
            context.getOptions().setConnectString(connectStr);
        }
        catch (URISyntaxException use) {
            LOG.debug((Object)("mysql: Couldn't parse connect str in checkDateTimeBehavior: " + use));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execAndPrint(String s) {
        ResultSet results = null;
        try {
            results = super.execute(s, 0, new Object[0]);
        }
        catch (SQLException sqlE) {
            LOG.error((Object)("Error executing statement: " + StringUtils.stringifyException((Throwable)sqlE)));
            this.release();
            return;
        }
        PrintWriter pw = new PrintWriter(System.out, true);
        try {
            this.formatAndPrintResultSet(results, pw);
        }
        finally {
            pw.close();
        }
    }

    @Override
    public String escapeColName(String colName) {
        if (null == colName) {
            return null;
        }
        return "`" + colName + "`";
    }

    @Override
    public String escapeTableName(String tableName) {
        if (null == tableName) {
            return null;
        }
        return "`" + tableName + "`";
    }

    @Override
    public boolean supportsStagingForExport() {
        return true;
    }

    @Override
    protected String getListDatabasesQuery() {
        return "SELECT SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA";
    }

    @Override
    protected String getSchemaQuery() {
        return "SELECT SCHEMA()";
    }
}

