/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.toc;

import java.awt.geom.Point2D;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.pentaho.reporting.designer.core.editor.ReportDocumentContext;
import org.pentaho.reporting.designer.core.editor.report.ReportElementEditorContext;
import org.pentaho.reporting.designer.core.editor.report.elements.AbstractSubReportElementDragHandler;
import org.pentaho.reporting.designer.core.editor.report.elements.SubreportConfigureHandler;
import org.pentaho.reporting.designer.core.util.undo.BandedSubreportEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.ElementEditUndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoEntry;
import org.pentaho.reporting.designer.core.util.undo.UndoManager;
import org.pentaho.reporting.designer.extensions.toc.Messages;
import org.pentaho.reporting.engine.classic.core.AbstractRootLevelBand;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.extensions.toc.IndexElement;

public class IndexReportElementDragHandler
extends AbstractSubReportElementDragHandler {
    protected Element createElement(ElementMetaData elementMetaData, String fieldName, ReportDocumentContext context) throws InstantiationException {
        ElementType type = elementMetaData.create();
        IndexElement visualElement = new IndexElement();
        SubreportConfigureHandler.configureDefaults((SubReport)visualElement);
        type.configureDesignTimeDefaults((ReportElement)visualElement, Locale.getDefault());
        ElementStyleSheet styleSheet = visualElement.getStyle();
        styleSheet.setStyleProperty(ElementStyleKeys.MIN_WIDTH, (Object)DEFAULT_WIDTH);
        styleSheet.setStyleProperty(ElementStyleKeys.MIN_HEIGHT, (Object)DEFAULT_HEIGHT);
        return visualElement;
    }

    protected void postProcessDrop(Element visualElement, Band target, ReportElementEditorContext dragContext, Point2D point) {
        Element rootBand = this.findRootBand(dragContext, point);
        SwingUtilities.invokeLater(new IndexReportConfigureHandler((IndexElement)visualElement, target, dragContext, rootBand == target));
    }

    private static class IndexReportConfigureHandler
    implements Runnable {
        private IndexElement subReport;
        private Band parent;
        private ReportElementEditorContext dragContext;
        private boolean rootband;

        private IndexReportConfigureHandler(IndexElement subReport, Band parent, ReportElementEditorContext dragContext, boolean rootband) {
            this.subReport = subReport;
            this.parent = parent;
            this.dragContext = dragContext;
            this.rootband = rootband;
        }

        @Override
        public void run() {
            if (this.rootband) {
                int result = JOptionPane.showOptionDialog(this.dragContext.getRepresentationContainer(), Messages.getInstance().getString("IndexElementDragHandler.BandedOrInlineSubreportQuestion"), Messages.getInstance().getString("IndexElementDragHandler.InsertSubreport"), 1, -1, null, new String[]{Messages.getInstance().getString("IndexElementDragHandler.Inline"), Messages.getInstance().getString("IndexElementDragHandler.Banded"), Messages.getInstance().getString("IndexElementDragHandler.Cancel")}, Messages.getInstance().getString("IndexElementDragHandler.Inline"));
                if (result == -1 || result == 2) {
                    return;
                }
                if (result == 0) {
                    ReportDocumentContext context = this.dragContext.getRenderContext();
                    UndoManager undo = context.getUndo();
                    undo.addChange(Messages.getInstance().getString("IndexElementDragHandler.UndoEntry"), (UndoEntry)new ElementEditUndoEntry(this.parent.getObjectID(), this.parent.getElementCount(), null, (Element)this.subReport));
                    this.parent.addElement((Element)this.subReport);
                } else {
                    AbstractRootLevelBand arb = (AbstractRootLevelBand)this.parent;
                    ReportDocumentContext context = this.dragContext.getRenderContext();
                    UndoManager undo = context.getUndo();
                    undo.addChange(Messages.getInstance().getString("IndexElementDragHandler.UndoEntry"), (UndoEntry)new BandedSubreportEditUndoEntry(this.parent.getObjectID(), arb.getSubReportCount(), null, (SubReport)this.subReport));
                    arb.addSubReport((SubReport)this.subReport);
                }
            } else {
                ReportDocumentContext context = this.dragContext.getRenderContext();
                UndoManager undo = context.getUndo();
                undo.addChange(Messages.getInstance().getString("IndexElementDragHandler.UndoEntry"), (UndoEntry)new ElementEditUndoEntry(this.parent.getObjectID(), this.parent.getElementCount(), null, (Element)this.subReport));
                this.parent.addElement((Element)this.subReport);
            }
            this.dragContext.getRenderContext().getSelectionModel().setSelectedElements(new Object[]{this.subReport});
        }
    }
}

