/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.messages;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.messages.MessageUtil;

public class MessagesBase {
    private final Map<Locale, ResourceBundle> locales = Collections.synchronizedMap(new HashMap());
    private String bundleName;

    public MessagesBase(String bundleName) {
        this.bundleName = bundleName;
    }

    public ResourceBundle getBundle() {
        return this.getBundle(LocaleHelper.getLocale());
    }

    public ResourceBundle getBundle(Locale locale) {
        ResourceBundle bundle = this.locales.get(locale);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(this.bundleName, locale);
            this.locales.put(locale, bundle);
        }
        return bundle;
    }

    public String getEncodedString(String rawValue) {
        if (rawValue == null) {
            return "";
        }
        StringBuffer value = new StringBuffer();
        for (int n = 0; n < rawValue.length(); ++n) {
            char charValue = rawValue.charAt(n);
            if (charValue >= '\u0080') {
                value.append("&#x");
                value.append(Integer.toString(charValue, 16));
                value.append(";");
                continue;
            }
            value.append(charValue);
        }
        return value.toString();
    }

    public String getXslString(String key) {
        String rawValue = this.getString(key);
        return this.getEncodedString(rawValue);
    }

    public String getString(String key) {
        try {
            return this.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
    }

    public String getString(String key, Object ... params) {
        return MessageUtil.getString(this.getBundle(), key, params);
    }

    public String getErrorString(String key) {
        return MessageUtil.formatErrorMessage(key, this.getString(key));
    }

    public String getErrorString(String key, Object ... params) {
        return MessageUtil.getErrorString(this.getBundle(), key, params);
    }
}

