/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.client;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.util.messages.Messages;

public class PublisherUtil {
    protected static final Log logger = LogFactory.getLog(PublisherUtil.class);
    public static final int FILE_EXISTS = 1;
    public static final int FILE_ADD_FAILED = 2;
    public static final int FILE_ADD_SUCCESSFUL = 3;
    public static final int FILE_ADD_INVALID_PUBLISH_PASSWORD = 4;
    public static final int FILE_ADD_INVALID_USER_CREDENTIALS = 5;

    public static int publish(String publishURL, String publishPath, File[] publishFiles, String publishPassword, String serverUserid, String serverPassword, boolean overwrite) {
        return PublisherUtil.publish(publishURL, publishPath, publishFiles, publishPassword, serverUserid, serverPassword, overwrite, true);
    }

    public static int publish(String publishURL, String publishPath, File[] publishFiles, String publishPassword, String serverUserid, String serverPassword, boolean overwrite, boolean mkdirs) {
        int status = -1;
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire.header", "warn");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "warn");
        String fullURL = null;
        try {
            fullURL = publishURL + "?publishPath=" + URLEncoder.encode(publishPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            fullURL = publishURL + "?publishPath=" + publishPath;
        }
        if (publishPassword == null) {
            throw new IllegalArgumentException(Messages.getInstance().getErrorString("PUBLISHERUTIL.ERROR_0001_PUBLISH_PASSWORD_REQUIRED"));
        }
        fullURL = fullURL + "&publishKey=" + PublisherUtil.getPasswordKey(publishPassword);
        fullURL = fullURL + "&overwrite=" + overwrite;
        fullURL = fullURL + "&mkdirs=" + mkdirs;
        PostMethod filePost = new PostMethod(fullURL);
        Part[] parts = new Part[publishFiles.length];
        for (int i = 0; i < publishFiles.length; ++i) {
            try {
                File file = publishFiles[i];
                FileInputStream in = new FileInputStream(file);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)in, (OutputStream)out);
                String reportNameEncoded = URLEncoder.encode(file.getName(), "UTF-8");
                ByteArrayPartSource source = new ByteArrayPartSource(reportNameEncoded, out.toByteArray());
                parts[i] = new FilePart(reportNameEncoded, (PartSource)source, "application/octet-stream", "UTF-8");
                continue;
            }
            catch (Exception e) {
                logger.error(null, (Throwable)e);
            }
        }
        filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
        HttpClient client = new HttpClient();
        try {
            if (serverUserid != null && serverUserid.length() > 0 && serverPassword != null && serverPassword.length() > 0) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(serverUserid, serverPassword);
                client.getState().setCredentials(AuthScope.ANY, (Credentials)creds);
                client.getParams().setAuthenticationPreemptive(true);
            }
            if ((status = client.executeMethod((HttpMethod)filePost)) == 200) {
                String postResult = filePost.getResponseBodyAsString();
                if (postResult != null) {
                    try {
                        return Integer.parseInt(postResult.trim());
                    }
                    catch (NumberFormatException e) {
                        logger.error(null, (Throwable)e);
                        return 5;
                    }
                }
            } else if (status == 401) {
                return 5;
            }
        }
        catch (HttpException e) {
            logger.error(null, (Throwable)e);
        }
        catch (IOException e) {
            logger.error(null, (Throwable)e);
        }
        return 2;
    }

    public static final String getPasswordKey(String passWord) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(passWord.getBytes());
            byte[] digest = md.digest("P3ntah0Publ1shPa55w0rd".getBytes());
            StringBuffer buf = new StringBuffer();
            for (byte element : digest) {
                String s = Integer.toHexString(0xFF & element);
                buf.append(s.length() == 1 ? "0" : "").append(s);
            }
            return buf.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error(null, (Throwable)ex);
            return null;
        }
    }
}

