/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util;

import java.net.NetworkInterface;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.util.messages.Messages;
import org.safehaus.uuid.EthernetAddress;
import org.safehaus.uuid.UUID;
import org.safehaus.uuid.UUIDGenerator;

public class UUIDUtil {
    private static final Log log;
    static boolean nativeInitialized;
    static UUIDGenerator ug;
    static EthernetAddress eAddr;

    public static String getUUIDAsString() {
        return UUIDUtil.getUUID().toString();
    }

    public static UUID getUUID() {
        UUID uuId = ug.generateTimeBasedUUID(eAddr);
        return uuId;
    }

    private static String getInterfaceInfo(NetworkInterface nif) throws Exception {
        return UUIDUtil.getInterfaceInfo(nif, ":");
    }

    private static String getInterfaceInfo(NetworkInterface nif, String sep) throws Exception {
        byte[] addrBytes = nif.getHardwareAddress();
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < addrBytes.length; ++i) {
            buff.append(String.format("%02X%s", addrBytes[i], i < addrBytes.length - 1 ? sep : ""));
        }
        return buff.toString();
    }

    public static String getActiveNetworkMacAddress() throws Exception {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface nif = interfaces.nextElement();
            if (!nif.isUp() || nif.isPointToPoint() || nif.isLoopback() || nif.isVirtual()) continue;
            return UUIDUtil.getInterfaceInfo(nif);
        }
        return null;
    }

    static {
        UUID olduuId;
        String macAddr;
        log = LogFactory.getLog(UUIDUtil.class);
        nativeInitialized = false;
        ug = UUIDGenerator.getInstance();
        if (eAddr == null && (macAddr = System.getProperty("MAC_ADDRESS")) != null) {
            macAddr = macAddr.replace('-', ':');
            eAddr = new EthernetAddress(macAddr);
        }
        if (eAddr == null) {
            try {
                NetworkInterface.class.getMethod("getHardwareAddress", new Class[0]);
                macAddr = UUIDUtil.getActiveNetworkMacAddress();
                if (macAddr != null) {
                    eAddr = new EthernetAddress(macAddr);
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (eAddr == null) {
            eAddr = ug.getDummyAddress();
        }
        if ((olduuId = ug.generateTimeBasedUUID(eAddr)) == null) {
            log.error((Object)Messages.getInstance().getErrorString("UUIDUtil.ERROR_0003_GENERATEFAILED"));
        }
    }
}

