/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.solution;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.pentaho.platform.api.engine.ActionSequenceException;
import org.pentaho.platform.api.engine.IActionCompleteListener;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.ICreateFeedbackParameterCallback;
import org.pentaho.platform.api.engine.IExecutionListener;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.api.repository.IRuntimeElement;
import org.pentaho.platform.api.repository.IRuntimeRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.engine.core.audit.AuditHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityParameterProvider;
import org.pentaho.platform.engine.services.ActionSequenceJCRHelper;
import org.pentaho.platform.engine.services.PentahoMessenger;
import org.pentaho.platform.engine.services.actionsequence.SequenceDefinition;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.engine.services.runtime.RuntimeContext;
import org.pentaho.platform.engine.services.runtime.SimpleRuntimeElement;
import org.pentaho.platform.engine.services.solution.FlashChartRequestMapper;
import org.pentaho.platform.util.JVMParameterProvider;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class SolutionEngine
extends PentahoMessenger
implements ISolutionEngine,
IPentahoInitializer {
    private static final long serialVersionUID = -8957434833691831700L;
    private final boolean debug = true;
    private Map<String, IParameterProvider> parameterProviders;
    private boolean persisted;
    private IActionCompleteListener doneListener;
    private IExecutionListener execListener;
    private IPentahoSession session;
    protected IRuntimeContext runtime = null;
    private int status = 3;
    private boolean forcePrompt = false;
    private static final String LOG_NAME = "SOLUTION-ENGINE";
    private static final String JVM_PARAMETER_PROVIDER = "jvm";
    private static final Log logger = LogFactory.getLog(SolutionEngine.class);
    private String parameterXsl = null;
    private ICreateFeedbackParameterCallback createFeedbackParameterCallback;

    @Override
    public Log getLogger() {
        return logger;
    }

    public void init(IPentahoSession pSession) {
        this.parameterProviders = new HashMap<String, IParameterProvider>();
        this.session = pSession;
        this.setParameterProvider(JVM_PARAMETER_PROVIDER, new JVMParameterProvider());
        this.setForcePrompt(false);
        SecurityParameterProvider provider = new SecurityParameterProvider(pSession);
        this.setParameterProvider("security", provider);
    }

    public void setParameterProvider(String name, IParameterProvider parameterProvider) {
        this.parameterProviders.put(name, parameterProvider);
    }

    protected Map getParameterProviders() {
        return this.parameterProviders;
    }

    public void setlistener(IActionCompleteListener doneListener) {
        this.doneListener = doneListener;
    }

    public void setlistener(IExecutionListener execListener) {
        this.execListener = execListener;
    }

    public void setSession(IPentahoSession session) {
        this.session = session;
    }

    protected boolean checkParameters(String sequencePath, String processId) {
        if (processId == null) {
            this.error(Messages.getInstance().getErrorString("SolutionEngine.ERROR_0001_PROCESS_NOT_SPECIFIED"));
            return false;
        }
        if (sequencePath == null) {
            this.error(Messages.getInstance().getErrorString("SolutionEngine.ERROR_0003_PATH_NOT_SPECIFIED"));
            return false;
        }
        return true;
    }

    public int getStatus() {
        return this.status;
    }

    public IRuntimeContext getExecutionContext() {
        return this.runtime;
    }

    protected IPentahoSession getSession() {
        return this.session;
    }

    protected IRuntimeContext getRuntime() {
        return this.runtime;
    }

    protected void setRuntime(IRuntimeContext runtime) {
        this.runtime = runtime;
    }

    protected void auditStart(String actionPath, String instanceId) {
        this.debug(Messages.getInstance().getString("SolutionEngine.DEBUG_STARTING_EXECUTION", actionPath));
        this.genLogIdFromInfo(instanceId, LOG_NAME, actionPath);
    }

    public IRuntimeContext execute(String actionPath, String processId, boolean async, boolean instanceEnds, String instanceId, boolean isPersisted, Map parameterProviderMap, IOutputHandler outputHandler, IActionCompleteListener pListener, IPentahoUrlFactory urlFactory, List messages) {
        this.applyParameterMappers(parameterProviderMap);
        return this.execute(actionPath, processId, async, instanceEnds, instanceId, isPersisted, parameterProviderMap, outputHandler, pListener, urlFactory, messages, null);
    }

    public IRuntimeContext execute(String actionSequenceXML, String sequencePath, String processId, boolean async, boolean instanceEnds, String instanceId, boolean isPersisted, Map parameterProviderMap, IOutputHandler outputHandler, IActionCompleteListener pListener, IPentahoUrlFactory urlFactory, List messages) {
        this.applyParameterMappers(parameterProviderMap);
        return this.execute(sequencePath, processId, async, instanceEnds, instanceId, isPersisted, parameterProviderMap, outputHandler, pListener, urlFactory, messages, actionSequenceXML);
    }

    protected IRuntimeContext execute(String actionPath, String processId, boolean async, boolean instanceEnds, String instanceId, boolean isPersisted, Map parameterProviderMap, IOutputHandler outputHandler, IActionCompleteListener pListener, IPentahoUrlFactory urlFactory, List messages, String actionSequenceXML) {
        SimpleRuntimeElement runtimeData;
        this.persisted = isPersisted;
        this.setlistener(pListener);
        this.setSession(this.session);
        this.setMessages(messages);
        this.auditStart(actionPath, instanceId);
        if (!this.checkParameters(actionPath, processId)) {
            return null;
        }
        this.session.setProcessId(processId);
        this.session.setActionName(actionPath);
        this.debug(Messages.getInstance().getString("SolutionEngine.DEBUG_GETTING_RUNTIME_CONTEXT"));
        boolean newInstance = instanceId == null;
        IRuntimeRepository runtimeRepository = null;
        if (PentahoSystem.getObjectFactory().objectDefined(IRuntimeRepository.class.getSimpleName())) {
            runtimeRepository = PentahoSystem.get(IRuntimeRepository.class, this.session);
        }
        if (runtimeRepository == null) {
            String id = UUIDUtil.getUUIDAsString();
            runtimeData = new SimpleRuntimeElement(id, this.session.getId(), "session");
        } else {
            runtimeRepository.setLoggingLevel(this.loggingLevel);
            if (newInstance) {
                try {
                    runtimeData = runtimeRepository.newRuntimeElement(this.session.getId(), "session", !this.persisted);
                }
                catch (Throwable t) {
                    this.error(Messages.getInstance().getErrorString("SolutionEngine.ERROR_0008_INVALID_INSTANCE", instanceId), t);
                    this.status = 10;
                    return null;
                }
            }
            try {
                runtimeData = runtimeRepository.loadElementById(instanceId, null);
            }
            catch (Throwable t) {
                this.error(Messages.getInstance().getErrorString("SolutionEngine.ERROR_0008_INVALID_INSTANCE", instanceId), t);
                this.status = 10;
                return null;
            }
        }
        if (runtimeData == null) {
            this.error(Messages.getInstance().getErrorString("SolutionEngine.ERROR_0008_INVALID_INSTANCE", instanceId));
            this.status = 10;
            return null;
        }
        this.createRuntime(runtimeData, actionPath, outputHandler, processId, urlFactory);
        this.runtime.setLoggingLevel(this.loggingLevel);
        instanceId = this.runtime.getInstanceId();
        this.genLogIdFromInfo(instanceId, LOG_NAME, actionPath);
        if (newInstance) {
            AuditHelper.audit(this.session.getId(), this.session.getName(), actionPath, this.getObjectName(), processId, "instance_start", instanceId, "", 0.0f, this);
        }
        return this.executeInternal(actionPath, processId, async, instanceEnds, parameterProviderMap, actionSequenceXML);
    }

    public IRuntimeContext execute(IRuntimeContext pRuntime, String actionPath, String processId, boolean async, boolean instanceEnds, Map parameterProviderMap, IOutputHandler outputHandler) {
        this.applyParameterMappers(parameterProviderMap);
        this.runtime = pRuntime;
        this.runtime.setOutputHandler(outputHandler);
        this.auditStart(actionPath, this.runtime.getInstanceId());
        if (!this.checkParameters(actionPath, processId)) {
            this.status = 7;
            return null;
        }
        return this.executeInternal(actionPath, processId, async, instanceEnds, parameterProviderMap);
    }

    protected IRuntimeContext executeInternal(String sequencePath, String processId, boolean async, boolean instanceEnds, Map parameterProviderMap) {
        return this.executeInternal(sequencePath, processId, async, instanceEnds, parameterProviderMap, null);
    }

    protected IRuntimeContext executeInternal(String sequencePath, String processId, boolean async, boolean instanceEnds, Map parameterProviderMap, String actionSequenceXML) {
        long start = System.currentTimeMillis();
        this.parameterProviders.putAll(parameterProviderMap);
        this.parameterProviders.put("global", PentahoSystem.getGlobalParameters());
        this.debug(Messages.getInstance().getString("SolutionEngine.DEBUG_LOADING_ACTION_DEFINITION"));
        IActionSequence actionSequence = null;
        actionSequence = actionSequenceXML != null ? this.createActionSequenceFromXml(actionSequenceXML) : this.createActionSequence(sequencePath);
        if (actionSequence == null) {
            this.error(Messages.getInstance().getErrorString("SolutionEngine.ERROR_0007_ACTION_EXECUTION_FAILED"));
            this.status = 7;
            long end = System.currentTimeMillis();
            AuditHelper.audit(this.session.getId(), this.session.getName(), sequencePath, this.getObjectName(), processId, "instance_failed", this.runtime.getInstanceId(), Messages.getInstance().getErrorString("SolutionEngine.ERROR_0007_ACTION_EXECUTION_FAILED"), (float)(end - start) / 1000.0f, this);
            return this.runtime;
        }
        this.runtime.setActionSequence(actionSequence);
        if (this.parameterXsl != null) {
            this.runtime.setParameterXsl(this.parameterXsl);
        }
        if (this.forcePrompt) {
            this.runtime.setPromptStatus(1);
        } else {
            this.runtime.setPromptStatus(0);
        }
        boolean validating = true;
        try {
            this.runtime.validateSequence(FilenameUtils.getName((String)sequencePath), this.execListener);
            validating = false;
            this.runtime.executeSequence(this.doneListener, this.execListener, async);
            if (instanceEnds) {
                long end = System.currentTimeMillis();
                AuditHelper.audit(this.session.getId(), this.session.getName(), sequencePath, this.getObjectName(), processId, "instance_end", this.runtime.getInstanceId(), "", (float)(end - start) / 1000.0f, this);
            }
            this.status = this.runtime.getStatus();
        }
        catch (ActionSequenceException ex) {
            String errorMsg = null;
            this.status = validating ? 0 : 7;
            this.error(ex);
            long end = System.currentTimeMillis();
            AuditHelper.audit(this.session.getId(), this.session.getName(), sequencePath, this.getObjectName(), processId, "instance_failed", this.runtime.getInstanceId(), errorMsg, (float)(end - start) / 1000.0f, this);
        }
        return this.runtime;
    }

    protected void createRuntime(IRuntimeElement runtimeData, String solutionName, IOutputHandler outputHandler, String processId, IPentahoUrlFactory urlFactory) {
        this.runtime = new RuntimeContext(runtimeData.getInstanceId(), this, solutionName, runtimeData, this.session, outputHandler, processId, urlFactory, this.parameterProviders, this.getMessages(), this.createFeedbackParameterCallback);
    }

    private IActionSequence createActionSequence(String actionPath) {
        return new ActionSequenceJCRHelper(this.session).getActionSequence(actionPath, this.loggingLevel, RepositoryFilePermission.READ);
    }

    private IActionSequence createActionSequenceFromXml(String actionDef) {
        try {
            Document actionSequenceDocument = XmlDom4JHelper.getDocFromString(actionDef, null);
            if (actionSequenceDocument == null) {
                return null;
            }
            IActionSequence actionSequence = SequenceDefinition.ActionSequenceFactory(actionSequenceDocument, "", this, PentahoSystem.getApplicationContext(), this.loggingLevel);
            return actionSequence;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setForcePrompt(boolean forcePrompt) {
        this.forcePrompt = forcePrompt;
    }

    public void setParameterXsl(String xsl) {
        this.parameterXsl = xsl;
    }

    protected void applyParameterMappers(Map parameterProviderMap) {
        IParameterProvider request = (IParameterProvider)parameterProviderMap.get("request");
        if (request != null) {
            FlashChartRequestMapper chartRequest = new FlashChartRequestMapper(request);
            parameterProviderMap.remove("request");
            parameterProviderMap.put("request", chartRequest);
        }
    }

    public void setCreateFeedbackParameterCallback(ICreateFeedbackParameterCallback callback) {
        this.createFeedbackParameterCallback = callback;
    }

    protected ICreateFeedbackParameterCallback getCreateFeedbackParameterCallback() {
        return this.createFeedbackParameterCallback;
    }
}

