/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services.connection.datasource.dbcp;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.PooledDatasourceHelper;

public abstract class BaseDatasourceService
implements IDBDatasourceService {
    ICacheManager cacheManager = this.getCacheManager();

    public void clearCache() {
        this.cacheManager.removeRegionCache("DataSource");
    }

    public void clearDataSource(String dsName) {
        this.cacheManager.removeFromRegionCache("DataSource", (Object)dsName);
    }

    public DataSource getDataSource(String dsName) throws DBDatasourceServiceException {
        DataSource dataSource = null;
        if (this.cacheManager != null) {
            Object foundDs;
            if (!this.cacheManager.cacheEnabled("DataSource")) {
                this.cacheManager.addCacheRegion("DataSource");
            }
            dataSource = (foundDs = this.cacheManager.getFromRegionCache("DataSource", (Object)dsName)) != null ? (DataSource)foundDs : this.retrieve(dsName);
        }
        return dataSource;
    }

    protected DataSource retrieve(String name) throws DBDatasourceServiceException {
        return null;
    }

    protected DataSource resolveDatabaseConnection(IDatabaseConnection databaseConnection) throws DBDatasourceServiceException {
        return null;
    }

    protected DataSource getJndiDataSource(String dsName) throws DBDatasourceServiceException {
        return PooledDatasourceHelper.getJndiDataSource(dsName);
    }

    public String getDSBoundName(String dsName) throws DBDatasourceServiceException {
        try {
            InitialContext ctx = new InitialContext();
            Object lkup = null;
            NamingException firstNe = null;
            String rtn = dsName;
            try {
                lkup = ctx.lookup(rtn);
                if (lkup != null) {
                    return rtn;
                }
            }
            catch (NamingException ignored) {
                firstNe = ignored;
            }
            try {
                rtn = "java:" + dsName;
                lkup = ctx.lookup(rtn);
                if (lkup != null) {
                    return rtn;
                }
            }
            catch (NamingException ignored) {
                // empty catch block
            }
            try {
                rtn = "java:comp/env/jdbc/" + dsName;
                lkup = ctx.lookup(rtn);
                if (lkup != null) {
                    return rtn;
                }
            }
            catch (NamingException ignored) {
                // empty catch block
            }
            try {
                rtn = "jdbc/" + dsName;
                lkup = ctx.lookup(rtn);
                if (lkup != null) {
                    return rtn;
                }
            }
            catch (NamingException ignored) {
                // empty catch block
            }
            if (firstNe != null) {
                throw new DBDatasourceServiceException((Throwable)firstNe);
            }
            throw new DBDatasourceServiceException(dsName);
        }
        catch (NamingException ne) {
            throw new DBDatasourceServiceException((Throwable)ne);
        }
    }

    public String getDSUnboundName(String dsName) {
        if (null == dsName) {
            return null;
        }
        String PREFIX_TOMCAT = "java:comp/env/jdbc/";
        String PREFIX_JBOSS = "java:";
        String PREFIX_OTHER = "jdbc/";
        if (dsName.startsWith("java:comp/env/jdbc/")) {
            return dsName.substring("java:comp/env/jdbc/".length());
        }
        if (dsName.startsWith("java:")) {
            return dsName.substring("java:".length());
        }
        if (dsName.startsWith("jdbc/")) {
            return dsName.substring("jdbc/".length());
        }
        int last = dsName.lastIndexOf("/");
        if (last < dsName.lastIndexOf(":")) {
            last = dsName.lastIndexOf(":");
        }
        if (last != -1) {
            return dsName.substring(last + 1);
        }
        return dsName;
    }

    public ICacheManager getCacheManager() {
        return PentahoSystem.getCacheManager(null);
    }

    public IDatasourceMgmtService getDatasourceMgmtService() {
        return PentahoSystem.get(IDatasourceMgmtService.class, PentahoSessionHolder.getSession());
    }
}

