/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.services;

import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.services.PentahoMessenger;
import org.pentaho.platform.engine.services.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class SoapHelper {
    public static String getSoapHeader() {
        return "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\n <SOAP-ENV:Body>\n";
    }

    public static String getSoapFooter() {
        return "</SOAP-ENV:Body>\n</SOAP-ENV:Envelope>";
    }

    public static String openSoapResponse() {
        return "<ExecuteActivityResponse xmlns:m=\"http://pentaho.org\">\n";
    }

    public static String closeSoapResponse() {
        return "</ExecuteActivityResponse>\n";
    }

    private static Element createActivityResponseElement() {
        DefaultElement element = new DefaultElement("ExecuteActivityResponse");
        element.addAttribute("xmlns:m", "http://pentaho.org");
        return element;
    }

    private static Element createSoapElement(String name, Object value) {
        if (value instanceof String) {
            return SoapHelper.createSoapElement(name, (String)value);
        }
        if (value instanceof List) {
            return SoapHelper.createSoapElement(name, (List)value);
        }
        if (value instanceof IPentahoResultSet) {
            return SoapHelper.createSoapElement(name, (IPentahoResultSet)value);
        }
        if (value instanceof IContentItem) {
            return SoapHelper.createSoapElement(name, ((IContentItem)value).getPath());
        }
        return null;
    }

    private static Element createSoapElement(String name, String value) {
        DefaultElement element = new DefaultElement(name);
        element.addCDATA(value);
        return element;
    }

    private static Element createSoapElement(String name, List value) {
        DefaultElement element = new DefaultElement(name);
        element.addCDATA(value.toString());
        return element;
    }

    private static Element createSoapElement(String name, IPentahoResultSet resultSet) {
        int column;
        boolean hasRowHeaders;
        DefaultElement resultSetElement = new DefaultElement(name);
        Object[][] columnHeaders = resultSet.getMetaData().getColumnHeaders();
        Object[][] rowHeaders = resultSet.getMetaData().getRowHeaders();
        boolean hasColumnHeaders = columnHeaders != null;
        boolean bl = hasRowHeaders = rowHeaders != null;
        if (hasColumnHeaders) {
            for (Object[] element : columnHeaders) {
                Element columnHeaderRowElement = resultSetElement.addElement("COLUMN-HDR-ROW");
                for (column = 0; column < element.length; ++column) {
                    columnHeaderRowElement.addElement("COLUMN-HDR-ITEM").addCDATA(element[column].toString());
                }
            }
        }
        if (hasRowHeaders) {
            for (Object[] element : rowHeaders) {
                Element rowHeaderRowElement = resultSetElement.addElement("ROW-HDR-ROW");
                for (column = 0; column < element.length; ++column) {
                    rowHeaderRowElement.addElement("ROW-HDR-ITEM").addCDATA(element[column].toString());
                }
            }
        }
        Object[] dataRow = resultSet.next();
        while (dataRow != null) {
            Element dataRowElement = resultSetElement.addElement("DATA-ROW");
            for (Object element : dataRow) {
                dataRowElement.addElement("DATA-ITEM").addCDATA(element.toString());
            }
            dataRow = resultSet.next();
        }
        return resultSetElement;
    }

    private static Element createSoapEnvelope() {
        DefaultElement envelope = new DefaultElement("SOAP-ENV:Envelope");
        envelope.addAttribute("xmlns:SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        envelope.addAttribute("SOAP-ENV:encodingStyle", "http://schemas.xmlsoap.org/soap/encoding/");
        return envelope;
    }

    private static Element createSoapBody() {
        return new DefaultElement("SOAP-ENV:Body");
    }

    public static Document createSoapDocument() {
        Document document = DocumentHelper.createDocument();
        Element envelope = SoapHelper.createSoapEnvelope();
        document.setRootElement(envelope);
        envelope.add(SoapHelper.createSoapBody());
        return document;
    }

    public static Document createSoapResponseDocument(Document[] documents) {
        return SoapHelper.createSoapResponseDocument(documents, "content");
    }

    public static Document createSoapResponseDocument(Document responseXml) {
        return SoapHelper.createSoapResponseDocument(responseXml, "content");
    }

    private static Element createSoapFaultElement(List messages) {
        DefaultElement faultElement = new DefaultElement("SOAP-ENV:Fault");
        String message = null;
        String errorStart = PentahoMessenger.getUserString("ERROR");
        int pos = errorStart.indexOf(123);
        if (pos != -1) {
            errorStart = errorStart.substring(0, pos);
        }
        for (String msg : messages) {
            if (msg.indexOf(errorStart) != 0) continue;
            message = msg;
        }
        if (message == null) {
            message = Messages.getInstance().getErrorString("SoapHelper.ERROR_0001_UNKNOWN_ERROR");
        }
        boolean senderFault = message.indexOf("SolutionEngine.ERROR_0002") != -1 || message.indexOf("SolutionEngine.ERROR_0003") != -1 || message.indexOf("SolutionEngine.ERROR_0004") != -1 || message.indexOf("SolutionEngine.ERROR_0005") != -1;
        faultElement.addElement("SOAP-ENV:Fault").addElement("SOAP-ENV:Subcode").addElement("SOAP-ENV:Value").addCDATA(message);
        if (senderFault) {
            faultElement.addElement("SOAP-ENV:faultactor").setText("SOAP-ENV:Client");
        } else {
            faultElement.addElement("SOAP-ENV:faultactor").setText("SOAP-ENV:Server");
        }
        Element faultTextElement = faultElement.addElement("SOAP-ENV:faultstring").addElement("SOAP-ENV:Text");
        faultTextElement.addAttribute("xml:lang", LocaleHelper.getDefaultLocale().toString());
        faultTextElement.addCDATA(message);
        Element detailElement = faultElement.addElement("SOAP-ENV:Detail");
        Iterator messageIterator = messages.iterator();
        while (messageIterator.hasNext()) {
            detailElement.addElement("message").addAttribute("name", "trace").addCDATA((String)messageIterator.next());
        }
        return faultElement;
    }

    public static Document createSoapResponseDocument(IRuntimeContext context, IOutputHandler outputHandler, OutputStream contentStream, List messages) {
        Document document = SoapHelper.createSoapDocument();
        if (context == null || context.getStatus() != 6) {
            document.getRootElement().element("SOAP-ENV:Body").add(SoapHelper.createSoapFaultElement(messages));
        } else {
            Element activityResponse = SoapHelper.createActivityResponseElement();
            document.getRootElement().element("SOAP-ENV:Body").add(activityResponse);
            IContentItem contentItem = outputHandler.getFeedbackContentItem();
            Set outputNames = context.getOutputNames();
            for (String outputName : outputNames) {
                contentItem = outputHandler.getOutputContentItem("response", "content", context.getInstanceId(), "text/xml");
                if (outputNames.size() == 1 && contentItem != null) {
                    String mimeType = contentItem.getMimeType();
                    if (mimeType != null && mimeType.startsWith("text/")) {
                        if (mimeType.equals("text/xml")) {
                            activityResponse.addElement(outputName).setText(contentStream.toString());
                            continue;
                        }
                        if (!mimeType.startsWith("text/")) continue;
                        activityResponse.addElement(outputName).addCDATA(contentStream.toString());
                        continue;
                    }
                    Object value = context.getOutputParameter(outputName).getValue();
                    if (value == null) {
                        value = "";
                    }
                    activityResponse.add(SoapHelper.createSoapElement(outputName, value));
                    continue;
                }
                Object value = context.getOutputParameter(outputName).getValue();
                if (value == null) {
                    value = "";
                }
                activityResponse.add(SoapHelper.createSoapElement(outputName, value));
            }
        }
        return document;
    }

    public static Document createSoapResponseDocument(Document[] documents, String contentNodeName) {
        Document document = SoapHelper.createSoapDocument();
        Element activityResponse = SoapHelper.createActivityResponseElement();
        document.getRootElement().element("SOAP-ENV:Body").add(activityResponse);
        Element contentElement = activityResponse.addElement(contentNodeName);
        for (Document contentDocument : documents) {
            if (contentDocument == null || contentDocument.getRootElement() == null) continue;
            contentElement.add(contentDocument.getRootElement());
        }
        return document;
    }

    public static Document createSoapResponseDocument(Document contentDocument, String contentNodeName) {
        Document document = SoapHelper.createSoapDocument();
        Element activityResponse = SoapHelper.createActivityResponseElement();
        document.getRootElement().element("SOAP-ENV:Body").add(activityResponse);
        Element contentElement = activityResponse.addElement(contentNodeName);
        if (contentDocument != null && contentDocument.getRootElement() != null) {
            contentElement.add(contentDocument.getRootElement());
        }
        return document;
    }

    public static Document createSoapResponseDocument(String responseString) {
        return SoapHelper.createSoapResponseDocument(responseString, "content");
    }

    public static Document createSoapResponseDocument(String responseString, String contentNodeName) {
        Document document = SoapHelper.createSoapDocument();
        Element activityResponse = document.getRootElement().element("SOAP-ENV:Body").addElement("ExecuteActivityResponse").addAttribute("xmlns:m", "\"http://pentaho.org\"");
        Element contentElement = activityResponse.addElement(contentNodeName);
        contentElement.setText(responseString);
        return document;
    }
}

