/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.engine.security;

import java.util.Iterator;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.vote.AccessDecisionVoter;

public class PentahoSubstringRoleVoter
implements AccessDecisionVoter {
    private String processConfigAttributePrefix;

    public PentahoSubstringRoleVoter(String processConfigAttributePrefix) {
        this.processConfigAttributePrefix = processConfigAttributePrefix;
    }

    public boolean supports(ConfigAttribute attribute) {
        return attribute.getAttribute() != null && attribute.getAttribute().startsWith(this.processConfigAttributePrefix);
    }

    public boolean supports(Class clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        int result = 0;
        Iterator iter = config.getConfigAttributes().iterator();
        GrantedAuthority[] authorities = this.extractAuthorities(authentication);
        while (iter.hasNext()) {
            ConfigAttribute attribute = (ConfigAttribute)iter.next();
            if (!this.supports(attribute)) continue;
            result = -1;
            for (int i = 0; i < authorities.length; ++i) {
                if (!attribute.getAttribute().substring(this.processConfigAttributePrefix.length()).equals(authorities[i].getAuthority())) continue;
                return 1;
            }
        }
        return result;
    }

    private GrantedAuthority[] extractAuthorities(Authentication authentication) {
        return authentication.getAuthorities();
    }
}

