/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.querybuilder;

import com.sun.image.codec.jpeg.ImageFormatException;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import nickyb.sqleonardo.common.util.I18n;
import nickyb.sqleonardo.environment.Preferences;
import nickyb.sqleonardo.querybuilder.DiagramAbstractEntity;
import nickyb.sqleonardo.querybuilder.QueryBuilder;

public abstract class QueryActions {
    public static final String COPY_SYNTAX = "copy-syntax";
    public static final String FIELDS_DRAGGABLE = "fields-draggable";
    public static final String ENTITIES_ARRANGE = "entities-arrange";
    public static final String ENTITIES_PACK = "entities-pack";
    public static final String ENTITIES_REMOVE = "entities-remove";
    public static final String DIAGRAM_SAVE_AS_IMAGE = "diagram-save-as-image";

    static void init(QueryBuilder builder) {
        builder.getActionMap().put(COPY_SYNTAX, new ActionCopySyntax(builder));
        builder.getActionMap().put(FIELDS_DRAGGABLE, new ActionDragAndDrop(builder));
        builder.getActionMap().put(ENTITIES_ARRANGE, new ActionArrangeEntities(builder));
        builder.getActionMap().put(ENTITIES_PACK, new ActionPackEntities(builder));
        builder.getActionMap().put(ENTITIES_REMOVE, new ActionRemoveEntities(builder));
        builder.getActionMap().put(DIAGRAM_SAVE_AS_IMAGE, new ActionSaveDiagramAsImage(builder));
    }

    static class ActionSaveDiagramAsImage
    extends AbstractQueryAction {
        ActionSaveDiagramAsImage(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", I18n.getString("querybuilder.action.saveDiagramAsImage", "save as image"));
        }

        public void actionPerformed(ActionEvent e) {
            String currentDirectory = Preferences.getString("lastDirectory", System.getProperty("user.home"));
            JFileChooser fc = new JFileChooser(currentDirectory);
            fc.setFileSelectionMode(0);
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".jpeg");
                }

                public String getDescription() {
                    return "JPEG (*.jpeg)";
                }
            });
            if (fc.showSaveDialog(this.builder) == 0) {
                Preferences.set("lastDirectory", fc.getCurrentDirectory().toString());
                String filename = fc.getSelectedFile().toString();
                if (!filename.endsWith(".jpeg")) {
                    filename = filename + ".jpeg";
                }
                try {
                    this.builder.diagram.saveAsImage(filename);
                }
                catch (ImageFormatException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    static class ActionRemoveEntities
    extends AbstractQueryAction {
        ActionRemoveEntities(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", I18n.getString("querybuilder.action.removeEntities", "remove entities"));
        }

        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(this.builder, I18n.getString("querybuilder.message.continue", "do you want to continue?"), I18n.getString("querybuilder.action.removeEntities", "remove entities"), 0, 3) == 1) {
                return;
            }
            DiagramAbstractEntity[] entities = this.builder.diagram.getEntities();
            for (int i = 0; i < entities.length; ++i) {
                entities[i].doDefaultCloseAction();
            }
        }
    }

    static class ActionPackEntities
    extends AbstractQueryAction {
        ActionPackEntities(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", I18n.getString("querybuilder.action.packEntities", "pack entities"));
        }

        public void actionPerformed(ActionEvent e) {
            DiagramAbstractEntity[] entities = this.builder.diagram.getEntities();
            for (int i = 0; i < entities.length; ++i) {
                entities[i].setPack(true);
            }
        }
    }

    static class ActionArrangeEntities
    extends AbstractQueryAction {
        ActionArrangeEntities(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", I18n.getString("querybuilder.action.arrangeEntities", "arrange entities"));
        }

        public void actionPerformed(ActionEvent e) {
            this.builder.diagram.doArrangeEntities();
        }
    }

    static class ActionCopySyntax
    extends AbstractQueryAction
    implements ClipboardOwner {
        ActionCopySyntax(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", I18n.getString("querybuilder.action.copySyntax", "copy syntax"));
        }

        public void actionPerformed(ActionEvent ae) {
            String value = this.builder.getQueryModel().toString(true);
            Clipboard cb = this.builder.getToolkit().getSystemClipboard();
            StringSelection contents = new StringSelection(value);
            cb.setContents(contents, this);
        }

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    static class ActionDragAndDrop
    extends AbstractQueryAction {
        ActionDragAndDrop(QueryBuilder builder) {
            super(builder);
            this.putValue("Name", I18n.getString("querybuilder.action.join", "join by Drag&Drop"));
        }

        public void actionPerformed(ActionEvent ae) {
            this.builder.setDragAndDropEnabled(!this.builder.isDragAndDropEnabled());
        }
    }

    static abstract class AbstractQueryAction
    extends AbstractAction {
        QueryBuilder builder;

        AbstractQueryAction(QueryBuilder builder) {
            this.builder = builder;
        }
    }
}

