/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import nickyb.sqleonardo.common.gui.CommandButton;
import nickyb.sqleonardo.common.gui.TextView;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.editor.SQLStyledDocument;

public class DialogFindReplace
extends JDialog
implements ActionListener {
    private DefaultHighlighter.DefaultHighlightPainter highlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
    private CommandButton btnFind;
    private CommandButton btnFindAll;
    private CommandButton btnReplace;
    private CommandButton btnReplaceAll;
    private JCheckBox chxCase;
    private JTextField txtFind;
    private JTextField txtReplace;
    private TextView view;

    public DialogFindReplace(TextView view) {
        super((Frame)Application.window, "find/replace");
        this.view = view;
        this.init();
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(Application.window);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                DialogFindReplace.this.view.getHighlighter().removeAllHighlights();
            }
        });
    }

    private void init() {
        this.getContentPane().setLayout(new GridBagLayout());
        JLabel lbl = new JLabel("find:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.insets = new Insets(8, 5, 3, 0);
        this.getContentPane().add((Component)lbl, gbc);
        this.txtFind = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(8, 2, 3, 5);
        this.add((Component)this.txtFind, gbc);
        lbl = new JLabel("replace:");
        gbc = new GridBagConstraints();
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 5, 7, 0);
        this.add((Component)lbl, gbc);
        this.txtReplace = new JTextField();
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 2, 7, 5);
        this.add((Component)this.txtReplace, gbc);
        this.chxCase = new JCheckBox("case sensitive");
        this.chxCase.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chxCase.setMargin(new Insets(0, 0, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(8, 5, 10, 0);
        this.add((Component)this.chxCase, gbc);
        JPanel pnlB = new JPanel();
        this.btnFind = new CommandButton("find", this);
        pnlB.add(this.btnFind);
        this.btnFindAll = new CommandButton("find all", this);
        pnlB.add(this.btnFindAll);
        this.btnReplace = new CommandButton("replace", this);
        pnlB.add(this.btnReplace);
        this.btnReplaceAll = new CommandButton("replace all", this);
        pnlB.add(this.btnReplaceAll);
        this.btnReplace.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        this.getContentPane().add((Component)pnlB, gbc);
    }

    private int find(int from) {
        int offset = -1;
        try {
            SQLStyledDocument document = (SQLStyledDocument)this.view.getDocument();
            String text = document.getText(document.getStartPosition().getOffset(), document.getEndPosition().getOffset());
            String find = this.txtFind.getText();
            if (text.length() == 0 || find.length() == 0) {
                return offset;
            }
            if (!this.chxCase.isSelected()) {
                find = find.toLowerCase();
                text = text.toLowerCase();
            }
            if ((offset = text.indexOf(find, from)) != -1) {
                int len = offset + this.txtFind.getText().length();
                Highlighter highlighter = this.view.getHighlighter();
                highlighter.addHighlight(offset, len, this.highlightPainter);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return offset;
    }

    private boolean findNext() {
        Highlighter highlighter = this.view.getHighlighter();
        int from = highlighter.getHighlights().length == 1 ? highlighter.getHighlights()[0].getEndOffset() : 0;
        highlighter.removeAllHighlights();
        this.find(from);
        return highlighter.getHighlights().length > 0;
    }

    private boolean findAll() {
        Highlighter highlighter = this.view.getHighlighter();
        highlighter.removeAllHighlights();
        int from = 0;
        while ((from = this.find(from)) != -1) {
            ++from;
        }
        return highlighter.getHighlights().length > 0;
    }

    private boolean replace() {
        try {
            Highlighter highlighter = this.view.getHighlighter();
            if (highlighter.getHighlights().length < 1) {
                return false;
            }
            Highlighter.Highlight tag = highlighter.getHighlights()[0];
            highlighter.removeHighlight(tag);
            SQLStyledDocument document = (SQLStyledDocument)this.view.getDocument();
            document.remove(tag.getStartOffset(), tag.getEndOffset() - tag.getStartOffset());
            if (this.txtReplace.getText().length() > 0) {
                document.insertString(tag.getStartOffset(), this.txtReplace.getText());
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return this.findNext();
    }

    private boolean replaceNext() {
        Highlighter highlighter = this.view.getHighlighter();
        if (highlighter.getHighlights().length < 1) {
            this.find(0);
        }
        return this.replace();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.btnFind) {
            this.btnReplace.setEnabled(this.findNext());
        } else if (ae.getSource() == this.btnFindAll) {
            this.btnReplace.setEnabled(this.findAll());
        } else if (ae.getSource() == this.btnReplace) {
            this.btnReplace.setEnabled(this.replace());
        } else if (ae.getSource() == this.btnReplaceAll) {
            this.btnReplace.setEnabled(false);
            while (this.replaceNext()) {
            }
        }
    }
}

