/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.util.ArrayList;
import java.util.List;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.PreparedStatementCallbackInterface;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.ResultSetCallbackInterface;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.StatementCallbackInterface;
import org.apache.derby.client.am.Types;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.FdocaConstants;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetCursor;
import org.apache.derby.client.net.NetPackageReply;
import org.apache.derby.client.net.NetResultSet;
import org.apache.derby.client.net.NetSqlca;
import org.apache.derby.client.net.NetSqldta;
import org.apache.derby.client.net.NetStatement;
import org.apache.derby.client.net.StatementReplyInterface;
import org.apache.derby.jdbc.ClientDriver;
import org.apache.derby.shared.common.i18n.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetStatementReply
extends NetPackageReply
implements StatementReplyInterface {
    NetStatementReply(NetAgent netAgent, int n) {
        super(netAgent, n);
    }

    @Override
    public void readPrepareDescribeOutput(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parsePRPSQLSTTreply(statementCallbackInterface);
        this.endOfSameIdChainData();
    }

    @Override
    public void readExecuteImmediate(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseEXCSQLIMMreply(statementCallbackInterface);
        this.endOfSameIdChainData();
    }

    @Override
    public void readOpenQuery(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseOPNQRYreply(statementCallbackInterface);
        this.endOfSameIdChainData();
    }

    @Override
    public void readExecute(PreparedStatementCallbackInterface preparedStatementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseEXCSQLSTTreply(preparedStatementCallbackInterface);
        this.endOfSameIdChainData();
    }

    @Override
    public void readPrepare(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parsePRPSQLSTTreply(statementCallbackInterface);
        this.endOfSameIdChainData();
    }

    @Override
    public void readDescribeInput(PreparedStatementCallbackInterface preparedStatementCallbackInterface) throws DisconnectException {
        if (this.longBufferForDecryption_ != null) {
            this.buffer_ = this.longBufferForDecryption_;
            this.pos_ = this.longPosForDecryption_;
            this.count_ = this.longCountForDecryption_;
            if (this.longBufferForDecryption_ != null && this.count_ > this.longBufferForDecryption_.length) {
                this.count_ = this.longBufferForDecryption_.length;
            }
            this.dssLength_ = 0;
            this.longBufferForDecryption_ = null;
        }
        this.startSameIdChainParse();
        this.parseDSCSQLSTTreply(preparedStatementCallbackInterface, 1);
        this.endOfSameIdChainData();
    }

    @Override
    public void readDescribeOutput(PreparedStatementCallbackInterface preparedStatementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseDSCSQLSTTreply(preparedStatementCallbackInterface, 0);
        this.endOfSameIdChainData();
    }

    @Override
    public void readExecuteCall(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseEXCSQLSTTreply(statementCallbackInterface);
        this.endOfSameIdChainData();
    }

    private void parsePRPSQLSTTreply(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n = this.parseTypdefsOrMgrlvlovrs();
        if (n == 9233) {
            ColumnMetaData columnMetaData = null;
            NetSqlca netSqlca = null;
            boolean bl = this.peekForNullSqlcagrp();
            if (bl && this.peekNumOfColumns() == 0) {
                netSqlca = this.parseSQLDARD(columnMetaData, true);
            } else {
                columnMetaData = ClientDriver.getFactory().newColumnMetaData(this.netAgent_.logWriter_);
                netSqlca = this.parseSQLDARD(columnMetaData, false);
            }
            statementCallbackInterface.completePrepareDescribeOutput(columnMetaData, netSqlca);
        } else if (n == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            statementCallbackInterface.completePrepare(netSqlca);
        } else {
            this.parsePrepareError(statementCallbackInterface);
        }
    }

    private void parseDSCSQLSTTreply(PreparedStatementCallbackInterface preparedStatementCallbackInterface, int n) throws DisconnectException {
        int n2 = this.parseTypdefsOrMgrlvlovrs();
        if (n2 == 9233) {
            ColumnMetaData columnMetaData = null;
            if (columnMetaData == null) {
                columnMetaData = ClientDriver.getFactory().newColumnMetaData(this.netAgent_.logWriter_);
            }
            NetSqlca netSqlca = this.parseSQLDARD(columnMetaData, false);
            if (columnMetaData.columns_ == 0) {
                columnMetaData = null;
            }
            if (n == 0) {
                preparedStatementCallbackInterface.completeDescribeOutput(columnMetaData, netSqlca);
            } else {
                preparedStatementCallbackInterface.completeDescribeInput(columnMetaData, netSqlca);
            }
        } else if (n2 == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            if (n == 0) {
                preparedStatementCallbackInterface.completeDescribeOutput(null, netSqlca);
            } else {
                preparedStatementCallbackInterface.completeDescribeInput(null, netSqlca);
            }
        } else {
            this.parseDescribeError(preparedStatementCallbackInterface);
        }
    }

    private void parseEXCSQLIMMreply(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n = this.parseTypdefsOrMgrlvlovrs();
        if (n == 8728) {
            this.parseRDBUPDRM();
            n = this.parseTypdefsOrMgrlvlovrs();
        }
        switch (n) {
            case 8716: {
                this.parseENDUOWRM(statementCallbackInterface.getConnectionCallbackInterface());
                this.parseTypdefsOrMgrlvlovrs();
            }
            case 9224: {
                NetSqlca netSqlca = this.parseSQLCARD(null);
                statementCallbackInterface.completeExecuteImmediate(netSqlca);
                break;
            }
            default: {
                this.parseExecuteImmediateError(statementCallbackInterface);
            }
        }
        n = this.peekCodePoint();
        if (n == 49152) {
            this.parsePBSD();
        }
    }

    private void parseOPNQRYreply(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n = this.peekCodePoint();
        if (n == 8709) {
            this.parseOpenQuery(statementCallbackInterface);
            n = this.peekCodePoint();
            if (n == 8728) {
                this.parseRDBUPDRM();
                n = this.peekCodePoint();
            }
        } else if (n == 8728) {
            this.parseRDBUPDRM();
            this.parseOpenQuery(statementCallbackInterface);
            n = this.peekCodePoint();
        } else if (n == 8722) {
            this.parseOpenQueryFailure(statementCallbackInterface);
            n = this.peekCodePoint();
        } else {
            this.parseOpenQueryError(statementCallbackInterface);
            n = this.peekCodePoint();
        }
        if (n == 49152) {
            this.parsePBSD();
        }
    }

    private void parseEXCSQLSETreply(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n = this.parseTypdefsOrMgrlvlovrs();
        if (n == 8728) {
            this.parseRDBUPDRM();
            this.parseTypdefsOrMgrlvlovrs();
        } else if (n == 8716) {
            this.parseENDUOWRM(statementCallbackInterface.getConnectionCallbackInterface());
            this.parseTypdefsOrMgrlvlovrs();
        }
        if (n == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            statementCallbackInterface.completeExecuteSetStatement(netSqlca);
        } else {
            this.parseExecuteSetStatementError(statementCallbackInterface);
        }
    }

    private void parseEXCSQLSTTreply(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n = this.peekCodePoint();
        if (n == 8728) {
            this.parseRDBUPDRM();
            n = this.peekCodePoint();
        }
        if (n == 8716) {
            this.parseENDUOWRM(statementCallbackInterface.getConnectionCallbackInterface());
            n = this.peekCodePoint();
        }
        if (n == 8729) {
            this.parseResultSetProcedure(statementCallbackInterface);
            n = this.peekCodePoint();
            if (n == 8728) {
                this.parseRDBUPDRM();
                n = this.peekCodePoint();
            }
            if (n == 49152) {
                this.parsePBSD();
            }
            return;
        }
        n = this.parseTypdefsOrMgrlvlovrs();
        if (n == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            statementCallbackInterface.completeExecute(netSqlca);
            n = this.peekCodePoint();
        } else if (n == 9235) {
            NetSqldta netSqldta = null;
            boolean bl = false;
            if (((Statement)statementCallbackInterface).cachedSingletonRowData_ == null) {
                netSqldta = new NetSqldta(this.netAgent_);
            } else {
                netSqldta = (NetSqldta)((Statement)statementCallbackInterface).cachedSingletonRowData_;
                netSqldta.resetDataBuffer();
                netSqldta.extdtaData_.clear();
                bl = true;
            }
            NetSqlca netSqlca = this.parseSQLDTARD(netSqldta);
            n = this.peekCodePoint();
            while (n == 5228) {
                this.copyEXTDTA(netSqldta);
                n = this.peekCodePoint();
            }
            statementCallbackInterface.completeExecuteCall(netSqlca, netSqldta);
        } else {
            this.parseExecuteError(statementCallbackInterface);
        }
        if (n == 49152) {
            this.parsePBSD();
            n = this.peekCodePoint();
        }
    }

    protected void parseResultSetProcedure(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        List<Section> list = this.parseRSLSETRM();
        int n = this.parseTypdefsOrMgrlvlovrs();
        NetSqldta netSqldta = null;
        NetSqlca netSqlca = null;
        if (n == 9224) {
            netSqlca = this.parseSQLCARD(null);
        } else {
            netSqldta = new NetSqldta(this.netAgent_);
            netSqlca = this.parseSQLDTARD(netSqldta);
        }
        n = this.parseTypdefsOrMgrlvlovrs();
        int n2 = this.parseSQLRSLRD(list);
        ResultSet[] resultSetArray = new NetResultSet[n2];
        for (int i = 0; i < n2; ++i) {
            NetResultSet netResultSet = this.parseResultSetCursor(statementCallbackInterface, list.get(i));
            resultSetArray[i] = netResultSet;
        }
        n = this.peekCodePoint();
        while (n == 5228) {
            this.copyEXTDTA(netSqldta);
            n = this.peekCodePoint();
        }
        statementCallbackInterface.completeExecuteCall(netSqlca, netSqldta, resultSetArray);
    }

    protected NetResultSet parseResultSetCursor(StatementCallbackInterface statementCallbackInterface, Section section) throws DisconnectException {
        NetResultSet netResultSet = this.parseOPNQRYRM(statementCallbackInterface, false);
        int n = this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = null;
        if (n == 9224) {
            netSqlca = this.parseSQLCARD(null);
            n = this.parseTypdefsOrMgrlvlovrs();
        }
        ColumnMetaData columnMetaData = null;
        if (n == 9227) {
            columnMetaData = this.parseSQLCINRD();
            n = this.parseTypdefsOrMgrlvlovrs();
        }
        this.parseQRYDSC(netResultSet.netCursor_);
        n = this.peekCodePoint();
        statementCallbackInterface.completeExecuteCallOpenQuery(netSqlca, netResultSet, columnMetaData, section);
        while (n == 9243) {
            this.parseQRYDTA(netResultSet);
            n = this.peekCodePoint();
        }
        if (n == 8715) {
            this.parseEndQuery(netResultSet);
        }
        return netResultSet;
    }

    protected void parseOpenQuery(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        Object object;
        NetResultSet netResultSet = this.parseOPNQRYRM(statementCallbackInterface, true);
        NetSqlca netSqlca = null;
        int n = this.peekCodePoint();
        if (n != 9242) {
            n = this.parseTypdefsOrMgrlvlovrs();
            if (n == 9233) {
                object = ClientDriver.getFactory().newColumnMetaData(this.netAgent_.logWriter_);
                NetSqlca netSqlca2 = this.parseSQLDARD((ColumnMetaData)object, false);
                statementCallbackInterface.completePrepareDescribeOutput((ColumnMetaData)object, netSqlca2);
                n = this.parseTypdefsOrMgrlvlovrs();
            }
            if (n == 9224) {
                netSqlca = this.parseSQLCARD(null);
                n = this.parseTypdefsOrMgrlvlovrs();
            }
        }
        this.parseQRYDSC(netResultSet.netCursor_);
        n = this.peekCodePoint();
        while (n == 9243) {
            this.parseQRYDTA(netResultSet);
            n = this.peekCodePoint();
        }
        if (n == 9224) {
            object = this.parseSQLCARD(null);
            statementCallbackInterface.completeSqlca((Sqlca)object);
            n = this.peekCodePoint();
        }
        if (n == 8715) {
            this.parseEndQuery(netResultSet);
        }
        statementCallbackInterface.completeOpenQuery(netSqlca, netResultSet);
    }

    protected void parseEndQuery(ResultSetCallbackInterface resultSetCallbackInterface) throws DisconnectException {
        this.parseENDQRYRM(resultSetCallbackInterface);
        this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        resultSetCallbackInterface.earlyCloseComplete(netSqlca);
    }

    void parseOpenQueryFailure(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        this.parseOPNQFLRM(statementCallbackInterface);
        this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        statementCallbackInterface.completeOpenQuery(netSqlca, null);
    }

    void parsePrepareError(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(statementCallbackInterface);
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca netSqlca = this.parseSqlErrorCondition();
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    void parseExecuteImmediateError(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(statementCallbackInterface);
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca netSqlca = this.parseSqlErrorCondition();
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    void parseDescribeError(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(statementCallbackInterface);
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca netSqlca = this.parseSqlErrorCondition();
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    void parseOpenQueryError(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(statementCallbackInterface);
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8719: {
                this.parseQRYPOPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    void parseExecuteError(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(statementCallbackInterface);
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca netSqlca = this.parseSqlErrorCondition();
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    void parseExecuteSetStatementError(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        int n = this.peekCodePoint();
        switch (n) {
            case 8717: {
                NetSqlca netSqlca = this.parseAbnormalEndUow(statementCallbackInterface);
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8718: {
                this.parseDTAMCHRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            case 8723: {
                NetSqlca netSqlca = this.parseSqlErrorCondition();
                statementCallbackInterface.completeSqlca(netSqlca);
                break;
            }
            default: {
                this.parseCommonError(n);
            }
        }
    }

    protected NetResultSet parseOPNQRYRM(StatementCallbackInterface statementCallbackInterface, boolean bl) throws DisconnectException {
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        int n2 = 0;
        boolean bl3 = false;
        int n3 = 240;
        boolean bl4 = false;
        int n4 = 240;
        boolean bl5 = false;
        int n5 = 0;
        boolean bl6 = false;
        int n6 = 0;
        boolean bl7 = false;
        long l = 0L;
        boolean bl8 = false;
        int n7 = 240;
        boolean bl9 = false;
        this.parseLengthAndMatchCodePoint(8709);
        int n8 = this.getDdmLength();
        this.ensureBLayerDataInBuffer(n8);
        int n9 = this.peekCodePoint();
        int n10 = 0;
        while (n8 > 0) {
            boolean bl10 = false;
            if (n9 == 4425) {
                bl10 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                n10 = this.peekedLength_;
                n = this.parseFastSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_SESDMG);
                n8 = this.adjustDdmLength(n8, n10);
                n9 = this.peekCodePoint();
            }
            if (n9 == 8450) {
                bl10 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                n10 = this.peekedLength_;
                n2 = this.parseFastQRYPRCTYP();
                n8 = this.adjustDdmLength(n8, n10);
                n9 = this.peekCodePoint();
            }
            if (n9 == 8479) {
                bl10 = true;
                bl4 = this.checkAndGetReceivedFlag(bl4);
                n10 = this.peekedLength_;
                n3 = this.parseFastSQLCSRHLD();
                n8 = this.adjustDdmLength(n8, n10);
                n9 = this.peekCodePoint();
            }
            if (n9 == 8521) {
                bl10 = true;
                bl5 = this.checkAndGetReceivedFlag(bl5);
                n10 = this.peekedLength_;
                n4 = this.parseFastQRYATTSCR();
                n8 = this.adjustDdmLength(n8, n10);
                n9 = this.peekCodePoint();
            }
            if (n9 == 8535) {
                bl10 = true;
                bl6 = this.checkAndGetReceivedFlag(bl6);
                n10 = this.peekedLength_;
                n5 = this.parseFastQRYATTSNS();
                n8 = this.adjustDdmLength(n8, n10);
                n9 = this.peekCodePoint();
            }
            if (n9 == 8528) {
                bl10 = true;
                bl7 = this.checkAndGetReceivedFlag(bl7);
                n10 = this.peekedLength_;
                n6 = this.parseFastQRYATTUPD();
                n8 = this.adjustDdmLength(n8, n10);
                n9 = this.peekCodePoint();
            }
            if (n9 == 8539) {
                bl10 = true;
                bl8 = this.checkAndGetReceivedFlag(bl8);
                n10 = this.peekedLength_;
                l = this.parseFastQRYINSID();
                n8 = this.adjustDdmLength(n8, n10);
                n9 = this.peekCodePoint();
            }
            if (n9 == 8522) {
                bl10 = true;
                bl9 = this.checkAndGetReceivedFlag(bl9);
                n10 = this.peekedLength_;
                n7 = this.parseFastQRYATTSET();
                n8 = this.adjustDdmLength(n8, n10);
                n9 = this.peekCodePoint();
            }
            if (bl10) continue;
            this.doPrmnsprmSemantics(n9);
        }
        this.checkRequiredObjects(bl2, bl3, bl8);
        this.netAgent_.setSvrcod(n);
        Statement statement = (Statement)statementCallbackInterface;
        NetResultSet netResultSet = null;
        if (statement.cachedCursor_ != null) {
            statement.cachedCursor_.resetDataBuffer();
            ((NetCursor)statement.cachedCursor_).extdtaData_.clear();
            try {
                netResultSet = (NetResultSet)ClientDriver.getFactory().newNetResultSet(this.netAgent_, (NetStatement)statement.materialStatement_, statement.cachedCursor_, n2, n3, n4, n5, n7, l, this.calculateResultSetType(n4, n5, statement.resultSetType_), this.calculateResultSetConcurrency(n6, statement.resultSetConcurrency_), this.calculateResultSetHoldability(n3));
            }
            catch (SqlException sqlException) {
                throw new DisconnectException((Agent)this.netAgent_, sqlException);
            }
        }
        try {
            netResultSet = (NetResultSet)ClientDriver.getFactory().newNetResultSet(this.netAgent_, (NetStatement)statement.materialStatement_, new NetCursor(this.netAgent_, n2), n2, n3, n4, n5, n7, l, this.calculateResultSetType(n4, n5, statement.resultSetType_), this.calculateResultSetConcurrency(n6, statement.resultSetConcurrency_), this.calculateResultSetHoldability(n3));
        }
        catch (SqlException sqlException) {
            throw new DisconnectException((Agent)this.netAgent_, sqlException);
        }
        boolean bl11 = bl && netResultSet.resultSetType_ == 1003 && this.netAgent_.netConnection_.serverSupportsQryclsimp();
        netResultSet.netCursor_.setQryclsimpEnabled(bl11);
        return netResultSet;
    }

    protected void parseENDQRYRM(ResultSetCallbackInterface resultSetCallbackInterface) throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8715);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl3 = false;
            if (n2 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_ERROR);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n2 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl);
        this.netAgent_.setSvrcod(n);
    }

    private void parseQRYPOPRM() throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        boolean bl3 = false;
        Section section = null;
        this.parseLengthAndMatchCodePoint(8719);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl4 = false;
            if (n2 == 4425) {
                bl4 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8464) {
                bl4 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8467) {
                bl4 = true;
                bl3 = this.checkAndGetReceivedFlag(bl3);
                section = this.parsePKGNAMCSN(true);
                n2 = this.peekCodePoint();
            }
            if (bl4) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2, bl3);
        this.netAgent_.setSvrcod(n);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)MessageUtil.getCompleteMessage("J129", "org.apache.derby.loc.clientmessages", null)));
    }

    private void parseOPNQFLRM(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        String string = null;
        this.parseLengthAndMatchCodePoint(8722);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl3 = false;
            if (n2 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8464) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                string = this.parseRDBNAM(true);
                n2 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n);
    }

    private List<Section> parseRSLSETRM() throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        boolean bl2 = false;
        List<Section> list = null;
        this.parseLengthAndMatchCodePoint(8729);
        this.pushLengthOnCollectionStack();
        int n2 = this.peekCodePoint();
        while (n2 != -1) {
            boolean bl3 = false;
            if (n2 == 4425) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_INFO);
                n2 = this.peekCodePoint();
            }
            if (n2 == 8505) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                list = this.parsePKGSNLST();
                n2 = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n2);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        this.netAgent_.setSvrcod(n);
        return list;
    }

    protected NetSqlca parseSQLDTARD(NetSqldta netSqldta) throws DisconnectException {
        boolean bl = false;
        boolean bl2 = false;
        this.parseLengthAndMatchCodePoint(9235);
        this.pushLengthOnCollectionStack();
        NetSqlca netSqlca = null;
        int n = this.peekCodePoint();
        while (n != -1) {
            boolean bl3 = false;
            if (n == 16) {
                bl3 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                this.parseFDODSC(netSqldta);
                n = this.peekCodePoint();
            }
            if (n == 5242) {
                bl3 = true;
                bl2 = this.checkAndGetReceivedFlag(bl2);
                netSqlca = this.parseFDODTA(netSqldta);
                n = this.peekCodePoint();
            }
            if (bl3) continue;
            this.doPrmnsprmSemantics(n);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(bl, bl2);
        netSqldta.calculateColumnOffsetsForRow();
        return netSqlca;
    }

    protected void parseQRYDSC(NetCursor netCursor) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9242);
        this.parseSQLDTARDarray(netCursor, false);
    }

    private void parseFDODSC(NetCursor netCursor) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(16);
        this.parseSQLDTARDarray(netCursor, false);
    }

    private void parseSQLDTARDarray(NetCursor netCursor, boolean bl) throws DisconnectException {
        int n;
        int n2;
        if (bl) {
            this.skipBytes();
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.netAgent_.targetTypdef_.clearMddOverrides();
        this.ensureBLayerDataInBuffer(n2);
        block11: for (n2 = this.getDdmLength(); n2 > 0; n2 -= n) {
            n = this.readFastUnsignedByte();
            int n7 = this.readFastUnsignedByte();
            int n8 = this.readFastUnsignedByte();
            switch (n7) {
                case 120: {
                    if (n != 7 || n8 != 0) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(n3, 2, n4, 3);
                    n3 = 2;
                    n4 = 3;
                    int n9 = this.readFastUnsignedByte();
                    int n10 = this.readFastUnsignedByte();
                    int n11 = this.readFastUnsignedByte();
                    n5 = this.readFastUnsignedByte();
                    continue block11;
                }
                case 118: {
                    if (n8 != 208) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(n3, 5, n4, 4);
                    n3 = 5;
                    n4 = 3;
                    int n12 = this.peekTotalColumnCount(n);
                    netCursor.initializeColumnInfoArrays(this.netAgent_.targetTypdef_, n12, this.netAgent_.targetSqlam_);
                    n6 += this.parseSQLDTAGRPdataLabelsAndUpdateColumn(netCursor, n6, n);
                    continue block11;
                }
                case 113: {
                    switch (n8) {
                        case 224: {
                            if (n != 9) {
                                this.descriptorErrorDetected();
                            }
                            this.checkPreviousSQLDTARDtriplet(n3, 4, n4, 5);
                            n3 = 4;
                            n4 = 5;
                            this.checkFastRLO(FdocaConstants.RLO_SQLCADTA);
                            continue block11;
                        }
                        case 240: {
                            if (n != 6) {
                                this.descriptorErrorDetected();
                            }
                            this.checkPreviousSQLDTARDtriplet(n3, 4, n4, 6);
                            n3 = 4;
                            n4 = 6;
                            this.checkFastRLO(FdocaConstants.RLO_SQLDTARD);
                            continue block11;
                        }
                    }
                    this.descriptorErrorDetected();
                    continue block11;
                }
                case 127: {
                    if (n8 != 0) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(n3, 6, n4, 3);
                    n3 = 6;
                    n4 = 3;
                    n6 += this.parseSQLDTAGRPdataLabelsAndUpdateColumn(netCursor, n6, n);
                    continue block11;
                }
                case 112: {
                    if (n != 12) {
                        this.descriptorErrorDetected();
                    }
                    this.checkPreviousSQLDTARDtriplet(n3, 3, n4, 2);
                    n3 = 3;
                    n4 = 2;
                    this.netAgent_.targetTypdef_.setMddOverride(n5, n8, this.readFastUnsignedByte(), this.readFastInt(), this.readFastUnsignedByte(), this.readFastUnsignedByte(), this.readFastShort());
                    continue block11;
                }
                default: {
                    this.descriptorErrorDetected();
                }
            }
        }
        this.adjustLengths(this.getDdmLength());
        netCursor.allocateCharBuffer();
        this.checkPreviousSQLDTARDtriplet(n3, 1, n4, 1);
    }

    private void checkPreviousSQLDTARDtriplet(int n, int n2, int n3, int n4) throws DisconnectException {
        if (!FdocaConstants.SQLDTARD_TRIPLET_TYPES[n][n2]) {
            this.descriptorErrorDetected();
        }
        if (!FdocaConstants.SQLDTARD_TRIPLET_IDS[n3][n4]) {
            this.descriptorErrorDetected();
        }
    }

    private void checkFastRLO(int[][] nArray) throws DisconnectException {
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            int n2;
            int n3 = this.readFastUnsignedByte();
            if (n3 != nArray[i][0]) {
                this.descriptorErrorDetected();
            }
            if ((n2 = this.readFastUnsignedByte()) != nArray[i][1]) {
                this.descriptorErrorDetected();
            }
            if ((n = this.readFastUnsignedByte()) == nArray[i][2]) continue;
            this.descriptorErrorDetected();
        }
    }

    private void descriptorErrorDetected() throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)MessageUtil.getCompleteMessage("J130", "org.apache.derby.loc.clientmessages", null)));
    }

    protected void parseQRYDTA(NetResultSet netResultSet) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9243);
        if (this.longValueForDecryption_ == null) {
            int n = this.getDdmLength();
            this.ensureBLayerDataInBuffer(n);
        }
        this.parseSQLDTARDdata(netResultSet.netCursor_);
        if (this.longValueForDecryption_ == null) {
            this.adjustLengths(this.getDdmLength());
        } else {
            this.longValueForDecryption_ = null;
        }
        if (this.longBufferForDecryption_ != null) {
            this.buffer_ = this.longBufferForDecryption_;
            this.pos_ = this.longPosForDecryption_;
            if (this.count_ > this.longBufferForDecryption_.length) {
                this.count_ = this.longBufferForDecryption_.length;
            } else if (this.longCountForDecryption_ != 0) {
                this.count_ = this.longCountForDecryption_;
                this.longCountForDecryption_ = 0;
            }
            this.dssLength_ = 0;
            this.longBufferForDecryption_ = null;
        }
    }

    NetSqlca parseFDODTA(NetCursor netCursor) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(5242);
        int n = this.getDdmLength();
        this.ensureBLayerDataInBuffer(n);
        this.mark();
        NetSqlca netSqlca = this.parseSQLCARDrow(null);
        int n2 = this.getFastSkipSQLCARDrowLength();
        this.adjustLengths(n2);
        this.parseFastSQLDTARDdata(netCursor);
        return netSqlca;
    }

    void parseFastSQLDTARDdata(NetCursor netCursor) throws DisconnectException {
        netCursor.dataBufferStream_ = this.getFastData(netCursor.dataBufferStream_);
        netCursor.dataBuffer_ = netCursor.dataBufferStream_.toByteArray();
        netCursor.lastValidBytePosition_ = netCursor.dataBuffer_.length;
    }

    void parseSQLDTARDdata(NetCursor netCursor) throws DisconnectException {
        if (this.longValueForDecryption_ == null) {
            netCursor.dataBufferStream_ = this.getData(netCursor.dataBufferStream_);
            netCursor.dataBuffer_ = netCursor.dataBufferStream_.toByteArray();
        } else {
            int n = netCursor.dataBufferStream_.size();
            if (n == 0) {
                netCursor.dataBuffer_ = this.longValueForDecryption_;
            } else {
                byte[] byArray = new byte[n + this.longValueForDecryption_.length];
                System.arraycopy(netCursor.dataBuffer_, 0, byArray, 0, n);
                System.arraycopy(this.longValueForDecryption_, 0, byArray, n, this.longValueForDecryption_.length);
                netCursor.dataBuffer_ = byArray;
            }
        }
        netCursor.lastValidBytePosition_ = netCursor.dataBuffer_.length;
    }

    protected void copyEXTDTA(NetCursor netCursor) throws DisconnectException {
        try {
            this.parseLengthAndMatchCodePoint(5228);
            byte[] byArray = null;
            if (this.longValueForDecryption_ == null) {
                byArray = this.getData(null).toByteArray();
            } else {
                byArray = this.longValueForDecryption_;
                this.dssLength_ = 0;
                this.longValueForDecryption_ = null;
            }
            netCursor.extdtaData_.add(byArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C.6"), null, (Throwable)outOfMemoryError));
        }
    }

    protected Section parsePKGNAMCSN(boolean bl) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8467);
        if (bl) {
            this.skipBytes();
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        byte[] byArray = null;
        int n = 0;
        byte[] byArray2 = null;
        int n2 = 0;
        int n3 = this.getDdmLength();
        int n4 = 0;
        this.ensureBLayerDataInBuffer(n3);
        if (n3 == 64) {
            n2 = n3 - 2;
            byArray2 = new byte[n2];
            n4 = this.peekFastBytes(byArray2, n4, n2);
            string = this.readFastString(18);
            string2 = this.readFastString(18);
            string3 = this.readFastString(18);
            byArray = this.readFastBytes(8);
        } else if (n3 >= 71 && n3 <= 781) {
            byArray2 = new byte[n3 - 2];
            int n5 = this.peekFastLength();
            if (n5 < 18 || n5 > 255) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.21"), (Object)n5));
                return null;
            }
            n4 = this.peekFastBytes(byArray2, n4, 2 + n5);
            this.skipFastBytes(2);
            string = this.readFastString(n5);
            n5 = this.peekFastLength();
            if (n5 < 18 || n5 > 255) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.7"), (Object)n5));
                return null;
            }
            n4 = this.peekFastBytes(byArray2, n4, 2 + n5);
            this.skipFastBytes(2);
            string2 = this.readFastString(n5);
            n5 = this.peekFastLength();
            if (n5 < 18 || n5 > 255) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.8"), (Object)n5));
                return null;
            }
            n4 = this.peekFastBytes(byArray2, n4, 2 + n5);
            this.skipFastBytes(2);
            string3 = this.readFastString(n5);
            n4 = this.peekFastBytes(byArray2, n4, 8);
            byArray = this.readFastBytes(8);
        } else {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.9"), (Object)n3, (Object)this.netAgent_.targetSqlam_));
            return null;
        }
        n = this.readFastUnsignedShort();
        this.adjustLengths(n3);
        Section section = new Section(this.agent_, string3, n, null, -1, true);
        section.setPKGNAMCBytes(byArray2);
        return section;
    }

    protected int parseFastQRYPRCTYP() throws DisconnectException {
        this.matchCodePoint(8450);
        int n = this.readFastUnsignedShort();
        if (n != 9240 && n != 9239) {
            this.doValnsprmSemantics(8450, n);
        }
        return n;
    }

    protected int parseFastSQLCSRHLD() throws DisconnectException {
        this.matchCodePoint(8479);
        int n = this.readFastUnsignedByte();
        if (n != 240 && n != 241) {
            this.doValnsprmSemantics(8479, n);
        }
        return n;
    }

    protected int parseFastQRYATTSCR() throws DisconnectException {
        this.matchCodePoint(8521);
        int n = this.readFastUnsignedByte();
        if (n != 240 && n != 241) {
            this.doValnsprmSemantics(8521, n);
        }
        return n;
    }

    protected int parseFastQRYATTSET() throws DisconnectException {
        this.matchCodePoint(8522);
        int n = this.readFastUnsignedByte();
        if (n != 240 && n != 241) {
            this.doValnsprmSemantics(8522, n);
        }
        return n;
    }

    protected int parseFastQRYATTSNS() throws DisconnectException {
        this.matchCodePoint(8535);
        int n = this.readFastUnsignedByte();
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                this.doValnsprmSemantics(8535, n);
            }
        }
        return n;
    }

    protected int parseFastQRYATTUPD() throws DisconnectException {
        this.matchCodePoint(8528);
        int n = this.readFastUnsignedByte();
        switch (n) {
            case 0: 
            case 1: 
            case 4: {
                break;
            }
            default: {
                this.doValnsprmSemantics(8528, n);
            }
        }
        return n;
    }

    private long parseFastQRYINSID() throws DisconnectException {
        this.matchCodePoint(8539);
        return this.readFastLong();
    }

    private List<Section> parsePKGSNLST() throws DisconnectException {
        ArrayList<Section> arrayList = new ArrayList<Section>();
        this.parseLengthAndMatchCodePoint(8505);
        this.pushLengthOnCollectionStack();
        while (this.peekCodePoint() != -1) {
            arrayList.add(this.parsePKGNAMCSN(false));
        }
        this.popCollectionStack();
        return arrayList;
    }

    protected NetSqlca parseSQLDARD(ColumnMetaData columnMetaData, boolean bl) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9233);
        return this.parseSQLDARDarray(columnMetaData, bl);
    }

    private int parseSQLRSLRD(List<Section> list) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9230);
        return this.parseSQLRSLRDarray(list);
    }

    protected ColumnMetaData parseSQLCINRD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9227);
        int n = this.getDdmLength();
        this.ensureBLayerDataInBuffer(n);
        ColumnMetaData columnMetaData = this.parseSQLCINRDarray();
        this.adjustLengths(this.getDdmLength());
        return columnMetaData;
    }

    NetSqlca parseSQLDARDarray(ColumnMetaData columnMetaData, boolean bl) throws DisconnectException {
        int n = 0;
        if (!this.ensuredLengthForDecryption_ && this.longValueForDecryption_ == null) {
            n = this.getDdmLength();
            this.ensureBLayerDataInBuffer(n);
        }
        if (this.longValueForDecryption_ != null) {
            this.buffer_ = this.longValueForDecryption_;
            this.pos_ = 0;
            this.count_ = this.longValueForDecryption_.length;
        }
        NetSqlca netSqlca = null;
        if (bl) {
            this.mark();
            netSqlca = this.parseSQLCARDrow(null);
            this.skipFastBytes(n - this.getFastSkipSQLCARDrowLength());
            this.adjustLengths(this.getDdmLength());
            return netSqlca;
        }
        netSqlca = this.parseSQLCARDrow(null);
        this.parseSQLDHROW(columnMetaData);
        int n2 = this.parseSQLNUMROW();
        if (n2 > columnMetaData.columns_) {
            columnMetaData.initializeCache(n2);
        } else {
            columnMetaData.columns_ = n2;
        }
        for (int i = 0; i < columnMetaData.columns_; ++i) {
            this.parseSQLDAROW(columnMetaData, i);
        }
        if (this.longValueForDecryption_ == null) {
            this.adjustLengths(this.getDdmLength());
        } else {
            this.dssLength_ = 0;
            this.longValueForDecryption_ = null;
        }
        return netSqlca;
    }

    private int parseSQLRSLRDarray(List<Section> list) throws DisconnectException {
        int n = this.parseSQLNUMROW();
        for (int i = 0; i < n; ++i) {
            this.parseSQLRSROW(list.get(i));
        }
        return n;
    }

    ColumnMetaData parseSQLCINRDarray() throws DisconnectException {
        ColumnMetaData columnMetaData = ClientDriver.getFactory().newColumnMetaData(this.netAgent_.logWriter_);
        this.parseSQLDHROW(columnMetaData);
        columnMetaData.initializeCache(this.parseFastSQLNUMROW());
        for (int i = 0; i < columnMetaData.columns_; ++i) {
            this.parseSQLDAROW(columnMetaData, i);
        }
        return columnMetaData;
    }

    private void parseSQLDAROW(ColumnMetaData columnMetaData, int n) throws DisconnectException {
        this.parseSQLDAGRP(columnMetaData, n);
    }

    private void parseSQLDHROW(ColumnMetaData columnMetaData) throws DisconnectException {
        this.parseSQLDHGRP(columnMetaData);
    }

    private void parseSQLRSROW(Section section) throws DisconnectException {
        this.parseSQLRSGRP(section);
    }

    private void parseSQLDAGRP(ColumnMetaData columnMetaData, int n) throws DisconnectException {
        long l = 0L;
        short s = this.readFastShort();
        short s2 = this.readFastShort();
        l = this.readFastLong();
        short s3 = this.readFastShort();
        int n2 = this.readFastUnsignedShort();
        columnMetaData.sqlPrecision_[n] = s;
        columnMetaData.sqlScale_[n] = s2;
        columnMetaData.sqlLength_[n] = l;
        columnMetaData.sqlType_[n] = s3;
        columnMetaData.nullable_[n] = Utils.isSqlTypeNullable(s3);
        columnMetaData.sqlCcsid_[n] = n2;
        columnMetaData.types_[n] = Types.mapDERBYTypeToDriverType(true, s3, l, n2);
        this.parseSQLDOPTGRP(columnMetaData, n);
    }

    private void parseSQLUDTGRP(ColumnMetaData columnMetaData, int n) throws DisconnectException {
        int n2 = columnMetaData.types_[n];
        if (n2 != 2000 || !this.netAgent_.netConnection_.serverSupportsUDTs()) {
            if (this.readFastUnsignedByte() == 255) {
                return;
            }
        } else {
            String string = this.parseFastVCMorVCS();
            String string2 = this.parseFastVCMorVCS();
            columnMetaData.sqlUDTname_[n] = string;
            columnMetaData.sqlUDTclassName_[n] = string2;
        }
    }

    private void parseSQLDOPTGRP(ColumnMetaData columnMetaData, int n) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        short s = this.readFastShort();
        String string = this.parseFastVCMorVCS();
        String string2 = this.parseFastVCMorVCS();
        String string3 = this.parseFastVCMorVCS();
        if (columnMetaData.sqlName_ == null) {
            columnMetaData.sqlName_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlLabel_ == null) {
            columnMetaData.sqlLabel_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlUnnamed_ == null) {
            columnMetaData.sqlUnnamed_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlComment_ == null) {
            columnMetaData.sqlComment_ = new String[columnMetaData.columns_];
        }
        columnMetaData.sqlName_[n] = string;
        columnMetaData.sqlLabel_[n] = string2;
        columnMetaData.sqlUnnamed_[n] = s;
        columnMetaData.sqlComment_[n] = string3;
        this.parseSQLUDTGRP(columnMetaData, n);
        this.parseSQLDXGRP(columnMetaData, n);
    }

    private void parseSQLDXGRP(ColumnMetaData columnMetaData, int n) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        short s = this.readFastShort();
        short s2 = this.readFastShort();
        short s3 = this.readFastShort();
        short s4 = this.readFastShort();
        String string = this.parseFastVCS();
        String string2 = this.parseFastVCMorVCS();
        String string3 = this.parseFastVCMorVCS();
        String string4 = this.parseFastVCMorVCS();
        String string5 = this.parseFastVCMorVCS();
        if (columnMetaData.sqlxKeymem_ == null) {
            columnMetaData.sqlxKeymem_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxGenerated_ == null) {
            columnMetaData.sqlxGenerated_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxParmmode_ == null) {
            columnMetaData.sqlxParmmode_ = new short[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxCorname_ == null) {
            columnMetaData.sqlxCorname_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxName_ == null) {
            columnMetaData.sqlxName_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxBasename_ == null) {
            columnMetaData.sqlxBasename_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxUpdatable_ == null) {
            columnMetaData.sqlxUpdatable_ = new int[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxSchema_ == null) {
            columnMetaData.sqlxSchema_ = new String[columnMetaData.columns_];
        }
        if (columnMetaData.sqlxRdbnam_ == null) {
            columnMetaData.sqlxRdbnam_ = new String[columnMetaData.columns_];
        }
        columnMetaData.sqlxKeymem_[n] = s;
        columnMetaData.sqlxGenerated_[n] = s3;
        columnMetaData.sqlxParmmode_[n] = s4;
        columnMetaData.sqlxCorname_[n] = string2;
        columnMetaData.sqlxName_[n] = string5;
        columnMetaData.sqlxBasename_[n] = string3;
        columnMetaData.sqlxUpdatable_[n] = s2;
        columnMetaData.sqlxSchema_[n] = string4 == null ? columnMetaData.sqldSchema_ : string4;
        columnMetaData.sqlxRdbnam_[n] = string == null ? columnMetaData.sqldRdbnam_ : string;
    }

    private void parseSQLDHGRP(ColumnMetaData columnMetaData) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        short s = this.readFastShort();
        short s2 = this.readFastShort();
        short s3 = this.readFastShort();
        short s4 = this.readFastShort();
        short s5 = this.readFastShort();
        short s6 = this.readFastShort();
        String string = this.parseFastVCS();
        String string2 = this.parseFastVCMorVCS();
        columnMetaData.sqldHold_ = s;
        columnMetaData.sqldReturn_ = s2;
        columnMetaData.sqldScroll_ = s3;
        columnMetaData.sqldSensitive_ = s4;
        columnMetaData.sqldFcode_ = s5;
        columnMetaData.sqldKeytype_ = s6;
        columnMetaData.sqldRdbnam_ = string;
        columnMetaData.sqldSchema_ = string2;
    }

    private void parseSQLRSGRP(Section section) throws DisconnectException {
        int n = this.readInt();
        String string = this.parseVCMorVCS();
        int n2 = this.readInt();
        section.setCursorName(string);
    }

    private String parseFastVCMorVCS() throws DisconnectException {
        String string = null;
        int n = this.readFastUnsignedShort();
        if (n > 0) {
            string = this.readFastString(n, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
        }
        int n2 = this.readFastUnsignedShort();
        if (n > 0 && n2 > 0) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.10")));
        } else if (n2 > 0) {
            string = this.readFastString(n2, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        }
        return string;
    }

    private String parseVCMorVCS() throws DisconnectException {
        String string = null;
        int n = this.readUnsignedShort();
        if (n > 0) {
            string = this.readString(n, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
        }
        int n2 = this.readUnsignedShort();
        if (n > 0 && n2 > 0) {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.10")));
        } else if (n2 > 0) {
            string = this.readString(n2, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        }
        return string;
    }

    private int calculateResultSetType(int n, int n2, int n3) {
        if (n == 240) {
            return 1003;
        }
        switch (n2) {
            case 1: {
                return 1004;
            }
        }
        return n3;
    }

    private int calculateResultSetConcurrency(int n, int n2) {
        switch (n) {
            case 1: {
                return 1007;
            }
            case 4: {
                return 1008;
            }
        }
        return n2;
    }

    private int calculateResultSetHoldability(int n) {
        if (n == 240) {
            return 2;
        }
        return 1;
    }

    private int parseSQLDTAGRPdataLabelsAndUpdateColumn(NetCursor netCursor, int n, int n2) throws DisconnectException {
        int n3 = (n2 - 3) / 3;
        for (int i = n; i < n + n3; ++i) {
            netCursor.qrydscTypdef_.updateColumn(netCursor, i, this.readFastUnsignedByte(), this.readFastUnsignedShort());
        }
        return n3;
    }

    @Override
    public void readSetSpecialRegister(StatementCallbackInterface statementCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseEXCSQLSETreply(statementCallbackInterface);
        this.endOfSameIdChainData();
    }
}

