/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.openerp.parser;

import com.debortoliwines.openerp.reporting.di.OpenERPConfiguration;
import com.debortoliwines.openerp.reporting.di.OpenERPFieldInfo;
import com.debortoliwines.openerp.reporting.di.OpenERPFilterInfo;
import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.DataFactoryReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.openerp.OpenERPDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.openerp.parser.ConfigReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.openerp.parser.FilterReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.openerp.parser.SelectedFieldReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OpenERPDataSourceReadHandler
extends AbstractXmlReadHandler
implements DataFactoryReadHandler {
    private ConfigReadHandler configReadHandler;
    private ArrayList<FilterReadHandler> filters = new ArrayList();
    private OpenERPDataFactory dataFactory;
    private ArrayList<SelectedFieldReadHandler> selectedFieldHandlers = new ArrayList();
    private ArrayList<OpenERPFieldInfo> allFields = new ArrayList();

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("config".equals(tagName)) {
            this.configReadHandler = new ConfigReadHandler();
            return this.configReadHandler;
        }
        if ("filter".equals(tagName)) {
            FilterReadHandler filterReadHandler = new FilterReadHandler();
            this.filters.add(filterReadHandler);
            return filterReadHandler;
        }
        if ("selectedField".equals(tagName)) {
            SelectedFieldReadHandler selectedFieldReadHandler = new SelectedFieldReadHandler(this.allFields);
            this.selectedFieldHandlers.add(selectedFieldReadHandler);
            return selectedFieldReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        OpenERPDataFactory srdf = new OpenERPDataFactory();
        if (this.configReadHandler == null) {
            throw new ParseException("Required element 'config' is missing.", this.getLocator());
        }
        srdf.setQueryName(this.configReadHandler.getQueryName());
        OpenERPConfiguration config = this.configReadHandler.getConfig();
        srdf.setConfig(config);
        ArrayList<OpenERPFilterInfo> filterRows = new ArrayList<OpenERPFilterInfo>();
        for (FilterReadHandler handler : this.filters) {
            filterRows.add(handler.getFilter());
        }
        config.setFilters(filterRows);
        ArrayList<OpenERPFieldInfo> selectedFields = new ArrayList<OpenERPFieldInfo>();
        for (SelectedFieldReadHandler handler : this.selectedFieldHandlers) {
            selectedFields.add(handler.getField());
        }
        config.setSelectedFields(selectedFields);
        this.dataFactory = srdf;
    }

    public Object getObject() throws SAXException {
        return this.dataFactory;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }
}

