/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import com.sun.jersey.api.NotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoRole;
import org.pentaho.platform.api.engine.security.userroledao.IPentahoUser;
import org.pentaho.platform.api.engine.security.userroledao.IUserRoleDao;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.api.mt.ITenantManager;
import org.pentaho.platform.core.mt.Tenant;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.security.policy.rolebased.IRoleAuthorizationPolicyRoleBindingDao;
import org.pentaho.platform.security.policy.rolebased.RoleBindingStruct;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.LocalizedLogicalRoleName;
import org.pentaho.platform.web.http.api.resources.LogicalRoleAssignment;
import org.pentaho.platform.web.http.api.resources.LogicalRoleAssignments;
import org.pentaho.platform.web.http.api.resources.RoleListWrapper;
import org.pentaho.platform.web.http.api.resources.SystemRolesMap;
import org.pentaho.platform.web.http.api.resources.User;
import org.pentaho.platform.web.http.api.resources.UserListWrapper;

@Path(value="/userroledao/")
public class UserRoleDaoResource
extends AbstractJaxRSResource {
    private IRoleAuthorizationPolicyRoleBindingDao roleBindingDao = null;
    private ITenantManager tenantManager = null;
    private ArrayList<String> systemRoles;
    private String adminRole;
    private static final Log logger = LogFactory.getLog(UserRoleDaoResource.class);

    public UserRoleDaoResource() {
        this((IRoleAuthorizationPolicyRoleBindingDao)PentahoSystem.get(IRoleAuthorizationPolicyRoleBindingDao.class), (ITenantManager)PentahoSystem.get(ITenantManager.class), (ArrayList)PentahoSystem.get(ArrayList.class, (String)"singleTenantSystemAuthorities", (IPentahoSession)PentahoSessionHolder.getSession()), (String)PentahoSystem.get(String.class, (String)"singleTenantAdminAuthorityName", (IPentahoSession)PentahoSessionHolder.getSession()));
    }

    public UserRoleDaoResource(IRoleAuthorizationPolicyRoleBindingDao roleBindingDao, ITenantManager tenantMgr, ArrayList<String> systemRoles, String adminRole) {
        if (roleBindingDao == null) {
            throw new IllegalArgumentException();
        }
        this.roleBindingDao = roleBindingDao;
        this.tenantManager = tenantMgr;
        this.systemRoles = systemRoles;
        this.adminRole = adminRole;
    }

    @GET
    @Path(value="/users")
    @Produces(value={"application/xml", "application/json"})
    @Facet(name="Unsupported")
    public UserListWrapper getUsers() throws Exception {
        if (this.canAdminister()) {
            try {
                IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
                return new UserListWrapper(roleDao.getUsers());
            }
            catch (Throwable t) {
                throw new WebApplicationException(t);
            }
        }
        throw new WebApplicationException(new Throwable());
    }

    @GET
    @Path(value="/roles")
    @Produces(value={"application/xml", "application/json"})
    @Facet(name="Unsupported")
    public RoleListWrapper getRoles() throws Exception {
        if (this.canAdminister()) {
            try {
                IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
                return new RoleListWrapper(roleDao.getRoles());
            }
            catch (Throwable t) {
                throw new WebApplicationException(t);
            }
        }
        throw new WebApplicationException(new Throwable());
    }

    @GET
    @Path(value="/userRoles")
    @Produces(value={"application/xml", "application/json"})
    @Facet(name="Unsupported")
    public RoleListWrapper getUserRoles(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="userName") String userName) throws Exception {
        if (this.canAdminister()) {
            try {
                IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
                return new RoleListWrapper(roleDao.getUserRoles(this.getTenant(tenantPath), userName));
            }
            catch (Throwable t) {
                throw new WebApplicationException(t);
            }
        }
        throw new WebApplicationException(new Throwable());
    }

    @GET
    @Path(value="/roleMembers")
    @Produces(value={"application/xml", "application/json"})
    @Facet(name="Unsupported")
    public UserListWrapper getRoleMembers(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="roleName") String roleName) throws Exception {
        IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
        return new UserListWrapper(roleDao.getRoleMembers(this.getTenant(tenantPath), roleName));
    }

    @PUT
    @Path(value="/assignRoleToUser")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response assignRoleToUser(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="userName") String userName, @QueryParam(value="roleNames") String roleNames) {
        if (this.canAdminister()) {
            IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
            StringTokenizer tokenizer = new StringTokenizer(roleNames, "\t");
            HashSet<String> assignedRoles = new HashSet<String>();
            for (IPentahoRole pentahoRole : roleDao.getUserRoles(this.getTenant(tenantPath), userName)) {
                assignedRoles.add(pentahoRole.getName());
            }
            while (tokenizer.hasMoreTokens()) {
                assignedRoles.add(tokenizer.nextToken());
            }
            try {
                roleDao.setUserRoles(this.getTenant(tenantPath), userName, assignedRoles.toArray(new String[0]));
            }
            catch (Throwable th) {
                return this.processErrorResponse(th.getLocalizedMessage());
            }
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Path(value="/removeRoleFromUser")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response removeRoleFromUser(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="userName") String userName, @QueryParam(value="roleNames") String roleNames) {
        if (this.canAdminister()) {
            try {
                IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
                StringTokenizer tokenizer = new StringTokenizer(roleNames, "\t");
                HashSet<String> assignedRoles = new HashSet<String>();
                for (IPentahoRole pentahoRole : roleDao.getUserRoles(this.getTenant(tenantPath), userName)) {
                    assignedRoles.add(pentahoRole.getName());
                }
                while (tokenizer.hasMoreTokens()) {
                    assignedRoles.remove(tokenizer.nextToken());
                }
                roleDao.setUserRoles(this.getTenant(tenantPath), userName, assignedRoles.toArray(new String[0]));
                return Response.ok().build();
            }
            catch (Throwable th) {
                return this.processErrorResponse(th.getLocalizedMessage());
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Path(value="/assignAllRolesToUser")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response assignAllRolesToUser(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="userName") String userName) {
        IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
        HashSet<String> assignedRoles = new HashSet<String>();
        for (IPentahoRole pentahoRole : roleDao.getRoles(this.getTenant(tenantPath))) {
            assignedRoles.add(pentahoRole.getName());
        }
        roleDao.setUserRoles(this.getTenant(tenantPath), userName, assignedRoles.toArray(new String[0]));
        return Response.ok().build();
    }

    @PUT
    @Path(value="/removeAllRolesFromUser")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response removeAllRolesFromUser(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="userName") String userName) {
        if (this.canAdminister()) {
            try {
                IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
                roleDao.setUserRoles(this.getTenant(tenantPath), userName, new String[0]);
                return Response.ok().build();
            }
            catch (Throwable th) {
                return this.processErrorResponse(th.getLocalizedMessage());
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Path(value="/assignUserToRole")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response assignUserToRole(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="userNames") String userNames, @QueryParam(value="roleName") String roleName) {
        if (this.canAdminister()) {
            IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
            StringTokenizer tokenizer = new StringTokenizer(userNames, "\t");
            HashSet<String> assignedUserNames = new HashSet<String>();
            for (IPentahoUser pentahoUser : roleDao.getRoleMembers(this.getTenant(tenantPath), roleName)) {
                assignedUserNames.add(pentahoUser.getUsername());
            }
            while (tokenizer.hasMoreTokens()) {
                assignedUserNames.add(tokenizer.nextToken());
            }
            try {
                roleDao.setRoleMembers(this.getTenant(tenantPath), roleName, assignedUserNames.toArray(new String[0]));
                return Response.ok().build();
            }
            catch (Throwable th) {
                return this.processErrorResponse(th.getLocalizedMessage());
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Path(value="/removeUserFromRole")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response removeUserFromRole(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="userNames") String userNames, @QueryParam(value="roleName") String roleName) {
        if (this.canAdminister()) {
            try {
                IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
                StringTokenizer tokenizer = new StringTokenizer(userNames, "\t");
                HashSet<String> assignedUserNames = new HashSet<String>();
                for (IPentahoUser pentahoUser : roleDao.getRoleMembers(this.getTenant(tenantPath), roleName)) {
                    assignedUserNames.add(pentahoUser.getUsername());
                }
                while (tokenizer.hasMoreTokens()) {
                    assignedUserNames.remove(tokenizer.nextToken());
                }
                roleDao.setRoleMembers(this.getTenant(tenantPath), roleName, assignedUserNames.toArray(new String[0]));
                return Response.ok().build();
            }
            catch (Throwable th) {
                return this.processErrorResponse(th.getLocalizedMessage());
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Path(value="/assignAllUsersToRole")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response assignAllUsersToRole(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="roleName") String roleName) {
        IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
        HashSet<String> assignedUserNames = new HashSet<String>();
        for (IPentahoUser pentahoUser : roleDao.getUsers(this.getTenant(tenantPath))) {
            assignedUserNames.add(pentahoUser.getUsername());
        }
        roleDao.setRoleMembers(this.getTenant(tenantPath), roleName, assignedUserNames.toArray(new String[0]));
        return Response.ok().build();
    }

    @PUT
    @Path(value="/removeAllUsersFromRole")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response removeAllUsersFromRole(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="roleName") String roleName) {
        if (this.canAdminister()) {
            try {
                IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
                roleDao.setRoleMembers(this.getTenant(tenantPath), roleName, new String[0]);
                return Response.ok().build();
            }
            catch (Throwable th) {
                return this.processErrorResponse(th.getLocalizedMessage());
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Path(value="/createUser")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response createUser(@QueryParam(value="tenant") String tenantPath, User user) {
        IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
        String userName = user.getUserName();
        String password = user.getPassword();
        try {
            userName = URLDecoder.decode(userName.replace("+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            userName = user.getUserName();
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        try {
            password = URLDecoder.decode(password.replace("+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            password = user.getPassword();
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        roleDao.createUser(this.getTenant(tenantPath), userName, password, "", new String[0]);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/createRole")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response createRole(@QueryParam(value="tenant") String tenantPath, @QueryParam(value="roleName") String roleName) {
        IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
        roleDao.createRole(this.getTenant(tenantPath), roleName, "", new String[0]);
        return Response.ok().build();
    }

    @PUT
    @Path(value="/deleteRoles")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response deleteRole(@QueryParam(value="roleNames") String roleNames) {
        if (this.canAdminister()) {
            try {
                IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
                StringTokenizer tokenizer = new StringTokenizer(roleNames, "\t");
                while (tokenizer.hasMoreTokens()) {
                    IPentahoRole role = roleDao.getRole(null, tokenizer.nextToken());
                    if (role == null) continue;
                    roleDao.deleteRole(role);
                }
            }
            catch (Throwable th) {
                return this.processErrorResponse(th.getLocalizedMessage());
            }
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Path(value="/deleteUsers")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response deleteUser(@QueryParam(value="userNames") String userNames) {
        if (this.canAdminister()) {
            try {
                IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
                StringTokenizer tokenizer = new StringTokenizer(userNames, "\t");
                while (tokenizer.hasMoreTokens()) {
                    IPentahoUser user = roleDao.getUser(null, tokenizer.nextToken());
                    if (user == null) continue;
                    roleDao.deleteUser(user);
                }
            }
            catch (Throwable th) {
                return this.processErrorResponse(th.getLocalizedMessage());
            }
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @PUT
    @Path(value="/updatePassword")
    @Consumes(value={"*/*"})
    @Facet(name="Unsupported")
    public Response updatePassword(User user) {
        if (this.canAdminister()) {
            try {
                IUserRoleDao roleDao = (IUserRoleDao)PentahoSystem.get(IUserRoleDao.class, (String)"userRoleDaoProxy", (IPentahoSession)PentahoSessionHolder.getSession());
                String userName = user.getUserName();
                String password = user.getPassword();
                try {
                    userName = URLDecoder.decode(userName.replace("+", "%2B"), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    userName = user.getUserName();
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
                try {
                    password = URLDecoder.decode(password.replace("+", "%2B"), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    password = user.getPassword();
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
                IPentahoUser puser = roleDao.getUser(null, userName);
                if (puser != null) {
                    roleDao.setPassword(null, userName, password);
                }
                return Response.ok().build();
            }
            catch (Throwable t) {
                throw new WebApplicationException(t);
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @Path(value="/logicalRoleMap")
    @Produces(value={"application/xml", "application/json"})
    @Facet(name="Unsupported")
    public SystemRolesMap getRoleBindingStruct(@QueryParam(value="locale") String locale) {
        if (this.canAdminister()) {
            try {
                RoleBindingStruct roleBindingStruct = this.roleBindingDao.getRoleBindingStruct(locale);
                SystemRolesMap systemRolesMap = new SystemRolesMap();
                for (Map.Entry localalizeNameEntry : roleBindingStruct.logicalRoleNameMap.entrySet()) {
                    systemRolesMap.getLocalizedRoleNames().add(new LocalizedLogicalRoleName((String)localalizeNameEntry.getKey(), (String)localalizeNameEntry.getValue()));
                }
                for (Map.Entry logicalRoleAssignments : roleBindingStruct.bindingMap.entrySet()) {
                    systemRolesMap.getAssignments().add(new LogicalRoleAssignment((String)logicalRoleAssignments.getKey(), (List)logicalRoleAssignments.getValue(), roleBindingStruct.immutableRoles.contains(logicalRoleAssignments.getKey())));
                }
                return systemRolesMap;
            }
            catch (Throwable t) {
                throw new WebApplicationException(t);
            }
        }
        throw new WebApplicationException(new Throwable());
    }

    @PUT
    @Consumes(value={"application/xml", "application/json"})
    @Path(value="/roleAssignments")
    @Facet(name="Unsupported")
    public Response setLogicalRoles(LogicalRoleAssignments roleAssignments) {
        for (LogicalRoleAssignment roleAssignment : roleAssignments.getAssignments()) {
            this.roleBindingDao.setRoleBindings(roleAssignment.getRoleName(), roleAssignment.getLogicalRoles());
        }
        return Response.ok().build();
    }

    private ITenant getTenant(String tenantId) throws NotFoundException {
        ITenant tenant = null;
        if (tenantId != null) {
            tenant = this.tenantManager.getTenant(tenantId);
            if (tenant == null) {
                throw new NotFoundException("Tenant not found.");
            }
        } else {
            IPentahoSession session = PentahoSessionHolder.getSession();
            String tenantPath = (String)session.getAttribute("org.pentaho.tenantId");
            if (tenantPath != null) {
                tenant = new Tenant(tenantPath, Boolean.valueOf(true));
            }
        }
        return tenant;
    }

    private HashSet<String> tokenToString(String tokenString) {
        StringTokenizer tokenizer = new StringTokenizer(tokenString, "\t");
        HashSet<String> result = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    private Response processErrorResponse(String errMessage) {
        return Response.ok((Object)errMessage).build();
    }

    private boolean canAdminister() {
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        return policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && policy.isAllowed("org.pentaho.security.administerSecurity");
    }
}

