/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;

public class PentahoHttpSessionHelper {
    private static final String[] DEFAULT_LOCATIONS = new String[]{"/eclipse/workspace/pentaho-solutions", "/eclipse/workspace/pentaho-samples/solutions/test-solution"};

    public static String getSolutionPath(ServletContext context) {
        File pentahoSolutions;
        String rootPath = context.getInitParameter("solution-path");
        if (StringUtils.isNotBlank((String)rootPath) && (pentahoSolutions = new File(rootPath)).exists() && pentahoSolutions.isDirectory()) {
            return rootPath;
        }
        for (String element : DEFAULT_LOCATIONS) {
            pentahoSolutions = new File(element);
            if (!pentahoSolutions.exists() || !pentahoSolutions.isDirectory()) continue;
            try {
                return pentahoSolutions.getCanonicalPath();
            }
            catch (IOException e) {
                return pentahoSolutions.getAbsolutePath();
            }
        }
        for (File file = new File(context.getRealPath("")); file != null; file = file.getParentFile()) {
            if (!file.exists() || !file.isDirectory() || !(pentahoSolutions = new File(file.getAbsolutePath() + File.separator + "pentaho-solutions")).exists() || !pentahoSolutions.isDirectory()) continue;
            try {
                return pentahoSolutions.getCanonicalPath();
            }
            catch (IOException e) {
                return pentahoSolutions.getAbsolutePath();
            }
        }
        return null;
    }
}

