/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.memory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.memory.UserMap;

public class UserRoleListEnhancedUserMap
extends UserMap {
    private final Map<String, UserDetails> userRoleListEnhanceduserMap = new HashMap<String, UserDetails>();
    private final Map<GrantedAuthority, Set<String>> rolesToUsersMap = new HashMap<GrantedAuthority, Set<String>>();

    public void addUser(UserDetails user) throws IllegalArgumentException {
        GrantedAuthority[] auths;
        super.addUser(user);
        this.userRoleListEnhanceduserMap.put(user.getUsername().toLowerCase(), user);
        for (GrantedAuthority anAuthority : auths = user.getAuthorities()) {
            Set<String> userListForAuthority = this.rolesToUsersMap.get(anAuthority);
            if (userListForAuthority == null) {
                userListForAuthority = new TreeSet<String>();
                this.rolesToUsersMap.put(anAuthority, userListForAuthority);
            }
            userListForAuthority.add(user.getUsername());
        }
    }

    public String[] getAllAuthorities() {
        Set<GrantedAuthority> authoritiesSet = this.rolesToUsersMap.keySet();
        ArrayList<String> roles = new ArrayList<String>(authoritiesSet.size());
        for (GrantedAuthority role : authoritiesSet) {
            roles.add(role.getAuthority());
        }
        return (String[])roles.toArray();
    }

    public String[] getAllUsers() {
        String[] rtn = new String[this.userRoleListEnhanceduserMap.size()];
        Iterator<UserDetails> it = this.userRoleListEnhanceduserMap.values().iterator();
        int i = 0;
        while (it.hasNext()) {
            rtn[i] = it.next().getUsername();
            ++i;
        }
        return rtn;
    }

    public String[] getUserNamesInRole(String role) {
        Set<String> userListForAuthority = this.rolesToUsersMap.get(new GrantedAuthorityImpl(role));
        String[] typ = new String[]{};
        if (userListForAuthority != null) {
            return userListForAuthority.toArray(typ);
        }
        return typ;
    }

    public void setUsers(Map users) {
        super.setUsers(users);
        Iterator iter = users.values().iterator();
        while (iter.hasNext()) {
            this.addUser((UserDetails)iter.next());
        }
    }
}

