/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport.legacy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.plugin.services.importexport.ImportSource;
import org.pentaho.platform.plugin.services.importexport.RepositoryFileBundle;
import org.pentaho.platform.plugin.services.importexport.legacy.AbstractImportSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.util.Assert;

public class DbSolutionRepositoryImportSource
extends AbstractImportSource {
    private static final Log logger = LogFactory.getLog(DbSolutionRepositoryImportSource.class);
    private String srcCharset;
    private String requiredCharset;
    private String ownerName;
    private JdbcTemplate jdbcTemplate;

    public DbSolutionRepositoryImportSource(DataSource dataSource, String srcCharset, String requiredCharset, String ownerName) {
        Assert.notNull((Object)dataSource);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
        Assert.hasLength((String)srcCharset);
        this.srcCharset = srcCharset;
        this.requiredCharset = requiredCharset;
        this.ownerName = ownerName;
    }

    @Override
    public int getCount() {
        return -1;
    }

    @Override
    public Iterable<ImportSource.IRepositoryFileBundle> getFiles() {
        Assert.hasLength((String)this.requiredCharset);
        return new Iterable<ImportSource.IRepositoryFileBundle>(){

            @Override
            public Iterator<ImportSource.IRepositoryFileBundle> iterator() {
                return new RepositoryFileBundleIterator();
            }
        };
    }

    private class RepositoryFileBundleIterator
    implements Iterator<ImportSource.IRepositoryFileBundle> {
        public static final String GET_FILES_QUERY = "SELECT f.FILE_ID, f.fileName, f.fullPath, f.data, f.directory, f.lastModified, a.ACL_MASK, a.RECIP_TYPE, a.RECIPIENT FROM PRO_FILES f LEFT OUTER JOIN PRO_ACLS_LIST a ON f.FILE_ID = a.ACL_ID ORDER BY f.fullPath, a.ACL_POSITION ";
        private static final int BATCH_SIZE = 100;
        private int i = 100;
        private int actualBatchSize = 100;
        private int batchNumber;
        private List<ImportSource.IRepositoryFileBundle> batch;
        private List<File> serializedBatches;

        public RepositoryFileBundleIterator() {
            DbsrRowCallbackHandler dbsrRowCallbackHandler = new DbsrRowCallbackHandler();
            DbSolutionRepositoryImportSource.this.jdbcTemplate.query(GET_FILES_QUERY, (RowCallbackHandler)dbsrRowCallbackHandler);
            this.serializedBatches = dbsrRowCallbackHandler.getSerializedBatches();
        }

        @Override
        public boolean hasNext() {
            if (this.i == 100 && this.actualBatchSize == 100) {
                this.fetchNextBatch();
            }
            return this.i < this.actualBatchSize;
        }

        @Override
        public ImportSource.IRepositoryFileBundle next() {
            return this.batch.get(this.i++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void fetchNextBatch() {
            try {
                FileInputStream in = FileUtils.openInputStream((File)this.serializedBatches.get(this.batchNumber));
                ObjectInputStream ois = new ObjectInputStream(in);
                this.batch = (List)ois.readObject();
                IOUtils.closeQuietly((InputStream)ois);
                this.actualBatchSize = this.batch.size();
                this.i = 0;
                ++this.batchNumber;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        private class DbsrRowCallbackHandler
        implements RowCallbackHandler {
            private String lastId;
            private RepositoryFile currentFile;
            private RepositoryFileAcl.Builder currentAclBuilder;
            private File currentTmpFile;
            private String currentPath;
            private String currentMimeType;
            private String currentCharset;
            private final List<ImportSource.IRepositoryFileBundle> currentBatch = new ArrayList<ImportSource.IRepositoryFileBundle>(100);
            private final List<File> serializedBatches = new ArrayList<File>();
            private final List<String> binaryFileTypes = new ArrayList<String>(Arrays.asList("gif", "jpg", "png", "prpt"));

            public void processRow(ResultSet rs) throws SQLException {
                String id = rs.getString(1);
                if (!id.equals(this.lastId)) {
                    if (this.lastId != null) {
                        this.currentBatch.add(new RepositoryFileBundle(this.currentFile, this.currentAclBuilder != null ? this.currentAclBuilder.build() : null, this.currentPath, this.currentTmpFile, this.currentCharset, this.currentMimeType));
                        this.currentFile = null;
                        this.currentAclBuilder = null;
                        this.currentTmpFile = null;
                        this.currentPath = null;
                        this.currentMimeType = null;
                        this.currentCharset = null;
                        if (this.currentBatch.size() == 100) {
                            this.flushBatch();
                        }
                    }
                    this.lastId = id;
                    String name = rs.getString(2);
                    this.currentPath = rs.getString(3);
                    boolean folder = rs.getBoolean(5);
                    Date lastModificationDate = null;
                    int lastModificationDateColumnType = rs.getMetaData().getColumnType(6);
                    lastModificationDate = lastModificationDateColumnType == 91 ? rs.getDate(6) : new Date(rs.getLong(6));
                    this.currentFile = new RepositoryFile.Builder(name).hidden(false).folder(folder).lastModificationDate(lastModificationDate).build();
                    this.currentTmpFile = null;
                    this.currentCharset = null;
                    this.currentMimeType = null;
                    if (!folder) {
                        try {
                            this.currentTmpFile = this.getTmpFile(name, rs.getBlob(4).getBinaryStream());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        this.currentCharset = this.isBinary(name) ? null : DbSolutionRepositoryImportSource.this.requiredCharset;
                        this.currentMimeType = DbSolutionRepositoryImportSource.this.getMimeType(this.getExtension(name));
                    }
                    if (this.hasAcl(rs)) {
                        int mask = rs.getInt(7);
                        int recipientType = rs.getInt(8);
                        String recipient = rs.getString(9);
                    }
                } else {
                    int mask = rs.getInt(7);
                    int recipientType = rs.getInt(8);
                    String recipient = rs.getString(9);
                }
            }

            private void flushBatch() {
                if (this.currentFile != null) {
                    this.currentBatch.add(new RepositoryFileBundle(this.currentFile, this.currentAclBuilder != null ? this.currentAclBuilder.build() : null, this.currentPath, this.currentTmpFile, this.currentCharset, this.currentMimeType));
                }
                if (!this.currentBatch.isEmpty()) {
                    try {
                        File tmpFile = File.createTempFile("pentaho", ".ser");
                        tmpFile.deleteOnExit();
                        FileOutputStream fout = FileUtils.openOutputStream((File)tmpFile);
                        ObjectOutputStream oos = new ObjectOutputStream(fout);
                        oos.writeObject(this.currentBatch);
                        oos.close();
                        this.currentBatch.clear();
                        this.serializedBatches.add(tmpFile);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public List<File> getSerializedBatches() {
                this.flushBatch();
                return this.serializedBatches;
            }

            private boolean hasAcl(ResultSet rs) throws SQLException {
                return rs.getString(9) != null;
            }

            private EnumSet<RepositoryFilePermission> makePerms(int mask) {
                if (mask == -1) {
                    return EnumSet.of(RepositoryFilePermission.ALL);
                }
                HashSet<RepositoryFilePermission> perms = new HashSet<RepositoryFilePermission>();
                if ((mask & 1) == 1) {
                    perms.add(RepositoryFilePermission.READ);
                }
                if ((mask & 4) == 4) {
                    perms.add(RepositoryFilePermission.WRITE);
                }
                if ((mask & 8) == 8) {
                    perms.add(RepositoryFilePermission.WRITE);
                }
                if ((mask & 0x10) == 16) {
                    perms.add(RepositoryFilePermission.WRITE);
                }
                if ((mask & 0x20) == 32) {
                    perms.add(RepositoryFilePermission.ACL_MANAGEMENT);
                }
                if (perms.isEmpty()) {
                    return EnumSet.noneOf(RepositoryFilePermission.class);
                }
                return EnumSet.copyOf(perms);
            }

            private File getTmpFile(String name, InputStream in) throws IOException {
                File tmp = File.createTempFile("pentaho", ".tmp");
                tmp.deleteOnExit();
                if (!this.isBinary(name)) {
                    InputStreamReader reader = new InputStreamReader(in, DbSolutionRepositoryImportSource.this.srcCharset);
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), DbSolutionRepositoryImportSource.this.requiredCharset);
                    IOUtils.copy((Reader)reader, (Writer)out);
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((Writer)out);
                } else {
                    logger.debug((Object)(name + " is binary"));
                    FileOutputStream out = new FileOutputStream(tmp);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)out);
                }
                return tmp;
            }

            private boolean isBinary(String name) {
                String ext = this.getExtension(name);
                if (ext != null) {
                    return Collections.binarySearch(this.binaryFileTypes, ext) >= 0;
                }
                return false;
            }

            private String getExtension(String name) {
                Assert.notNull((Object)name);
                int lastDot = name.lastIndexOf(46);
                if (lastDot > -1) {
                    return name.substring(lastDot + 1).toLowerCase();
                }
                return null;
            }
        }
    }
}

