/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.defaultcontent;

import java.io.File;
import java.util.concurrent.Callable;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.plugin.services.importer.ArchiveLoader;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.util.logging.Logger;

public class DefaultContentSystemListener
implements IPentahoSystemListener {
    private static final String DEFAULT_CONTENT_FOLDER = "system/default-content";

    public void shutdown() {
    }

    public boolean startup(IPentahoSession arg0) {
        try {
            SecurityHelper.getInstance().runAsSystem((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    Logger.info((String)this.getClass().getName(), (String)"Default content importer has started");
                    String solutionPath = PentahoSystem.getApplicationContext().getSolutionPath(DefaultContentSystemListener.DEFAULT_CONTENT_FOLDER);
                    File directory = new File(solutionPath);
                    IPlatformImporter importer = (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
                    ArchiveLoader archiveLoader = new ArchiveLoader(importer);
                    archiveLoader.loadAll(directory, ArchiveLoader.ZIPS_FILTER);
                    return null;
                }
            });
        }
        catch (Exception e) {
            Logger.error((String)this.getClass().getName(), (String)e.getMessage());
        }
        return true;
    }
}

