/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.snappy.LoadSnappy;
import org.apache.hadoop.io.compress.snappy.SnappyCompressor;
import org.apache.hadoop.io.compress.snappy.SnappyDecompressor;

public class SnappyCodec
implements Configurable,
CompressionCodec {
    public static final String IO_COMPRESSION_CODEC_SNAPPY_BUFFERSIZE_KEY = "io.compression.codec.snappy.buffersize";
    public static final int IO_COMPRESSION_CODEC_SNAPPY_BUFFERSIZE_DEFAULT = 262144;
    Configuration conf;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static boolean isNativeSnappyLoaded(Configuration conf) {
        return LoadSnappy.isLoaded();
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        if (!SnappyCodec.isNativeSnappyLoaded(this.conf)) {
            throw new RuntimeException("native snappy library not available");
        }
        int bufferSize = this.conf.getInt(IO_COMPRESSION_CODEC_SNAPPY_BUFFERSIZE_KEY, 262144);
        int compressionOverhead = bufferSize / 6 + 32;
        return new BlockCompressorStream(out, compressor, bufferSize, compressionOverhead);
    }

    public Class<? extends Compressor> getCompressorType() {
        if (!SnappyCodec.isNativeSnappyLoaded(this.conf)) {
            throw new RuntimeException("native snappy library not available");
        }
        return SnappyCompressor.class;
    }

    public Compressor createCompressor() {
        if (!SnappyCodec.isNativeSnappyLoaded(this.conf)) {
            throw new RuntimeException("native snappy library not available");
        }
        int bufferSize = this.conf.getInt(IO_COMPRESSION_CODEC_SNAPPY_BUFFERSIZE_KEY, 262144);
        return new SnappyCompressor(bufferSize);
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!SnappyCodec.isNativeSnappyLoaded(this.conf)) {
            throw new RuntimeException("native snappy library not available");
        }
        return new BlockDecompressorStream(in, decompressor, this.conf.getInt(IO_COMPRESSION_CODEC_SNAPPY_BUFFERSIZE_KEY, 262144));
    }

    public Class<? extends Decompressor> getDecompressorType() {
        if (!SnappyCodec.isNativeSnappyLoaded(this.conf)) {
            throw new RuntimeException("native snappy library not available");
        }
        return SnappyDecompressor.class;
    }

    public Decompressor createDecompressor() {
        if (!SnappyCodec.isNativeSnappyLoaded(this.conf)) {
            throw new RuntimeException("native snappy library not available");
        }
        int bufferSize = this.conf.getInt(IO_COMPRESSION_CODEC_SNAPPY_BUFFERSIZE_KEY, 262144);
        return new SnappyDecompressor(bufferSize);
    }

    public String getDefaultExtension() {
        return ".snappy";
    }

    static {
        LoadSnappy.isLoaded();
    }
}

