/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.linq4j.expressions;

import java.lang.reflect.Type;
import java.util.List;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.ExpressionType;
import net.hydromatic.linq4j.expressions.ExpressionWriter;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.linq4j.expressions.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewArrayExpression
extends Expression {
    public final int dimension;
    public final Expression bound;
    public final List<Expression> expressions;

    public NewArrayExpression(Type type, int dimension, Expression bound, List<Expression> expressions) {
        super(ExpressionType.NewArrayInit, Types.arrayType(type, dimension));
        this.dimension = dimension;
        this.bound = bound;
        this.expressions = expressions;
    }

    @Override
    public Expression accept(Visitor visitor) {
        List<Expression> expressions = this.expressions == null ? null : Expressions.acceptExpressions(this.expressions, visitor);
        Expression bound = Expressions.accept(this.bound, visitor);
        return visitor.visit(this, this.dimension, bound, expressions);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        writer.append("new ").append(Types.getComponentTypeN(this.type));
        for (int i = 0; i < this.dimension; ++i) {
            if (i == 0 && this.bound != null) {
                writer.append('[').append(this.bound).append(']');
                continue;
            }
            writer.append("[]");
        }
        if (this.expressions != null) {
            writer.list(" {\n", ",\n", "}", this.expressions);
        }
    }
}

