/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.lambda.functions;

import java.util.Arrays;
import java.util.Collection;
import net.hydromatic.lambda.functions.Mapper;
import net.hydromatic.lambda.functions.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Predicates {
    private static final Predicate<Object> IS_NULL = new AbstractPredicate<Object>(){

        @Override
        public boolean test(Object o) {
            return o == null;
        }
    };
    private static final Predicate<Object> NON_NULL = new AbstractPredicate<Object>(){

        @Override
        public boolean test(Object o) {
            return o != null;
        }
    };
    private static final Predicate<Object> FALSE = new AbstractPredicate<Object>(){

        @Override
        public boolean test(Object o) {
            return false;
        }
    };
    private static final Predicate<Object> TRUE = new AbstractPredicate<Object>(){

        @Override
        public boolean test(Object o) {
            return true;
        }
    };

    private Predicates() {
        throw new AssertionError((Object)"No instances!");
    }

    public static <T> Predicate<T> isNull() {
        return IS_NULL;
    }

    public static <T> Predicate<T> nonNull() {
        return NON_NULL;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return FALSE;
    }

    public static <T> Predicate<T> alwaysTrue() {
        return TRUE;
    }

    public static <T> Predicate<T> instanceOf(final Class<?> clazz) {
        return new AbstractPredicate<T>(){

            @Override
            public boolean test(T t) {
                return clazz.isInstance(t);
            }
        };
    }

    public static <T> Predicate<T> isSame(final Object target) {
        return new AbstractPredicate<T>(){

            @Override
            public boolean test(T t) {
                return t == target;
            }
        };
    }

    public static <T> Predicate<T> isEqual(final Object target) {
        if (null == target) {
            return Predicates.isNull();
        }
        return new AbstractPredicate<T>(){

            @Override
            public boolean test(T t) {
                return target.equals(t);
            }
        };
    }

    public static <T> Predicate<T> contains(final Collection<?> target) {
        return new AbstractPredicate<T>(){

            @Override
            public boolean test(T t) {
                return target.contains(t);
            }
        };
    }

    public static <T, V> Predicate<T> compose(final Predicate<? super V> predicate, final Mapper<? super T, ? extends V> mapper) {
        return new AbstractPredicate<T>(){

            @Override
            public boolean test(T t) {
                return predicate.test(mapper.map(t));
            }
        };
    }

    public static <T> Predicate<T> negate(final Predicate<? super T> predicate) {
        return new AbstractPredicate<T>(){

            @Override
            public boolean test(T t) {
                return !predicate.test(t);
            }
        };
    }

    public static <T> Predicate<T> and(final Predicate<? super T> first, final Predicate<? super T> second) {
        return new AbstractPredicate<T>(){

            @Override
            public boolean test(T t) {
                return first.test(t) && second.test(t);
            }
        };
    }

    public static <T> Predicate<T> and(final Iterable<? extends Predicate<? super T>> predicates) {
        return new AbstractPredicate<T>(){

            @Override
            public boolean test(T t) {
                for (Predicate predicate : predicates) {
                    if (!predicate.test(t)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> Predicate<T> and(final Predicate<? super T> first, final Iterable<? extends Predicate<? super T>> predicates) {
        return new AbstractPredicate<T>(){

            @Override
            public boolean test(T t) {
                if (!first.test(t)) {
                    return false;
                }
                for (Predicate predicate : predicates) {
                    if (!predicate.test(t)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <T> Predicate<T> or(final Predicate<? super T> first, final Predicate<? super T> second) {
        return new AbstractPredicate<T>(){

            @Override
            public boolean test(T t) {
                return first.test(t) || second.test(t);
            }
        };
    }

    public static <T> Predicate<T> or(final Iterable<? extends Predicate<? super T>> predicates) {
        return new AbstractPredicate<T>(){

            @Override
            public boolean test(T t) {
                for (Predicate predicate : predicates) {
                    if (!predicate.test(t)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> Predicate<T> or(Predicate<? super T> ... predicates) {
        return Predicates.or(Arrays.asList(predicates));
    }

    public static <T> Predicate<T> xor(final Predicate<? super T> first, final Predicate<? super T> second) {
        return new AbstractPredicate<T>(){

            @Override
            public boolean test(T t) {
                return first.test(t) ^ second.test(t);
            }
        };
    }

    public static <T> Predicate<T> xor(Iterable<? extends Predicate<? super T>> predicates) {
        throw new UnsupportedOperationException();
    }

    public static <T> Predicate<T> xor(Predicate<? super T> ... predicates) {
        return Predicates.xor(Arrays.asList(predicates));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class AbstractPredicate<T>
    implements Predicate<T> {
        AbstractPredicate() {
        }

        @Override
        public Predicate<T> and(Predicate<? super T> p) {
            return Predicates.and(this, p);
        }

        @Override
        public Predicate<T> or(Predicate<? super T> p) {
            return Predicates.or(this, p);
        }

        @Override
        public Predicate<T> xor(Predicate<? super T> p) {
            return Predicates.xor(this, p);
        }

        @Override
        public Predicate<T> negate() {
            return Predicates.negate(this);
        }
    }
}

