/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.extensions.legacycharts;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jfree.chart.JFreeChart;
import org.pentaho.reporting.designer.core.settings.WorkspaceSettings;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionsModel;
import org.pentaho.reporting.designer.extensions.legacycharts.ChartDataSource;
import org.pentaho.reporting.designer.extensions.legacycharts.ChartType;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.engine.classic.core.metadata.GroupedMetaDataComparator;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;

public class LegacyChartEditModel {
    public static final String PRIMARY_DATA_SOURCE_PROPERTY = "primaryDataSource";
    public static final String SECONDARY_DATA_SOURCE_PROPERTY = "secondaryDataSource";
    public static final String CHART_EXPRESSION_PROPERTY = "chartExpression";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Expression chartExpression;
    private Expression primaryDataSource;
    private Expression secondaryDataSource;
    private ChartType currentChartType;
    private DefaultComboBoxModel primaryDataSourcesModel;
    private DefaultComboBoxModel secondaryDataSourcesModel;
    private DefaultComboBoxModel chartExpressionsModel = new DefaultComboBoxModel();

    public LegacyChartEditModel() {
        this.chartExpressionsModel.addListDataListener(new ChartExpressionTypeSelectionHandler());
        this.primaryDataSourcesModel = new DefaultComboBoxModel();
        this.primaryDataSourcesModel.addListDataListener(new PrimaryDataSourceSelectionHandler());
        this.secondaryDataSourcesModel = new DefaultComboBoxModel();
        this.secondaryDataSourcesModel.addListDataListener(new SecondaryDataSourceSelectionHandler());
        this.populateExpressionSelectorModel(this.chartExpressionsModel, JFreeChart.class);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public Expression getChartExpression() {
        return this.chartExpression;
    }

    public void setChartExpression(Expression chartExpression) {
        Expression oldChartExpression = this.chartExpression;
        this.chartExpression = chartExpression;
        this.currentChartType = null;
        this.propertyChangeSupport.firePropertyChange(CHART_EXPRESSION_PROPERTY, oldChartExpression, chartExpression);
        if (this.chartExpression != null) {
            String key = this.chartExpression.getClass().getName();
            ExpressionMetaData newMetaData = ExpressionRegistry.getInstance().getExpressionMetaData(key);
            if (newMetaData == null) {
                this.chartExpressionsModel.setSelectedItem(null);
            } else {
                Object selectedMetaData = this.chartExpressionsModel.getSelectedItem();
                if (selectedMetaData instanceof ExpressionMetaData) {
                    ExpressionMetaData metaData = (ExpressionMetaData)selectedMetaData;
                    if (!metaData.getExpressionType().equals(newMetaData.getExpressionType())) {
                        this.chartExpressionsModel.setSelectedItem(newMetaData);
                    }
                } else {
                    this.chartExpressionsModel.setSelectedItem(newMetaData);
                }
            }
        } else {
            this.chartExpressionsModel.setSelectedItem(null);
        }
        this.updateExpressionDataSources();
    }

    private void updateExpressionDataSources() {
        ChartType type = this.getCurrentChartType();
        if (type == null) {
            this.populateExpressionSelectorModel(this.primaryDataSourcesModel, null);
            this.populateExpressionSelectorModel(this.secondaryDataSourcesModel, null);
            this.setPrimaryDataSource(null);
            this.setSecondaryDataSource(null);
            return;
        }
        ChartDataSource datasource = type.getDatasource();
        if (datasource != null) {
            Expression primaryDataSource = this.getPrimaryDataSource();
            if (!this.isValidType(primaryDataSource, datasource.getResultType())) {
                this.populateExpressionSelectorModel(this.primaryDataSourcesModel, datasource.getResultType());
                ExpressionMetaData data = ExpressionRegistry.getInstance().getExpressionMetaData(type.getPreferredPrimaryDataSourceImplementation().getName());
                this.primaryDataSourcesModel.setSelectedItem(data);
            }
        } else {
            this.populateExpressionSelectorModel(this.primaryDataSourcesModel, null);
            this.setPrimaryDataSource(null);
        }
        ChartDataSource secondaryDataSource = type.getSecondaryDataSource();
        if (secondaryDataSource != null) {
            Expression dataSource = this.getSecondaryDataSource();
            if (!this.isValidType(dataSource, secondaryDataSource.getResultType())) {
                this.populateExpressionSelectorModel(this.secondaryDataSourcesModel, secondaryDataSource.getResultType());
                ExpressionMetaData data = ExpressionRegistry.getInstance().getExpressionMetaData(type.getPreferredSecondaryDataSourceImplementation().getName());
                this.secondaryDataSourcesModel.setSelectedItem(data);
            }
        } else {
            this.populateExpressionSelectorModel(this.secondaryDataSourcesModel, null);
            this.setSecondaryDataSource(null);
        }
    }

    private boolean isValidType(Expression expression, Class resultType) {
        if (expression == null) {
            return false;
        }
        if (!ExpressionRegistry.getInstance().isExpressionRegistered(expression.getClass().getName())) {
            return false;
        }
        ExpressionMetaData metaData = ExpressionRegistry.getInstance().getExpressionMetaData(expression.getClass().getName());
        return resultType.isAssignableFrom(metaData.getResultType());
    }

    public Expression getPrimaryDataSource() {
        return this.primaryDataSource;
    }

    public void setPrimaryDataSource(Expression primaryDataSource) {
        Expression oldExpression = this.primaryDataSource;
        this.primaryDataSource = primaryDataSource;
        this.propertyChangeSupport.firePropertyChange(PRIMARY_DATA_SOURCE_PROPERTY, oldExpression, primaryDataSource);
        if (primaryDataSource != null) {
            ExpressionMetaData data = ExpressionRegistry.getInstance().getExpressionMetaData(primaryDataSource.getClass().getName());
            this.primaryDataSourcesModel.setSelectedItem(data);
        } else {
            this.primaryDataSourcesModel.setSelectedItem(null);
        }
    }

    public Expression getSecondaryDataSource() {
        return this.secondaryDataSource;
    }

    public void setSecondaryDataSource(Expression secondaryDataSource) {
        Expression oldExpression = this.secondaryDataSource;
        this.secondaryDataSource = secondaryDataSource;
        this.propertyChangeSupport.firePropertyChange(SECONDARY_DATA_SOURCE_PROPERTY, oldExpression, secondaryDataSource);
        if (secondaryDataSource != null) {
            ExpressionMetaData data = ExpressionRegistry.getInstance().getExpressionMetaData(secondaryDataSource.getClass().getName());
            this.secondaryDataSourcesModel.setSelectedItem(data);
        } else {
            this.secondaryDataSourcesModel.setSelectedItem(null);
        }
    }

    public ChartType getCurrentChartType() {
        if (this.currentChartType == null && this.chartExpression != null) {
            this.currentChartType = ChartType.getTypeByChartExpression(this.chartExpression.getClass());
        }
        return this.currentChartType;
    }

    public ComboBoxModel getPrimaryDataSourcesModel() {
        return this.primaryDataSourcesModel;
    }

    public ComboBoxModel getSecondaryDataSourcesModel() {
        return this.secondaryDataSourcesModel;
    }

    public ComboBoxModel getChartExpressionsModel() {
        return this.chartExpressionsModel;
    }

    private void propagateExpressionSettings(Expression source, Expression destination) {
        if (source == null || destination == null) {
            return;
        }
        try {
            BeanUtility buSource = new BeanUtility((Object)source);
            BeanUtility buDest = new BeanUtility((Object)destination);
            String[] strings = buSource.getProperties();
            for (int i = 0; i < strings.length; ++i) {
                try {
                    String propertyName = strings[i];
                    Object value = buSource.getProperty(propertyName);
                    buDest.setProperty(propertyName, value);
                    continue;
                }
                catch (BeanException e) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void populateExpressionSelectorModel(DefaultComboBoxModel model, Class resultType) {
        model.removeAllElements();
        if (resultType == null) {
            model.setSelectedItem(null);
            return;
        }
        ExpressionMetaData[] allExpressionMetaDatas = ExpressionRegistry.getInstance().getAllExpressionMetaDatas();
        Arrays.sort(allExpressionMetaDatas, new GroupedMetaDataComparator());
        for (int i = 0; i < allExpressionMetaDatas.length; ++i) {
            ExpressionMetaData data = allExpressionMetaDatas[i];
            if (data.isHidden() || !WorkspaceSettings.getInstance().isVisible((MetaData)data) || StructureFunction.class.isAssignableFrom(data.getExpressionType()) || !resultType.isAssignableFrom(data.getResultType())) continue;
            model.addElement(data);
        }
        model.setSelectedItem(null);
    }

    private class ChartExpressionTypeSelectionHandler
    implements ListDataListener {
        private ChartExpressionTypeSelectionHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ExpressionMetaData o = (ExpressionMetaData)LegacyChartEditModel.this.getChartExpressionsModel().getSelectedItem();
            if (o == null) {
                LegacyChartEditModel.this.setChartExpression(null);
                return;
            }
            Expression chartExpression = LegacyChartEditModel.this.getChartExpression();
            if (chartExpression != null && chartExpression.getClass().equals(o.getExpressionType())) {
                return;
            }
            try {
                ExpressionMetaData theSecondaryModel;
                Expression primaryDSExpression = LegacyChartEditModel.this.getPrimaryDataSource();
                Expression secondaryDSExpression = LegacyChartEditModel.this.getSecondaryDataSource();
                Expression newChartExpression = (Expression)o.getExpressionType().newInstance();
                LegacyChartEditModel.this.propagateExpressionSettings(chartExpression, newChartExpression);
                LegacyChartEditModel.this.setChartExpression(newChartExpression);
                ExpressionMetaData thePrimaryModel = (ExpressionMetaData)LegacyChartEditModel.this.getPrimaryDataSourcesModel().getSelectedItem();
                if (thePrimaryModel != null && primaryDSExpression != null) {
                    if (thePrimaryModel.getExpressionType().equals(primaryDSExpression.getClass())) {
                        LegacyChartEditModel.this.setPrimaryDataSource(primaryDSExpression);
                    } else {
                        Expression newPrimaryDataSource = (Expression)thePrimaryModel.getExpressionType().newInstance();
                        LegacyChartEditModel.this.propagateExpressionSettings(primaryDSExpression, newPrimaryDataSource);
                        LegacyChartEditModel.this.setPrimaryDataSource(newPrimaryDataSource);
                    }
                }
                if ((theSecondaryModel = (ExpressionMetaData)LegacyChartEditModel.this.getSecondaryDataSourcesModel().getSelectedItem()) != null && secondaryDSExpression != null) {
                    if (theSecondaryModel.getExpressionType().equals(secondaryDSExpression.getClass())) {
                        LegacyChartEditModel.this.setSecondaryDataSource(secondaryDSExpression);
                    } else {
                        Expression newSecondaryDataSource = (Expression)theSecondaryModel.getExpressionType().newInstance();
                        LegacyChartEditModel.this.propagateExpressionSettings(secondaryDSExpression, newSecondaryDataSource);
                        LegacyChartEditModel.this.setSecondaryDataSource(newSecondaryDataSource);
                    }
                }
            }
            catch (Exception e1) {
                UncaughtExceptionsModel.getInstance().addException((Throwable)e1);
                LegacyChartEditModel.this.setChartExpression(null);
            }
        }
    }

    private class SecondaryDataSourceSelectionHandler
    implements ListDataListener {
        private SecondaryDataSourceSelectionHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ExpressionMetaData o = (ExpressionMetaData)LegacyChartEditModel.this.getSecondaryDataSourcesModel().getSelectedItem();
            if (o == null) {
                LegacyChartEditModel.this.setSecondaryDataSource(null);
                return;
            }
            Expression secondaryDataSourceExpression = LegacyChartEditModel.this.getSecondaryDataSource();
            if (secondaryDataSourceExpression != null && secondaryDataSourceExpression.getClass().equals(o.getExpressionType())) {
                return;
            }
            try {
                Expression expression = (Expression)o.getExpressionType().newInstance();
                if (secondaryDataSourceExpression != null) {
                    LegacyChartEditModel.this.propagateExpressionSettings(secondaryDataSourceExpression, expression);
                }
                LegacyChartEditModel.this.setSecondaryDataSource(expression.getInstance());
            }
            catch (Exception e1) {
                UncaughtExceptionsModel.getInstance().addException((Throwable)e1);
                LegacyChartEditModel.this.setSecondaryDataSource(null);
            }
        }
    }

    private class PrimaryDataSourceSelectionHandler
    implements ListDataListener {
        private PrimaryDataSourceSelectionHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            ExpressionMetaData o = (ExpressionMetaData)LegacyChartEditModel.this.getPrimaryDataSourcesModel().getSelectedItem();
            if (o == null) {
                LegacyChartEditModel.this.setPrimaryDataSource(null);
                return;
            }
            Expression primaryDataSourceExpression = LegacyChartEditModel.this.getPrimaryDataSource();
            if (primaryDataSourceExpression != null && primaryDataSourceExpression.getClass().equals(o.getExpressionType())) {
                return;
            }
            try {
                Expression expression = (Expression)o.getExpressionType().newInstance();
                if (primaryDataSourceExpression != null) {
                    LegacyChartEditModel.this.propagateExpressionSettings(primaryDataSourceExpression, expression);
                }
                LegacyChartEditModel.this.setPrimaryDataSource(expression.getInstance());
            }
            catch (Exception e1) {
                UncaughtExceptionsModel.getInstance().addException((Throwable)e1);
                LegacyChartEditModel.this.setPrimaryDataSource(null);
            }
        }
    }
}

