/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.mstor.util;

import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public final class MessageUtils {
    private MessageUtils() {
    }

    public static Flags.Flag getFlag(String flagName) {
        if ("answered".equals(flagName)) {
            return Flags.Flag.ANSWERED;
        }
        if ("deleted".equalsIgnoreCase(flagName)) {
            return Flags.Flag.DELETED;
        }
        if ("draft".equalsIgnoreCase(flagName)) {
            return Flags.Flag.DRAFT;
        }
        if ("flagged".equalsIgnoreCase(flagName)) {
            return Flags.Flag.FLAGGED;
        }
        if ("recent".equalsIgnoreCase(flagName)) {
            return Flags.Flag.RECENT;
        }
        if ("seen".equalsIgnoreCase(flagName)) {
            return Flags.Flag.SEEN;
        }
        if ("user".equalsIgnoreCase(flagName)) {
            return Flags.Flag.USER;
        }
        return null;
    }

    public static String getFlagName(Flags.Flag flag) {
        if (Flags.Flag.ANSWERED.equals(flag)) {
            return "answered";
        }
        if (Flags.Flag.DELETED.equals(flag)) {
            return "deleted";
        }
        if (Flags.Flag.DRAFT.equals(flag)) {
            return "draft";
        }
        if (Flags.Flag.FLAGGED.equals(flag)) {
            return "flagged";
        }
        if (Flags.Flag.RECENT.equals(flag)) {
            return "recent";
        }
        if (Flags.Flag.SEEN.equals(flag)) {
            return "seen";
        }
        if (Flags.Flag.USER.equals(flag)) {
            return "user";
        }
        return null;
    }

    public static String getMessageId(Message message) throws MessagingException {
        String[] uids;
        String messageId = null;
        if (message instanceof MimeMessage) {
            MimeMessage mimeMessage = (MimeMessage)message;
            messageId = mimeMessage.getMessageID();
        }
        if (messageId == null && (uids = message.getHeader("X-UIDL")) != null && uids.length > 0) {
            messageId = uids[0];
        }
        return messageId;
    }
}

