/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.CellKey;
import mondrian.rolap.GroupingSetsCollector;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.agg.GroupingSet;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentAxis;
import mondrian.rolap.agg.SegmentCacheManager;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SegmentLoader;
import mondrian.rolap.agg.SegmentWithData;
import mondrian.rolap.agg.StarPredicates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregation {
    private final List<StarPredicate> compoundPredicateList;
    private final RolapStar star;
    private final BitKey constrainedColumnsBitKey;
    private final int maxConstraints;
    private final Date creationTimestamp;

    public Aggregation(AggregationKey aggregationKey) {
        this.compoundPredicateList = aggregationKey.getCompoundPredicateList();
        this.star = aggregationKey.getStar();
        this.constrainedColumnsBitKey = aggregationKey.getConstrainedColumnsBitKey();
        this.maxConstraints = MondrianProperties.instance().MaxConstraints.get();
        this.creationTimestamp = new Date();
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void load(SegmentCacheManager cacheMgr, int cellRequestCount, RolapStar.Column[] columns, List<RolapStar.Measure> measures, StarColumnPredicate[] predicates, GroupingSetsCollector groupingSetsCollector, List<Future<Map<Segment, SegmentWithData>>> segmentFutures) {
        BitKey measureBitKey = this.getConstrainedColumnsBitKey().emptyCopy();
        int axisCount = columns.length;
        Util.assertTrue(predicates.length == axisCount);
        List<Segment> segments = this.createSegments(columns, measures, measureBitKey, predicates);
        BitKey levelBitKey = this.getConstrainedColumnsBitKey();
        GroupingSet groupingSet = new GroupingSet(segments, levelBitKey, measureBitKey, predicates, columns);
        if (groupingSetsCollector.useGroupingSets()) {
            groupingSetsCollector.add(groupingSet);
        } else {
            SegmentLoader segmentLoader = new SegmentLoader(cacheMgr);
            segmentLoader.load(cellRequestCount, new ArrayList<GroupingSet>(Collections.singletonList(groupingSet)), this.compoundPredicateList, segmentFutures);
        }
    }

    private List<Segment> createSegments(RolapStar.Column[] columns, List<RolapStar.Measure> measures, BitKey measureBitKey, StarColumnPredicate[] predicates) {
        ArrayList<Segment> segments = new ArrayList<Segment>(measures.size());
        for (RolapStar.Measure measure : measures) {
            measureBitKey.set(measure.getBitPosition());
            Segment segment = new Segment(this.star, this.constrainedColumnsBitKey, columns, measure, predicates, Collections.<Segment.ExcludedRegion>emptyList(), this.compoundPredicateList);
            segments.add(segment);
        }
        Collections.sort(segments, new Comparator<Segment>(){

            @Override
            public int compare(Segment o1, Segment o2) {
                return Integer.valueOf(o1.measure.getBitPosition()).compareTo(o2.measure.getBitPosition());
            }
        });
        return segments;
    }

    public StarColumnPredicate[] optimizePredicates(RolapStar.Column[] columns, StarColumnPredicate[] predicates) {
        RolapStar star = this.getStar();
        Util.assertTrue(predicates.length == columns.length);
        StarColumnPredicate[] newPredicates = (StarColumnPredicate[])predicates.clone();
        double[] bloats = new double[columns.length];
        ArrayList<RolapMember> potentialParents = new ArrayList<RolapMember>();
        for (StarColumnPredicate predicate : predicates) {
            if (!(predicate instanceof MemberColumnPredicate)) continue;
            RolapMember m = ((MemberColumnPredicate)predicate).getMember();
            potentialParents.add(m);
        }
        for (int i = 0; i < newPredicates.length; ++i) {
            int memberCount;
            SchemaReader scr;
            if (!(newPredicates[i] instanceof ListColumnPredicate)) {
                bloats[i] = 0.0;
                continue;
            }
            ListColumnPredicate newPredicate = (ListColumnPredicate)newPredicates[i];
            List<StarColumnPredicate> predicateList = newPredicate.getPredicates();
            int valueCount = predicateList.size();
            if (valueCount < 2) {
                bloats[i] = 0.0;
                continue;
            }
            if (valueCount > this.maxConstraints) {
                bloats[i] = 1.0;
                continue;
            }
            double constraintLength = valueCount;
            Member parent = null;
            Level level = null;
            for (int j = 0; j < valueCount; ++j) {
                StarColumnPredicate value = predicateList.get(j);
                if (value instanceof MemberColumnPredicate) {
                    MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)value;
                    RolapMember m = memberColumnPredicate.getMember();
                    if (j == 0) {
                        parent = m.getParentMember();
                        level = m.getLevel();
                        continue;
                    }
                    if (parent != null && !parent.equals(m.getParentMember())) {
                        parent = null;
                    }
                    if (level == null || level.equals(m.getLevel())) continue;
                    level = null;
                    continue;
                }
                parent = null;
                level = null;
                bloats[i] = constraintLength / (double)columns[i].getCardinality();
                break;
            }
            boolean done = false;
            if (parent != null && (parent.isAll() || potentialParents.contains(parent))) {
                scr = star.getSchema().getSchemaReader();
                int childCount = scr.getChildrenCountFromCache(parent);
                if (childCount == -1) {
                    if (!parent.isAll()) {
                        bloats[i] = 0.0;
                        done = true;
                    }
                } else {
                    bloats[i] = constraintLength / (double)childCount;
                    done = true;
                }
            }
            if (!done && level != null && (memberCount = (scr = star.getSchema().getSchemaReader()).getLevelCardinality(level, true, false)) > 0) {
                bloats[i] = constraintLength / (double)memberCount;
                done = true;
            }
            if (done) continue;
            bloats[i] = constraintLength / (double)columns[i].getCardinality();
        }
        ConstraintComparator comparator = new ConstraintComparator(bloats);
        Integer[] indexes = new Integer[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            indexes[i] = i;
        }
        Arrays.sort(indexes, comparator);
        double abloat = 1.0;
        double aBloatLimit = 0.5;
        for (Integer j : indexes) {
            if ((abloat *= bloats[j]) <= 0.5) break;
            if (!MondrianProperties.instance().OptimizePredicates.get() && bloats[j] != 1.0) continue;
            newPredicates[j.intValue()] = new LiteralStarPredicate(columns[j], true);
        }
        for (int i = 0; i < newPredicates.length; ++i) {
            newPredicates[i] = StarPredicates.optimize(newPredicates[i]);
        }
        return newPredicates;
    }

    public RolapStar getStar() {
        return this.star;
    }

    public BitKey getConstrainedColumnsBitKey() {
        return this.constrainedColumnsBitKey;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstraintComparator
    implements Comparator<Integer> {
        private final double[] bloats;

        ConstraintComparator(double[] bloats) {
            this.bloats = bloats;
        }

        @Override
        public int compare(Integer o0, Integer o1) {
            double bloat1;
            double bloat0 = this.bloats[o0];
            return bloat0 == (bloat1 = this.bloats[o1]) ? 0 : (bloat0 < bloat1 ? 1 : -1);
        }
    }

    private static class ValuePruner {
        private final StarPredicate flushPredicate;
        private final int arity;
        private final SegmentAxis[] axes;
        private final BitSet[] keepBitSets;
        private final int[] axisInverseOrdinals;
        private final Object[] values;
        private final List<Object> valueList;
        private final int[] ordinals;
        private final SegmentDataset data;
        private final CellKey cellKey;

        ValuePruner(StarPredicate flushPredicate, SegmentAxis[] segmentAxes, SegmentDataset data) {
            this.flushPredicate = flushPredicate;
            this.arity = flushPredicate.getConstrainedColumnList().size();
            this.axes = new SegmentAxis[this.arity];
            this.keepBitSets = new BitSet[this.arity];
            this.axisInverseOrdinals = new int[segmentAxes.length];
            Arrays.fill(this.axisInverseOrdinals, -1);
            this.values = new Object[this.arity];
            this.valueList = Arrays.asList(this.values);
            this.ordinals = new int[this.arity];
            assert (data != null);
            this.data = data;
            this.cellKey = CellKey.Generator.newCellKey(segmentAxes.length);
            for (int i = 0; i < this.arity; ++i) {
                RolapStar.Column column = flushPredicate.getConstrainedColumnList().get(i);
                int axisOrdinal = this.findAxis(segmentAxes, column.getBitPosition());
                if (axisOrdinal < 0) {
                    this.axes[i] = null;
                    this.values[i] = StarPredicate.WILDCARD;
                    this.keepBitSets[i] = new BitSet(1);
                    continue;
                }
                this.axes[i] = segmentAxes[axisOrdinal];
                this.axisInverseOrdinals[axisOrdinal] = i;
                int keyCount = this.axes[i].getKeys().length;
                this.keepBitSets[i] = new BitSet(keyCount);
            }
        }

        private int findAxis(SegmentAxis[] axes, int bitPosition) {
            for (int i = 0; i < axes.length; ++i) {
                SegmentAxis axis = axes[i];
                if (axis.getPredicate().getConstrainedColumn().getBitPosition() != bitPosition) continue;
                return i;
            }
            return -1;
        }

        void go(BitSet[] axisKeepBitSets) {
            this.evaluatePredicate(0);
            for (int i = 0; i < axisKeepBitSets.length; ++i) {
                if (this.axisInverseOrdinals[i] < 0) continue;
                BitSet axisKeepBitSet = axisKeepBitSets[this.axisInverseOrdinals[i]];
                BitSet keepBitSet = this.keepBitSets[i];
                axisKeepBitSet.and(keepBitSet);
            }
        }

        private void evaluatePredicate(int axisOrdinal) {
            block5: {
                block4: {
                    if (axisOrdinal != this.arity) break block4;
                    if (this.flushPredicate.evaluate(this.valueList) || this.data.getObject(this.cellKey) == null) break block5;
                    for (int k = 0; k < this.arity; ++k) {
                        this.keepBitSets[k].set(this.ordinals[k]);
                    }
                    break block5;
                }
                SegmentAxis axis = this.axes[axisOrdinal];
                if (axis == null) {
                    this.evaluatePredicate(axisOrdinal + 1);
                } else {
                    Comparable[] keys = axis.getKeys();
                    for (int keyOrdinal = 0; keyOrdinal < keys.length; ++keyOrdinal) {
                        Comparable key = keys[keyOrdinal];
                        this.values[axisOrdinal] = key;
                        this.ordinals[axisOrdinal] = keyOrdinal;
                        this.cellKey.setAxis(this.axisInverseOrdinals[axisOrdinal], keyOrdinal);
                        this.evaluatePredicate(axisOrdinal + 1);
                    }
                }
            }
        }
    }
}

