/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.metadata.mqleditor.editor.controllers;

import java.util.List;
import org.pentaho.commons.metadata.mqleditor.MqlQuery;
import org.pentaho.commons.metadata.mqleditor.editor.MQLEditorService;
import org.pentaho.commons.metadata.mqleditor.editor.controllers.MainController;
import org.pentaho.commons.metadata.mqleditor.editor.models.UIColumn;
import org.pentaho.commons.metadata.mqleditor.editor.models.Workspace;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulTreeCell;
import org.pentaho.ui.xul.components.XulTreeCol;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeItem;
import org.pentaho.ui.xul.containers.XulTreeRow;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class PreviewController
extends AbstractXulEventHandler {
    private Workspace workspace;
    private BindingFactory bf;
    private XulTree previewTree;
    private XulDialog previewDialog;
    private MQLEditorService service;
    private String query;
    private int page = 1;
    private String[][] previewData;
    private int previewLimit = 10;

    @Bindable
    public void init() {
        this.previewTree = (XulTree)this.document.getElementById("previewTree");
        this.previewDialog = (XulDialog)this.document.getElementById("previewDialog");
        this.bf.createBinding((Object)this.document.getElementById("previewLimit"), "value", (Object)this, "previewLimit", new BindingConvertor[]{new BindingConvertor<String, Integer>(){

            public Integer sourceToTarget(String value) {
                return Integer.parseInt(value);
            }

            public String targetToSource(Integer value) {
                return "" + value;
            }
        }});
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public String getName() {
        return "previewController";
    }

    public MQLEditorService getService() {
        return this.service;
    }

    public void setService(MQLEditorService service) {
        this.service = service;
    }

    @Bindable
    public void showPreview() {
        MqlQuery q = this.workspace.getMqlQuery();
        this.service.getPreviewData(this.workspace.getMqlQuery(), this.page, this.previewLimit, new XulServiceCallback<String[][]>(){

            public void error(String message, Throwable error) {
                PreviewController.this.setPreviewData(new String[0][]);
                MainController.showErrorDialog(PreviewController.this.cleanUpErrorMessage(error.getLocalizedMessage()));
            }

            public void success(String[][] retVal) {
                PreviewController.this.setPreviewData(retVal);
                PreviewController.this.openDialog();
            }
        });
    }

    @Bindable
    private void openDialog() {
        this.previewDialog.show();
    }

    @Bindable
    public String[][] getPreviewData() {
        return this.previewData;
    }

    @Bindable
    public void upateQuery() {
        this.service.getPreviewData(this.workspace.getMqlQuery(), this.page, this.previewLimit, new XulServiceCallback<String[][]>(){

            public void error(String message, Throwable error) {
                MainController.showErrorDialog(PreviewController.this.cleanUpErrorMessage(error.getLocalizedMessage()));
            }

            public void success(String[][] retVal) {
                PreviewController.this.setPreviewData(retVal);
            }
        });
    }

    public void setPreviewData(String[][] previewData) {
        int i;
        this.previewData = previewData;
        if (previewData == null || previewData.length == 0) {
            this.previewTree.setElements(null);
            return;
        }
        int colCount = previewData[0].length;
        int curTreeColCount = this.previewTree.getColumns().getColumnCount();
        try {
            if (colCount > curTreeColCount) {
                for (i = colCount - curTreeColCount; i > 0; --i) {
                    XulTreeCol col = (XulTreeCol)this.document.createElement("treecol");
                    col.setFlex(1);
                    this.previewTree.getColumns().addColumn(col);
                }
            } else if (colCount < curTreeColCount) {
                List cols = this.previewTree.getColumns().getChildNodes();
                for (int i2 = curTreeColCount - colCount; i2 < cols.size(); ++i2) {
                    this.previewTree.getColumns().removeChild((Element)cols.get(i2));
                }
            }
        }
        catch (XulException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        for (i = 0; i < this.previewTree.getColumns().getColumnCount(); ++i) {
            this.previewTree.getColumns().getColumn(i).setLabel(((UIColumn)this.workspace.getSelections().get(i)).getPreviewName());
        }
        this.previewTree.getRootChildren().removeAll();
        try {
            for (i = 0; i < previewData.length; ++i) {
                XulTreeItem item = (XulTreeItem)this.document.createElement("treeitem");
                XulTreeRow row = (XulTreeRow)this.document.createElement("treerow");
                String[] r = previewData[i];
                for (int y = 0; y < r.length; ++y) {
                    XulTreeCell cell = (XulTreeCell)this.document.createElement("treecell");
                    cell.setLabel(r[y] != null ? r[y] : "");
                    row.addCell(cell);
                }
                item.addChild((Element)row);
                this.previewTree.getRootChildren().addChild((Element)item);
            }
            this.previewTree.update();
        }
        catch (XulException e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    @Bindable
    public void closeDialog() {
        this.previewDialog.hide();
    }

    @Bindable
    public int getPreviewLimit() {
        return this.previewLimit;
    }

    @Bindable
    public void setPreviewLimit(int previewLimit) {
        this.previewLimit = previewLimit;
    }

    private String cleanUpErrorMessage(String errorMessage) {
        if (errorMessage.startsWith("SqlOpenFormula.ERROR_")) {
            return errorMessage.substring("SqlOpenFormula.ERROR_XXXX - ".length());
        }
        return errorMessage;
    }
}

