/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.FuncSpec;
import org.apache.pig.SortColInfo;
import org.apache.pig.SortInfo;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOProject;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.LogicalPlanCloneHelper;
import org.apache.pig.impl.logicalLayer.ProjectFixerUpper;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.logicalLayer.TopLevelProjectFinder;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOSort
extends RelationalOperator {
    private static final long serialVersionUID = 2L;
    private List<Boolean> mAscCols;
    private FuncSpec mSortFunc;
    private boolean mIsStar = false;
    private long limit;
    private List<LogicalPlan> mSortColPlans;
    private static Log log = LogFactory.getLog(LOSort.class);

    public LOSort(LogicalPlan plan, OperatorKey key, List<LogicalPlan> sortColPlans, List<Boolean> ascCols, FuncSpec sortFunc) {
        super(plan, key);
        this.mSortColPlans = sortColPlans;
        this.mAscCols = ascCols;
        this.mSortFunc = sortFunc;
        this.limit = -1L;
    }

    public LogicalOperator getInput() {
        return this.mPlan.getPredecessors(this).get(0);
    }

    public List<LogicalPlan> getSortColPlans() {
        return this.mSortColPlans;
    }

    public void setSortColPlans(List<LogicalPlan> sortPlans) {
        this.mSortColPlans = sortPlans;
    }

    public List<Boolean> getAscendingCols() {
        return this.mAscCols;
    }

    public void setAscendingCols(List<Boolean> ascCols) {
        this.mAscCols = ascCols;
    }

    public FuncSpec getUserFunc() {
        return this.mSortFunc;
    }

    public void setUserFunc(FuncSpec func) {
        this.mSortFunc = func;
    }

    public boolean isStar() {
        return this.mIsStar;
    }

    public void setStar(boolean b) {
        this.mIsStar = b;
    }

    public void setLimit(long l) {
        this.limit = l;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean isLimited() {
        return this.limit != -1L;
    }

    @Override
    public String name() {
        return this.getAliasString() + "SORT " + this.mKey.scope + "-" + this.mKey.id;
    }

    @Override
    public Schema getSchema() throws FrontendException {
        if (!this.mIsSchemaComputed) {
            List<LOSort> s = this.mPlan.getPredecessors(this);
            ArrayList<Schema.FieldSchema> fss = new ArrayList<Schema.FieldSchema>();
            try {
                LogicalOperator op = (LogicalOperator)s.iterator().next();
                if (null == op) {
                    int errCode = 1006;
                    String msg = "Could not find operator in plan";
                    throw new FrontendException(msg, errCode, 2, false, null);
                }
                if (op instanceof ExpressionOperator) {
                    Schema.FieldSchema fs = Schema.FieldSchema.copyAndLink(((ExpressionOperator)op).getFieldSchema(), op);
                    if (DataType.isSchemaType(fs.type)) {
                        this.mSchema = fs.schema;
                    } else {
                        fss.add(fs);
                        this.mSchema = new Schema(fss);
                    }
                } else {
                    this.mSchema = this.getInput().getSchema() != null ? Schema.copyAndLink(op.getSchema(), op) : null;
                }
                this.mIsSchemaComputed = true;
            }
            catch (FrontendException ioe) {
                this.mSchema = null;
                this.mIsSchemaComputed = false;
                throw ioe;
            }
        }
        return this.mSchema;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    @Override
    public byte getType() {
        return 120;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        Iterator<Serializable> it;
        LOSort clone = (LOSort)super.clone();
        if (this.mAscCols != null) {
            clone.mAscCols = new ArrayList<Boolean>();
            it = this.mAscCols.iterator();
            while (it.hasNext()) {
                clone.mAscCols.add((boolean)it.next());
            }
        }
        if (this.mSortFunc != null) {
            clone.mSortFunc = this.mSortFunc.clone();
        }
        if (this.mSortColPlans != null) {
            clone.mSortColPlans = new ArrayList<LogicalPlan>();
            it = this.mSortColPlans.iterator();
            while (it.hasNext()) {
                LogicalPlanCloneHelper lpCloneHelper = new LogicalPlanCloneHelper((LogicalPlan)it.next());
                clone.mSortColPlans.add(lpCloneHelper.getClonedPlan());
            }
        }
        return clone;
    }

    @Override
    public ProjectionMap getProjectionMap() {
        Schema outputSchema;
        if (this.mIsProjectionMapComputed) {
            return this.mProjectionMap;
        }
        this.mIsProjectionMapComputed = true;
        try {
            outputSchema = this.getSchema();
        }
        catch (FrontendException fee) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        Schema inputSchema = null;
        ArrayList predecessors = (ArrayList)this.mPlan.getPredecessors(this);
        if (predecessors != null) {
            try {
                inputSchema = ((LogicalOperator)predecessors.get(0)).getSchema();
            }
            catch (FrontendException fee) {
                this.mProjectionMap = null;
                return this.mProjectionMap;
            }
        } else {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        if (Schema.equals(inputSchema, outputSchema, false, true)) {
            this.mProjectionMap = new ProjectionMap(false);
            return this.mProjectionMap;
        }
        this.mProjectionMap = null;
        return this.mProjectionMap;
    }

    @Override
    public List<RequiredFields> getRequiredFields() {
        ArrayList<RequiredFields> requiredFields = new ArrayList<RequiredFields>();
        HashSet<Pair<Integer, Integer>> fields = new HashSet<Pair<Integer, Integer>>();
        HashSet<LOProject> projectSet = new HashSet<LOProject>();
        boolean orderByStar = false;
        for (LogicalPlan plan : this.getSortColPlans()) {
            TopLevelProjectFinder projectFinder = new TopLevelProjectFinder(plan);
            try {
                projectFinder.visit();
            }
            catch (VisitorException ve) {
                requiredFields.clear();
                requiredFields.add(null);
                return requiredFields;
            }
            projectSet.addAll(projectFinder.getProjectSet());
            if (projectFinder.getProjectStarSet() == null) continue;
            orderByStar = true;
        }
        if (orderByStar) {
            requiredFields.add(new RequiredFields(true));
            return requiredFields;
        }
        for (LOProject project : projectSet) {
            for (int inputColumn : project.getProjection()) {
                fields.add(new Pair<Integer, Integer>(0, inputColumn));
            }
        }
        if (fields.size() == 0) {
            requiredFields.add(new RequiredFields(false, true));
        } else {
            requiredFields.add(new RequiredFields(new ArrayList<Pair<Integer, Integer>>(fields)));
        }
        return requiredFields.size() == 0 ? null : requiredFields;
    }

    @Override
    public void rewire(Operator<LOVisitor> oldPred, int oldPredIndex, Operator<LOVisitor> newPred, boolean useOldPred) throws PlanException {
        super.rewire(oldPred, oldPredIndex, newPred, useOldPred);
        LogicalOperator previous = (LogicalOperator)oldPred;
        LogicalOperator current = (LogicalOperator)newPred;
        for (LogicalPlan plan : this.mSortColPlans) {
            try {
                ProjectFixerUpper projectFixer = new ProjectFixerUpper(plan, previous, oldPredIndex, current, useOldPred, this);
                projectFixer.visit();
            }
            catch (VisitorException ve) {
                int errCode = 2144;
                String msg = "Problem while fixing project inputs during rewiring.";
                throw new PlanException(msg, errCode, 4, ve);
            }
        }
    }

    public SortInfo getSortInfo() throws FrontendException {
        Schema schema = this.getSchema();
        ArrayList<SortColInfo> sortColInfoList = new ArrayList<SortColInfo>();
        for (int i = 0; i < this.mSortColPlans.size(); ++i) {
            LogicalPlan lp = this.mSortColPlans.get(i);
            Iterator opsIterator = lp.iterator();
            ArrayList opsList = new ArrayList();
            while (opsIterator.hasNext()) {
                opsList.add(opsIterator.next());
            }
            if (opsList.size() != 1 || !(opsList.get(0) instanceof LOProject)) {
                int errCode = 2066;
                String msg = "Unsupported operator in inner plan: " + opsList.get(0);
                throw new PlanException(msg, errCode, 4);
            }
            LOProject project = (LOProject)opsList.get(0);
            int sortColIndex = project.getCol();
            String sortColName = schema == null ? null : schema.getField((int)sortColIndex).alias;
            sortColInfoList.add(new SortColInfo(sortColName, sortColIndex, this.mAscCols.get(i) != false ? SortColInfo.Order.ASCENDING : SortColInfo.Order.DESCENDING));
        }
        return new SortInfo(sortColInfoList);
    }

    @Override
    public List<RequiredFields> getRelevantInputs(int output, int column) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (output != 0) {
            return null;
        }
        if (column < 0) {
            return null;
        }
        if (this.mSchema != null && column >= this.mSchema.size()) {
            return null;
        }
        ArrayList<Pair<Integer, Integer>> inputList = new ArrayList<Pair<Integer, Integer>>();
        inputList.add(new Pair<Integer, Integer>(0, column));
        ArrayList<RequiredFields> result = new ArrayList<RequiredFields>();
        result.add(new RequiredFields(inputList));
        return result;
    }

    @Override
    public boolean pruneColumns(List<Pair<Integer, Integer>> columns) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (this.mSchema == null) {
            log.warn((Object)"Cannot prune columns in sort, no schema information found");
            return false;
        }
        List<LOSort> predecessors = this.mPlan.getPredecessors(this);
        if (predecessors == null) {
            return false;
        }
        for (int i = columns.size() - 1; i >= 0; --i) {
            Pair<Integer, Integer> column = columns.get(i);
            if ((Integer)column.first != 0) {
                int errCode = 2191;
                throw new FrontendException("Sort only take 1 input, cannot prune input with index " + column.first, errCode, 4);
            }
            if ((Integer)column.second < 0) {
                int errCode = 2192;
                throw new FrontendException("Column to prune does not exist", errCode, 4);
            }
            for (LogicalPlan plan : this.mSortColPlans) {
                this.pruneColumnInPlan(plan, (Integer)column.second);
            }
        }
        super.pruneColumns(columns);
        return true;
    }
}

